/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.FanInShape14;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.stage.OutHandler;
import de.sciss.fscape.Log$;
import de.sciss.fscape.Util$;
import de.sciss.fscape.graph.BinaryOp;
import de.sciss.fscape.graph.BinaryOp$Op$;
import de.sciss.fscape.stream.Allocator;
import de.sciss.fscape.stream.Buf;
import de.sciss.fscape.stream.BufD;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.Node;
import de.sciss.fscape.stream.PenImage$;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.fscape.stream.package$;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.IntFunctions$;
import de.sciss.numbers.RichDouble;
import de.sciss.numbers.RichInt$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0005\rmq!\u0002,X\u0011\u0003\u0001g!\u00022X\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003Y\u0007\"\u00027\u0002\t\u0003i\u0007\"CA\u001b\u0003\t\u0007IQBA\u001c\u0011!\ti$\u0001Q\u0001\u000e\u0005eRABA \u0003\u0011\t\tE\u0002\u0004\u0002d\u00051\u0011Q\r\u0005\u000b\u0003o:!\u0011!Q\u0001\n\u0005e\u0004BCA@\u000f\t\u0005\t\u0015a\u0003\u0002\u0002\"1!n\u0002C\u0001\u0003\u000fC\u0011\"!%\b\u0005\u0004%\t!a%\t\u0011\u0005\u0005v\u0001)A\u0005\u0003+Cq!a)\b\t\u0003\t)K\u0002\u0004\u00028\u00061\u0011\u0011\u0018\u0005\r\u0003#s!\u0011!Q\u0001\n\u0005M\u0014\u0011\u001a\u0005\r\u0003or!\u0011!Q\u0001\n\u0005e\u00141\u001a\u0005\r\u0003\u007fr!\u0011!Q\u0001\f\u0005\u0005\u0015Q\u001a\u0005\u0007U:!\t!!5\t\u0011\u0005ug\u0002)Q\u0005\u0003?D\u0001\"!:\u000fA\u0003&\u0011q\u001d\u0005\t\u0003[t\u0001\u0015)\u0003\u0002`\"A\u0011q\u001e\b!B\u0013\t9\u000f\u0003\u0005\u0002r:\u0001\u000b\u0015BAp\u0011!\t\u0019P\u0004Q!\n\u0005\u001d\bbCA\u0003\u001d\u0001\u0007\t\u0011)Q\u0005\u0003?D1\"a\u0004\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002`\"Y\u0011q\u0004\bA\u0002\u0003\u0005\u000b\u0015BAp\u0011-\t\u0019C\u0004a\u0001\u0002\u0003\u0006K!!>\t\u0017\u0005\u001db\u00021A\u0001B\u0003&\u0011q\u001d\u0005\f\u0003Wq\u0001\u0019!A!B\u0013\tY\u0010C\u0006\u000209\u0001\r\u0011!Q!\n\u0005m\bbCA\u001a\u001d\u0001\u0007\t\u0011)Q\u0005\u0003?D\u0001B!\u0001\u000fA\u0003%!1\u0001\u0005\t\u0005\u0003r\u0001\u0015!\u0003\u0003\u0004!A!1\t\b!\u0002\u0013\u0011\u0019\u0001\u0003\u0005\u0003F9\u0001\u000b\u0011\u0002B\u0002\u0011!\u00119E\u0004Q\u0001\n\t%\u0003\u0002\u0003B&\u001d\u0001\u0006IA!\u0014\t\u0011\t\rd\u0002)A\u0005\u0005KB\u0001Ba\u001f\u000fA\u0003%!Q\r\u0005\t\u0005{r\u0001\u0015!\u0003\u0003f!A!q\u0010\b!\u0002\u0013\u0011)\u0007\u0003\u0005\u0003\u0002:\u0001\u000b\u0011\u0002B3\u0011!\u0011\u0019I\u0004Q\u0001\n\t\u0015\u0005\u0002\u0003BD\u001d\u0001\u0006IA!\"\t\u0011\t%e\u0002)A\u0005\u0005KB\u0001Ba#\u000fA\u0003%!Q\u0012\u0005\t\u0005;s\u0001\u0015!\u0003\u0003 \"A!1\u0016\b!B\u0013\ty\u000eC\u0006\u0003.:\u0001\r\u0011!Q!\n\t=\u0006\u0002CAb\u001d\u0001\u0006K!a8\t\u0011\tEf\u0002)Q\u0005\u0003?DqAa-\u000f\t#\u0012I\u0004C\u0004\u00036:!IA!\u000f\u0007\r\t\u001ddB\u0002B5\u0011)\u0011Ic\u000eB\u0001B\u0003%!1\u000f\u0005\u0007U^\"\tA!\u001e\t\u000f\t]r\u0007\"\u0005\u0003:\u00191!q\u0001\b\u0007\u0005\u0013A!B!\u000b<\u0005\u0003\u0005\u000b\u0011\u0002B\u0016\u0011\u0019Q7\b\"\u0001\u00032!9!qG\u001e\u0005\u0012\tebA\u0002B(\u001d\u0019\u0011\t\u0006\u0003\u0006\u0003*}\u0012\t\u0011)A\u0005\u00057BaA[ \u0005\u0002\tu\u0003b\u0002B\u001c\u007f\u0011E!\u0011\b\u0005\b\u0005osA\u0011\u0001B\u001d\u0011\u001d\u0011IL\u0004C!\u0005wCqAa6\u000f\t\u0013\u0011I\u0004C\u0004\u0003Z:!IA!\u000f\t\u000f\tmg\u0002\"\u0003\u0003:!9!Q\u001c\b\u0005\n\te\u0002b\u0002Bp\u001d\u0011%!\u0011\b\u0005\b\u0005CtA\u0011\u0002B\u001d\u0011\u001d\u0011\u0019O\u0004C\u0005\u0005sAqA!:\u000f\t\u0013\u0011I\u0004\u0003\u0005\u0003h:\u0001\u000b\u0015BAt\u0011-\u0011IO\u0004a\u0001\u0002\u0003\u0006KAa;\t\u0011\tEh\u0002)Q\u0005\u0003?D\u0001Ba=\u000fA\u0003&\u0011q\u001c\u0005\b\u0005ktA\u0011\u0002B\u001d\u0011\u001d\u00119P\u0004C\u0005\u0005sAqA!?\u000f\t\u0013\u0011I\u0004C\u0004\u0003|:!IA!@\t\u000f\r=a\u0002\"\u0003\u0004\u0012\u0005A\u0001+\u001a8J[\u0006<WM\u0003\u0002Y3\u000611\u000f\u001e:fC6T!AW.\u0002\r\u0019\u001c8-\u00199f\u0015\taV,A\u0003tG&\u001c8OC\u0001_\u0003\t!Wm\u0001\u0001\u0011\u0005\u0005\fQ\"A,\u0003\u0011A+g.S7bO\u0016\u001c\"!\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001-A\u0003baBd\u0017\u0010\u0006\u000eowv|\u00181AA\u0007\u0003#\t)\"!\u0007\u0002\u001e\u0005\u0005\u0012QEA\u0015\u0003[\t\t\u0004\u0006\u0002pmB\u0011\u0001o\u001d\b\u0003CFL!A],\u0002\u000fA\f7m[1hK&\u0011A/\u001e\u0002\u0005\u001fV$HI\u0003\u0002s/\")qo\u0001a\u0002q\u0006\t!\r\u0005\u0002bs&\u0011!p\u0016\u0002\b\u0005VLG\u000eZ3s\u0011\u0015a8\u00011\u0001p\u0003\r\u0019(o\u0019\u0005\u0006}\u000e\u0001\ra\\\u0001\u0006C2\u0004\b.\u0019\u0005\u0007\u0003\u0003\u0019\u0001\u0019A8\u0002\u0007\u0011\u001cH\u000fC\u0004\u0002\u0006\r\u0001\r!a\u0002\u0002\u000b]LG\r\u001e5\u0011\u0007A\fI!C\u0002\u0002\fU\u0014AaT;u\u0013\"9\u0011qB\u0002A\u0002\u0005\u001d\u0011A\u00025fS\u001eDG\u000f\u0003\u0004\u0002\u0014\r\u0001\ra\\\u0001\u0002q\"1\u0011qC\u0002A\u0002=\f\u0011!\u001f\u0005\b\u00037\u0019\u0001\u0019AA\u0004\u0003\u0011qW\r\u001f;\t\u000f\u0005}1\u00011\u0001\u0002\b\u0005!!/\u001e7f\u0011\u001d\t\u0019c\u0001a\u0001\u0003\u000f\t!a\u001c9\t\u000f\u0005\u001d2\u00011\u0001\u0002\b\u0005!qO]1q\u0011\u0019\tYc\u0001a\u0001_\u00069!o\u001c7m\u001f\u001a4\u0007BBA\u0018\u0007\u0001\u0007q.\u0001\u0006lC&\u001cXM\u001d\"fi\u0006Dq!a\r\u0004\u0001\u0004\t9!A\u0007{KJ|7I]8tg&twm]\u0001\u0005]\u0006lW-\u0006\u0002\u0002:=\u0011\u00111H\u0011\u0002-\u0006)a.Y7fA\t\u00191\u000b\u001b9\u0011E\u0005\r\u00131JA(\u0003\u001f\ny%!\u0018\u0002^\u0005=\u0013qJA/\u0003;\ni&!\u0018\u0002P\u0005=\u0013QLA(\u001b\t\t)EC\u0002Y\u0003\u000fR!!!\u0013\u0002\t\u0005\\7.Y\u0005\u0005\u0003\u001b\n)E\u0001\u0007GC:Len\u00155ba\u0016\fD\u0007\u0005\u0003\u0002R\u0005]cbA1\u0002T%\u0019\u0011QK,\u0002\u0007\t+h-\u0003\u0003\u0002Z\u0005m#!\u0001#\u000b\u0007\u0005Us\u000b\u0005\u0003\u0002R\u0005}\u0013\u0002BA1\u00037\u0012\u0011!\u0013\u0002\u0006'R\fw-Z\n\u0004\u000f\u0005\u001d\u0004CBA5\u0003_\n\u0019(\u0004\u0002\u0002l)\u0019\u0011QN,\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003c\nYGA\u0005Ti\u0006<W-S7qYB\u0019\u0011Q\u000f\u0004\u000e\u0003\u0005\tQ\u0001\\1zKJ\u00042\u0001]A>\u0013\r\ti(\u001e\u0002\u0006\u0019\u0006LXM]\u0001\u0002CB\u0019\u0011-a!\n\u0007\u0005\u0015uKA\u0005BY2|7-\u0019;peR!\u0011\u0011RAH)\u0011\tY)!$\u0011\u0007\u0005Ut\u0001C\u0004\u0002\u0000)\u0001\u001d!!!\t\u000f\u0005]$\u00021\u0001\u0002z\u0005)1\u000f[1qKV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bI*D\u0001\b\u0013\u0011\tY*!(\u0003\u000bMC\u0017\r]3\n\t\u0005}\u0015Q\t\u0002\u0006\u000fJ\f\u0007\u000f[\u0001\u0007g\"\f\u0007/\u001a\u0011\u0002\u0017\r\u0014X-\u0019;f\u0019><\u0017n\u0019\u000b\u0005\u0003O\u000bi\u000b\u0005\u0004\u0002j\u0005%\u0016QS\u0005\u0005\u0003W\u000bYG\u0001\u0005O_\u0012,\u0017*\u001c9m\u0011\u001d\ty+\u0004a\u0001\u0003c\u000bA!\u0019;ueB!\u00111IAZ\u0013\u0011\t),!\u0012\u0003\u0015\u0005#HO]5ckR,7OA\u0003M_\u001eL7mE\u0003\u000f\u0003w\u000bi\f\u0005\u0004\u0002j\u0005%\u00161\u000f\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YA#\u0003\u0015\u0019H/Y4f\u0013\u0011\t9-!1\u0003\u0015=+H\u000fS1oI2,'/\u0003\u0003\u0002\u0012\u0006%\u0016\u0002BA<\u0003SKA!a4\u0002*\u0006I\u0011\r\u001c7pG\u0006$xN\u001d\u000b\u0007\u0003'\fI.a7\u0015\t\u0005U\u0017q\u001b\t\u0004\u0003kr\u0001bBA@%\u0001\u000f\u0011\u0011\u0011\u0005\b\u0003#\u0013\u0002\u0019AA:\u0011\u001d\t9H\u0005a\u0001\u0003s\n!\"Y;y\t\u0006$\u0018MU3n!\r)\u0017\u0011]\u0005\u0004\u0003G4'aA%oi\u0006a\u0011-\u001e=ECR\f'+Z1esB\u0019Q-!;\n\u0007\u0005-hMA\u0004C_>dW-\u00198\u0002\u0015\u0011\u001cH\u000fR1uCJ+W.\u0001\u0007egR$\u0015\r^1SK\u0006$\u00170\u0001\u0006qK:$\u0015\r^1SK6\fA\u0002]3o\t\u0006$\u0018MU3bIf\u0004\u0012\"ZA|\u0003w\fY0a?\n\u0007\u0005ehMA\u0005Gk:\u001cG/[8oeA\u0019Q-!@\n\u0007\u0005}hM\u0001\u0004E_V\u0014G.Z\u0001\u0005QN\u00138\rE\u0003\u0003\u0006m\nY0D\u0001\u000f\u00051\u0001VM\\%o\u0011\u0006tG\r\\3s+\u0011\u0011YAa\u0006\u0014\u0007m\u0012i\u0001\u0005\u0004\u0003\u0006\t=!1C\u0005\u0005\u0005#\tIKA\u0007J]\"\u000bg\u000e\u001a7fe&k\u0007\u000f\u001c\t\u0005\u0005+\u00119\u0002\u0004\u0001\u0005\u000f\te1H1\u0001\u0003\u001c\t\t\u0011)\u0005\u0003\u0003\u001e\t\r\u0002cA3\u0003 %\u0019!\u0011\u00054\u0003\u000f9{G\u000f[5oOB\u0019QM!\n\n\u0007\t\u001dbMA\u0002B]f\f!!\u001b8\u0011\u000bA\u0014iCa\u0005\n\u0007\t=RO\u0001\u0002J]R!!1\u0007B\u001b!\u0015\u0011)a\u000fB\n\u0011\u001d\u0011I#\u0010a\u0001\u0005W\t1B\\8uS\u001aLh+\u00197vKR\u0011!1\b\t\u0004K\nu\u0012b\u0001B M\n!QK\\5u\u0003\u0019A\u0017\t\u001c9iC\u0006\u0011\u0001\u000eW\u0001\u0003Qf\u000bQ\u0001\u001b(fqR\u0004RA!\u0002<\u0003?\fA\u0001\u001b#tiB)!QA \u0002|\naAi\u001d;J]\"\u000bg\u000e\u001a7feV!!1\u000bB-'\ry$Q\u000b\t\u0007\u0005\u000b\u0011yAa\u0016\u0011\t\tU!\u0011\f\u0003\b\u00053y$\u0019\u0001B\u000e!\u0015\u0001(Q\u0006B,)\u0011\u0011yF!\u0019\u0011\u000b\t\u0015qHa\u0016\t\u000f\t%\u0012\t1\u0001\u0003\\\u00051\u0001nV5ei\"\u0004RA!\u00028\u0003?\u0014A\"Q;y\u0013:D\u0015M\u001c3mKJ,BAa\u001b\u0003rM\u0019qG!\u001c\u0011\r\t\u0015!q\u0002B8!\u0011\u0011)B!\u001d\u0005\u000f\teqG1\u0001\u0003\u001cA)\u0001O!\f\u0003pQ!!q\u000fB=!\u0015\u0011)a\u000eB8\u0011\u001d\u0011I#\u000fa\u0001\u0005g\nq\u0001\u001b%fS\u001eDG/A\u0003i%VdW-A\u0002i\u001fB\fQ\u0001[,sCB\f\u0001\u0002\u001b*pY2|eM\u001a\t\u0006\u0005\u000b9\u00141`\u0001\fQ.\u000b\u0017n]3s\u0005\u0016$\u0018-\u0001\bi5\u0016\u0014xn\u0011:pgNLgnZ:\u0002\u001bA,g.\u00138IC:$G.\u001a:t!\u0015)'q\u0012BJ\u0013\r\u0011\tJ\u001a\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u0005+\u0013I\nE\u0003\u0003\u0006m\u00129\n\u0005\u0003\u0003\u0016\teEa\u0003BN_\u0005\u0005\t\u0011!B\u0001\u00057\u00111a\u0018\u00132\u00035\tW\u000f_%o\u0011\u0006tG\r\\3sgB)QMa$\u0003\"B\"!1\u0015BT!\u0019\u0011)Aa\u0004\u0003&B!!Q\u0003BT\t-\u0011I\u000bMA\u0001\u0002\u0003\u0015\tAa\u0007\u0003\u0007}##'A\u0005ge\u0006lWmU5{K\u0006AaM]1nK\n+h\rE\u0003f\u0005\u001f\u000bY0\u0001\u0006egR<&/\u001b;uK:\fqa\u001d;paB,G-A\u0007ge\u0016,w*\u001e;Ck\u001a4WM]\u0001\u0007_:\u0004V\u000f\u001c7\u0002%=tGi\\<ogR\u0014X-Y7GS:L7\u000f\u001b\u000b\u0005\u0005w\u0011i\fC\u0004\u0003@\u0012\u0003\rA!1\u0002\u000b\r\fWo]3\u0011\t\t\r'\u0011\u001b\b\u0005\u0005\u000b\u0014yM\u0004\u0003\u0003H\n5WB\u0001Be\u0015\r\u0011YmX\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dL!A\u001d4\n\t\tM'Q\u001b\u0002\n)\"\u0014xn^1cY\u0016T!A\u001d4\u0002%I,\u0017/^3ti:+\u0007\u0010^!vq\u0012\u000bG/Y\u0001\u0013e\u0016\fX/Z:u\u001d\u0016DH\u000fR:u\t\u0006$\u0018-\u0001\nsKF,Xm\u001d;OKb$\b+\u001a8ECR\f\u0017A\u00058pi&4\u00170Q;y\t\u0006$\u0018MU3bIf\f!C\\8uS\u001aLHi\u001d;ECR\f'+Z1es\u0006\u0011bn\u001c;jMf\u0004VM\u001c#bi\u0006\u0014V-\u00193z\u00039\u0001(o\\2fgN\fU\u000f\u001f#bi\u0006\fa\u0002\u001d:pG\u0016\u001c8\u000fR:u\t\u0006$\u0018-A\u0003oKb$\b+\u0001\u0004ck\u001a|U\u000f\u001e\t\u0004C\n5\u0018b\u0001Bx/\n!!)\u001e4E\u0003\u0019yW\u000f^(gM\u0006Qq.\u001e;Xe&$H/\u001a8\u0002\u001dA\u0014xnY3tgB+g\u000eR1uC\u0006q\u0001O]8dKN\u001cx*\u001e;ECR\f\u0017\u0001C<sSR,w*\u001e;\u0002\u0013\r\fGn\u0019,bYV,GCCA~\u0005\u007f\u001c\u0019aa\u0002\u0004\f!91\u0011\u0001+A\u0002\u0005m\u0018AA\"t\u0011\u001d\u0019)\u0001\u0016a\u0001\u0003w\f!!Q:\t\u000f\r%A\u000b1\u0001\u0002|\u0006\u00111\t\u001a\u0005\b\u0007\u001b!\u0006\u0019AA~\u0003\u00059\u0018a\u00029s_\u000e,7o\u001d\u000b\u000b\u0005w\u0019\u0019b!\u0006\u0004\u0018\re\u0001bBA\n+\u0002\u0007\u00111 \u0005\b\u0003/)\u0006\u0019AA~\u0011\u001d\u0019\t!\u0016a\u0001\u0003wDqa!\u0002V\u0001\u0004\tY\u0010")
public final class PenImage {
    public static Outlet<Buf> apply(Outlet<Buf> src, Outlet<Buf> alpha, Outlet<Buf> dst, Outlet<Buf> width, Outlet<Buf> height, Outlet<Buf> x, Outlet<Buf> y, Outlet<Buf> next, Outlet<Buf> rule, Outlet<Buf> op, Outlet<Buf> wrap, Outlet<Buf> rollOff, Outlet<Buf> kaiserBeta, Outlet<Buf> zeroCrossings, Builder b) {
        return PenImage$.MODULE$.apply(src, alpha, dst, width, height, x, y, next, rule, op, wrap, rollOff, kaiserBeta, zeroCrossings, b);
    }

    private static final class Logic
    extends NodeImpl<FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>>
    implements OutHandler {
        public int de$sciss$fscape$stream$PenImage$Logic$$auxDataRem;
        private boolean auxDataReady;
        public int de$sciss$fscape$stream$PenImage$Logic$$dstDataRem;
        private boolean dstDataReady;
        public int de$sciss$fscape$stream$PenImage$Logic$$penDataRem;
        private boolean penDataReady;
        private int width;
        private int height;
        private int rule;
        private Function2<Object, Object, Object> op;
        private boolean wrap;
        private double rollOff;
        private double kaiserBeta;
        private int zeroCrossings;
        private final PenInHandler<Object> hSrc;
        private final PenInHandler<Object> hAlpha;
        private final PenInHandler<Object> hX;
        private final PenInHandler<Object> hY;
        private final PenInHandler<Object> hNext;
        private final DstInHandler<Object> hDst;
        private final AuxInHandler<Object> hWidth;
        private final AuxInHandler<Object> hHeight;
        private final AuxInHandler<Object> hRule;
        private final AuxInHandler<Object> hOp;
        private final AuxInHandler<Object> hWrap;
        private final AuxInHandler<Object> hRollOff;
        private final AuxInHandler<Object> hKaiserBeta;
        private final AuxInHandler<Object> hZeroCrossings;
        private final PenInHandler<?>[] penInHandlers;
        private final NodeImpl.InHandlerImpl<?>[] auxInHandlers;
        private int frameSize;
        private double[] frameBuf;
        private int stage;
        private int dstWritten;
        private boolean nextP;
        private BufD bufOut;
        private int outOff;
        private int outWritten;

        @Override
        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$(this);
        }

        @Override
        public void stopped() {
            Node.stopped$(this);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.auxInHandlers), (Function1<NodeImpl.InHandlerImpl, Object> & Serializable)x$10 -> {
                x$10.freeBuffer();
                return BoxedUnit.UNIT;
            });
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.penInHandlers), (Function1<PenInHandler, Object> & Serializable)x$11 -> {
                x$11.freeBuffer();
                return BoxedUnit.UNIT;
            });
            this.frameBuf = null;
            this.freeOutBuffer();
        }

        private void freeOutBuffer() {
            if (this.bufOut != null) {
                this.bufOut.release(super.allocator());
                this.bufOut = null;
                return;
            }
        }

        @Override
        public void onPull() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> new StringBuilder(9).append("onPull() ").append(this).toString());
            if (this.stage == 3) {
                this.processOutData();
                return;
            }
        }

        @Override
        public void onDownstreamFinish(Throwable cause) {
            Log$.MODULE$.stream().info((Function0<String> & Serializable)() -> new StringBuilder(21).append("onDownstreamFinish() ").append(this).toString());
            OutHandler.onDownstreamFinish$(this, cause);
        }

        private void requestNextAuxData() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "requestNextAuxData");
            Predef$.MODULE$.assert(this.stage == 0);
            Predef$.MODULE$.assert(!this.auxDataReady);
            if (this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem == 0) {
                this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(this.auxInHandlers), (Function1<NodeImpl.InHandlerImpl, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.hasNext()));
                if (this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem > 0) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.auxInHandlers), (Function1<NodeImpl.InHandlerImpl, Object> & Serializable)h -> {
                        Logic.$anonfun$requestNextAuxData$3(h);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                this.de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady();
                return;
            }
        }

        private void requestNextDstData() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "requestNextDstData");
            Predef$.MODULE$.assert(this.stage == 1);
            Predef$.MODULE$.assert(!this.dstDataReady);
            if (this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem == 0) {
                if (this.hDst.hasNext()) {
                    this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem = 1;
                    this.hDst.next();
                    return;
                }
                this.de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady();
                return;
            }
        }

        private void requestNextPenData() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "requestNextPenData");
            Predef$.MODULE$.assert(this.stage == 2);
            Predef$.MODULE$.assert(!this.penDataReady);
            if (this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem == 0) {
                this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(this.penInHandlers), (Function1<PenInHandler, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.hasNext()));
                if (this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem > 0) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.penInHandlers), (Function1<PenInHandler, Object> & Serializable)h -> {
                        Logic.$anonfun$requestNextPenData$3(h);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                this.de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady();
                return;
            }
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "notifyAuxDataReady");
            Predef$.MODULE$.assert(!this.auxDataReady);
            if (this.stage == 0) {
                this.processAuxData();
                return;
            }
            this.auxDataReady = true;
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "notifyDstDataReady");
            Predef$.MODULE$.assert(!this.dstDataReady);
            if (this.stage == 1) {
                this.processDstData();
                return;
            }
            this.dstDataReady = true;
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "notifyPenDataReady");
            Predef$.MODULE$.assert(!this.penDataReady);
            if (this.stage == 2) {
                this.processPenData();
                return;
            }
            this.penDataReady = true;
        }

        private void processAuxData() {
            Log$.MODULE$.stream().error((Function0<String> & Serializable)() -> "processAuxData");
            Predef$.MODULE$.assert(this.stage == 0);
            this.width = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hWidth.takeValue())), 1);
            this.height = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hHeight.takeValue())), 1);
            this.rule = RichInt$.MODULE$.clip$extension(Implicits$.MODULE$.intNumberWrapper(BoxesRunTime.unboxToInt(this.hRule.takeValue())), 1, 12);
            BinaryOp.Op<?, ?, ?> op = BinaryOp$Op$.MODULE$.legacy(RichInt$.MODULE$.clip$extension(Implicits$.MODULE$.intNumberWrapper(BoxesRunTime.unboxToInt(this.hOp.takeValue())), 0, 101));
            if (op instanceof BinaryOp.OpDD) {
                BinaryOp.Op<?, ?, ?> op2 = op;
                this.op = ((BinaryOp.OpDD)((Object)op2)).funDD();
            } else {
                this.notifyFail(new IllegalArgumentException(new StringBuilder(47).append("Op ").append(op).append(" does not support double-to-double operation").toString()));
            }
            this.wrap = BoxesRunTime.unboxToInt(this.hWrap.takeValue()) != 0;
            this.rollOff = new RichDouble(Implicits$.MODULE$.doubleNumberWrapper(BoxesRunTime.unboxToDouble(this.hRollOff.takeValue()))).clip(0.0, 1.0);
            this.kaiserBeta = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble(this.hKaiserBeta.takeValue())), 0.0);
            this.zeroCrossings = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hZeroCrossings.takeValue())), 0);
            int newFrameSize = this.width * this.height;
            if (this.frameSize != newFrameSize) {
                this.frameSize = newFrameSize;
                this.frameBuf = new double[newFrameSize];
            }
            this.stage = 1;
            if (this.dstDataReady) {
                this.dstDataReady = false;
                this.processDstData();
                return;
            }
            this.requestNextDstData();
        }

        private void processDstData() {
            int n;
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "processDstData");
            Predef$.MODULE$.assert(this.stage == 1);
            int dstRem = this.hDst.bufRemain();
            int frameRem = this.frameSize - this.dstWritten;
            if (dstRem == 0) {
                Util$.MODULE$.fill(this.frameBuf, this.dstWritten, frameRem, BoxesRunTime.unboxToDouble(this.hDst.takeValue()));
                n = frameRem;
            } else {
                Buf b = this.hDst.buf();
                int _chunk = scala.math.package$.MODULE$.min(dstRem, frameRem);
                int dstOff = this.hDst.offset();
                Util$.MODULE$.copy((double[])b.buf(), dstOff, this.frameBuf, this.dstWritten, _chunk);
                this.hDst.updateOffset(dstOff + _chunk);
                n = _chunk;
            }
            int chunk = n;
            this.dstWritten += chunk;
            if (this.dstWritten < this.frameSize) {
                this.requestNextDstData();
                return;
            }
            this.stage = 2;
            if (this.penDataReady) {
                this.penDataReady = false;
                this.processPenData();
                return;
            }
            this.requestNextPenData();
        }

        private void processPenData() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "processPenData");
            Predef$.MODULE$.assert(this.stage == 2);
            int srcRem = this.hSrc.bufRemain();
            int alphaRem = this.hAlpha.bufRemain();
            int xRem = this.hX.bufRemain();
            int yRem = this.hY.bufRemain();
            int nextRem = this.hNext.bufRemain();
            boolean next = false;
            double src = 0.0;
            double alpha = 0.0;
            double x = 0.0;
            double y = 0.0;
            int chunk = Integer.MAX_VALUE;
            if (srcRem > 0 && srcRem < chunk) {
                chunk = srcRem;
            }
            if (alphaRem > 0 && alphaRem < chunk) {
                chunk = alphaRem;
            }
            if (xRem > 0 && xRem < chunk) {
                chunk = xRem;
            }
            if (yRem > 0 && yRem < chunk) {
                chunk = yRem;
            }
            if (nextRem > 0 && nextRem < chunk) {
                chunk = nextRem;
            }
            if (!this.hSrc.hasNext()) {
                this.goToOut$1();
                return;
            }
            Predef$.MODULE$.assert(chunk < Integer.MAX_VALUE);
            while (chunk > 0) {
                boolean bl = next = BoxesRunTime.unboxToInt(this.hNext.peekValue()) != 0;
                if (!this.nextP && next) {
                    this.goToOut$1();
                    return;
                }
                this.hNext.skipValue();
                src = BoxesRunTime.unboxToDouble(this.hSrc.takeValue());
                alpha = BoxesRunTime.unboxToDouble(this.hAlpha.takeValue());
                x = BoxesRunTime.unboxToDouble(this.hX.takeValue());
                y = BoxesRunTime.unboxToDouble(this.hY.takeValue());
                this.process(x, y, src, alpha);
                --chunk;
                this.nextP = next;
            }
            this.requestNextPenData();
        }

        private void processOutData() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "processOutData");
            Predef$.MODULE$.assert(this.stage == 3);
            if (this.bufOut == null) {
                this.bufOut = this.allocator().borrowBufD();
            }
            int chunk = scala.math.package$.MODULE$.min(this.bufOut.size() - this.outOff, this.frameSize - this.outWritten);
            Util$.MODULE$.copy(this.frameBuf, this.outWritten, this.bufOut.buf(), this.outOff, chunk);
            this.outOff += chunk;
            this.outWritten += chunk;
            if (this.outOff == this.bufOut.size()) {
                this.writeOut();
            }
            if (this.outWritten == this.frameSize) {
                if (this.hSrc.hasNext()) {
                    this.stage = 0;
                    if (this.auxDataReady) {
                        this.auxDataReady = false;
                        this.processAuxData();
                        return;
                    }
                    this.requestNextAuxData();
                    return;
                }
                this.writeOut();
                this.completeStage();
                return;
            }
        }

        private void writeOut() {
            Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> "writeOut");
            if (this.outOff > 0) {
                this.bufOut.size_$eq(this.outOff);
                this.push(((FanInShape14)super.shape()).out(), this.bufOut);
                this.outOff = 0;
                this.bufOut = null;
                return;
            }
            this.freeOutBuffer();
        }

        private double calcValue(double Cs, double As2, double Cd, double w) {
            int n = this.rule;
            switch (n) {
                case 1: {
                    return 0.0;
                }
                case 2: 
                case 5: {
                    return Cs * w;
                }
                case 4: 
                case 9: {
                    return Cd;
                }
                case 3: {
                    return this.op.apply$mcDDD$sp(Cs * w, Cd * (1.0 - As2 * w));
                }
                case 7: {
                    return this.op.apply$mcDDD$sp(Cs * w, Cd);
                }
                case 6: 
                case 11: {
                    return Cd * (As2 * w);
                }
                case 8: {
                    return Cd * (1.0 - As2 * w);
                }
                case 12: {
                    return this.op.apply$mcDDD$sp(Cd, Cs * w);
                }
                case 10: {
                    return this.op.apply$mcDDD$sp(Cd * (1.0 - As2 * w), Cs * w);
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }

        private void process(double x, double y, double Cs, double As2) {
            double[] _winBuf = this.frameBuf;
            int _width = this.width;
            int _height = this.height;
            boolean _wrap = this.wrap;
            double xq = scala.math.package$.MODULE$.abs(x) % 1.0;
            int xTi = (int)x;
            double yq = scala.math.package$.MODULE$.abs(y) % 1.0;
            int yTi = (int)y;
            if (this.zeroCrossings == 0) {
                int y3;
                int x3;
                int y2;
                int x2;
                int y0;
                int x0;
                int y1;
                int w1 = _width - 1;
                int h1 = _height - 1;
                int x1 = _wrap ? IntFunctions$.MODULE$.wrap(xTi, 0, w1) : xTi;
                int n = y1 = _wrap ? IntFunctions$.MODULE$.wrap(yTi, 0, h1) : yTi;
                if (xq < 1.0E-20 && yq < 1.0E-20) {
                    if (_wrap || x1 >= 0 && x1 <= w1 && y1 >= 0 && y1 <= h1) {
                        double Cr;
                        int winBufOff = y1 * _width + x1;
                        double Cd = _winBuf[winBufOff];
                        _winBuf[winBufOff] = Cr = this.calcValue(Cs, As2, Cd, 1.0);
                        return;
                    }
                    return;
                }
                int n2 = x1 > 0 ? x1 - 1 : (x0 = _wrap ? w1 : x1 - 1);
                int n3 = y1 > 0 ? y1 - 1 : (y0 = _wrap ? h1 : y1 - 1);
                int n4 = x1 < w1 ? x1 + 1 : (x2 = _wrap ? 0 : x1 + 1);
                int n5 = y1 < h1 ? y1 + 1 : (y2 = _wrap ? 0 : y1 + 1);
                int n6 = x2 < w1 ? x2 + 1 : (x3 = _wrap ? 0 : x2 + 1);
                int n7 = y2 < h1 ? y2 + 1 : (y3 = _wrap ? 0 : y2 + 1);
                if (_wrap || x0 >= 0 && x3 <= w1 && y0 >= 0 && y3 <= h1) {
                    int y0s = y0 * _width;
                    int y1s = y1 * _width;
                    int y2s = y2 * _width;
                    int y3s = y3 * _width;
                    int p00 = y0s + x0;
                    int p10 = y0s + x1;
                    int p20 = y0s + x2;
                    int p30 = y0s + x3;
                    int p01 = y1s + x0;
                    int p11 = y1s + x1;
                    int p21 = y1s + x2;
                    int p31 = y1s + x3;
                    int p02 = y2s + x0;
                    int p12 = y2s + x1;
                    int p22 = y2s + x2;
                    int p32 = y2s + x3;
                    int p03 = y3s + x0;
                    int p13 = y3s + x1;
                    int p23 = y3s + x2;
                    int p33 = y3s + x3;
                    double t = xq;
                    double tt = t * t;
                    double ttt = tt * t;
                    double s = yq;
                    double ss = s * s;
                    double sss = ss * s;
                    double wx0 = (-t + (double)2 * tt - ttt) * 0.5;
                    double wx1 = ((double)2 - (double)5 * tt + (double)3 * ttt) * 0.5;
                    double wx2 = (t + (double)4 * tt - (double)3 * ttt) * 0.5;
                    double wx3 = (-tt + ttt) * 0.5;
                    double wy0 = (-s + (double)2 * ss - sss) * 0.5;
                    double wy1 = ((double)2 - (double)5 * ss + (double)3 * sss) * 0.5;
                    double wy2 = (s + (double)4 * ss - (double)3 * sss) * 0.5;
                    double wy3 = (-ss + sss) * 0.5;
                    _winBuf[p00] = this.calcValue(Cs, As2, _winBuf[p00], wx0 * wy0);
                    _winBuf[p10] = this.calcValue(Cs, As2, _winBuf[p10], wx1 * wy0);
                    _winBuf[p20] = this.calcValue(Cs, As2, _winBuf[p20], wx2 * wy0);
                    _winBuf[p30] = this.calcValue(Cs, As2, _winBuf[p30], wx3 * wy0);
                    _winBuf[p01] = this.calcValue(Cs, As2, _winBuf[p01], wx0 * wy1);
                    _winBuf[p11] = this.calcValue(Cs, As2, _winBuf[p11], wx1 * wy1);
                    _winBuf[p21] = this.calcValue(Cs, As2, _winBuf[p21], wx2 * wy1);
                    _winBuf[p31] = this.calcValue(Cs, As2, _winBuf[p31], wx3 * wy1);
                    _winBuf[p02] = this.calcValue(Cs, As2, _winBuf[p02], wx0 * wy2);
                    _winBuf[p12] = this.calcValue(Cs, As2, _winBuf[p12], wx1 * wy2);
                    _winBuf[p22] = this.calcValue(Cs, As2, _winBuf[p22], wx2 * wy2);
                    _winBuf[p32] = this.calcValue(Cs, As2, _winBuf[p32], wx3 * wy2);
                    _winBuf[p03] = this.calcValue(Cs, As2, _winBuf[p03], wx0 * wy3);
                    _winBuf[p13] = this.calcValue(Cs, As2, _winBuf[p13], wx1 * wy3);
                    _winBuf[p23] = this.calcValue(Cs, As2, _winBuf[p23], wx2 * wy3);
                    _winBuf[p33] = this.calcValue(Cs, As2, _winBuf[p33], wx3 * wy3);
                    return;
                }
                return;
            }
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public static final /* synthetic */ void $anonfun$requestNextAuxData$3(NodeImpl.InHandlerImpl h) {
            if (h.hasNext()) {
                h.next();
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$requestNextPenData$3(PenInHandler h) {
            if (h.hasNext()) {
                h.next();
                return;
            }
        }

        private final void goToOut$1() {
            this.nextP = true;
            this.stage = 3;
            this.outWritten = 0;
            if (this.isAvailable(((FanInShape14)super.shape()).out())) {
                this.processOutData();
                return;
            }
        }

        public Logic(FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape, int layer, Allocator a) {
            super("PenImage", layer, shape, a);
            OutHandler.$init$(this);
            this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem = 8;
            this.auxDataReady = false;
            this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem = 1;
            this.dstDataReady = false;
            this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem = 5;
            this.penDataReady = false;
            this.hSrc = new PenInHandler(this, ((FanInShape14)super.shape()).in0());
            this.hAlpha = new PenInHandler(this, ((FanInShape14)super.shape()).in1());
            this.hX = new PenInHandler(this, ((FanInShape14)super.shape()).in5());
            this.hY = new PenInHandler(this, ((FanInShape14)super.shape()).in6());
            this.hNext = new PenInHandler(this, ((FanInShape14)super.shape()).in7());
            this.hDst = new DstInHandler(this, ((FanInShape14)super.shape()).in2());
            this.hWidth = new AuxInHandler(this, ((FanInShape14)super.shape()).in3());
            this.hHeight = new AuxInHandler(this, ((FanInShape14)super.shape()).in4());
            this.hRule = new AuxInHandler(this, ((FanInShape14)super.shape()).in8());
            this.hOp = new AuxInHandler(this, ((FanInShape14)super.shape()).in9());
            this.hWrap = new AuxInHandler(this, ((FanInShape14)super.shape()).in10());
            this.hRollOff = new AuxInHandler(this, ((FanInShape14)super.shape()).in11());
            this.hKaiserBeta = new AuxInHandler(this, ((FanInShape14)super.shape()).in12());
            this.hZeroCrossings = new AuxInHandler(this, ((FanInShape14)super.shape()).in13());
            this.penInHandlers = (PenInHandler[])((Object[])new PenInHandler[]{this.hSrc, this.hAlpha, this.hX, this.hY, this.hNext});
            this.auxInHandlers = (NodeImpl.InHandlerImpl[])((Object[])new NodeImpl.InHandlerImpl[]{this.hWidth, this.hHeight, this.hRule, this.hOp, this.hWrap, this.hRollOff, this.hKaiserBeta, this.hZeroCrossings});
            this.frameSize = -1;
            this.stage = 0;
            this.dstWritten = 0;
            this.setHandler(((FanInShape14)super.shape()).out(), this);
            this.nextP = true;
            this.outOff = 0;
            this.outWritten = 0;
        }

        private final class AuxInHandler<A>
        extends NodeImpl.InHandlerImpl<A> {
            @Override
            public void notifyValue() {
                --this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$auxDataRem;
                if (this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$auxDataRem == 0) {
                    this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady();
                    return;
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public AuxInHandler(Logic $outer, Inlet<Buf> in) {
                super($outer, in);
            }
        }

        private final class DstInHandler<A>
        extends NodeImpl.InHandlerImpl<A> {
            @Override
            public void notifyValue() {
                --this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$dstDataRem;
                if (this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$dstDataRem == 0) {
                    this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady();
                    return;
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public DstInHandler(Logic $outer, Inlet<Buf> in) {
                super($outer, in);
            }
        }

        private final class PenInHandler<A>
        extends NodeImpl.InHandlerImpl<A> {
            @Override
            public void notifyValue() {
                --this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$penDataRem;
                if (this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$penDataRem == 0) {
                    this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady();
                    return;
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public PenInHandler(Logic $outer, Inlet<Buf> in) {
                super($outer, in);
            }
        }
    }

    private static final class Stage
    extends StageImpl<FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>> {
        private final int layer;
        private final Allocator a;
        private final FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape;

        @Override
        public FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape() {
            return this.shape;
        }

        @Override
        public NodeImpl<FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>> createLogic(Attributes attr) {
            return new Logic((FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>)this.shape(), this.layer, this.a);
        }

        public Stage(int layer, Allocator a) {
            this.layer = layer;
            this.a = a;
            super("PenImage");
            this.shape = new FanInShape14<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>(package$.MODULE$.InD(new StringBuilder(4).append(this.name()).append(".src").toString()), package$.MODULE$.InD(new StringBuilder(6).append(this.name()).append(".alpha").toString()), package$.MODULE$.InD(new StringBuilder(4).append(this.name()).append(".dst").toString()), package$.MODULE$.InI(new StringBuilder(6).append(this.name()).append(".width").toString()), package$.MODULE$.InI(new StringBuilder(7).append(this.name()).append(".height").toString()), package$.MODULE$.InD(new StringBuilder(2).append(this.name()).append(".x").toString()), package$.MODULE$.InD(new StringBuilder(2).append(this.name()).append(".y").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".next").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".rule").toString()), package$.MODULE$.InI(new StringBuilder(3).append(this.name()).append(".op").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".wrap").toString()), package$.MODULE$.InD(new StringBuilder(8).append(this.name()).append(".rollOff").toString()), package$.MODULE$.InD(new StringBuilder(11).append(this.name()).append(".kaiserBeta").toString()), package$.MODULE$.InI(new StringBuilder(14).append(this.name()).append(".zeroCrossings").toString()), package$.MODULE$.OutD(new StringBuilder(4).append(this.name()).append(".out").toString()));
        }
    }
}

