/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.Enc;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.MP3Data;
import de.sciss.jump3r.mp3.Parse;
import de.sciss.jump3r.mpg.MPGLib;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public class GetAudio {
    Parse parse;
    MPGLib mpg;
    private boolean count_samples_carefully;
    private int pcmbitwidth;
    private boolean pcmswapbytes;
    private boolean pcm_is_unsigned_8bit;
    private int num_samples_read;
    private RandomAccessFile musicin;
    private MPGLib.mpstr_tag hip;
    private static final String type_name = "MP3 file";
    private static final int IFF_ID_FORM = 1179603533;
    private static final int IFF_ID_AIFF = 1095321158;
    private static final int IFF_ID_AIFC = 1095321155;
    private static final int IFF_ID_COMM = 1129270605;
    private static final int IFF_ID_SSND = 1397968452;
    private static final int IFF_ID_NONE = 1313820229;
    private static final int IFF_ID_2CBE = 1953984371;
    private static final int IFF_ID_2CLE = 1936684916;
    private static final int WAV_ID_RIFF = 1380533830;
    private static final int WAV_ID_WAVE = 1463899717;
    private static final int WAV_ID_FMT = 1718449184;
    private static final int WAV_ID_DATA = 1684108385;
    private static final short WAVE_FORMAT_PCM = 1;
    private static final short WAVE_FORMAT_EXTENSIBLE = -2;
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final char[] abl2 = new char[]{'\u0000', '\u0007', '\u0007', '\u0007', '\u0000', '\u0007', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\b', '\b', '\b', '\b', '\b'};

    public void setModules(Parse parse2, MPGLib mpg2) {
        this.parse = parse2;
        this.mpg = mpg2;
    }

    public DataOutput init_outfile(String outPath) {
        DataOutputStream outf;
        try {
            new File(outPath).delete();
            outf = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outPath), 0x100000));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return outf;
    }

    public final void init_infile(LameGlobalFlags gfp, String inPath, Enc enc) {
        this.count_samples_carefully = false;
        this.num_samples_read = 0;
        this.pcmbitwidth = this.parse.in_bitwidth;
        this.pcmswapbytes = this.parse.swapbytes;
        this.pcm_is_unsigned_8bit = !this.parse.in_signed;
        this.musicin = this.OpenSndFile(gfp, inPath, enc);
    }

    public final void close_infile() {
        this.closeSndFile(this.parse.input_format, this.musicin);
    }

    public final int get_audio(LameGlobalFlags gfp, int[][] buffer) {
        return this.get_audio_common(gfp, buffer, null);
    }

    public final int get_audio16(LameGlobalFlags gfp, short[][] buffer) {
        return this.get_audio_common(gfp, null, buffer);
    }

    private int get_audio_common(LameGlobalFlags gfp, int[][] buffer, short[][] buffer16) {
        int samples_read;
        int remaining;
        int framesize;
        int num_channels = gfp.num_channels;
        int[] insamp = new int[2304];
        short[][] buf_tmp16 = new short[2][1152];
        int samples_to_read = framesize = gfp.framesize;
        assert (framesize <= 1152);
        int tmp_num_samples = gfp.num_samples;
        if (this.count_samples_carefully && (remaining = tmp_num_samples - Math.min(tmp_num_samples, this.num_samples_read)) < framesize && 0 != tmp_num_samples) {
            samples_to_read = remaining;
        }
        if (this.is_mpeg_file_format(this.parse.input_format)) {
            samples_read = buffer != null ? this.read_samples_mp3(gfp, this.musicin, buf_tmp16) : this.read_samples_mp3(gfp, this.musicin, buffer16);
            if (samples_read < 0) {
                return samples_read;
            }
        } else {
            int i;
            samples_read = this.read_samples_pcm(this.musicin, insamp, num_channels * samples_to_read);
            if (samples_read < 0) {
                return samples_read;
            }
            int p = samples_read;
            samples_read /= num_channels;
            if (buffer != null) {
                if (num_channels == 2) {
                    i = samples_read;
                    while (--i >= 0) {
                        buffer[1][i] = insamp[--p];
                        buffer[0][i] = insamp[--p];
                    }
                } else if (num_channels == 1) {
                    Arrays.fill(buffer[1], 0, samples_read, 0);
                    i = samples_read;
                    while (--i >= 0) {
                        buffer[0][i] = insamp[--p];
                    }
                } else assert (false);
            } else if (num_channels == 2) {
                i = samples_read;
                while (--i >= 0) {
                    buffer16[1][i] = (short)(insamp[--p] >> 16 & 0xFFFF);
                    buffer16[0][i] = (short)(insamp[--p] >> 16 & 0xFFFF);
                }
            } else if (num_channels == 1) {
                Arrays.fill(buffer16[1], 0, samples_read, (short)0);
                i = samples_read;
                while (--i >= 0) {
                    buffer16[0][i] = (short)(insamp[--p] >> 16 & 0xFFFF);
                }
            } else assert (false);
        }
        if (this.is_mpeg_file_format(this.parse.input_format) && buffer != null) {
            int i = samples_read;
            while (--i >= 0) {
                buffer[0][i] = (buf_tmp16[0][i] & 0xFFFF) << 16;
            }
            if (num_channels == 2) {
                i = samples_read;
                while (--i >= 0) {
                    buffer[1][i] = (buf_tmp16[1][i] & 0xFFFF) << 16;
                }
            } else if (num_channels == 1) {
                Arrays.fill(buffer[1], 0, samples_read, 0);
            } else assert (false);
        }
        if (tmp_num_samples != Integer.MAX_VALUE) {
            this.num_samples_read += samples_read;
        }
        return samples_read;
    }

    int read_samples_mp3(LameGlobalFlags gfp, RandomAccessFile musicin, short[][] mpg123pcm) {
        int out = this.lame_decode_fromfile(musicin, mpg123pcm[0], mpg123pcm[1], this.parse.mp3input_data);
        if (out < 0) {
            Arrays.fill(mpg123pcm[0], (short)0);
            Arrays.fill(mpg123pcm[1], (short)0);
            return 0;
        }
        if (gfp.num_channels != this.parse.mp3input_data.stereo) {
            if (this.parse.silent < 10) {
                System.err.printf("Error: number of channels has changed in %s - not supported\n", type_name);
            }
            out = -1;
        }
        if (gfp.in_samplerate != this.parse.mp3input_data.samplerate) {
            if (this.parse.silent < 10) {
                System.err.printf("Error: sample frequency has changed in %s - not supported\n", type_name);
            }
            out = -1;
        }
        return out;
    }

    public final int WriteWaveHeader(DataOutput fp, int pcmbytes, int freq, int channels, int bits) {
        try {
            int bytes = (bits + 7) / 8;
            fp.writeBytes("RIFF");
            this.write32BitsLowHigh(fp, pcmbytes + 44 - 8);
            fp.writeBytes("WAVEfmt ");
            this.write32BitsLowHigh(fp, 16);
            this.write16BitsLowHigh(fp, 1);
            this.write16BitsLowHigh(fp, channels);
            this.write32BitsLowHigh(fp, freq);
            this.write32BitsLowHigh(fp, freq * channels * bytes);
            this.write16BitsLowHigh(fp, channels * bytes);
            this.write16BitsLowHigh(fp, bits);
            fp.writeBytes("data");
            this.write32BitsLowHigh(fp, pcmbytes);
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private int unpack_read_samples(int samples_to_read, int bytes_per_sample, boolean swap_order, int[] sample_buffer, RandomAccessFile pcm_in) throws IOException {
        int samples_read;
        block16: {
            int i;
            byte[] bytes;
            block15: {
                int i2;
                bytes = new byte[bytes_per_sample * samples_to_read];
                pcm_in.readFully(bytes);
                int op = samples_read = samples_to_read;
                if (swap_order) break block15;
                if (bytes_per_sample == 1) {
                    i2 = samples_read * bytes_per_sample;
                    while ((i2 -= bytes_per_sample) >= 0) {
                        sample_buffer[--op] = (bytes[i2] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample == 2) {
                    i2 = samples_read * bytes_per_sample;
                    while ((i2 -= bytes_per_sample) >= 0) {
                        sample_buffer[--op] = (bytes[i2] & 0xFF) << 16 | (bytes[i2 + 1] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample == 3) {
                    i2 = samples_read * bytes_per_sample;
                    while ((i2 -= bytes_per_sample) >= 0) {
                        sample_buffer[--op] = (bytes[i2] & 0xFF) << 8 | (bytes[i2 + 1] & 0xFF) << 16 | (bytes[i2 + 2] & 0xFF) << 24;
                    }
                }
                if (bytes_per_sample != 4) break block16;
                i2 = samples_read * bytes_per_sample;
                while ((i2 -= bytes_per_sample) >= 0) {
                    sample_buffer[--op] = bytes[i2] & 0xFF | (bytes[i2 + 1] & 0xFF) << 8 | (bytes[i2 + 2] & 0xFF) << 16 | (bytes[i2 + 3] & 0xFF) << 24;
                }
                break block16;
            }
            if (bytes_per_sample == 1) {
                i = samples_read * bytes_per_sample;
                while ((i -= bytes_per_sample) >= 0) {
                    sample_buffer[--op] = ((bytes[i] ^ 0x80) & 0xFF) << 24 | 0x7F0000;
                }
            }
            if (bytes_per_sample == 2) {
                i = samples_read * bytes_per_sample;
                while ((i -= bytes_per_sample) >= 0) {
                    sample_buffer[--op] = (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16;
                }
            }
            if (bytes_per_sample == 3) {
                i = samples_read * bytes_per_sample;
                while ((i -= bytes_per_sample) >= 0) {
                    sample_buffer[--op] = (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8;
                }
            }
            if (bytes_per_sample == 4) {
                i = samples_read * bytes_per_sample;
                while ((i -= bytes_per_sample) >= 0) {
                    sample_buffer[--op] = (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8 | bytes[i + 3] & 0xFF;
                }
            }
        }
        return samples_read;
    }

    private int read_samples_pcm(RandomAccessFile musicin, int[] sample_buffer, int samples_to_read) {
        int samples_read = 0;
        try {
            switch (this.pcmbitwidth) {
                case 16: 
                case 24: 
                case 32: {
                    boolean swap_byte_order;
                    if (!this.parse.in_signed) {
                        throw new RuntimeException("Unsigned input only supported with bitwidth 8");
                    }
                    boolean bl = swap_byte_order = this.parse.in_endian != ByteOrder.LITTLE_ENDIAN;
                    if (this.pcmswapbytes) {
                        swap_byte_order = !swap_byte_order;
                    }
                    samples_read = this.unpack_read_samples(samples_to_read, this.pcmbitwidth / 8, swap_byte_order, sample_buffer, musicin);
                    break;
                }
                case 8: {
                    samples_read = this.unpack_read_samples(samples_to_read, 1, this.pcm_is_unsigned_8bit, sample_buffer, musicin);
                    break;
                }
                default: {
                    throw new RuntimeException("Only 8, 16, 24 and 32 bit input files supported");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input file", e);
        }
        return samples_read;
    }

    private int parse_wave_header(LameGlobalFlags gfp, RandomAccessFile sf) {
        int format_tag = 0;
        int channels = 0;
        int bits_per_sample = 0;
        int samples_per_sec = 0;
        boolean is_wav = false;
        int data_length = 0;
        int subSize = 0;
        int loop_sanity = 0;
        this.Read32BitsHighLow(sf);
        if (this.Read32BitsHighLow(sf) != 1463899717) {
            return -1;
        }
        for (loop_sanity = 0; loop_sanity < 20; ++loop_sanity) {
            int type = this.Read32BitsHighLow(sf);
            if (type == 1718449184) {
                subSize = this.Read32BitsLowHigh(sf);
                if (subSize < 16) {
                    return -1;
                }
                format_tag = this.Read16BitsLowHigh(sf);
                subSize -= 2;
                channels = this.Read16BitsLowHigh(sf);
                subSize -= 2;
                samples_per_sec = this.Read32BitsLowHigh(sf);
                subSize -= 4;
                this.Read32BitsLowHigh(sf);
                subSize -= 4;
                this.Read16BitsLowHigh(sf);
                subSize -= 2;
                bits_per_sample = this.Read16BitsLowHigh(sf);
                if ((subSize -= 2) > 9 && format_tag == -2) {
                    this.Read16BitsLowHigh(sf);
                    this.Read16BitsLowHigh(sf);
                    this.Read32BitsLowHigh(sf);
                    format_tag = this.Read16BitsLowHigh(sf);
                    subSize -= 10;
                }
                if (subSize <= 0) continue;
                try {
                    sf.skipBytes(subSize);
                    continue;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            if (type == 1684108385) {
                data_length = subSize = this.Read32BitsLowHigh(sf);
                is_wav = true;
                break;
            }
            subSize = this.Read32BitsLowHigh(sf);
            try {
                sf.skipBytes(subSize);
                continue;
            }
            catch (IOException e) {
                return -1;
            }
        }
        if (is_wav) {
            if (format_tag != 1) {
                if (this.parse.silent < 10) {
                    System.err.printf("Unsupported data format: 0x%04X\n", format_tag);
                }
                return 0;
            }
            gfp.num_channels = channels;
            if (-1 == gfp.num_channels) {
                if (this.parse.silent < 10) {
                    System.err.printf("Unsupported number of channels: %d\n", channels);
                }
                return 0;
            }
            gfp.in_samplerate = samples_per_sec;
            this.pcmbitwidth = bits_per_sample;
            this.pcm_is_unsigned_8bit = true;
            gfp.num_samples = data_length / (channels * ((bits_per_sample + 7) / 8));
            return 1;
        }
        return -1;
    }

    private int aiff_check2(IFF_AIFF pcm_aiff_data) {
        if (pcm_aiff_data.sampleType != 1397968452) {
            if (this.parse.silent < 10) {
                System.err.printf("ERROR: input sound data is not PCM\n", new Object[0]);
            }
            return 1;
        }
        switch (pcm_aiff_data.sampleSize) {
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                if (this.parse.silent < 10) {
                    System.err.printf("ERROR: input sound data is not 8, 16, 24 or 32 bits\n", new Object[0]);
                }
                return 1;
            }
        }
        if (pcm_aiff_data.numChannels != 1 && pcm_aiff_data.numChannels != 2) {
            if (this.parse.silent < 10) {
                System.err.printf("ERROR: input sound data is not mono or stereo\n", new Object[0]);
            }
            return 1;
        }
        if (pcm_aiff_data.blkAlgn.blockSize != 0) {
            if (this.parse.silent < 10) {
                System.err.printf("ERROR: block size of input sound data is not 0 bytes\n", new Object[0]);
            }
            return 1;
        }
        return 0;
    }

    private long make_even_number_of_bytes_in_length(int x) {
        if ((x & 1) != 0) {
            return x + 1;
        }
        return x;
    }

    private int parse_aiff_header(LameGlobalFlags gfp, RandomAccessFile sf) {
        int subSize = 0;
        int dataType = 1313820229;
        IFF_AIFF aiff_info = new IFF_AIFF();
        int seen_comm_chunk = 0;
        int seen_ssnd_chunk = 0;
        long pcm_data_pos = -1L;
        int chunkSize = this.Read32BitsHighLow(sf);
        int typeID = this.Read32BitsHighLow(sf);
        if (typeID != 1095321158 && typeID != 1095321155) {
            return -1;
        }
        while (chunkSize > 0) {
            long ckSize;
            int type = this.Read32BitsHighLow(sf);
            chunkSize -= 4;
            if (type == 1129270605) {
                seen_comm_chunk = seen_ssnd_chunk + 1;
                subSize = this.Read32BitsHighLow(sf);
                ckSize = this.make_even_number_of_bytes_in_length(subSize);
                chunkSize = (int)((long)chunkSize - ckSize);
                aiff_info.numChannels = (short)this.Read16BitsHighLow(sf);
                ckSize -= 2L;
                aiff_info.numSampleFrames = this.Read32BitsHighLow(sf);
                ckSize -= 4L;
                aiff_info.sampleSize = (short)this.Read16BitsHighLow(sf);
                ckSize -= 2L;
                try {
                    aiff_info.sampleRate = this.readIeeeExtendedHighLow(sf);
                }
                catch (IOException e1) {
                    return -1;
                }
                ckSize -= 10L;
                if (typeID == 1095321155) {
                    dataType = this.Read32BitsHighLow(sf);
                    ckSize -= 4L;
                }
                try {
                    sf.skipBytes((int)ckSize);
                    continue;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            if (type == 1397968452) {
                seen_ssnd_chunk = 1;
                subSize = this.Read32BitsHighLow(sf);
                ckSize = this.make_even_number_of_bytes_in_length(subSize);
                chunkSize = (int)((long)chunkSize - ckSize);
                aiff_info.blkAlgn.offset = this.Read32BitsHighLow(sf);
                ckSize -= 4L;
                aiff_info.blkAlgn.blockSize = this.Read32BitsHighLow(sf);
                ckSize -= 4L;
                aiff_info.sampleType = 1397968452;
                if (seen_comm_chunk > 0) {
                    try {
                        sf.skipBytes(aiff_info.blkAlgn.offset);
                        break;
                    }
                    catch (IOException e) {
                        return -1;
                    }
                }
                try {
                    pcm_data_pos = sf.getFilePointer();
                }
                catch (IOException e) {
                    return -1;
                }
                if (pcm_data_pos >= 0L) {
                    pcm_data_pos += (long)aiff_info.blkAlgn.offset;
                }
                try {
                    sf.skipBytes((int)ckSize);
                    continue;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            subSize = this.Read32BitsHighLow(sf);
            ckSize = this.make_even_number_of_bytes_in_length(subSize);
            chunkSize = (int)((long)chunkSize - ckSize);
            try {
                sf.skipBytes((int)ckSize);
            }
            catch (IOException e) {
                return -1;
            }
        }
        if (dataType == 1936684916) {
            this.pcmswapbytes = this.parse.swapbytes;
        } else if (dataType == 1953984371) {
            this.pcmswapbytes = !this.parse.swapbytes;
        } else if (dataType == 1313820229) {
            this.pcmswapbytes = !this.parse.swapbytes;
        } else {
            return -1;
        }
        if (seen_comm_chunk != 0 && (seen_ssnd_chunk > 0 || aiff_info.numSampleFrames == 0)) {
            if (0 != this.aiff_check2(aiff_info)) {
                return 0;
            }
            short s = aiff_info.numChannels;
            gfp.num_channels = s;
            if (-1 == s) {
                if (this.parse.silent < 10) {
                    System.err.printf("Unsupported number of channels: %u\n", aiff_info.numChannels);
                }
                return 0;
            }
            gfp.in_samplerate = (int)aiff_info.sampleRate;
            gfp.num_samples = aiff_info.numSampleFrames;
            this.pcmbitwidth = aiff_info.sampleSize;
            this.pcm_is_unsigned_8bit = false;
            if (pcm_data_pos >= 0L) {
                try {
                    sf.seek(pcm_data_pos);
                }
                catch (IOException e) {
                    if (this.parse.silent < 10) {
                        System.err.printf("Can't rewind stream to audio data position\n", new Object[0]);
                    }
                    return 0;
                }
            }
            return 1;
        }
        return -1;
    }

    private sound_file_format parse_file_header(LameGlobalFlags gfp, RandomAccessFile sf) {
        int type = this.Read32BitsHighLow(sf);
        this.count_samples_carefully = false;
        boolean bl = this.pcm_is_unsigned_8bit = !this.parse.in_signed;
        if (type == 1380533830) {
            int ret = this.parse_wave_header(gfp, sf);
            if (ret > 0) {
                this.count_samples_carefully = true;
                return sound_file_format.sf_wave;
            }
            if (ret < 0 && this.parse.silent < 10) {
                System.err.println("Warning: corrupt or unsupported WAVE format");
            }
        } else if (type == 1179603533) {
            int ret = this.parse_aiff_header(gfp, sf);
            if (ret > 0) {
                this.count_samples_carefully = true;
                return sound_file_format.sf_aiff;
            }
            if (ret < 0 && this.parse.silent < 10) {
                System.err.printf("Warning: corrupt or unsupported AIFF format\n", new Object[0]);
            }
        } else if (this.parse.silent < 10) {
            System.err.println("Warning: unsupported audio format\n");
        }
        return sound_file_format.sf_unknown;
    }

    private void closeSndFile(sound_file_format input, RandomAccessFile musicin) {
        if (musicin != null) {
            try {
                musicin.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close sound file", e);
            }
        }
    }

    private RandomAccessFile OpenSndFile(LameGlobalFlags gfp, String inPath, Enc enc) {
        double flen;
        gfp.num_samples = -1;
        try {
            this.musicin = new RandomAccessFile(inPath, "r");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Could not find \"%s\".", inPath), e);
        }
        if (this.is_mpeg_file_format(this.parse.input_format)) {
            if (-1 == this.lame_decode_initfile(this.musicin, this.parse.mp3input_data, enc)) {
                throw new RuntimeException(String.format("Error reading headers in mp3 input file %s.", inPath));
            }
            gfp.num_channels = this.parse.mp3input_data.stereo;
            gfp.in_samplerate = this.parse.mp3input_data.samplerate;
            gfp.num_samples = this.parse.mp3input_data.nsamp;
        } else {
            if (this.parse.input_format == sound_file_format.sf_ogg) {
                throw new RuntimeException("sorry, vorbis support in LAME is deprecated.");
            }
            if (this.parse.input_format == sound_file_format.sf_raw) {
                if (this.parse.silent < 10) {
                    System.out.println("Assuming raw pcm input file");
                    if (this.parse.swapbytes) {
                        System.out.printf(" : Forcing byte-swapping\n", new Object[0]);
                    } else {
                        System.out.printf("\n", new Object[0]);
                    }
                }
                this.pcmswapbytes = this.parse.swapbytes;
            } else {
                this.parse.input_format = this.parse_file_header(gfp, this.musicin);
            }
        }
        if (this.parse.input_format == sound_file_format.sf_unknown) {
            throw new RuntimeException("Unknown sound format!");
        }
        if (gfp.num_samples == -1 && (flen = (double)new File(inPath).length()) >= 0.0) {
            if (this.is_mpeg_file_format(this.parse.input_format)) {
                if (this.parse.mp3input_data.bitrate > 0) {
                    int tmp_num_samples;
                    double totalseconds = flen * 8.0 / (1000.0 * (double)this.parse.mp3input_data.bitrate);
                    gfp.num_samples = tmp_num_samples = (int)(totalseconds * (double)gfp.in_samplerate);
                    this.parse.mp3input_data.nsamp = tmp_num_samples;
                }
            } else {
                gfp.num_samples = (int)(flen / (double)(2 * gfp.num_channels));
            }
        }
        return this.musicin;
    }

    private boolean check_aid(byte[] header) {
        return new String(header, ISO_8859_1).startsWith("AiD\u0001");
    }

    private boolean is_syncword_mp123(byte[] headerptr) {
        int p = 0;
        if ((headerptr[p + 0] & 0xFF) != 255) {
            return false;
        }
        if ((headerptr[p + 1] & 0xE0) != 224) {
            return false;
        }
        if ((headerptr[p + 1] & 0x18) == 8) {
            return false;
        }
        switch (headerptr[p + 1] & 6) {
            default: {
                return false;
            }
            case 2: {
                if (this.parse.input_format != sound_file_format.sf_mp3 && this.parse.input_format != sound_file_format.sf_mp123) {
                    return false;
                }
                this.parse.input_format = sound_file_format.sf_mp3;
                break;
            }
            case 4: {
                if (this.parse.input_format != sound_file_format.sf_mp2 && this.parse.input_format != sound_file_format.sf_mp123) {
                    return false;
                }
                this.parse.input_format = sound_file_format.sf_mp2;
                break;
            }
            case 6: {
                if (this.parse.input_format != sound_file_format.sf_mp1 && this.parse.input_format != sound_file_format.sf_mp123) {
                    return false;
                }
                this.parse.input_format = sound_file_format.sf_mp1;
            }
        }
        if ((headerptr[p + 1] & 6) == 0) {
            return false;
        }
        if ((headerptr[p + 2] & 0xF0) == 240) {
            return false;
        }
        if ((headerptr[p + 2] & 0xC) == 12) {
            return false;
        }
        if ((headerptr[p + 1] & 0x18) == 24 && (headerptr[p + 1] & 6) == 4 && (abl2[(headerptr[p + 2] & 0xFF) >> 4] & 1 << ((headerptr[p + 3] & 0xFF) >> 6)) != 0) {
            return false;
        }
        return (headerptr[p + 3] & 3) != 2;
    }

    private int lame_decode_initfile(RandomAccessFile fd, MP3Data mp3data, Enc enc) {
        int ret;
        byte[] buf2 = new byte[100];
        short[] pcm_l = new short[1152];
        short[] pcm_r = new short[1152];
        boolean freeformat = false;
        if (this.hip != null) {
            this.mpg.hip_decode_exit(this.hip);
        }
        this.hip = this.mpg.hip_decode_init();
        int len = 4;
        try {
            fd.readFully(buf2, 0, len);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        if (buf2[0] == 73 && buf2[1] == 68 && buf2[2] == 51) {
            if (this.parse.silent < 10) {
                System.out.println("ID3v2 found. Be aware that the ID3 tag is currently lost when transcoding.");
            }
            len = 6;
            try {
                fd.readFully(buf2, 0, len);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            buf2[2] = (byte)(buf2[2] & 0x7F);
            buf2[3] = (byte)(buf2[3] & 0x7F);
            buf2[4] = (byte)(buf2[4] & 0x7F);
            buf2[5] = (byte)(buf2[5] & 0x7F);
            len = (((buf2[2] << 7) + buf2[3] << 7) + buf2[4] << 7) + buf2[5];
            try {
                fd.skipBytes(len);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            len = 4;
            try {
                fd.readFully(buf2, 0, len);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (this.check_aid(buf2)) {
            try {
                fd.readFully(buf2, 0, 2);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            int aid_header = (buf2[0] & 0xFF) + 256 * (buf2[1] & 0xFF);
            if (this.parse.silent < 10) {
                System.out.printf("Album ID found.  length=%d \n", aid_header);
            }
            try {
                fd.skipBytes(aid_header - 6);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            try {
                fd.readFully(buf2, 0, len);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        len = 4;
        while (!this.is_syncword_mp123(buf2)) {
            for (int i = 0; i < len - 1; ++i) {
                buf2[i] = buf2[i + 1];
            }
            try {
                fd.readFully(buf2, len - 1, 1);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if ((buf2[2] & 0xF0) == 0) {
            if (this.parse.silent < 10) {
                System.out.println("Input file is freeformat.");
            }
            freeformat = true;
        }
        if (-1 == (ret = this.mpg.hip_decode1_headersB(this.hip, buf2, len, pcm_l, pcm_r, mp3data, enc))) {
            return -1;
        }
        while (!mp3data.header_parsed) {
            try {
                fd.readFully(buf2);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            ret = this.mpg.hip_decode1_headersB(this.hip, buf2, buf2.length, pcm_l, pcm_r, mp3data, enc);
            if (-1 != ret) continue;
            return -1;
        }
        if (mp3data.bitrate == 0 && !freeformat) {
            if (this.parse.silent < 10) {
                System.err.println("fail to sync...");
            }
            return this.lame_decode_initfile(fd, mp3data, enc);
        }
        if (mp3data.totalframes <= 0) {
            mp3data.nsamp = -1;
        }
        return 0;
    }

    private int lame_decode_fromfile(RandomAccessFile fd, short[] pcm_l, short[] pcm_r, MP3Data mp3data) {
        int ret = 0;
        int len = 0;
        byte[] buf2 = new byte[1024];
        ret = -1;
        ret = this.mpg.hip_decode1_headers(this.hip, buf2, len, pcm_l, pcm_r, mp3data);
        if (ret != 0) {
            return ret;
        }
        do {
            try {
                len = fd.read(buf2, 0, 1024);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            if (len <= 0) {
                ret = this.mpg.hip_decode1_headers(this.hip, buf2, 0, pcm_l, pcm_r, mp3data);
                if (ret <= 0) {
                    this.mpg.hip_decode_exit(this.hip);
                    this.hip = null;
                    return -1;
                }
                break;
            }
            ret = this.mpg.hip_decode1_headers(this.hip, buf2, len, pcm_l, pcm_r, mp3data);
            if (ret != -1) continue;
            this.mpg.hip_decode_exit(this.hip);
            this.hip = null;
            return -1;
        } while (ret <= 0);
        return ret;
    }

    private boolean is_mpeg_file_format(sound_file_format input_file_format) {
        switch (input_file_format) {
            case sf_mp1: 
            case sf_mp2: 
            case sf_mp3: 
            case sf_mp123: {
                return true;
            }
        }
        return false;
    }

    private int Read32BitsLowHigh(RandomAccessFile fp) {
        int first = 0xFFFF & this.Read16BitsLowHigh(fp);
        int second = 0xFFFF & this.Read16BitsLowHigh(fp);
        int result2 = (second << 16) + first;
        return result2;
    }

    private int Read16BitsLowHigh(RandomAccessFile fp) {
        try {
            int first = 0xFF & fp.read();
            int second = 0xFF & fp.read();
            int result2 = (second << 8) + first;
            return result2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int Read16BitsHighLow(RandomAccessFile fp) {
        try {
            int high = fp.readUnsignedByte();
            int low = fp.readUnsignedByte();
            return high << 8 | low;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int Read32BitsHighLow(RandomAccessFile fp) {
        int first = 0xFFFF & this.Read16BitsHighLow(fp);
        int second = 0xFFFF & this.Read16BitsHighLow(fp);
        int result2 = (first << 16) + second;
        return result2;
    }

    private double unsignedToFloat(double u) {
        return (double)((long)(u - 2.147483647E9 - 1.0)) + 2.147483648E9;
    }

    private double ldexp(double x, double exp) {
        return x * Math.pow(2.0, exp);
    }

    private double convertFromIeeeExtended(byte[] bytes) {
        double f;
        long expon = (bytes[0] & 0x7F) << 8 | bytes[1] & 0xFF;
        long hiMant = (long)(bytes[2] & 0xFF) << 24 | (long)(bytes[3] & 0xFF) << 16 | (long)(bytes[4] & 0xFF) << 8 | (long)(bytes[5] & 0xFF);
        long loMant = (long)(bytes[6] & 0xFF) << 24 | (long)(bytes[7] & 0xFF) << 16 | (long)(bytes[8] & 0xFF) << 8 | (long)(bytes[9] & 0xFF);
        if (expon == 0L && hiMant == 0L && loMant == 0L) {
            f = 0.0;
        } else if (expon == 32767L) {
            f = Double.POSITIVE_INFINITY;
        } else {
            expon -= 16383L;
            f = this.ldexp(this.unsignedToFloat(hiMant), (int)(expon -= 31L));
            f += this.ldexp(this.unsignedToFloat(loMant), (int)(expon -= 32L));
        }
        if ((bytes[0] & 0x80) != 0) {
            return -f;
        }
        return f;
    }

    private double readIeeeExtendedHighLow(RandomAccessFile fp) throws IOException {
        byte[] bytes = new byte[10];
        fp.readFully(bytes);
        return this.convertFromIeeeExtended(bytes);
    }

    private void write32BitsLowHigh(DataOutput fp, int i) throws IOException {
        this.write16BitsLowHigh(fp, (int)((long)i & 0xFFFFL));
        this.write16BitsLowHigh(fp, (int)((long)(i >> 16) & 0xFFFFL));
    }

    public final void write16BitsLowHigh(DataOutput fp, int i) throws IOException {
        fp.write(i & 0xFF);
        fp.write(i >> 8 & 0xFF);
    }

    protected static final class IFF_AIFF {
        short numChannels;
        int numSampleFrames;
        short sampleSize;
        double sampleRate;
        int sampleType;
        BlockAlign blkAlgn = new BlockAlign();

        protected IFF_AIFF() {
        }
    }

    protected static final class BlockAlign {
        int offset;
        int blockSize;

        protected BlockAlign() {
        }
    }

    public static enum sound_file_format {
        sf_unknown,
        sf_raw,
        sf_wave,
        sf_aiff,
        sf_mp1,
        sf_mp2,
        sf_mp3,
        sf_mp123,
        sf_ogg;

    }
}

