/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.FFT;
import de.sciss.jump3r.mp3.III_psy_ratio;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.LameInternalFlags;
import de.sciss.jump3r.mp3.MPEGMode;
import de.sciss.jump3r.mp3.ShortBlock;
import de.sciss.jump3r.mp3.Util;
import de.sciss.jump3r.mp3.VbrMode;
import java.util.Arrays;

public class PsyModel {
    private FFT fft = new FFT();
    private static final float LOG10 = 2.3025851f;
    private static final int rpelev = 2;
    private static final int rpelev2 = 16;
    private static final int rpelev_s = 2;
    private static final int rpelev2_s = 16;
    private static final float DELBARK = 0.34f;
    private static final float VO_SCALE = 8.974871E-12f;
    private static final float temporalmask_sustain_sec = 0.01f;
    private static final float NS_PREECHO_ATT0 = 0.8f;
    private static final float NS_PREECHO_ATT1 = 0.6f;
    private static final float NS_PREECHO_ATT2 = 0.3f;
    private static final float NS_MSFIX = 3.5f;
    public static final float NSATTACKTHRE = 4.4f;
    public static final int NSATTACKTHRE_S = 25;
    private static final int NSFIRLEN = 21;
    private static final float LN_TO_LOG10 = 0.23025851f;
    private static final int I1LIMIT = 8;
    private static final int I2LIMIT = 23;
    private static final int MLIMIT = 15;
    private float ma_max_i1;
    private float ma_max_i2;
    private float ma_max_m;
    private static final float[] tab = new float[]{1.0f, 0.79433f, 0.63096f, 0.63096f, 0.63096f, 0.63096f, 0.63096f, 0.25119f, 0.11749f};
    private static final float[] table1 = new float[]{11.052965f, 10.48704f, 9.95005f, 9.024737f, 8.185493f, 7.044087f, 6.0618873f, 5.2166557f, 4.4892707f, 3.8632689f, 3.324605f, 2.861037f, 2.4621062f, 2.150857f, 1.8789283f, 1.7170432f, 1.5691069f, 1.4555941f, 1.3503137f, 1.2715945f, 1.1974487f, 1.1361427f, 1.0779837f, 1.038259f, 1.0f};
    private static final float[] table2 = new float[]{1.7782757f, 1.8463104f, 1.916951f, 1.9459414f, 1.9753741f, 1.8325038f, 1.6999466f, 1.4962426f, 1.31694f, 1.0f};
    private static final float[] table3 = new float[]{5.539622f, 5.2559686f, 4.9868693f, 4.5230656f, 4.1024475f, 3.5304155f, 3.0381534f, 2.6145275f, 2.24997f, 1.9362165f, 1.6662421f, 1.4339106f, 1.2339654f, 1.0779837f};
    private static final float[] table2_ = new float[]{1.7782757f, 1.8463104f, 1.916951f, 1.9459414f, 1.9753741f, 1.8325038f, 1.6999466f, 1.4962426f, 1.31694f, 1.0f};
    private static final float[] regcoef_s = new float[]{11.8f, 13.6f, 17.2f, 32.0f, 46.5f, 51.3f, 57.5f, 67.1f, 71.5f, 84.6f, 97.6f, 130.0f};
    private static final float[] regcoef_l = new float[]{6.8f, 5.8f, 5.8f, 6.4f, 6.5f, 9.9f, 12.1f, 14.4f, 15.0f, 18.9f, 21.6f, 26.9f, 34.2f, 40.2f, 46.8f, 56.5f, 60.7f, 73.9f, 85.7f, 93.4f, 126.1f};
    private static final float[] fircoef = new float[]{-1.730326E-17f, -0.01703172f, -1.349528E-17f, 0.0418072f, -6.73278E-17f, -0.0876324f, -3.0835E-17f, 0.1863476f, -1.104424E-16f, -0.627638f};
    private static final float[] fircoef_ = new float[]{-1.730326E-17f, -0.01703172f, -1.349528E-17f, 0.0418072f, -6.73278E-17f, -0.0876324f, -3.0835E-17f, 0.1863476f, -1.104424E-16f, -0.627638f};

    private static final float NON_LINEAR_SCALE_ENERGY(float x) {
        return x;
    }

    private float psycho_loudness_approx(float[] energy, LameInternalFlags gfc) {
        float loudness_power = 0.0f;
        for (int i = 0; i < 512; ++i) {
            loudness_power += energy[i] * gfc.ATH.eql_w[i];
        }
        return loudness_power *= 8.974871E-12f;
    }

    private void compute_ffts(LameGlobalFlags gfp, float[] fftenergy, float[][] fftenergy_s, float[][] wsamp_l, int wsamp_lPos, float[][][] wsamp_s, int wsamp_sPos, int gr_out, int chn, float[][] buffer, int bufPos) {
        int b;
        int j;
        LameInternalFlags gfc = gfp.internal_flags;
        if (chn < 2) {
            this.fft.fft_long(gfc, wsamp_l[wsamp_lPos], chn, buffer, bufPos);
            this.fft.fft_short(gfc, wsamp_s[wsamp_sPos], chn, buffer, bufPos);
        } else if (chn == 2) {
            for (j = 1023; j >= 0; --j) {
                float l2 = wsamp_l[wsamp_lPos + 0][j];
                float r = wsamp_l[wsamp_lPos + 1][j];
                wsamp_l[wsamp_lPos + 0][j] = (l2 + r) * 1.4142135f * 0.5f;
                wsamp_l[wsamp_lPos + 1][j] = (l2 - r) * 1.4142135f * 0.5f;
            }
            for (b = 2; b >= 0; --b) {
                for (int j2 = 255; j2 >= 0; --j2) {
                    float l3 = wsamp_s[wsamp_sPos + 0][b][j2];
                    float r = wsamp_s[wsamp_sPos + 1][b][j2];
                    wsamp_s[wsamp_sPos + 0][b][j2] = (l3 + r) * 1.4142135f * 0.5f;
                    wsamp_s[wsamp_sPos + 1][b][j2] = (l3 - r) * 1.4142135f * 0.5f;
                }
            }
        }
        fftenergy[0] = PsyModel.NON_LINEAR_SCALE_ENERGY(wsamp_l[wsamp_lPos + 0][0]);
        fftenergy[0] = fftenergy[0] * fftenergy[0];
        for (j = 511; j >= 0; --j) {
            float re = wsamp_l[wsamp_lPos + 0][512 - j];
            float im = wsamp_l[wsamp_lPos + 0][512 + j];
            fftenergy[512 - j] = PsyModel.NON_LINEAR_SCALE_ENERGY((re * re + im * im) * 0.5f);
        }
        for (b = 2; b >= 0; --b) {
            fftenergy_s[b][0] = wsamp_s[wsamp_sPos + 0][b][0];
            float[] fArray = fftenergy_s[b];
            fArray[0] = fArray[0] * fftenergy_s[b][0];
            for (int j3 = 127; j3 >= 0; --j3) {
                float re = wsamp_s[wsamp_sPos + 0][b][128 - j3];
                float im = wsamp_s[wsamp_sPos + 0][b][128 + j3];
                fftenergy_s[b][128 - j3] = PsyModel.NON_LINEAR_SCALE_ENERGY((re * re + im * im) * 0.5f);
            }
        }
        float totalenergy = 0.0f;
        for (int j4 = 11; j4 < 513; ++j4) {
            totalenergy += fftenergy[j4];
        }
        gfc.tot_ener[chn] = totalenergy;
        if (gfp.analysis) {
            for (int j5 = 0; j5 < 513; ++j5) {
                gfc.pinfo.energy[gr_out][chn][j5] = gfc.pinfo.energy_save[chn][j5];
                gfc.pinfo.energy_save[chn][j5] = fftenergy[j5];
            }
            gfc.pinfo.pe[gr_out][chn] = gfc.pe[chn];
        }
        if (gfp.athaa_loudapprox == 2 && chn < 2) {
            gfc.loudness_sq[gr_out][chn] = gfc.loudness_sq_save[chn];
            gfc.loudness_sq_save[chn] = this.psycho_loudness_approx(fftenergy, gfc);
        }
    }

    private void init_mask_add_max_values() {
        this.ma_max_i1 = (float)Math.pow(10.0, 0.5625);
        this.ma_max_i2 = (float)Math.pow(10.0, 1.5);
        this.ma_max_m = (float)Math.pow(10.0, 1.5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float mask_add(float m1, float m2, int kk, int b, LameInternalFlags gfc, int shortblock) {
        float ratio;
        if (m2 > m1) {
            if (!(m2 < m1 * this.ma_max_i2)) return m1 + m2;
            ratio = m2 / m1;
        } else {
            if (m1 >= m2 * this.ma_max_i2) {
                return m1 + m2;
            }
            ratio = m1 / m2;
        }
        assert (m1 >= 0.0f);
        assert (m2 >= 0.0f);
        m1 += m2;
        if (((long)(b + 3) & 0xFFFFFFFFL) <= 6L) {
            if (ratio >= this.ma_max_i1) {
                return m1;
            }
            int i = (int)Util.FAST_LOG10_X(ratio, 16.0f);
            return m1 * table2[i];
        }
        int i = (int)Util.FAST_LOG10_X(ratio, 16.0f);
        m2 = shortblock != 0 ? gfc.ATH.cb_s[kk] * gfc.ATH.adjust : gfc.ATH.cb_l[kk] * gfc.ATH.adjust;
        assert (m2 >= 0.0f);
        if (!(m1 < this.ma_max_m * m2)) return m1 * table1[i];
        if (m1 > m2) {
            float f = 1.0f;
            if (i <= 13) {
                f = table3[i];
            }
            float r = Util.FAST_LOG10_X(m1 / m2, 0.6666667f);
            return m1 * ((table1[i] - f) * r + f);
        }
        if (i <= 13) return m1 * table3[i];
        return m1;
    }

    private float vbrpsy_mask_add(float m1, float m2, int b) {
        if (m1 < 0.0f) {
            m1 = 0.0f;
        }
        if (m2 < 0.0f) {
            m2 = 0.0f;
        }
        if (m1 <= 0.0f) {
            return m2;
        }
        if (m2 <= 0.0f) {
            return m1;
        }
        float ratio = m2 > m1 ? m2 / m1 : m1 / m2;
        if (-2 <= b && b <= 2) {
            if (ratio >= this.ma_max_i1) {
                return m1 + m2;
            }
            int i = (int)Util.FAST_LOG10_X(ratio, 16.0f);
            return (m1 + m2) * table2_[i];
        }
        if (ratio < this.ma_max_i2) {
            return m1 + m2;
        }
        if (m1 < m2) {
            m1 = m2;
        }
        return m1;
    }

    private void calc_interchannel_masking(LameGlobalFlags gfp, float ratio) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc.channels_out > 1) {
            int sb = 0;
            while (sb < 22) {
                float l2 = gfc.thm[0].l[sb];
                float r = gfc.thm[1].l[sb];
                int n = sb;
                gfc.thm[0].l[n] = gfc.thm[0].l[n] + r * ratio;
                int n2 = sb++;
                gfc.thm[1].l[n2] = gfc.thm[1].l[n2] + l2 * ratio;
            }
            for (sb = 0; sb < 13; ++sb) {
                int sblock = 0;
                while (sblock < 3) {
                    float l3 = gfc.thm[0].s[sb][sblock];
                    float r = gfc.thm[1].s[sb][sblock];
                    float[] fArray = gfc.thm[0].s[sb];
                    int n = sblock;
                    fArray[n] = fArray[n] + r * ratio;
                    float[] fArray2 = gfc.thm[1].s[sb];
                    int n3 = sblock++;
                    fArray2[n3] = fArray2[n3] + l3 * ratio;
                }
            }
        }
    }

    private void msfix1(LameInternalFlags gfc) {
        int sb;
        for (sb = 0; sb < 22; ++sb) {
            if ((double)gfc.thm[0].l[sb] > 1.58 * (double)gfc.thm[1].l[sb] || (double)gfc.thm[1].l[sb] > 1.58 * (double)gfc.thm[0].l[sb]) continue;
            float mld = gfc.mld_l[sb] * gfc.en[3].l[sb];
            float rmid = Math.max(gfc.thm[2].l[sb], Math.min(gfc.thm[3].l[sb], mld));
            mld = gfc.mld_l[sb] * gfc.en[2].l[sb];
            float rside = Math.max(gfc.thm[3].l[sb], Math.min(gfc.thm[2].l[sb], mld));
            gfc.thm[2].l[sb] = rmid;
            gfc.thm[3].l[sb] = rside;
        }
        for (sb = 0; sb < 13; ++sb) {
            for (int sblock = 0; sblock < 3; ++sblock) {
                if ((double)gfc.thm[0].s[sb][sblock] > 1.58 * (double)gfc.thm[1].s[sb][sblock] || (double)gfc.thm[1].s[sb][sblock] > 1.58 * (double)gfc.thm[0].s[sb][sblock]) continue;
                float mld = gfc.mld_s[sb] * gfc.en[3].s[sb][sblock];
                float rmid = Math.max(gfc.thm[2].s[sb][sblock], Math.min(gfc.thm[3].s[sb][sblock], mld));
                mld = gfc.mld_s[sb] * gfc.en[2].s[sb][sblock];
                float rside = Math.max(gfc.thm[3].s[sb][sblock], Math.min(gfc.thm[2].s[sb][sblock], mld));
                gfc.thm[2].s[sb][sblock] = rmid;
                gfc.thm[3].s[sb][sblock] = rside;
            }
        }
    }

    private void ns_msfix(LameInternalFlags gfc, float msfix, float athadjust) {
        int sb;
        float msfix2 = msfix;
        float athlower = (float)Math.pow(10.0, athadjust);
        msfix *= 2.0f;
        msfix2 *= 2.0f;
        for (sb = 0; sb < 22; ++sb) {
            float thmS;
            float thmM;
            float ath = gfc.ATH.cb_l[gfc.bm_l[sb]] * athlower;
            float thmLR = Math.min(Math.max(gfc.thm[0].l[sb], ath), Math.max(gfc.thm[1].l[sb], ath));
            if (thmLR * msfix < (thmM = Math.max(gfc.thm[2].l[sb], ath)) + (thmS = Math.max(gfc.thm[3].l[sb], ath))) {
                float f = thmLR * msfix2 / (thmM + thmS);
                assert ((thmM *= f) + (thmS *= f) > 0.0f);
            }
            gfc.thm[2].l[sb] = Math.min(thmM, gfc.thm[2].l[sb]);
            gfc.thm[3].l[sb] = Math.min(thmS, gfc.thm[3].l[sb]);
        }
        athlower *= 0.25f;
        for (sb = 0; sb < 13; ++sb) {
            for (int sblock = 0; sblock < 3; ++sblock) {
                float thmS;
                float thmM;
                float ath = gfc.ATH.cb_s[gfc.bm_s[sb]] * athlower;
                float thmLR = Math.min(Math.max(gfc.thm[0].s[sb][sblock], ath), Math.max(gfc.thm[1].s[sb][sblock], ath));
                if (thmLR * msfix < (thmM = Math.max(gfc.thm[2].s[sb][sblock], ath)) + (thmS = Math.max(gfc.thm[3].s[sb][sblock], ath))) {
                    float f = thmLR * msfix / (thmM + thmS);
                    assert ((thmM *= f) + (thmS *= f) > 0.0f);
                }
                gfc.thm[2].s[sb][sblock] = Math.min(gfc.thm[2].s[sb][sblock], thmM);
                gfc.thm[3].s[sb][sblock] = Math.min(gfc.thm[3].s[sb][sblock], thmS);
            }
        }
    }

    private void convert_partition2scalefac_s(LameInternalFlags gfc, float[] eb, float[] thr, int chn, int sblock) {
        int sb;
        float enn = 0.0f;
        float thmm = 0.0f;
        int b = 0;
        for (sb = 0; sb < 13; ++sb) {
            int b_lim;
            int bo_s_sb = gfc.bo_s[sb];
            int npart_s = gfc.npart_s;
            int n = b_lim = bo_s_sb < npart_s ? bo_s_sb : npart_s;
            while (b < b_lim) {
                assert (eb[b] >= 0.0f);
                assert (thr[b] >= 0.0f);
                enn += eb[b];
                thmm += thr[b];
                ++b;
            }
            gfc.en[chn].s[sb][sblock] = enn;
            gfc.thm[chn].s[sb][sblock] = thmm;
            if (b >= npart_s) {
                ++sb;
                break;
            }
            assert (eb[b] >= 0.0f);
            assert (thr[b] >= 0.0f);
            float w_curr = gfc.PSY.bo_s_weight[sb];
            float w_next = 1.0f - w_curr;
            enn = w_curr * eb[b];
            thmm = w_curr * thr[b];
            float[] fArray = gfc.en[chn].s[sb];
            int n2 = sblock;
            fArray[n2] = fArray[n2] + enn;
            float[] fArray2 = gfc.thm[chn].s[sb];
            int n3 = sblock;
            fArray2[n3] = fArray2[n3] + thmm;
            enn = w_next * eb[b];
            thmm = w_next * thr[b];
            ++b;
        }
        while (sb < 13) {
            gfc.en[chn].s[sb][sblock] = 0.0f;
            gfc.thm[chn].s[sb][sblock] = 0.0f;
            ++sb;
        }
    }

    private void convert_partition2scalefac_l(LameInternalFlags gfc, float[] eb, float[] thr, int chn) {
        float enn = 0.0f;
        float thmm = 0.0f;
        int b = 0;
        int sb = 0;
        while (sb < 22) {
            int b_lim;
            int bo_l_sb = gfc.bo_l[sb];
            int npart_l = gfc.npart_l;
            int n = b_lim = bo_l_sb < npart_l ? bo_l_sb : npart_l;
            while (b < b_lim) {
                assert (eb[b] >= 0.0f);
                assert (thr[b] >= 0.0f);
                enn += eb[b];
                thmm += thr[b];
                ++b;
            }
            gfc.en[chn].l[sb] = enn;
            gfc.thm[chn].l[sb] = thmm;
            if (b >= npart_l) {
                ++sb;
                break;
            }
            assert (eb[b] >= 0.0f);
            assert (thr[b] >= 0.0f);
            float w_curr = gfc.PSY.bo_l_weight[sb];
            float w_next = 1.0f - w_curr;
            enn = w_curr * eb[b];
            thmm = w_curr * thr[b];
            int n2 = sb;
            gfc.en[chn].l[n2] = gfc.en[chn].l[n2] + enn;
            int n3 = sb++;
            gfc.thm[chn].l[n3] = gfc.thm[chn].l[n3] + thmm;
            enn = w_next * eb[b];
            thmm = w_next * thr[b];
            ++b;
        }
        while (sb < 22) {
            gfc.en[chn].l[sb] = 0.0f;
            gfc.thm[chn].l[sb] = 0.0f;
            ++sb;
        }
    }

    private void compute_masking_s(LameGlobalFlags gfp, float[][] fftenergy_s, float[] eb, float[] thr, int chn, int sblock) {
        int b;
        LameInternalFlags gfc = gfp.internal_flags;
        int j = 0;
        for (b = 0; b < gfc.npart_s; ++b) {
            float ebb = 0.0f;
            float m = 0.0f;
            int n = gfc.numlines_s[b];
            int i = 0;
            while (i < n) {
                float el = fftenergy_s[sblock][j];
                ebb += el;
                if (m < el) {
                    m = el;
                }
                ++i;
                ++j;
            }
            eb[b] = ebb;
        }
        assert (b == gfc.npart_s);
        assert (j == 129);
        j = 0;
        for (b = 0; b < gfc.npart_s; ++b) {
            int kk = gfc.s3ind_s[b][0];
            float ecb = gfc.s3_ss[j++] * eb[kk];
            ++kk;
            while (kk <= gfc.s3ind_s[b][1]) {
                ecb += gfc.s3_ss[j] * eb[kk];
                ++j;
                ++kk;
            }
            float x = 2.0f * gfc.nb_s1[chn][b];
            thr[b] = Math.min(ecb, x);
            if (gfc.blocktype_old[chn & 1] == 2) {
                x = 16.0f * gfc.nb_s2[chn][b];
                float y = thr[b];
                thr[b] = Math.min(x, y);
            }
            gfc.nb_s2[chn][b] = gfc.nb_s1[chn][b];
            gfc.nb_s1[chn][b] = ecb;
            assert (thr[b] >= 0.0f);
        }
        while (b <= 64) {
            eb[b] = 0.0f;
            thr[b] = 0.0f;
            ++b;
        }
    }

    private void block_type_set(LameGlobalFlags gfp, int[] uselongblock, int[] blocktype_d, int[] blocktype) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfp.short_blocks == ShortBlock.short_block_coupled && (uselongblock[0] == 0 || uselongblock[1] == 0)) {
            uselongblock[1] = 0;
            uselongblock[0] = 0;
        }
        for (int chn = 0; chn < gfc.channels_out; ++chn) {
            blocktype[chn] = 0;
            if (gfp.short_blocks == ShortBlock.short_block_dispensed) {
                uselongblock[chn] = 1;
            }
            if (gfp.short_blocks == ShortBlock.short_block_forced) {
                uselongblock[chn] = 0;
            }
            if (uselongblock[chn] != 0) {
                assert (gfc.blocktype_old[chn] != 1);
                if (gfc.blocktype_old[chn] == 2) {
                    blocktype[chn] = 3;
                }
            } else {
                blocktype[chn] = 2;
                if (gfc.blocktype_old[chn] == 0) {
                    gfc.blocktype_old[chn] = 1;
                }
                if (gfc.blocktype_old[chn] == 3) {
                    gfc.blocktype_old[chn] = 2;
                }
            }
            blocktype_d[chn] = gfc.blocktype_old[chn];
            gfc.blocktype_old[chn] = blocktype[chn];
        }
    }

    private float NS_INTERP(float x, float y, float r) {
        if ((double)r >= 1.0) {
            return x;
        }
        if ((double)r <= 0.0) {
            return y;
        }
        if ((double)y > 0.0) {
            return (float)(Math.pow(x / y, r) * (double)y);
        }
        return 0.0f;
    }

    private float pecalc_s(III_psy_ratio mr, float masking_lower) {
        float pe_s = 309.07f;
        for (int sb = 0; sb < 12; ++sb) {
            for (int sblock = 0; sblock < 3; ++sblock) {
                float x;
                float en;
                float thm = mr.thm.s[sb][sblock];
                assert (sb < regcoef_s.length);
                if (!((double)thm > 0.0) || !((en = mr.en.s[sb][sblock]) > (x = thm * masking_lower))) continue;
                if ((double)en > (double)x * 1.0E10) {
                    pe_s += regcoef_s[sb] * 23.025852f;
                    continue;
                }
                assert (x > 0.0f);
                pe_s += regcoef_s[sb] * Util.FAST_LOG10(en / x);
            }
        }
        return pe_s;
    }

    private float pecalc_l(III_psy_ratio mr, float masking_lower) {
        float pe_l = 281.0575f;
        for (int sb = 0; sb < 21; ++sb) {
            float x;
            float en;
            float thm = mr.thm.l[sb];
            assert (sb < regcoef_l.length);
            if (!((double)thm > 0.0) || !((en = mr.en.l[sb]) > (x = thm * masking_lower))) continue;
            if ((double)en > (double)x * 1.0E10) {
                pe_l += regcoef_l[sb] * 23.025852f;
                continue;
            }
            assert (x > 0.0f);
            pe_l += regcoef_l[sb] * Util.FAST_LOG10(en / x);
        }
        return pe_l;
    }

    private void calc_energy(LameInternalFlags gfc, float[] fftenergy, float[] eb, float[] max, float[] avg) {
        int j = 0;
        for (int b = 0; b < gfc.npart_l; ++b) {
            float ebb = 0.0f;
            float m = 0.0f;
            int i = 0;
            while (i < gfc.numlines_l[b]) {
                float el = fftenergy[j];
                assert (el >= 0.0f);
                ebb += el;
                if (m < el) {
                    m = el;
                }
                ++i;
                ++j;
            }
            eb[b] = ebb;
            max[b] = m;
            avg[b] = ebb * gfc.rnumlines_l[b];
            assert (gfc.rnumlines_l[b] >= 0.0f);
            assert (ebb >= 0.0f);
            assert (eb[b] >= 0.0f);
            assert (max[b] >= 0.0f);
            assert (avg[b] >= 0.0f);
        }
    }

    private void calc_mask_index_l(LameInternalFlags gfc, float[] max, float[] avg, int[] mask_idx) {
        int k;
        float m;
        int last_tab_entry = tab.length - 1;
        int b = 0;
        float a = avg[b] + avg[b + 1];
        assert (a >= 0.0f);
        if ((double)a > 0.0) {
            m = max[b];
            if (m < max[b + 1]) {
                m = max[b + 1];
            }
            assert (gfc.numlines_l[b] + gfc.numlines_l[b + 1] - 1 > 0);
            k = (int)(a = 20.0f * (m * 2.0f - a) / (a * (float)(gfc.numlines_l[b] + gfc.numlines_l[b + 1] - 1)));
            if (k > last_tab_entry) {
                k = last_tab_entry;
            }
            mask_idx[b] = k;
        } else {
            mask_idx[b] = 0;
        }
        for (b = 1; b < gfc.npart_l - 1; ++b) {
            a = avg[b - 1] + avg[b] + avg[b + 1];
            assert (a >= 0.0f);
            if ((double)a > 0.0) {
                m = max[b - 1];
                if (m < max[b]) {
                    m = max[b];
                }
                if (m < max[b + 1]) {
                    m = max[b + 1];
                }
                assert (gfc.numlines_l[b - 1] + gfc.numlines_l[b] + gfc.numlines_l[b + 1] - 1 > 0);
                k = (int)(a = 20.0f * (m * 3.0f - a) / (a * (float)(gfc.numlines_l[b - 1] + gfc.numlines_l[b] + gfc.numlines_l[b + 1] - 1)));
                if (k > last_tab_entry) {
                    k = last_tab_entry;
                }
                mask_idx[b] = k;
                continue;
            }
            mask_idx[b] = 0;
        }
        assert (b > 0);
        assert (b == gfc.npart_l - 1);
        a = avg[b - 1] + avg[b];
        assert (a >= 0.0f);
        if ((double)a > 0.0) {
            m = max[b - 1];
            if (m < max[b]) {
                m = max[b];
            }
            assert (gfc.numlines_l[b - 1] + gfc.numlines_l[b] - 1 > 0);
            k = (int)(a = 20.0f * (m * 2.0f - a) / (a * (float)(gfc.numlines_l[b - 1] + gfc.numlines_l[b] - 1)));
            if (k > last_tab_entry) {
                k = last_tab_entry;
            }
            mask_idx[b] = k;
        } else {
            mask_idx[b] = 0;
        }
        assert (b == gfc.npart_l - 1);
    }

    public final int L3psycho_anal_ns(LameGlobalFlags gfp, float[][] buffer, int bufPos, int gr_out, III_psy_ratio[][] masking_ratio, III_psy_ratio[][] masking_MS_ratio, float[] percep_entropy, float[] percep_MS_entropy, float[] energy, int[] blocktype_d) {
        int i;
        int chn;
        LameInternalFlags gfc = gfp.internal_flags;
        float[][] wsamp_L = new float[2][1024];
        float[][][] wsamp_S = new float[2][3][256];
        float[] eb_l = new float[65];
        float[] eb_s = new float[65];
        float[] thr = new float[66];
        int[] blocktype = new int[2];
        int[] uselongblock = new int[2];
        float[][] ns_hpfsmpl = new float[2][576];
        int[] mask_idx_l = new int[66];
        int[] mask_idx_s = new int[66];
        Arrays.fill(mask_idx_s, 0);
        int numchn = gfc.channels_out;
        if (gfp.mode == MPEGMode.JOINT_STEREO) {
            numchn = 4;
        }
        float pcfact = gfp.VBR == VbrMode.vbr_off ? (gfc.ResvMax == 0 ? 0.0f : (float)gfc.ResvSize / (float)gfc.ResvMax * 0.5f) : (gfp.VBR == VbrMode.vbr_rh || gfp.VBR == VbrMode.vbr_mtrh || gfp.VBR == VbrMode.vbr_mt ? 0.6f : 1.0f);
        for (chn = 0; chn < gfc.channels_out; ++chn) {
            float[] firbuf = buffer[chn];
            int firbufPos = bufPos + 576 - 350 - 21 + 192;
            assert (fircoef.length == 10);
            for (i = 0; i < 576; ++i) {
                float sum1 = firbuf[firbufPos + i + 10];
                float sum2 = 0.0f;
                for (int j = 0; j < 9; j += 2) {
                    sum1 += fircoef[j] * (firbuf[firbufPos + i + j] + firbuf[firbufPos + i + 21 - j]);
                    sum2 += fircoef[j + 1] * (firbuf[firbufPos + i + j + 1] + firbuf[firbufPos + i + 21 - j - 1]);
                }
                ns_hpfsmpl[chn][i] = sum1 + sum2;
            }
            masking_ratio[gr_out][chn].en.assign(gfc.en[chn]);
            masking_ratio[gr_out][chn].thm.assign(gfc.thm[chn]);
            if (numchn <= 2) continue;
            masking_MS_ratio[gr_out][chn].en.assign(gfc.en[chn + 2]);
            masking_MS_ratio[gr_out][chn].thm.assign(gfc.thm[chn + 2]);
        }
        for (chn = 0; chn < numchn; ++chn) {
            int b;
            float[] en_subshort = new float[12];
            float[] en_short = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] attack_intensity = new float[12];
            int ns_uselongblock = 1;
            float[] max = new float[64];
            float[] avg = new float[64];
            int[] ns_attacks = new int[]{0, 0, 0, 0};
            float[] fftenergy = new float[513];
            float[][] fftenergy_s = new float[3][129];
            assert (gfc.npart_s <= 64);
            assert (gfc.npart_l <= 64);
            for (i = 0; i < 3; ++i) {
                en_subshort[i] = gfc.nsPsy.last_en_subshort[chn][i + 6];
                assert (gfc.nsPsy.last_en_subshort[chn][i + 4] > 0.0f);
                attack_intensity[i] = en_subshort[i] / gfc.nsPsy.last_en_subshort[chn][i + 4];
                en_short[0] = en_short[0] + en_subshort[i];
            }
            if (chn == 2) {
                for (i = 0; i < 576; ++i) {
                    float l2 = ns_hpfsmpl[0][i];
                    float r = ns_hpfsmpl[1][i];
                    ns_hpfsmpl[0][i] = l2 + r;
                    ns_hpfsmpl[1][i] = l2 - r;
                }
            }
            float[] pf = ns_hpfsmpl[chn & 1];
            int pfPos = 0;
            for (i = 0; i < 9; ++i) {
                int pfe = pfPos + 64;
                float p = 1.0f;
                while (pfPos < pfe) {
                    if (p < Math.abs(pf[pfPos])) {
                        p = Math.abs(pf[pfPos]);
                    }
                    ++pfPos;
                }
                float f = p;
                en_subshort[i + 3] = f;
                gfc.nsPsy.last_en_subshort[chn][i] = f;
                int n = 1 + i / 3;
                en_short[n] = en_short[n] + p;
                if (p > en_subshort[i + 3 - 2]) {
                    assert (en_subshort[i + 3 - 2] > 0.0f);
                    p /= en_subshort[i + 3 - 2];
                } else if (en_subshort[i + 3 - 2] > p * 10.0f) {
                    assert (p > 0.0f);
                    p = en_subshort[i + 3 - 2] / (p * 10.0f);
                } else {
                    p = 0.0f;
                }
                attack_intensity[i + 3] = p;
            }
            if (gfp.analysis) {
                float x = attack_intensity[0];
                for (i = 1; i < 12; ++i) {
                    if (!(x < attack_intensity[i])) continue;
                    x = attack_intensity[i];
                }
                gfc.pinfo.ers[gr_out][chn] = gfc.pinfo.ers_save[chn];
                gfc.pinfo.ers_save[chn] = x;
            }
            float attackThreshold = chn == 3 ? gfc.nsPsy.attackthre_s : gfc.nsPsy.attackthre;
            for (i = 0; i < 12; ++i) {
                if (0 != ns_attacks[i / 3] || !(attack_intensity[i] > attackThreshold)) continue;
                ns_attacks[i / 3] = i % 3 + 1;
            }
            for (i = 1; i < 4; ++i) {
                float ratio;
                if (en_short[i - 1] > en_short[i]) {
                    assert (en_short[i] > 0.0f);
                    ratio = en_short[i - 1] / en_short[i];
                } else {
                    assert (en_short[i - 1] > 0.0f);
                    ratio = en_short[i] / en_short[i - 1];
                }
                if (!((double)ratio < 1.7)) continue;
                ns_attacks[i] = 0;
                if (i != 1) continue;
                ns_attacks[0] = 0;
            }
            if (ns_attacks[0] != 0 && gfc.nsPsy.lastAttacks[chn] != 0) {
                ns_attacks[0] = 0;
            }
            if (gfc.nsPsy.lastAttacks[chn] == 3 || ns_attacks[0] + ns_attacks[1] + ns_attacks[2] + ns_attacks[3] != 0) {
                ns_uselongblock = 0;
                if (ns_attacks[1] != 0 && ns_attacks[0] != 0) {
                    ns_attacks[1] = 0;
                }
                if (ns_attacks[2] != 0 && ns_attacks[1] != 0) {
                    ns_attacks[2] = 0;
                }
                if (ns_attacks[3] != 0 && ns_attacks[2] != 0) {
                    ns_attacks[3] = 0;
                }
            }
            if (chn < 2) {
                uselongblock[chn] = ns_uselongblock;
            } else if (ns_uselongblock == 0) {
                uselongblock[1] = 0;
                uselongblock[0] = 0;
            }
            energy[chn] = gfc.tot_ener[chn];
            float[][][] wsamp_s = wsamp_S;
            float[][] wsamp_l = wsamp_L;
            this.compute_ffts(gfp, fftenergy, fftenergy_s, wsamp_l, chn & 1, wsamp_s, chn & 1, gr_out, chn, buffer, bufPos);
            this.calc_energy(gfc, fftenergy, eb_l, max, avg);
            this.calc_mask_index_l(gfc, max, avg, mask_idx_l);
            for (int sblock = 0; sblock < 3; ++sblock) {
                this.compute_masking_s(gfp, fftenergy_s, eb_s, thr, chn, sblock);
                this.convert_partition2scalefac_s(gfc, eb_s, thr, chn, sblock);
                for (int sb = 0; sb < 13; ++sb) {
                    double p;
                    int idx;
                    float thmm = gfc.thm[chn].s[sb][sblock];
                    thmm *= 0.8f;
                    if (ns_attacks[sblock] >= 2 || ns_attacks[sblock + 1] == 1) {
                        idx = sblock != 0 ? sblock - 1 : 2;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.6f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    }
                    if (ns_attacks[sblock] == 1) {
                        idx = sblock != 0 ? sblock - 1 : 2;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.3f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    } else if (sblock != 0 && ns_attacks[sblock - 1] == 3 || sblock == 0 && gfc.nsPsy.lastAttacks[chn] == 3) {
                        idx = sblock != 2 ? sblock + 1 : 0;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.3f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    }
                    float enn = en_subshort[sblock * 3 + 3] + en_subshort[sblock * 3 + 4] + en_subshort[sblock * 3 + 5];
                    if (en_subshort[sblock * 3 + 5] * 6.0f < enn) {
                        thmm = (float)((double)thmm * 0.5);
                        if (en_subshort[sblock * 3 + 4] * 6.0f < enn) {
                            thmm = (float)((double)thmm * 0.5);
                        }
                    }
                    gfc.thm[chn].s[sb][sblock] = thmm;
                }
            }
            gfc.nsPsy.lastAttacks[chn] = ns_attacks[2];
            int k = 0;
            for (b = 0; b < gfc.npart_l; ++b) {
                int kk = gfc.s3ind[b][0];
                float eb2 = eb_l[kk] * tab[mask_idx_l[kk]];
                float ecb = gfc.s3_ll[k++] * eb2;
                while (++kk <= gfc.s3ind[b][1]) {
                    eb2 = eb_l[kk] * tab[mask_idx_l[kk]];
                    ecb = this.mask_add(ecb, gfc.s3_ll[k++] * eb2, kk, kk - b, gfc, 0);
                }
                ecb = (float)((double)ecb * 0.158489319246111);
                thr[b] = gfc.blocktype_old[chn & 1] == 2 ? ecb : this.NS_INTERP(Math.min(ecb, Math.min(2.0f * gfc.nb_1[chn][b], 16.0f * gfc.nb_2[chn][b])), ecb, pcfact);
                gfc.nb_2[chn][b] = gfc.nb_1[chn][b];
                gfc.nb_1[chn][b] = ecb;
            }
            while (b <= 64) {
                eb_l[b] = 0.0f;
                thr[b] = 0.0f;
                ++b;
            }
            this.convert_partition2scalefac_l(gfc, eb_l, thr, chn);
        }
        if ((gfp.mode == MPEGMode.STEREO || gfp.mode == MPEGMode.JOINT_STEREO) && (double)gfp.interChRatio > 0.0) {
            this.calc_interchannel_masking(gfp, gfp.interChRatio);
        }
        if (gfp.mode == MPEGMode.JOINT_STEREO) {
            this.msfix1(gfc);
            float msfix = gfp.msfix;
            if ((double)Math.abs(msfix) > 0.0) {
                this.ns_msfix(gfc, msfix, gfp.ATHlower * gfc.ATH.adjust);
            }
        }
        this.block_type_set(gfp, uselongblock, blocktype_d, blocktype);
        for (chn = 0; chn < numchn; ++chn) {
            III_psy_ratio mr;
            int type;
            float[] ppe;
            int ppePos = 0;
            if (chn > 1) {
                ppe = percep_MS_entropy;
                ppePos = -2;
                type = 0;
                if (blocktype_d[0] == 2 || blocktype_d[1] == 2) {
                    type = 2;
                }
                mr = masking_MS_ratio[gr_out][chn - 2];
            } else {
                ppe = percep_entropy;
                ppePos = 0;
                type = blocktype_d[chn];
                mr = masking_ratio[gr_out][chn];
            }
            ppe[ppePos + chn] = type == 2 ? this.pecalc_s(mr, gfc.masking_lower) : this.pecalc_l(mr, gfc.masking_lower);
            if (!gfp.analysis) continue;
            gfc.pinfo.pe[gr_out][chn] = ppe[ppePos + chn];
        }
        return 0;
    }

    private void vbrpsy_compute_fft_l(LameGlobalFlags gfp, float[][] buffer, int bufPos, int chn, int gr_out, float[] fftenergy, float[][] wsamp_l, int wsamp_lPos) {
        int j;
        LameInternalFlags gfc = gfp.internal_flags;
        if (chn < 2) {
            this.fft.fft_long(gfc, wsamp_l[wsamp_lPos], chn, buffer, bufPos);
        } else if (chn == 2) {
            for (j = 1023; j >= 0; --j) {
                float l2 = wsamp_l[wsamp_lPos + 0][j];
                float r = wsamp_l[wsamp_lPos + 1][j];
                wsamp_l[wsamp_lPos + 0][j] = (l2 + r) * 1.4142135f * 0.5f;
                wsamp_l[wsamp_lPos + 1][j] = (l2 - r) * 1.4142135f * 0.5f;
            }
        }
        fftenergy[0] = PsyModel.NON_LINEAR_SCALE_ENERGY(wsamp_l[wsamp_lPos + 0][0]);
        fftenergy[0] = fftenergy[0] * fftenergy[0];
        for (j = 511; j >= 0; --j) {
            float re = wsamp_l[wsamp_lPos + 0][512 - j];
            float im = wsamp_l[wsamp_lPos + 0][512 + j];
            fftenergy[512 - j] = PsyModel.NON_LINEAR_SCALE_ENERGY((re * re + im * im) * 0.5f);
        }
        float totalenergy = 0.0f;
        for (int j2 = 11; j2 < 513; ++j2) {
            totalenergy += fftenergy[j2];
        }
        gfc.tot_ener[chn] = totalenergy;
        if (gfp.analysis) {
            for (int j3 = 0; j3 < 513; ++j3) {
                gfc.pinfo.energy[gr_out][chn][j3] = gfc.pinfo.energy_save[chn][j3];
                gfc.pinfo.energy_save[chn][j3] = fftenergy[j3];
            }
            gfc.pinfo.pe[gr_out][chn] = gfc.pe[chn];
        }
    }

    private void vbrpsy_compute_fft_s(LameGlobalFlags gfp, float[][] buffer, int bufPos, int chn, int sblock, float[][] fftenergy_s, float[][][] wsamp_s, int wsamp_sPos) {
        int j;
        LameInternalFlags gfc = gfp.internal_flags;
        if (sblock == 0 && chn < 2) {
            this.fft.fft_short(gfc, wsamp_s[wsamp_sPos], chn, buffer, bufPos);
        }
        if (chn == 2) {
            for (j = 255; j >= 0; --j) {
                float l2 = wsamp_s[wsamp_sPos + 0][sblock][j];
                float r = wsamp_s[wsamp_sPos + 1][sblock][j];
                wsamp_s[wsamp_sPos + 0][sblock][j] = (l2 + r) * 1.4142135f * 0.5f;
                wsamp_s[wsamp_sPos + 1][sblock][j] = (l2 - r) * 1.4142135f * 0.5f;
            }
        }
        fftenergy_s[sblock][0] = wsamp_s[wsamp_sPos + 0][sblock][0];
        float[] fArray = fftenergy_s[sblock];
        fArray[0] = fArray[0] * fftenergy_s[sblock][0];
        for (j = 127; j >= 0; --j) {
            float re = wsamp_s[wsamp_sPos + 0][sblock][128 - j];
            float im = wsamp_s[wsamp_sPos + 0][sblock][128 + j];
            fftenergy_s[sblock][128 - j] = PsyModel.NON_LINEAR_SCALE_ENERGY((re * re + im * im) * 0.5f);
        }
    }

    private void vbrpsy_compute_loudness_approximation_l(LameGlobalFlags gfp, int gr_out, int chn, float[] fftenergy) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfp.athaa_loudapprox == 2 && chn < 2) {
            gfc.loudness_sq[gr_out][chn] = gfc.loudness_sq_save[chn];
            gfc.loudness_sq_save[chn] = this.psycho_loudness_approx(fftenergy, gfc);
        }
    }

    private void vbrpsy_attack_detection(LameGlobalFlags gfp, float[][] buffer, int bufPos, int gr_out, III_psy_ratio[][] masking_ratio, III_psy_ratio[][] masking_MS_ratio, float[] energy, float[][] sub_short_factor, int[][] ns_attacks, int[] uselongblock) {
        int chn;
        float[][] ns_hpfsmpl = new float[2][576];
        LameInternalFlags gfc = gfp.internal_flags;
        int n_chn_out = gfc.channels_out;
        int n_chn_psy = gfp.mode == MPEGMode.JOINT_STEREO ? 4 : n_chn_out;
        for (chn = 0; chn < n_chn_out; ++chn) {
            float[] firbuf = buffer[chn];
            int firbufPos = bufPos + 576 - 350 - 21 + 192;
            assert (fircoef_.length == 10);
            for (int i = 0; i < 576; ++i) {
                float sum1 = firbuf[firbufPos + i + 10];
                float sum2 = 0.0f;
                for (int j = 0; j < 9; j += 2) {
                    sum1 += fircoef_[j] * (firbuf[firbufPos + i + j] + firbuf[firbufPos + i + 21 - j]);
                    sum2 += fircoef_[j + 1] * (firbuf[firbufPos + i + j + 1] + firbuf[firbufPos + i + 21 - j - 1]);
                }
                ns_hpfsmpl[chn][i] = sum1 + sum2;
            }
            masking_ratio[gr_out][chn].en.assign(gfc.en[chn]);
            masking_ratio[gr_out][chn].thm.assign(gfc.thm[chn]);
            if (n_chn_psy <= 2) continue;
            masking_MS_ratio[gr_out][chn].en.assign(gfc.en[chn + 2]);
            masking_MS_ratio[gr_out][chn].thm.assign(gfc.thm[chn + 2]);
        }
        for (chn = 0; chn < n_chn_psy; ++chn) {
            int i;
            float[] attack_intensity = new float[12];
            float[] en_subshort = new float[12];
            float[] en_short = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] pf = ns_hpfsmpl[chn & 1];
            int pfPos = 0;
            float attackThreshold = chn == 3 ? gfc.nsPsy.attackthre_s : gfc.nsPsy.attackthre;
            int ns_uselongblock = 1;
            if (chn == 2) {
                i = 0;
                for (int j = 576; j > 0; --j) {
                    float l2 = ns_hpfsmpl[0][i];
                    float r = ns_hpfsmpl[1][i];
                    ns_hpfsmpl[0][i] = l2 + r;
                    ns_hpfsmpl[1][i] = l2 - r;
                    ++i;
                }
            }
            for (i = 0; i < 3; ++i) {
                en_subshort[i] = gfc.nsPsy.last_en_subshort[chn][i + 6];
                assert (gfc.nsPsy.last_en_subshort[chn][i + 4] > 0.0f);
                attack_intensity[i] = en_subshort[i] / gfc.nsPsy.last_en_subshort[chn][i + 4];
                en_short[0] = en_short[0] + en_subshort[i];
            }
            for (i = 0; i < 9; ++i) {
                int pfe = pfPos + 64;
                float p = 1.0f;
                while (pfPos < pfe) {
                    if (p < Math.abs(pf[pfPos])) {
                        p = Math.abs(pf[pfPos]);
                    }
                    ++pfPos;
                }
                float f = p;
                en_subshort[i + 3] = f;
                gfc.nsPsy.last_en_subshort[chn][i] = f;
                int n = 1 + i / 3;
                en_short[n] = en_short[n] + p;
                if (p > en_subshort[i + 3 - 2]) {
                    assert (en_subshort[i + 3 - 2] > 0.0f);
                    p /= en_subshort[i + 3 - 2];
                } else if ((double)en_subshort[i + 3 - 2] > (double)p * 10.0) {
                    assert (p > 0.0f);
                    p = en_subshort[i + 3 - 2] / (p * 10.0f);
                } else {
                    p = 0.0f;
                }
                attack_intensity[i + 3] = p;
            }
            for (i = 0; i < 3; ++i) {
                float enn = en_subshort[i * 3 + 3] + en_subshort[i * 3 + 4] + en_subshort[i * 3 + 5];
                float factor = 1.0f;
                if (en_subshort[i * 3 + 5] * 6.0f < enn) {
                    factor *= 0.5f;
                    if (en_subshort[i * 3 + 4] * 6.0f < enn) {
                        factor *= 0.5f;
                    }
                }
                sub_short_factor[chn][i] = factor;
            }
            if (gfp.analysis) {
                float x = attack_intensity[0];
                for (int i2 = 1; i2 < 12; ++i2) {
                    if (!(x < attack_intensity[i2])) continue;
                    x = attack_intensity[i2];
                }
                gfc.pinfo.ers[gr_out][chn] = gfc.pinfo.ers_save[chn];
                gfc.pinfo.ers_save[chn] = x;
            }
            for (i = 0; i < 12; ++i) {
                if (0 != ns_attacks[chn][i / 3] || !(attack_intensity[i] > attackThreshold)) continue;
                ns_attacks[chn][i / 3] = i % 3 + 1;
            }
            for (i = 1; i < 4; ++i) {
                float u = en_short[i - 1];
                float v = en_short[i];
                float m = Math.max(u, v);
                if (!(m < 40000.0f) || !((double)u < 1.7 * (double)v) || !((double)v < 1.7 * (double)u)) continue;
                if (i == 1 && ns_attacks[chn][0] <= ns_attacks[chn][i]) {
                    ns_attacks[chn][0] = 0;
                }
                ns_attacks[chn][i] = 0;
            }
            if (ns_attacks[chn][0] <= gfc.nsPsy.lastAttacks[chn]) {
                ns_attacks[chn][0] = 0;
            }
            if (gfc.nsPsy.lastAttacks[chn] == 3 || ns_attacks[chn][0] + ns_attacks[chn][1] + ns_attacks[chn][2] + ns_attacks[chn][3] != 0) {
                ns_uselongblock = 0;
                if (ns_attacks[chn][1] != 0 && ns_attacks[chn][0] != 0) {
                    ns_attacks[chn][1] = 0;
                }
                if (ns_attacks[chn][2] != 0 && ns_attacks[chn][1] != 0) {
                    ns_attacks[chn][2] = 0;
                }
                if (ns_attacks[chn][3] != 0 && ns_attacks[chn][2] != 0) {
                    ns_attacks[chn][3] = 0;
                }
            }
            if (chn < 2) {
                uselongblock[chn] = ns_uselongblock;
            } else if (ns_uselongblock == 0) {
                uselongblock[1] = 0;
                uselongblock[0] = 0;
            }
            energy[chn] = gfc.tot_ener[chn];
        }
    }

    private void vbrpsy_skip_masking_s(LameInternalFlags gfc, int chn, int sblock) {
        if (sblock == 0) {
            for (int b = 0; b < gfc.npart_s; ++b) {
                gfc.nb_s2[chn][b] = gfc.nb_s1[chn][b];
                gfc.nb_s1[chn][b] = 0.0f;
            }
        }
    }

    private void vbrpsy_skip_masking_l(LameInternalFlags gfc, int chn) {
        for (int b = 0; b < gfc.npart_l; ++b) {
            gfc.nb_2[chn][b] = gfc.nb_1[chn][b];
            gfc.nb_1[chn][b] = 0.0f;
        }
    }

    private void psyvbr_calc_mask_index_s(LameInternalFlags gfc, float[] max, float[] avg, int[] mask_idx) {
        int k;
        float m;
        int last_tab_entry = tab.length - 1;
        int b = 0;
        float a = avg[b] + avg[b + 1];
        assert (a >= 0.0f);
        if ((double)a > 0.0) {
            m = max[b];
            if (m < max[b + 1]) {
                m = max[b + 1];
            }
            assert (gfc.numlines_s[b] + gfc.numlines_s[b + 1] - 1 > 0);
            k = (int)(a = 20.0f * (m * 2.0f - a) / (a * (float)(gfc.numlines_s[b] + gfc.numlines_s[b + 1] - 1)));
            if (k > last_tab_entry) {
                k = last_tab_entry;
            }
            mask_idx[b] = k;
        } else {
            mask_idx[b] = 0;
        }
        for (b = 1; b < gfc.npart_s - 1; ++b) {
            a = avg[b - 1] + avg[b] + avg[b + 1];
            assert (b + 1 < gfc.npart_s);
            assert (a >= 0.0f);
            if ((double)a > 0.0) {
                m = max[b - 1];
                if (m < max[b]) {
                    m = max[b];
                }
                if (m < max[b + 1]) {
                    m = max[b + 1];
                }
                assert (gfc.numlines_s[b - 1] + gfc.numlines_s[b] + gfc.numlines_s[b + 1] - 1 > 0);
                k = (int)(a = 20.0f * (m * 3.0f - a) / (a * (float)(gfc.numlines_s[b - 1] + gfc.numlines_s[b] + gfc.numlines_s[b + 1] - 1)));
                if (k > last_tab_entry) {
                    k = last_tab_entry;
                }
                mask_idx[b] = k;
                continue;
            }
            mask_idx[b] = 0;
        }
        assert (b > 0);
        assert (b == gfc.npart_s - 1);
        a = avg[b - 1] + avg[b];
        assert (a >= 0.0f);
        if ((double)a > 0.0) {
            m = max[b - 1];
            if (m < max[b]) {
                m = max[b];
            }
            assert (gfc.numlines_s[b - 1] + gfc.numlines_s[b] - 1 > 0);
            k = (int)(a = 20.0f * (m * 2.0f - a) / (a * (float)(gfc.numlines_s[b - 1] + gfc.numlines_s[b] - 1)));
            if (k > last_tab_entry) {
                k = last_tab_entry;
            }
            mask_idx[b] = k;
        } else {
            mask_idx[b] = 0;
        }
        assert (b == gfc.npart_s - 1);
    }

    private void vbrpsy_compute_masking_s(LameGlobalFlags gfp, float[][] fftenergy_s, float[] eb, float[] thr, int chn, int sblock) {
        int b;
        LameInternalFlags gfc = gfp.internal_flags;
        float[] max = new float[64];
        float[] avg = new float[64];
        int[] mask_idx_s = new int[64];
        int j = 0;
        for (b = 0; b < gfc.npart_s; ++b) {
            float ebb = 0.0f;
            float m = 0.0f;
            int n = gfc.numlines_s[b];
            int i = 0;
            while (i < n) {
                float el = fftenergy_s[sblock][j];
                ebb += el;
                if (m < el) {
                    m = el;
                }
                ++i;
                ++j;
            }
            eb[b] = ebb;
            assert (ebb >= 0.0f);
            max[b] = m;
            assert (n > 0);
            avg[b] = ebb / (float)n;
            assert (avg[b] >= 0.0f);
        }
        assert (b == gfc.npart_s);
        assert (j == 129);
        while (b < 64) {
            max[b] = 0.0f;
            avg[b] = 0.0f;
            ++b;
        }
        this.psyvbr_calc_mask_index_s(gfc, max, avg, mask_idx_s);
        j = 0;
        for (b = 0; b < gfc.npart_s; ++b) {
            float x;
            int kk = gfc.s3ind_s[b][0];
            int last = gfc.s3ind_s[b][1];
            int dd = mask_idx_s[kk];
            int dd_n = 1;
            float ecb = gfc.s3_ss[j] * eb[kk] * tab[mask_idx_s[kk]];
            ++j;
            ++kk;
            while (kk <= last) {
                dd += mask_idx_s[kk];
                ++dd_n;
                x = gfc.s3_ss[j] * eb[kk] * tab[mask_idx_s[kk]];
                ecb = this.vbrpsy_mask_add(ecb, x, kk - b);
                ++j;
                ++kk;
            }
            dd = (1 + 2 * dd) / (2 * dd_n);
            float avg_mask = tab[dd] * 0.5f;
            thr[b] = ecb *= avg_mask;
            gfc.nb_s2[chn][b] = gfc.nb_s1[chn][b];
            gfc.nb_s1[chn][b] = ecb;
            x = max[b];
            x *= gfc.minval_s[b];
            if (thr[b] > (x *= avg_mask)) {
                thr[b] = x;
            }
            if (gfc.masking_lower > 1.0f) {
                int n = b;
                thr[n] = thr[n] * gfc.masking_lower;
            }
            if (thr[b] > eb[b]) {
                thr[b] = eb[b];
            }
            if (gfc.masking_lower < 1.0f) {
                int n = b;
                thr[n] = thr[n] * gfc.masking_lower;
            }
            assert (thr[b] >= 0.0f);
        }
        while (b < 64) {
            eb[b] = 0.0f;
            thr[b] = 0.0f;
            ++b;
        }
    }

    private void vbrpsy_compute_masking_l(LameInternalFlags gfc, float[] fftenergy, float[] eb_l, float[] thr, int chn) {
        int b;
        float[] max = new float[64];
        float[] avg = new float[64];
        int[] mask_idx_l = new int[66];
        this.calc_energy(gfc, fftenergy, eb_l, max, avg);
        this.calc_mask_index_l(gfc, max, avg, mask_idx_l);
        int k = 0;
        for (b = 0; b < gfc.npart_l; ++b) {
            float x;
            int kk = gfc.s3ind[b][0];
            int last = gfc.s3ind[b][1];
            int dd = 0;
            int dd_n = 0;
            dd = mask_idx_l[kk];
            ++dd_n;
            float ecb = gfc.s3_ll[k] * eb_l[kk] * tab[mask_idx_l[kk]];
            ++k;
            ++kk;
            while (kk <= last) {
                float t;
                dd += mask_idx_l[kk];
                ++dd_n;
                x = gfc.s3_ll[k] * eb_l[kk] * tab[mask_idx_l[kk]];
                ecb = t = this.vbrpsy_mask_add(ecb, x, kk - b);
                ++k;
                ++kk;
            }
            dd = (1 + 2 * dd) / (2 * dd_n);
            float avg_mask = tab[dd] * 0.5f;
            ecb *= avg_mask;
            if (gfc.blocktype_old[chn & 1] == 2) {
                float ecb_limit = 2.0f * gfc.nb_1[chn][b];
                thr[b] = ecb_limit > 0.0f ? Math.min(ecb, ecb_limit) : Math.min(ecb, eb_l[b] * 0.3f);
            } else {
                float ecb_limit_2 = 16.0f * gfc.nb_2[chn][b];
                float ecb_limit_1 = 2.0f * gfc.nb_1[chn][b];
                if (ecb_limit_2 <= 0.0f) {
                    ecb_limit_2 = ecb;
                }
                if (ecb_limit_1 <= 0.0f) {
                    ecb_limit_1 = ecb;
                }
                float ecb_limit = gfc.blocktype_old[chn & 1] == 0 ? Math.min(ecb_limit_1, ecb_limit_2) : ecb_limit_1;
                thr[b] = Math.min(ecb, ecb_limit);
            }
            gfc.nb_2[chn][b] = gfc.nb_1[chn][b];
            gfc.nb_1[chn][b] = ecb;
            x = max[b];
            x *= gfc.minval_l[b];
            x *= avg_mask;
            if (thr[b] > x) {
                thr[b] = x;
            }
            if (gfc.masking_lower > 1.0f) {
                int n = b;
                thr[n] = thr[n] * gfc.masking_lower;
            }
            if (thr[b] > eb_l[b]) {
                thr[b] = eb_l[b];
            }
            if (gfc.masking_lower < 1.0f) {
                int n = b;
                thr[n] = thr[n] * gfc.masking_lower;
            }
            assert (thr[b] >= 0.0f);
        }
        while (b < 64) {
            eb_l[b] = 0.0f;
            thr[b] = 0.0f;
            ++b;
        }
    }

    private void vbrpsy_compute_block_type(LameGlobalFlags gfp, int[] uselongblock) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfp.short_blocks == ShortBlock.short_block_coupled && (uselongblock[0] == 0 || uselongblock[1] == 0)) {
            uselongblock[1] = 0;
            uselongblock[0] = 0;
        }
        for (int chn = 0; chn < gfc.channels_out; ++chn) {
            if (gfp.short_blocks == ShortBlock.short_block_dispensed) {
                uselongblock[chn] = 1;
            }
            if (gfp.short_blocks != ShortBlock.short_block_forced) continue;
            uselongblock[chn] = 0;
        }
    }

    private void vbrpsy_apply_block_type(LameGlobalFlags gfp, int[] uselongblock, int[] blocktype_d) {
        LameInternalFlags gfc = gfp.internal_flags;
        for (int chn = 0; chn < gfc.channels_out; ++chn) {
            int blocktype = 0;
            if (uselongblock[chn] != 0) {
                assert (gfc.blocktype_old[chn] != 1);
                if (gfc.blocktype_old[chn] == 2) {
                    blocktype = 3;
                }
            } else {
                blocktype = 2;
                if (gfc.blocktype_old[chn] == 0) {
                    gfc.blocktype_old[chn] = 1;
                }
                if (gfc.blocktype_old[chn] == 3) {
                    gfc.blocktype_old[chn] = 2;
                }
            }
            blocktype_d[chn] = gfc.blocktype_old[chn];
            gfc.blocktype_old[chn] = blocktype;
        }
    }

    private void vbrpsy_compute_MS_thresholds(float[][] eb, float[][] thr, float[] cb_mld, float[] ath_cb, float athadjust, float msfix, int n) {
        float msfix2 = msfix * 2.0f;
        float athlower = msfix > 0.0f ? (float)Math.pow(10.0, athadjust) : 1.0f;
        for (int b = 0; b < n; ++b) {
            float rside;
            float rmid;
            float ebM = eb[2][b];
            float ebS = eb[3][b];
            float thmL = thr[0][b];
            float thmR = thr[1][b];
            float thmM = thr[2][b];
            float thmS = thr[3][b];
            if ((double)thmL <= 1.58 * (double)thmR && (double)thmR <= 1.58 * (double)thmL) {
                float mld_m = cb_mld[b] * ebS;
                float mld_s = cb_mld[b] * ebM;
                rmid = Math.max(thmM, Math.min(thmS, mld_m));
                rside = Math.max(thmS, Math.min(thmM, mld_s));
            } else {
                rmid = thmM;
                rside = thmS;
            }
            if (msfix > 0.0f) {
                float ath = ath_cb[b] * athlower;
                float thmLR = Math.min(Math.max(thmL, ath), Math.max(thmR, ath));
                thmM = Math.max(rmid, ath);
                float thmMS = thmM + (thmS = Math.max(rside, ath));
                if (thmMS > 0.0f && thmLR * msfix2 < thmMS) {
                    float f = thmLR * msfix2 / thmMS;
                    thmM *= f;
                    thmS *= f;
                    assert (thmMS > 0.0f);
                }
                rmid = Math.min(thmM, rmid);
                rside = Math.min(thmS, rside);
            }
            if (rmid > ebM) {
                rmid = ebM;
            }
            if (rside > ebS) {
                rside = ebS;
            }
            thr[2][b] = rmid;
            thr[3][b] = rside;
        }
    }

    public final int L3psycho_anal_vbr(LameGlobalFlags gfp, float[][] buffer, int bufPos, int gr_out, III_psy_ratio[][] masking_ratio, III_psy_ratio[][] masking_MS_ratio, float[] percep_entropy, float[] percep_MS_entropy, float[] energy, int[] blocktype_d) {
        int ch01;
        int chn;
        LameInternalFlags gfc = gfp.internal_flags;
        float[] fftenergy = new float[513];
        float[][] fftenergy_s = new float[3][129];
        float[][] wsamp_L = new float[2][1024];
        float[][][] wsamp_S = new float[2][3][256];
        float[][] eb = new float[4][64];
        float[][] thr = new float[4][64];
        float[][] sub_short_factor = new float[4][3];
        float pcfact = 0.6f;
        int[][] ns_attacks = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
        int[] uselongblock = new int[2];
        int n_chn_psy = gfp.mode == MPEGMode.JOINT_STEREO ? 4 : gfc.channels_out;
        this.vbrpsy_attack_detection(gfp, buffer, bufPos, gr_out, masking_ratio, masking_MS_ratio, energy, sub_short_factor, ns_attacks, uselongblock);
        this.vbrpsy_compute_block_type(gfp, uselongblock);
        for (chn = 0; chn < n_chn_psy; ++chn) {
            ch01 = chn & 1;
            float[][] wsamp_l = wsamp_L;
            this.vbrpsy_compute_fft_l(gfp, buffer, bufPos, chn, gr_out, fftenergy, wsamp_l, ch01);
            this.vbrpsy_compute_loudness_approximation_l(gfp, gr_out, chn, fftenergy);
            if (uselongblock[ch01] != 0) {
                this.vbrpsy_compute_masking_l(gfc, fftenergy, eb[chn], thr[chn], chn);
                continue;
            }
            this.vbrpsy_skip_masking_l(gfc, chn);
        }
        if (uselongblock[0] + uselongblock[1] == 2 && gfp.mode == MPEGMode.JOINT_STEREO) {
            this.vbrpsy_compute_MS_thresholds(eb, thr, gfc.mld_cb_l, gfc.ATH.cb_l, gfp.ATHlower * gfc.ATH.adjust, gfp.msfix, gfc.npart_l);
        }
        for (chn = 0; chn < n_chn_psy; ++chn) {
            ch01 = chn & 1;
            if (uselongblock[ch01] == 0) continue;
            this.convert_partition2scalefac_l(gfc, eb[chn], thr[chn], chn);
        }
        for (int sblock = 0; sblock < 3; ++sblock) {
            int ch012;
            int chn2;
            for (chn2 = 0; chn2 < n_chn_psy; ++chn2) {
                ch012 = chn2 & 1;
                if (uselongblock[ch012] != 0) {
                    this.vbrpsy_skip_masking_s(gfc, chn2, sblock);
                    continue;
                }
                float[][][] wsamp_s = wsamp_S;
                this.vbrpsy_compute_fft_s(gfp, buffer, bufPos, chn2, sblock, fftenergy_s, wsamp_s, ch012);
                this.vbrpsy_compute_masking_s(gfp, fftenergy_s, eb[chn2], thr[chn2], chn2, sblock);
            }
            if (uselongblock[0] + uselongblock[1] == 0 && gfp.mode == MPEGMode.JOINT_STEREO) {
                this.vbrpsy_compute_MS_thresholds(eb, thr, gfc.mld_cb_s, gfc.ATH.cb_s, gfp.ATHlower * gfc.ATH.adjust, gfp.msfix, gfc.npart_s);
            }
            for (chn2 = 0; chn2 < n_chn_psy; ++chn2) {
                ch012 = chn2 & 1;
                if (0 != uselongblock[ch012]) continue;
                this.convert_partition2scalefac_s(gfc, eb[chn2], thr[chn2], chn2, sblock);
            }
        }
        for (chn = 0; chn < n_chn_psy; ++chn) {
            ch01 = chn & 1;
            if (uselongblock[ch01] != 0) continue;
            for (int sb = 0; sb < 13; ++sb) {
                int sblock;
                float[] new_thmm = new float[3];
                for (sblock = 0; sblock < 3; ++sblock) {
                    double p;
                    int idx;
                    float thmm = gfc.thm[chn].s[sb][sblock];
                    thmm *= 0.8f;
                    if (ns_attacks[chn][sblock] >= 2 || ns_attacks[chn][sblock + 1] == 1) {
                        idx = sblock != 0 ? sblock - 1 : 2;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.6f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    } else if (ns_attacks[chn][sblock] == 1) {
                        idx = sblock != 0 ? sblock - 1 : 2;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.3f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    } else if (sblock != 0 && ns_attacks[chn][sblock - 1] == 3 || sblock == 0 && gfc.nsPsy.lastAttacks[chn] == 3) {
                        idx = sblock != 2 ? sblock + 1 : 0;
                        p = this.NS_INTERP(gfc.thm[chn].s[sb][idx], thmm, 0.3f * pcfact);
                        thmm = (float)Math.min((double)thmm, p);
                    }
                    new_thmm[sblock] = thmm *= sub_short_factor[chn][sblock];
                }
                for (sblock = 0; sblock < 3; ++sblock) {
                    gfc.thm[chn].s[sb][sblock] = new_thmm[sblock];
                }
            }
        }
        for (chn = 0; chn < n_chn_psy; ++chn) {
            gfc.nsPsy.lastAttacks[chn] = ns_attacks[chn][2];
        }
        this.vbrpsy_apply_block_type(gfp, uselongblock, blocktype_d);
        for (chn = 0; chn < n_chn_psy; ++chn) {
            III_psy_ratio mr;
            int type;
            int ppePos;
            float[] ppe;
            if (chn > 1) {
                ppe = percep_MS_entropy;
                ppePos = -2;
                type = 0;
                if (blocktype_d[0] == 2 || blocktype_d[1] == 2) {
                    type = 2;
                }
                mr = masking_MS_ratio[gr_out][chn - 2];
            } else {
                ppe = percep_entropy;
                ppePos = 0;
                type = blocktype_d[chn];
                mr = masking_ratio[gr_out][chn];
            }
            ppe[ppePos + chn] = type == 2 ? this.pecalc_s(mr, gfc.masking_lower) : this.pecalc_l(mr, gfc.masking_lower);
            if (!gfp.analysis) continue;
            gfc.pinfo.pe[gr_out][chn] = ppe[ppePos + chn];
        }
        return 0;
    }

    private float s3_func_x(float bark, float hf_slope) {
        float tempx = bark;
        float tempy = tempx >= 0.0f ? -tempx * 27.0f : tempx * hf_slope;
        if ((double)tempy <= -72.0) {
            return 0.0f;
        }
        return (float)Math.exp(tempy * 0.23025851f);
    }

    private float norm_s3_func_x(float hf_slope) {
        double lim_a = 0.0;
        double lim_b = 0.0;
        double x = 0.0;
        x = 0.0;
        while ((double)this.s3_func_x((float)x, hf_slope) > 1.0E-20) {
            x -= 1.0;
        }
        double l2 = x;
        double h = 0.0;
        while (Math.abs(h - l2) > 1.0E-12) {
            x = (h + l2) / 2.0;
            if (this.s3_func_x((float)x, hf_slope) > 0.0f) {
                h = x;
                continue;
            }
            l2 = x;
        }
        lim_a = l2;
        x = 0.0;
        x = 0.0;
        while ((double)this.s3_func_x((float)x, hf_slope) > 1.0E-20) {
            x += 1.0;
        }
        l2 = 0.0;
        h = x;
        while (Math.abs(h - l2) > 1.0E-12) {
            x = (h + l2) / 2.0;
            if (this.s3_func_x((float)x, hf_slope) > 0.0f) {
                l2 = x;
                continue;
            }
            h = x;
        }
        lim_b = h;
        double sum = 0.0;
        int m = 1000;
        for (int i = 0; i <= 1000; ++i) {
            double x2 = lim_a + (double)i * (lim_b - lim_a) / 1000.0;
            double y = this.s3_func_x((float)x2, hf_slope);
            sum += y;
        }
        double norm = 1001.0 / (sum * (lim_b - lim_a));
        return (float)norm;
    }

    private float s3_func(float bark) {
        float x;
        float tempx = bark;
        tempx = tempx >= 0.0f ? (tempx *= 3.0f) : (float)((double)tempx * 1.5);
        if ((double)tempx >= 0.5 && (double)tempx <= 2.5) {
            float temp = tempx - 0.5f;
            x = 8.0f * (temp * temp - 2.0f * temp);
        } else {
            x = 0.0f;
        }
        tempx = (float)((double)tempx + 0.474);
        float tempy = 15.811389f + 7.5f * tempx - 17.5f * (float)Math.sqrt(1.0 + (double)(tempx * tempx));
        if ((double)tempy <= -60.0) {
            return 0.0f;
        }
        tempx = (float)Math.exp((x + tempy) * 0.23025851f);
        tempx = (float)((double)tempx / 0.6609193);
        return tempx;
    }

    private float freq2bark(float freq) {
        if (freq < 0.0f) {
            freq = 0.0f;
        }
        return 13.0f * (float)Math.atan(0.76 * (double)(freq *= 0.001f)) + 3.5f * (float)Math.atan((double)(freq * freq) / 56.25);
    }

    private int init_numline(int[] numlines, int[] bo, int[] bm, float[] bval, float[] bval_width, float[] mld, float[] bo_w, float sfreq, int blksize, int[] scalepos, float deltafreq, int sbmax) {
        int i;
        float[] b_frq = new float[65];
        float sample_freq_frac = sfreq / (float)(sbmax > 15 ? 1152 : 384);
        int[] partition = new int[513];
        sfreq /= (float)blksize;
        int j = 0;
        int ni = 0;
        for (i = 0; i < 64; ++i) {
            int j2;
            float bark1 = this.freq2bark(sfreq * (float)j);
            b_frq[i] = sfreq * (float)j;
            for (j2 = j; this.freq2bark(sfreq * (float)j2) - bark1 < 0.34f && j2 <= blksize / 2; ++j2) {
            }
            numlines[i] = j2 - j;
            ni = i + 1;
            while (j < j2) {
                assert (j < 513);
                partition[j++] = i;
            }
            if (j <= blksize / 2) continue;
            j = blksize / 2;
            ++i;
            break;
        }
        assert (i < 64);
        b_frq[i] = sfreq * (float)j;
        for (int sfb = 0; sfb < sbmax; ++sfb) {
            int i2;
            int start2 = scalepos[sfb];
            int end = scalepos[sfb + 1];
            int i1 = (int)Math.floor(0.5 + (double)deltafreq * ((double)start2 - 0.5));
            if (i1 < 0) {
                i1 = 0;
            }
            if ((i2 = (int)Math.floor(0.5 + (double)deltafreq * ((double)end - 0.5))) > blksize / 2) {
                i2 = blksize / 2;
            }
            bm[sfb] = (partition[i1] + partition[i2]) / 2;
            bo[sfb] = partition[i2];
            float f_tmp = sample_freq_frac * (float)end;
            bo_w[sfb] = (f_tmp - b_frq[bo[sfb]]) / (b_frq[bo[sfb] + 1] - b_frq[bo[sfb]]);
            if (bo_w[sfb] < 0.0f) {
                bo_w[sfb] = 0.0f;
            } else if (bo_w[sfb] > 1.0f) {
                bo_w[sfb] = 1.0f;
            }
            float arg = this.freq2bark(sfreq * (float)scalepos[sfb] * deltafreq);
            arg = (float)Math.min((double)arg, 15.5) / 15.5f;
            mld[sfb] = (float)Math.pow(10.0, 1.25 * (1.0 - Math.cos(Math.PI * (double)arg)) - 2.5);
        }
        j = 0;
        for (int k = 0; k < ni; ++k) {
            int w = numlines[k];
            float bark1 = this.freq2bark(sfreq * (float)j);
            float bark2 = this.freq2bark(sfreq * (float)(j + w - 1));
            bval[k] = 0.5f * (bark1 + bark2);
            bark1 = this.freq2bark(sfreq * ((float)j - 0.5f));
            bark2 = this.freq2bark(sfreq * ((float)(j + w) - 0.5f));
            bval_width[k] = bark2 - bark1;
            j += w;
        }
        return ni;
    }

    private float[] init_s3_values(int[][] s3ind, int npart, float[] bval, float[] bval_width, float[] norm, boolean use_old_s3) {
        int i;
        int j;
        int i2;
        float[][] s3 = new float[64][64];
        int numberOfNoneZero = 0;
        if (use_old_s3) {
            for (i2 = 0; i2 < npart; ++i2) {
                for (j = 0; j < npart; ++j) {
                    float v = this.s3_func(bval[i2] - bval[j]) * bval_width[j];
                    s3[i2][j] = v * norm[i2];
                }
            }
        } else {
            for (j = 0; j < npart; ++j) {
                float hf_slope = 15.0f + Math.min(21.0f / bval[j], 12.0f);
                float s3_x_norm = this.norm_s3_func_x(hf_slope);
                for (i = 0; i < npart; ++i) {
                    float v = s3_x_norm * this.s3_func_x(bval[i] - bval[j], hf_slope) * bval_width[j];
                    s3[i][j] = v * norm[i];
                }
            }
        }
        for (i2 = 0; i2 < npart; ++i2) {
            for (j = 0; j < npart && !(s3[i2][j] > 0.0f); ++j) {
            }
            s3ind[i2][0] = j;
            for (j = npart - 1; j > 0 && !(s3[i2][j] > 0.0f); --j) {
            }
            s3ind[i2][1] = j;
            numberOfNoneZero += s3ind[i2][1] - s3ind[i2][0] + 1;
        }
        float[] p = new float[numberOfNoneZero];
        int k = 0;
        for (i = 0; i < npart; ++i) {
            for (j = s3ind[i][0]; j <= s3ind[i][1]; ++j) {
                p[k++] = s3[i][j];
            }
        }
        return p;
    }

    private float stereo_demask(double f) {
        double arg = this.freq2bark((float)f);
        arg = Math.min(arg, 15.5) / 15.5;
        return (float)Math.pow(10.0, 1.25 * (1.0 - Math.cos(Math.PI * arg)) - 2.5);
    }

    public final int psymodel_init(LameGlobalFlags gfp) {
        int b;
        int i;
        LameInternalFlags gfc = gfp.internal_flags;
        boolean useOldS3 = true;
        float bvl_a = 13.0f;
        float bvl_b = 24.0f;
        float snr_l_a = 0.0f;
        float snr_l_b = 0.0f;
        float snr_s_a = -8.25f;
        float snr_s_b = -4.5f;
        float[] bval = new float[64];
        float[] bval_width = new float[64];
        float[] norm = new float[64];
        float sfreq = gfp.out_samplerate;
        switch (gfp.experimentalZ) {
            default: {
                useOldS3 = true;
                break;
            }
            case 1: {
                useOldS3 = gfp.VBR != VbrMode.vbr_mtrh && gfp.VBR != VbrMode.vbr_mt;
                break;
            }
            case 2: {
                useOldS3 = false;
                break;
            }
            case 3: {
                bvl_a = 8.0f;
                snr_l_a = -1.75f;
                snr_l_b = -0.0125f;
                snr_s_a = -8.25f;
                snr_s_b = -2.25f;
            }
        }
        gfc.ms_ener_ratio_old = 0.25f;
        gfc.blocktype_old[1] = 0;
        gfc.blocktype_old[0] = 0;
        for (i = 0; i < 4; ++i) {
            int j;
            for (j = 0; j < 64; ++j) {
                gfc.nb_1[i][j] = 1.0E20f;
                gfc.nb_2[i][j] = 1.0E20f;
                gfc.nb_s2[i][j] = 1.0f;
                gfc.nb_s1[i][j] = 1.0f;
            }
            for (int sb = 0; sb < 22; ++sb) {
                gfc.en[i].l[sb] = 1.0E20f;
                gfc.thm[i].l[sb] = 1.0E20f;
            }
            for (j = 0; j < 3; ++j) {
                for (int sb = 0; sb < 13; ++sb) {
                    gfc.en[i].s[sb][j] = 1.0E20f;
                    gfc.thm[i].s[sb][j] = 1.0E20f;
                }
                gfc.nsPsy.lastAttacks[i] = 0;
            }
            for (j = 0; j < 9; ++j) {
                gfc.nsPsy.last_en_subshort[i][j] = 10.0f;
            }
        }
        gfc.loudness_sq_save[1] = 0.0f;
        gfc.loudness_sq_save[0] = 0.0f;
        gfc.npart_l = this.init_numline(gfc.numlines_l, gfc.bo_l, gfc.bm_l, bval, bval_width, gfc.mld_l, gfc.PSY.bo_l_weight, sfreq, 1024, gfc.scalefac_band.l, 0.8888889f, 22);
        assert (gfc.npart_l < 64);
        for (i = 0; i < gfc.npart_l; ++i) {
            double snr = snr_l_a;
            if (bval[i] >= bvl_a) {
                snr = snr_l_b * (bval[i] - bvl_a) / (bvl_b - bvl_a) + snr_l_a * (bvl_b - bval[i]) / (bvl_b - bvl_a);
            }
            norm[i] = (float)Math.pow(10.0, snr / 10.0);
            gfc.rnumlines_l[i] = gfc.numlines_l[i] > 0 ? 1.0f / (float)gfc.numlines_l[i] : 0.0f;
        }
        gfc.s3_ll = this.init_s3_values(gfc.s3ind, gfc.npart_l, bval, bval_width, norm, useOldS3);
        int j = 0;
        for (i = 0; i < gfc.npart_l; ++i) {
            double x = 3.4028234663852886E38;
            int k = 0;
            while (k < gfc.numlines_l[i]) {
                float freq = sfreq * (float)j / 1024000.0f;
                float level = this.ATHformula(freq * 1000.0f, gfp) - 20.0f;
                level = (float)Math.pow(10.0, 0.1 * (double)level);
                if (x > (double)(level *= (float)gfc.numlines_l[i])) {
                    x = level;
                }
                ++k;
                ++j;
            }
            gfc.ATH.cb_l[i] = (float)x;
            x = -20.0f + bval[i] * 20.0f / 10.0f;
            if (x > 6.0) {
                x = 100.0;
            }
            if (x < -15.0) {
                x = -15.0;
            }
            gfc.minval_l[i] = (float)(Math.pow(10.0, (x -= 8.0) / 10.0) * (double)gfc.numlines_l[i]);
        }
        gfc.npart_s = this.init_numline(gfc.numlines_s, gfc.bo_s, gfc.bm_s, bval, bval_width, gfc.mld_s, gfc.PSY.bo_s_weight, sfreq, 256, gfc.scalefac_band.s, 0.6666667f, 13);
        assert (gfc.npart_s < 64);
        j = 0;
        for (i = 0; i < gfc.npart_s; ++i) {
            double snr = snr_s_a;
            if (bval[i] >= bvl_a) {
                snr = snr_s_b * (bval[i] - bvl_a) / (bvl_b - bvl_a) + snr_s_a * (bvl_b - bval[i]) / (bvl_b - bvl_a);
            }
            norm[i] = (float)Math.pow(10.0, snr / 10.0);
            double x = 3.4028234663852886E38;
            int k = 0;
            while (k < gfc.numlines_s[i]) {
                float freq = sfreq * (float)j / 256000.0f;
                float level = this.ATHformula(freq * 1000.0f, gfp) - 20.0f;
                level = (float)Math.pow(10.0, 0.1 * (double)level);
                if (x > (double)(level *= (float)gfc.numlines_s[i])) {
                    x = level;
                }
                ++k;
                ++j;
            }
            gfc.ATH.cb_s[i] = (float)x;
            x = -7.0 + (double)bval[i] * 7.0 / 12.0;
            if (bval[i] > 12.0f) {
                x *= 1.0 + Math.log(1.0 + x) * 3.1;
            }
            if (bval[i] < 12.0f) {
                x *= 1.0 + Math.log(1.0 - x) * 2.3;
            }
            if (x < -15.0) {
                x = -15.0;
            }
            gfc.minval_s[i] = (float)Math.pow(10.0, (x -= 8.0) / 10.0) * (float)gfc.numlines_s[i];
        }
        gfc.s3_ss = this.init_s3_values(gfc.s3ind_s, gfc.npart_s, bval, bval_width, norm, useOldS3);
        this.init_mask_add_max_values();
        this.fft.init_fft(gfc);
        gfc.decay = (float)Math.exp(-2.3025851249694824 / ((double)(0.01f * sfreq) / 192.0));
        float msfix = 3.5f;
        if ((gfp.exp_nspsytune & 2) != 0) {
            msfix = 1.0f;
        }
        if ((double)Math.abs(gfp.msfix) > 0.0) {
            msfix = gfp.msfix;
        }
        gfp.msfix = msfix;
        for (b = 0; b < gfc.npart_l; ++b) {
            if (gfc.s3ind[b][1] <= gfc.npart_l - 1) continue;
            gfc.s3ind[b][1] = gfc.npart_l - 1;
        }
        float frame_duration = 576.0f * (float)gfc.mode_gr / sfreq;
        gfc.ATH.decay = (float)Math.pow(10.0, -1.2 * (double)frame_duration);
        gfc.ATH.adjust = 0.01f;
        gfc.ATH.adjustLimit = 1.0f;
        assert (gfc.bo_l[21] <= gfc.npart_l);
        assert (gfc.bo_s[12] <= gfc.npart_s);
        if (gfp.ATHtype != -1) {
            float freq_inc = (float)gfp.out_samplerate / 1024.0f;
            float eql_balance = 0.0f;
            float freq = 0.0f;
            for (i = 0; i < 512; ++i) {
                gfc.ATH.eql_w[i] = 1.0f / (float)Math.pow(10.0, this.ATHformula(freq += freq_inc, gfp) / 10.0f);
                eql_balance += gfc.ATH.eql_w[i];
            }
            eql_balance = 1.0f / eql_balance;
            i = 512;
            while (--i >= 0) {
                int n = i;
                gfc.ATH.eql_w[n] = gfc.ATH.eql_w[n] * eql_balance;
            }
        }
        j = 0;
        for (b = 0; b < gfc.npart_s; ++b) {
            for (i = 0; i < gfc.numlines_s[b]; ++i) {
                ++j;
            }
        }
        assert (j == 129);
        j = 0;
        for (b = 0; b < gfc.npart_l; ++b) {
            for (i = 0; i < gfc.numlines_l[b]; ++i) {
                ++j;
            }
        }
        assert (j == 513);
        j = 0;
        for (i = 0; i < gfc.npart_l; ++i) {
            float freq = sfreq * (float)(j + gfc.numlines_l[i] / 2) / 1024.0f;
            gfc.mld_cb_l[i] = this.stereo_demask(freq);
            j += gfc.numlines_l[i];
        }
        while (i < 64) {
            gfc.mld_cb_l[i] = 1.0f;
            ++i;
        }
        j = 0;
        for (i = 0; i < gfc.npart_s; ++i) {
            float freq = sfreq * (float)(j + gfc.numlines_s[i] / 2) / 256.0f;
            gfc.mld_cb_s[i] = this.stereo_demask(freq);
            j += gfc.numlines_s[i];
        }
        while (i < 64) {
            gfc.mld_cb_s[i] = 1.0f;
            ++i;
        }
        return 0;
    }

    private float ATHformula_GB(float f, float value) {
        if ((double)f < -0.3) {
            f = 3410.0f;
        }
        f /= 1000.0f;
        f = (float)Math.max(0.1, (double)f);
        float ath = 3.64f * (float)Math.pow(f, -0.8) - 6.8f * (float)Math.exp(-0.6 * Math.pow((double)f - 3.4, 2.0)) + 6.0f * (float)Math.exp(-0.15 * Math.pow((double)f - 8.7, 2.0)) + (0.6f + 0.04f * value) * 0.001f * (float)Math.pow(f, 4.0);
        return ath;
    }

    public final float ATHformula(float f, LameGlobalFlags gfp) {
        float ath;
        switch (gfp.ATHtype) {
            case 0: {
                ath = this.ATHformula_GB(f, 9.0f);
                break;
            }
            case 1: {
                ath = this.ATHformula_GB(f, -1.0f);
                break;
            }
            case 2: {
                ath = this.ATHformula_GB(f, 0.0f);
                break;
            }
            case 3: {
                ath = this.ATHformula_GB(f, 1.0f) + 6.0f;
                break;
            }
            case 4: {
                ath = this.ATHformula_GB(f, gfp.ATHcurve);
                break;
            }
            default: {
                ath = this.ATHformula_GB(f, 0.0f);
            }
        }
        return ath;
    }
}

