/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.Lame;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.LameInternalFlags;
import de.sciss.jump3r.mp3.ShortBlock;
import de.sciss.jump3r.mp3.Tables;
import de.sciss.jump3r.mp3.VBRSeekInfo;
import de.sciss.jump3r.mp3.VBRTagData;
import de.sciss.jump3r.mp3.VbrMode;
import de.sciss.jump3r.mp3.Version;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;

public class VBRTag {
    Lame lame;
    BitStream bs;
    Version v;
    private static final int FRAMES_FLAG = 1;
    private static final int BYTES_FLAG = 2;
    private static final int TOC_FLAG = 4;
    private static final int VBR_SCALE_FLAG = 8;
    public static final int NUMTOCENTRIES = 100;
    public static final int MAXFRAMESIZE = 2880;
    private static final int VBRHEADERSIZE = 120;
    private static final int LAMEHEADERSIZE = 156;
    private static final int XING_BITRATE1 = 128;
    private static final int XING_BITRATE2 = 64;
    private static final int XING_BITRATE25 = 32;
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final String VBRTag0 = "Xing";
    private static final String VBRTag1 = "Info";
    private static int[] crc16Lookup = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    public final void setModules(Lame lame, BitStream bs, Version v) {
        this.lame = lame;
        this.bs = bs;
        this.v = v;
    }

    private void addVbr(VBRSeekInfo v, int bitrate) {
        ++v.nVbrNumFrames;
        v.sum += bitrate;
        ++v.seen;
        if (v.seen < v.want) {
            return;
        }
        if (v.pos < v.size) {
            v.bag[v.pos] = v.sum;
            ++v.pos;
            v.seen = 0;
        }
        if (v.pos == v.size) {
            for (int i = 1; i < v.size; i += 2) {
                v.bag[i / 2] = v.bag[i];
            }
            v.want *= 2;
            v.pos /= 2;
        }
    }

    private void xingSeekTable(VBRSeekInfo v, byte[] t) {
        if (v.pos <= 0) {
            return;
        }
        for (int i = 1; i < 100; ++i) {
            float sum;
            float act;
            int seek_point;
            float j = (float)i / 100.0f;
            int indx = (int)Math.floor(j * (float)v.pos);
            if (indx > v.pos - 1) {
                indx = v.pos - 1;
            }
            if ((seek_point = (int)(256.0 * (double)(act = (float)v.bag[indx]) / (double)(sum = (float)v.sum))) > 255) {
                seek_point = 255;
            }
            t[i] = (byte)seek_point;
        }
    }

    public final void addVbrFrame(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        int kbps = Tables.bitrate_table[gfp.version][gfc.bitrate_index];
        assert (gfc.VBR_seek_table.bag != null);
        this.addVbr(gfc.VBR_seek_table, kbps);
    }

    private int extractInteger(byte[] buf2, int bufPos) {
        int x = buf2[bufPos + 0] & 0xFF;
        x <<= 8;
        x |= buf2[bufPos + 1] & 0xFF;
        x <<= 8;
        x |= buf2[bufPos + 2] & 0xFF;
        x <<= 8;
        return x |= buf2[bufPos + 3] & 0xFF;
    }

    private void createInteger(byte[] buf2, int bufPos, int value) {
        buf2[bufPos + 0] = (byte)(value >> 24 & 0xFF);
        buf2[bufPos + 1] = (byte)(value >> 16 & 0xFF);
        buf2[bufPos + 2] = (byte)(value >> 8 & 0xFF);
        buf2[bufPos + 3] = (byte)(value & 0xFF);
    }

    private void createShort(byte[] buf2, int bufPos, int value) {
        buf2[bufPos + 0] = (byte)(value >> 8 & 0xFF);
        buf2[bufPos + 1] = (byte)(value & 0xFF);
    }

    private boolean isVbrTag(byte[] buf2, int bufPos) {
        return new String(buf2, bufPos, VBRTag0.length(), ISO_8859_1).equals(VBRTag0) || new String(buf2, bufPos, VBRTag1.length(), ISO_8859_1).equals(VBRTag1);
    }

    private byte shiftInBitsValue(byte x, int n, int v) {
        return (byte)(x << n | v & ~(-1 << n));
    }

    private void setLameTagFrameHeader(LameGlobalFlags gfp, byte[] buffer) {
        LameInternalFlags gfc = gfp.internal_flags;
        buffer[0] = this.shiftInBitsValue(buffer[0], 8, 255);
        buffer[1] = this.shiftInBitsValue(buffer[1], 3, 7);
        buffer[1] = this.shiftInBitsValue(buffer[1], 1, gfp.out_samplerate < 16000 ? 0 : 1);
        buffer[1] = this.shiftInBitsValue(buffer[1], 1, gfp.version);
        buffer[1] = this.shiftInBitsValue(buffer[1], 2, 1);
        buffer[1] = this.shiftInBitsValue(buffer[1], 1, !gfp.error_protection ? 1 : 0);
        buffer[2] = this.shiftInBitsValue(buffer[2], 4, gfc.bitrate_index);
        buffer[2] = this.shiftInBitsValue(buffer[2], 2, gfc.samplerate_index);
        buffer[2] = this.shiftInBitsValue(buffer[2], 1, 0);
        buffer[2] = this.shiftInBitsValue(buffer[2], 1, gfp.extension);
        buffer[3] = this.shiftInBitsValue(buffer[3], 2, gfp.mode.ordinal());
        buffer[3] = this.shiftInBitsValue(buffer[3], 2, gfc.mode_ext);
        buffer[3] = this.shiftInBitsValue(buffer[3], 1, gfp.copyright);
        buffer[3] = this.shiftInBitsValue(buffer[3], 1, gfp.original);
        buffer[3] = this.shiftInBitsValue(buffer[3], 2, gfp.emphasis);
        buffer[0] = -1;
        byte abyte = (byte)(buffer[1] & 0xF1);
        int bitrate = 1 == gfp.version ? 128 : (gfp.out_samplerate < 16000 ? 32 : 64);
        if (gfp.VBR == VbrMode.vbr_off) {
            bitrate = gfp.brate;
        }
        byte bbyte = gfp.free_format ? (byte)0 : (byte)(16 * this.lame.BitrateIndex(bitrate, gfp.version, gfp.out_samplerate));
        if (gfp.version == 1) {
            buffer[1] = (byte)(abyte | 0xA);
            abyte = (byte)(buffer[2] & 0xD);
            buffer[2] = (byte)(bbyte | abyte);
        } else {
            buffer[1] = (byte)(abyte | 2);
            abyte = (byte)(buffer[2] & 0xD);
            buffer[2] = (byte)(bbyte | abyte);
        }
    }

    public final VBRTagData getVbrTag(byte[] buf2) {
        VBRTagData pTagData = new VBRTagData();
        int bufPos = 0;
        pTagData.flags = 0;
        int hId = buf2[bufPos + 1] >> 3 & 1;
        int hSrIndex = buf2[bufPos + 2] >> 2 & 3;
        int hMode = buf2[bufPos + 3] >> 6 & 3;
        int hBitrate = buf2[bufPos + 2] >> 4 & 0xF;
        hBitrate = Tables.bitrate_table[hId][hBitrate];
        pTagData.samprate = buf2[bufPos + 1] >> 4 == 14 ? Tables.samplerate_table[2][hSrIndex] : Tables.samplerate_table[hId][hSrIndex];
        bufPos = hId != 0 ? (hMode != 3 ? (bufPos += 36) : (bufPos += 21)) : (hMode != 3 ? (bufPos += 21) : (bufPos += 13));
        if (!this.isVbrTag(buf2, bufPos)) {
            return null;
        }
        pTagData.hId = hId;
        int head_flags = pTagData.flags = this.extractInteger(buf2, bufPos += 4);
        bufPos += 4;
        if ((head_flags & 1) != 0) {
            pTagData.frames = this.extractInteger(buf2, bufPos);
            bufPos += 4;
        }
        if ((head_flags & 2) != 0) {
            pTagData.bytes = this.extractInteger(buf2, bufPos);
            bufPos += 4;
        }
        if ((head_flags & 4) != 0) {
            if (pTagData.toc != null) {
                for (int i = 0; i < 100; ++i) {
                    pTagData.toc[i] = buf2[bufPos + i];
                }
            }
            bufPos += 100;
        }
        pTagData.vbrScale = -1;
        if ((head_flags & 8) != 0) {
            pTagData.vbrScale = this.extractInteger(buf2, bufPos);
            bufPos += 4;
        }
        pTagData.headersize = (hId + 1) * 72000 * hBitrate / pTagData.samprate;
        int encDelay = buf2[(bufPos += 21) + 0] << 4;
        int encPadding = (buf2[bufPos + 1] & 0xF) << 8;
        encPadding += buf2[bufPos + 2] & 0xFF;
        if ((encDelay += buf2[bufPos + 1] >> 4) < 0 || encDelay > 3000) {
            encDelay = -1;
        }
        if (encPadding < 0 || encPadding > 3000) {
            encPadding = -1;
        }
        pTagData.encDelay = encDelay;
        pTagData.encPadding = encPadding;
        return pTagData;
    }

    public final void InitVbrTag(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        int kbps_header = 1 == gfp.version ? 128 : (gfp.out_samplerate < 16000 ? 32 : 64);
        if (gfp.VBR == VbrMode.vbr_off) {
            kbps_header = gfp.brate;
        }
        int totalFrameSize = (gfp.version + 1) * 72000 * kbps_header / gfp.out_samplerate;
        int headerSize = gfc.sideinfo_len + 156;
        gfc.VBR_seek_table.TotalFrameSize = totalFrameSize;
        if (totalFrameSize < headerSize || totalFrameSize > 2880) {
            gfp.bWriteVbrTag = false;
            return;
        }
        gfc.VBR_seek_table.nVbrNumFrames = 0;
        gfc.VBR_seek_table.nBytesWritten = 0;
        gfc.VBR_seek_table.sum = 0;
        gfc.VBR_seek_table.seen = 0;
        gfc.VBR_seek_table.want = 1;
        gfc.VBR_seek_table.pos = 0;
        if (gfc.VBR_seek_table.bag == null) {
            gfc.VBR_seek_table.bag = new int[400];
            gfc.VBR_seek_table.size = 400;
        }
        byte[] buffer = new byte[2880];
        this.setLameTagFrameHeader(gfp, buffer);
        int n = gfc.VBR_seek_table.TotalFrameSize;
        for (int i = 0; i < n; ++i) {
            this.bs.add_dummy_byte(gfp, buffer[i] & 0xFF, 1);
        }
    }

    private int crcUpdateLookup(int value, int crc) {
        int tmp = crc ^ value;
        crc = crc >> 8 ^ crc16Lookup[tmp & 0xFF];
        return crc;
    }

    public final void updateMusicCRC(int[] crc, byte[] buffer, int bufferPos, int size) {
        for (int i = 0; i < size; ++i) {
            crc[0] = this.crcUpdateLookup(buffer[bufferPos + i], crc[0]);
        }
    }

    private int putLameVBR(LameGlobalFlags gfp, int musicLength, byte[] streamBuffer, int streamBufferPos, int crc) {
        int abrBitrate;
        LameInternalFlags gfc = gfp.internal_flags;
        int bytesWritten = 0;
        int encDelay = gfp.encoder_delay;
        int encPadding = gfp.encoder_padding;
        int quality = 100 - 10 * gfp.VBR_q - gfp.quality;
        String version = this.v.getLameVeryShortVersion();
        int revision = 0;
        int[] vbrTypeTranslator = new int[]{1, 5, 3, 2, 4, 0, 3};
        int lowpass = (int)((double)gfp.lowpassfreq / 100.0 + 0.5 > 255.0 ? 255.0 : (double)gfp.lowpassfreq / 100.0 + 0.5);
        int peakSignalAmplitude = 0;
        int radioReplayGain = 0;
        int audiophileReplayGain = 0;
        int noiseShaping = gfp.internal_flags.noise_shaping;
        int stereoMode = 0;
        int nonOptimal = 0;
        int sourceFreq = 0;
        int misc = 0;
        int musicCRC = 0;
        boolean expNPsyTune = (gfp.exp_nspsytune & 1) != 0;
        boolean safeJoint = (gfp.exp_nspsytune & 2) != 0;
        boolean noGapMore = false;
        boolean noGapPrevious = false;
        int noGapCount = gfp.internal_flags.nogap_total;
        int noGapCurr = gfp.internal_flags.nogap_current;
        int athType = gfp.ATHtype;
        int flags = 0;
        switch (gfp.VBR) {
            case vbr_abr: {
                abrBitrate = gfp.VBR_mean_bitrate_kbps;
                break;
            }
            case vbr_off: {
                abrBitrate = gfp.brate;
                break;
            }
            default: {
                abrBitrate = gfp.VBR_min_bitrate_kbps;
            }
        }
        int vbr = gfp.VBR.ordinal() < vbrTypeTranslator.length ? vbrTypeTranslator[gfp.VBR.ordinal()] : 0;
        int revMethod = 16 * revision + vbr;
        if (gfc.findReplayGain) {
            if (gfc.RadioGain > 510) {
                gfc.RadioGain = 510;
            }
            if (gfc.RadioGain < -510) {
                gfc.RadioGain = -510;
            }
            radioReplayGain = 8192;
            radioReplayGain |= 0xC00;
            if (gfc.RadioGain >= 0) {
                radioReplayGain |= gfc.RadioGain;
            } else {
                radioReplayGain |= 0x200;
                radioReplayGain |= -gfc.RadioGain;
            }
        }
        if (gfc.findPeakSample) {
            peakSignalAmplitude = Math.abs((int)((double)gfc.PeakSample / 32767.0 * Math.pow(2.0, 23.0) + 0.5));
        }
        if (noGapCount != -1) {
            if (noGapCurr > 0) {
                noGapPrevious = true;
            }
            if (noGapCurr < noGapCount - 1) {
                noGapMore = true;
            }
        }
        flags = athType + ((expNPsyTune ? 1 : 0) << 4) + ((safeJoint ? 1 : 0) << 5) + ((noGapMore ? 1 : 0) << 6) + ((noGapPrevious ? 1 : 0) << 7);
        if (quality < 0) {
            quality = 0;
        }
        switch (gfp.mode) {
            case MONO: {
                stereoMode = 0;
                break;
            }
            case STEREO: {
                stereoMode = 1;
                break;
            }
            case DUAL_CHANNEL: {
                stereoMode = 2;
                break;
            }
            case JOINT_STEREO: {
                if (gfp.force_ms) {
                    stereoMode = 4;
                    break;
                }
                stereoMode = 3;
                break;
            }
            default: {
                stereoMode = 7;
            }
        }
        sourceFreq = gfp.in_samplerate <= 32000 ? 0 : (gfp.in_samplerate == 48000 ? 2 : (gfp.in_samplerate > 48000 ? 3 : 1));
        if (gfp.short_blocks == ShortBlock.short_block_forced || gfp.short_blocks == ShortBlock.short_block_dispensed || gfp.lowpassfreq == -1 && gfp.highpassfreq == -1 || gfp.scale_left < gfp.scale_right || gfp.scale_left > gfp.scale_right || gfp.disable_reservoir && gfp.brate < 320 || gfp.noATH || gfp.ATHonly || athType == 0 || gfp.in_samplerate <= 32000) {
            nonOptimal = 1;
        }
        misc = noiseShaping + (stereoMode << 2) + (nonOptimal << 5) + (sourceFreq << 6);
        musicCRC = gfc.nMusicCRC;
        this.createInteger(streamBuffer, streamBufferPos + bytesWritten, quality);
        bytesWritten += 4;
        for (int j = 0; j < 9; ++j) {
            streamBuffer[streamBufferPos + bytesWritten + j] = (byte)version.charAt(j);
        }
        streamBuffer[streamBufferPos + (bytesWritten += 9)] = (byte)revMethod;
        streamBuffer[streamBufferPos + ++bytesWritten] = (byte)lowpass;
        this.createInteger(streamBuffer, streamBufferPos + ++bytesWritten, peakSignalAmplitude);
        this.createShort(streamBuffer, streamBufferPos + (bytesWritten += 4), radioReplayGain);
        this.createShort(streamBuffer, streamBufferPos + (bytesWritten += 2), audiophileReplayGain);
        streamBuffer[streamBufferPos + (bytesWritten += 2)] = (byte)flags;
        streamBuffer[streamBufferPos + ++bytesWritten] = abrBitrate >= 255 ? -1 : (byte)abrBitrate;
        streamBuffer[streamBufferPos + ++bytesWritten] = (byte)(encDelay >> 4);
        streamBuffer[streamBufferPos + bytesWritten + 1] = (byte)((encDelay << 4) + (encPadding >> 8));
        streamBuffer[streamBufferPos + bytesWritten + 2] = (byte)encPadding;
        streamBuffer[streamBufferPos + (bytesWritten += 3)] = (byte)misc;
        int n = ++bytesWritten;
        streamBuffer[streamBufferPos + n] = 0;
        this.createShort(streamBuffer, streamBufferPos + ++bytesWritten, gfp.preset);
        this.createInteger(streamBuffer, streamBufferPos + (bytesWritten += 2), musicLength);
        this.createShort(streamBuffer, streamBufferPos + (bytesWritten += 4), musicCRC);
        bytesWritten += 2;
        for (int i = 0; i < bytesWritten; ++i) {
            crc = this.crcUpdateLookup(streamBuffer[streamBufferPos + i], crc);
        }
        this.createShort(streamBuffer, streamBufferPos + bytesWritten, crc);
        return bytesWritten += 2;
    }

    private int skipId3v2(RandomAccessFile fpStream) throws IOException {
        fpStream.seek(0L);
        byte[] id3v2Header = new byte[10];
        fpStream.readFully(id3v2Header);
        int id3v2TagSize = !new String(id3v2Header, "ISO-8859-1").startsWith("ID3") ? ((id3v2Header[6] & 0x7F) << 21 | (id3v2Header[7] & 0x7F) << 14 | (id3v2Header[8] & 0x7F) << 7 | id3v2Header[9] & 0x7F) + id3v2Header.length : 0;
        return id3v2TagSize;
    }

    public final int getLameTagFrame(LameGlobalFlags gfp, byte[] buffer) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (!gfp.bWriteVbrTag) {
            return 0;
        }
        if (gfc.Class_ID != -487877L) {
            return 0;
        }
        if (gfc.VBR_seek_table.pos <= 0) {
            return 0;
        }
        if (buffer.length < gfc.VBR_seek_table.TotalFrameSize) {
            return gfc.VBR_seek_table.TotalFrameSize;
        }
        Arrays.fill(buffer, 0, gfc.VBR_seek_table.TotalFrameSize, (byte)0);
        this.setLameTagFrameHeader(gfp, buffer);
        byte[] toc = new byte[100];
        if (gfp.free_format) {
            for (int i = 1; i < 100; ++i) {
                toc[i] = (byte)(255 * i / 100);
            }
        } else {
            this.xingSeekTable(gfc.VBR_seek_table, toc);
        }
        int streamIndex = gfc.sideinfo_len;
        if (gfp.error_protection) {
            streamIndex -= 2;
        }
        if (gfp.VBR == VbrMode.vbr_off) {
            buffer[streamIndex++] = (byte)VBRTag1.charAt(0);
            buffer[streamIndex++] = (byte)VBRTag1.charAt(1);
            buffer[streamIndex++] = (byte)VBRTag1.charAt(2);
            buffer[streamIndex++] = (byte)VBRTag1.charAt(3);
        } else {
            buffer[streamIndex++] = (byte)VBRTag0.charAt(0);
            buffer[streamIndex++] = (byte)VBRTag0.charAt(1);
            buffer[streamIndex++] = (byte)VBRTag0.charAt(2);
            buffer[streamIndex++] = (byte)VBRTag0.charAt(3);
        }
        this.createInteger(buffer, streamIndex, 15);
        this.createInteger(buffer, streamIndex += 4, gfc.VBR_seek_table.nVbrNumFrames);
        int streamSize = gfc.VBR_seek_table.nBytesWritten + gfc.VBR_seek_table.TotalFrameSize;
        this.createInteger(buffer, streamIndex += 4, streamSize);
        System.arraycopy(toc, 0, buffer, streamIndex += 4, toc.length);
        streamIndex += toc.length;
        if (gfp.error_protection) {
            this.bs.CRC_writeheader(gfc, buffer);
        }
        int crc = 0;
        for (int i = 0; i < streamIndex; ++i) {
            crc = this.crcUpdateLookup(buffer[i], crc);
        }
        streamIndex += this.putLameVBR(gfp, streamSize, buffer, streamIndex, crc);
        return gfc.VBR_seek_table.TotalFrameSize;
    }

    public final int putVbrTag(LameGlobalFlags gfp, RandomAccessFile stream) throws IOException {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc.VBR_seek_table.pos <= 0) {
            return -1;
        }
        stream.seek(stream.length());
        if (stream.length() == 0L) {
            return -1;
        }
        int id3v2TagSize = this.skipId3v2(stream);
        stream.seek(id3v2TagSize);
        byte[] buffer = new byte[2880];
        int bytes = this.getLameTagFrame(gfp, buffer);
        if (bytes > buffer.length) {
            return -1;
        }
        if (bytes < 1) {
            return 0;
        }
        stream.write(buffer, 0, bytes);
        return 0;
    }
}

