/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.log;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2q!\u0002\u0004\u0011\u0002\u0007\u0005Q\u0002C\u0003\u0015\u0001\u0011\u0005Q\u0003C\u0004\u001a\u0001\t\u0007K\u0011\u0002\u000e\t\u000f\r\u0002!\u0019)C\u0005I!)1\u0006\u0001C\u000bY\tqAj\\4hKJ\u0004F.\u0019;g_Jl'BA\u0004\t\u0003\rawn\u001a\u0006\u0003\u0013)\tQa]2jgNT\u0011aC\u0001\u0003I\u0016\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\f\u0011\u0005=9\u0012B\u0001\r\u0011\u0005\u0011)f.\u001b;\u0002\u000b\rdwnY6\u0016\u0003m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\tQLW.\u001a\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SDA\u0003DY>\u001c7.A\u0003sk2,7/F\u0001&!\t1\u0013&D\u0001(\u0015\tAS$\u0001\u0003{_:,\u0017B\u0001\u0016(\u0005%QvN\\3Sk2,7/A\u0006nWRKW.Z*uC6\u0004H#A\u0017\u0011\u00059*dBA\u00184!\t\u0001\u0004#D\u00012\u0015\t\u0011D\"\u0001\u0004=e>|GOP\u0005\u0003iA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A\u0007\u0005")
public interface LoggerPlatform {
    public void de$sciss$log$LoggerPlatform$_setter_$de$sciss$log$LoggerPlatform$$clock_$eq(Clock var1);

    public void de$sciss$log$LoggerPlatform$_setter_$de$sciss$log$LoggerPlatform$$rules_$eq(ZoneRules var1);

    public Clock de$sciss$log$LoggerPlatform$$clock();

    public ZoneRules de$sciss$log$LoggerPlatform$$rules();

    public static /* synthetic */ String mkTimeStamp$(LoggerPlatform $this) {
        return $this.mkTimeStamp();
    }

    default public String mkTimeStamp() {
        Instant instant = this.de$sciss$log$LoggerPlatform$$clock().instant();
        ZoneOffset offset = this.de$sciss$log$LoggerPlatform$$rules().getOffset(instant);
        long localSecond = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        int SECONDS_PER_DAY = 86400;
        long NANOS_PER_SECOND = 1000000000L;
        long NANOS_PER_MINUTE = 60000000000L;
        long NANOS_PER_HOUR = 3600000000000L;
        long localEpochDay = Math.floorDiv(localSecond, (long)SECONDS_PER_DAY);
        long secsOfDay = Math.floorMod(localSecond, (long)SECONDS_PER_DAY);
        LocalDate ld = LocalDate.ofEpochDay(localEpochDay);
        long nanoOfDay = secsOfDay * NANOS_PER_SECOND + (long)instant.getNano();
        int hour = (int)(nanoOfDay / NANOS_PER_HOUR);
        int minute = (int)((nanoOfDay -= (long)hour * NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int second = (int)((nanoOfDay -= (long)minute * NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        int nano = (int)(nanoOfDay -= (long)second * NANOS_PER_SECOND);
        StringBuilder sb = new StringBuilder(26);
        sb.append(ld.toString()).append(' ');
        sb.append(hour < 10 ? "0" : "").append(hour).append(minute < 10 ? ":0" : ":").append(minute).append(second < 10 ? ":0" : ":").append(second).append('.').append(Integer.toString(nano / 1000000 + 1000).substring(1));
        return sb.toString();
    }

    public static void $init$(LoggerPlatform $this) {
        $this.de$sciss$log$LoggerPlatform$_setter_$de$sciss$log$LoggerPlatform$$clock_$eq(Clock.systemDefaultZone());
        $this.de$sciss$log$LoggerPlatform$_setter_$de$sciss$log$LoggerPlatform$$rules_$eq($this.de$sciss$log$LoggerPlatform$$clock().getZone().getRules());
    }
}

