/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.swing.graph;

import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.SampleFormat$Double$;
import de.sciss.audiofile.SampleFormat$Float$;
import de.sciss.audiofile.SampleFormat$UInt8$;
import de.sciss.audiowidgets.AxisFormat;
import de.sciss.lucre.expr.ExElem;
import de.sciss.lucre.swing.graph.AudioFileIn;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class AudioFileIn$
implements ExElem.ProductReader<AudioFileIn> {
    public static final AudioFileIn$ MODULE$ = new AudioFileIn$();
    private static AxisFormat.Time timeFmt;
    private static final String keyPathFieldVisible;
    private static final String keyFormatVisible;
    private static final String defaultTitle;
    private static final boolean defaultPathFieldVisible;
    private static final boolean defaultFormatVisible;
    private static volatile boolean bitmap$0;

    static {
        keyPathFieldVisible = "pathFieldVisible";
        keyFormatVisible = "formatVisible";
        defaultTitle = "Select Audio Input File";
        defaultPathFieldVisible = true;
        defaultFormatVisible = true;
    }

    public AudioFileIn apply() {
        return new AudioFileIn.Impl();
    }

    @Override
    public AudioFileIn read(ExElem.RefMapIn in, String key, int arity, int adj) {
        Predef$.MODULE$.require(arity == 0 && adj == 0);
        return this.apply();
    }

    private AxisFormat.Time timeFmt$lzycompute() {
        AudioFileIn$ audioFileIn$ = this;
        synchronized (audioFileIn$) {
            if (!bitmap$0) {
                timeFmt = new AxisFormat.Time(false, true);
                bitmap$0 = true;
            }
        }
        return timeFmt;
    }

    private AxisFormat.Time timeFmt() {
        if (!bitmap$0) {
            return this.timeFmt$lzycompute();
        }
        return timeFmt;
    }

    public String specToString(AudioFileSpec spec) {
        String string;
        String smpFmt = this.formatToString(spec.sampleFormat());
        int n = spec.numChannels();
        switch (n) {
            case 1: {
                string = "mono";
                break;
            }
            case 2: {
                string = "stereo";
                break;
            }
            default: {
                string = new StringBuilder(6).append(n).append("-chan.").toString();
                break;
            }
        }
        String channels = string;
        String sr = StringOps$.MODULE$.format$extension("%1.1f", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(spec.sampleRate() / (double)1000)}));
        String dur = this.timeFmt().format((double)spec.numFrames() / spec.sampleRate(), this.timeFmt().format$default$2(), this.timeFmt().format$default$3());
        String txt = new StringBuilder(10).append(spec.fileType().name()).append(", ").append(channels).append(" ").append(smpFmt).append(" ").append(sr).append(" kHz, ").append(dur).toString();
        return txt;
    }

    public String formatToString(SampleFormat smp) {
        SampleFormat sampleFormat = smp;
        String smpTpe = (SampleFormat$Float$.MODULE$.equals(sampleFormat) ? true : SampleFormat$Double$.MODULE$.equals(sampleFormat)) ? "float" : (SampleFormat$UInt8$.MODULE$.equals(sampleFormat) ? "uint" : "int");
        String txt = new StringBuilder(5).append(smp.bitsPerSample()).append("-bit ").append(smpTpe).toString();
        return txt;
    }

    public String keyPathFieldVisible() {
        return keyPathFieldVisible;
    }

    public String keyFormatVisible() {
        return keyFormatVisible;
    }

    public String defaultTitle() {
        return defaultTitle;
    }

    public boolean defaultPathFieldVisible() {
        return defaultPathFieldVisible;
    }

    public boolean defaultFormatVisible() {
        return defaultFormatVisible;
    }

    private AudioFileIn$() {
    }
}

