/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ChangedRequestBody;
import org.openapitools.openapidiff.core.model.ChangedSecurityRequirements;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedOperation
implements ComposedChanged {
    private Operation oldOperation;
    private Operation newOperation;
    private String pathUrl;
    private PathItem.HttpMethod httpMethod;
    private ChangedMetadata summary;
    private ChangedMetadata description;
    private ChangedMetadata operationId;
    private boolean deprecated;
    private ChangedParameters parameters;
    private ChangedRequestBody requestBody;
    private ChangedApiResponse apiResponses;
    private ChangedSecurityRequirements securityRequirements;
    private ChangedExtensions extensions;

    public ChangedOperation(String pathUrl, PathItem.HttpMethod httpMethod, Operation oldOperation, Operation newOperation) {
        this.httpMethod = httpMethod;
        this.pathUrl = pathUrl;
        this.oldOperation = oldOperation;
        this.newOperation = newOperation;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.summary, this.description, this.operationId, this.parameters, this.requestBody, this.apiResponses, this.securityRequirements, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.deprecated) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.NO_CHANGES;
    }

    public DiffResult resultApiResponses() {
        return Changed.result(this.apiResponses);
    }

    public DiffResult resultRequestBody() {
        return this.requestBody == null ? DiffResult.NO_CHANGES : this.requestBody.isChanged();
    }

    public Operation getOldOperation() {
        return this.oldOperation;
    }

    public Operation getNewOperation() {
        return this.newOperation;
    }

    public String getPathUrl() {
        return this.pathUrl;
    }

    public PathItem.HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public ChangedMetadata getSummary() {
        return this.summary;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedMetadata getOperationId() {
        return this.operationId;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public ChangedParameters getParameters() {
        return this.parameters;
    }

    public ChangedRequestBody getRequestBody() {
        return this.requestBody;
    }

    public ChangedApiResponse getApiResponses() {
        return this.apiResponses;
    }

    public ChangedSecurityRequirements getSecurityRequirements() {
        return this.securityRequirements;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedOperation setOldOperation(Operation oldOperation) {
        this.oldOperation = oldOperation;
        return this;
    }

    public ChangedOperation setNewOperation(Operation newOperation) {
        this.newOperation = newOperation;
        return this;
    }

    public ChangedOperation setPathUrl(String pathUrl) {
        this.pathUrl = pathUrl;
        return this;
    }

    public ChangedOperation setHttpMethod(PathItem.HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public ChangedOperation setSummary(ChangedMetadata summary) {
        this.summary = summary;
        return this;
    }

    public ChangedOperation setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedOperation setOperationId(ChangedMetadata operationId) {
        this.operationId = operationId;
        return this;
    }

    public ChangedOperation setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ChangedOperation setParameters(ChangedParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public ChangedOperation setRequestBody(ChangedRequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public ChangedOperation setApiResponses(ChangedApiResponse apiResponses) {
        this.apiResponses = apiResponses;
        return this;
    }

    public ChangedOperation setSecurityRequirements(ChangedSecurityRequirements securityRequirements) {
        this.securityRequirements = securityRequirements;
        return this;
    }

    public ChangedOperation setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedOperation that = (ChangedOperation)o;
        return this.deprecated == that.deprecated && Objects.equals(this.oldOperation, that.oldOperation) && Objects.equals(this.newOperation, that.newOperation) && Objects.equals(this.pathUrl, that.pathUrl) && this.httpMethod == that.httpMethod && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.operationId, that.operationId) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.requestBody, that.requestBody) && Objects.equals(this.apiResponses, that.apiResponses) && Objects.equals(this.securityRequirements, that.securityRequirements) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldOperation, this.newOperation, this.pathUrl, this.httpMethod, this.summary, this.description, this.operationId, this.deprecated, this.parameters, this.requestBody, this.apiResponses, this.securityRequirements, this.extensions});
    }

    public String toString() {
        return "ChangedOperation(oldOperation=" + this.getOldOperation() + ", newOperation=" + this.getNewOperation() + ", pathUrl=" + this.getPathUrl() + ", httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", summary=" + this.getSummary() + ", description=" + this.getDescription() + ", operationId=" + this.getOperationId() + ", deprecated=" + this.isDeprecated() + ", parameters=" + this.getParameters() + ", requestBody=" + this.getRequestBody() + ", apiResponses=" + this.getApiResponses() + ", securityRequirements=" + this.getSecurityRequirements() + ", extensions=" + this.getExtensions() + ")";
    }
}

