/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BottomType;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClassFileReader;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.Error;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.NullType;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RecordTypeDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.util.ContractUtils;

public final class BuiltinTypes {
    public static final TypeDefinition Boolean = new PrimitiveType(JvmType.Boolean);
    public static final TypeDefinition Byte = new PrimitiveType(JvmType.Byte);
    public static final TypeDefinition Character = new PrimitiveType(JvmType.Character);
    public static final TypeDefinition Short = new PrimitiveType(JvmType.Short);
    public static final TypeDefinition Integer = new PrimitiveType(JvmType.Integer);
    public static final TypeDefinition Long = new PrimitiveType(JvmType.Long);
    public static final TypeDefinition Float = new PrimitiveType(JvmType.Float);
    public static final TypeDefinition Double = new PrimitiveType(JvmType.Double);
    public static final TypeDefinition Void = new PrimitiveType(JvmType.Void);
    public static final TypeDefinition Object;
    public static final TypeDefinition Bottom;
    public static final TypeDefinition Null;
    public static final TypeDefinition Class;
    public static final TypeDefinition Record;

    public static TypeDefinition fromPrimitiveTypeCode(int code) {
        switch (code) {
            case 4: {
                return Boolean;
            }
            case 8: {
                return Byte;
            }
            case 9: {
                return Short;
            }
            case 10: {
                return Integer;
            }
            case 11: {
                return Long;
            }
            case 5: {
                return Character;
            }
            case 6: {
                return Float;
            }
            case 7: {
                return Double;
            }
        }
        throw ContractUtils.unreachable();
    }

    static {
        Bottom = BottomType.INSTANCE;
        Null = NullType.INSTANCE;
        ClasspathTypeLoader typeLoader = new ClasspathTypeLoader();
        Buffer buffer = new Buffer();
        if (!typeLoader.tryLoadType("java/lang/Object", buffer)) {
            throw Error.couldNotLoadObjectType();
        }
        MetadataSystem metadataSystem = MetadataSystem.instance();
        Bottom.setResolver(metadataSystem);
        Null.setResolver(metadataSystem);
        Object = ClassFileReader.readClass(metadataSystem, buffer);
        buffer.reset();
        if (!typeLoader.tryLoadType("java/lang/Class", buffer)) {
            throw Error.couldNotLoadClassType();
        }
        Class = ClassFileReader.readClass(metadataSystem, buffer);
        buffer.reset();
        Record = typeLoader.tryLoadType("java/lang/Record", buffer) ? ClassFileReader.readClass(metadataSystem, buffer) : RecordTypeDefinition.INSTANCE;
    }
}

