/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.protege.editor.owl.ui.renderer.styledstring.BackgroundAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.FontWeightAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.ForegroundAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.StrikeThrough;
import org.protege.editor.owl.ui.renderer.styledstring.StrikeThroughAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;

public class Style {
    public static final Style STRIKE_THROUGH_STYLE = new Style(StrikeThroughAttribute.get(StrikeThrough.SINGLE));
    public static final Style BOLD_STYLE = new Style(FontWeightAttribute.getBoldFontWeight());
    private List<StyleAttribute> styleAttributes = new ArrayList<StyleAttribute>(1);

    public Style(List<StyleAttribute> styleAttributes) {
        this.styleAttributes.addAll(styleAttributes);
    }

    public Style(StyleAttribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public Style(Color foreground) {
        this(ForegroundAttribute.get(foreground));
    }

    public static Style getForeground(Color foreground) {
        return new Style(ForegroundAttribute.get(foreground));
    }

    public static Style getBoldForeground(Color foreground) {
        return new Style(FontWeightAttribute.getBoldFontWeight(), ForegroundAttribute.get(foreground));
    }

    public static Style getBackground(Color background) {
        return new Style(BackgroundAttribute.get(background));
    }

    public static Style getBoldBackground(Color background) {
        return new Style(FontWeightAttribute.getBoldFontWeight(), BackgroundAttribute.get(background));
    }

    public static Style getBold() {
        return BOLD_STYLE;
    }

    public static Style getStrikeThrough() {
        return STRIKE_THROUGH_STYLE;
    }

    public List<StyleAttribute> getStyleAttributes() {
        return Collections.unmodifiableList(this.styleAttributes);
    }

    public Style append(Style style) {
        int size = this.styleAttributes.size() + style.styleAttributes.size();
        ArrayList<StyleAttribute> allAttributes = new ArrayList<StyleAttribute>(size);
        allAttributes.addAll(this.styleAttributes);
        allAttributes.addAll(style.styleAttributes);
        return new Style(allAttributes);
    }

    public int hashCode() {
        return Style.class.getSimpleName().hashCode() + this.styleAttributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Style)) {
            return false;
        }
        Style other = (Style)obj;
        return this.styleAttributes.equals(other.styleAttributes);
    }
}

