/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class IvyNode
implements Comparable {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map dds = new HashMap();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection confsToFetch = new HashSet();
    private Collection fetchedConfigurations = new HashSet();
    private Collection loadedRootModuleConfs = new HashSet();
    private IvyNodeUsage usage = new IvyNodeUsage(this);
    private Map mergedUsages = new LinkedHashMap();

    public IvyNode(ResolveData resolveData, IvyNode ivyNode, DependencyDescriptor dependencyDescriptor) {
        this.id = dependencyDescriptor.getDependencyRevisionId();
        this.dds.put(ivyNode, dependencyDescriptor);
        this.root = ivyNode.getRoot();
        this.init(resolveData);
    }

    public IvyNode(ResolveData resolveData, ModuleDescriptor moduleDescriptor) {
        this.id = moduleDescriptor.getModuleRevisionId();
        this.md = moduleDescriptor;
        this.root = this;
        this.init(resolveData);
    }

    private void init(ResolveData resolveData) {
        this.data = resolveData;
        this.settings = resolveData.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public boolean loadData(String string, IvyNode ivyNode, String string2, String string3, boolean bl, IvyNodeUsage ivyNodeUsage) {
        Object object;
        Message.debug("loadData of " + this.toString() + " of rootConf=" + string);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean bl2 = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(string)) {
            Message.debug(string + " is evicted.  Skip loading");
        } else if (!this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded(string)) {
            Message.debug(string + " is loaded and no conf to load.  Skip loading");
        } else {
            this.markRootModuleConfLoaded(string);
            if (this.md == null) {
                object = this.data.getSettings().getResolver(this.getId());
                if (object == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this.problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    return false;
                }
                try {
                    Message.debug("\tusing " + object + " to resolve " + this.getId());
                    Object object2 = this.getDependencyDescriptor(ivyNode);
                    long l = System.currentTimeMillis();
                    ModuleRevisionId moduleRevisionId = object2.getDependencyRevisionId();
                    this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent((DependencyResolver)object, (DependencyDescriptor)object2, moduleRevisionId));
                    this.module = object.getDependency((DependencyDescriptor)object2, this.data);
                    this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent((DependencyResolver)object, (DependencyDescriptor)object2, moduleRevisionId, this.module, System.currentTimeMillis() - l));
                    if (this.module != null) {
                        this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                        if (this.settings.logModuleWhenFound() && "default".equals(this.getData().getOptions().getLog())) {
                            Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        }
                        if (this.settings.getVersionMatcher().isDynamic(this.getId()) && this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                            Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and make sure revision is part of your pattern");
                            this.problem = new RuntimeException("impossible to resolve dynamic revision");
                            return false;
                        }
                        if (!this.getId().equals(this.module.getId())) {
                            object2 = this.data.getNode(this.module.getId());
                            if (object2 != null) {
                                this.md = this.module.getDescriptor();
                                if (!this.handleConfiguration(false, string, ivyNode, string2, string3, bl, ivyNodeUsage)) {
                                    return false;
                                }
                                this.moveToRealNode(string, ivyNode, string2, string3, bl, (IvyNode)object2);
                                return true;
                            }
                            object2 = "\t[" + this.module.getId().getRevision() + "] " + this.getId();
                            if (!this.settings.getVersionMatcher().isDynamic(this.getId())) {
                                object2 = (String)object2 + " (forced)";
                            }
                            if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
                                Message.info((String)object2);
                            } else {
                                Message.verbose((String)object2);
                            }
                        }
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        object.reportFailure();
                        this.problem = new RuntimeException("not found");
                        return false;
                    }
                    this.downloaded = this.module.getReport().isDownloaded();
                    this.searched = this.module.getReport().isSearched();
                    bl2 = true;
                    this.md = this.module.getDescriptor();
                    this.confsToFetch.remove("*");
                    IvyNode ivyNode2 = this;
                    ivyNode2.updateConfsToFetch(Arrays.asList(ivyNode2.resolveSpecialConfigurations(this.getRequiredConfigurations(ivyNode, string2))));
                }
                catch (ResolveProcessException resolveProcessException) {
                    ResolveProcessException resolveProcessException2 = resolveProcessException;
                    throw resolveProcessException;
                }
                catch (Exception exception) {
                    this.problem = exception;
                    return false;
                }
            } else {
                bl2 = true;
            }
        }
        this.handleConfiguration(bl2, string, ivyNode, string2, string3, bl, ivyNodeUsage);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        object = this.getDependencyDescriptor(ivyNode);
        if (object != null) {
            ivyNodeUsage.addUsage(string, (DependencyDescriptor)object, string2);
        }
        return bl2;
    }

    private void moveToRealNode(String string, IvyNode ivyNode, String string2, String string3, boolean bl, IvyNode ivyNode2) {
        if (ivyNode2.md == null) {
            ivyNode2.md = this.md;
        }
        if (ivyNode2.module == null) {
            ivyNode2.module = this.module;
        }
        ivyNode2.downloaded |= this.module.getReport().isDownloaded();
        ivyNode2.searched |= this.module.getReport().isSearched();
        ivyNode2.dds.putAll(this.dds);
        ivyNode2.updateDataFrom(this, string, true);
        ivyNode2.loadData(string, ivyNode, string2, string3, bl, this.usage);
        ivyNode2.usage.updateDataFrom(this.getAllUsages(), string);
        this.usage = ivyNode2.usage;
        this.data.replaceNode(this.getId(), ivyNode2, string);
        if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
            Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
            return;
        }
        Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
    }

    public Collection getDependencies(String string, String[] stringArray, String string2) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(stringArray).contains("*")) {
            stringArray = this.isRoot() ? this.md.getConfigurationsNames() : this.md.getPublicConfigurationsNames();
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(this.getDependencies(string, stringArray[i], string2));
        }
        return hashSet;
    }

    public Collection getDependencies(String string, String string2, String string3) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dependencyDescriptorArray = this.md.getDependencies();
        LinkedHashMap<ModuleRevisionId, IvyNode> linkedHashMap = new LinkedHashMap<ModuleRevisionId, IvyNode>();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            DependencyDescriptor dependencyDescriptor = this.data.mediate(dependencyDescriptorArray[i]);
            String[] stringArray = dependencyDescriptor.getDependencyConfigurations(string2, string3);
            if (stringArray.length == 0) continue;
            ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
            if (this.isDependencyModuleExcluded(dependencyDescriptor, string, moduleRevisionId, string2)) {
                Message.verbose("excluding " + dependencyDescriptor + " in " + string2);
                continue;
            }
            IvyNode ivyNode = (IvyNode)linkedHashMap.get(moduleRevisionId);
            if (ivyNode == null) {
                ivyNode = this.data.getNode(moduleRevisionId);
            }
            if (ivyNode == null) {
                ivyNode = new IvyNode(this.data, this, dependencyDescriptor);
            } else {
                ivyNode.addDependencyDescriptor(this, dependencyDescriptor);
                ivyNode.hasProblem();
            }
            String[] stringArray2 = ivyNode.resolveSpecialConfigurations(stringArray);
            List<String> list = Arrays.asList(stringArray2);
            ivyNode.updateConfsToFetch(list);
            IvyNode ivyNode2 = ivyNode;
            ivyNode2.addRootModuleConfigurations(ivyNode2.usage, string, stringArray2);
            ivyNode.usage.setRequiredConfs(this, string2, list);
            ivyNode.addCaller(string, this, string2, string3, stringArray, dependencyDescriptor);
            linkedHashMap.put(moduleRevisionId, ivyNode);
        }
        return linkedHashMap.values();
    }

    private void addDependencyDescriptor(IvyNode ivyNode, DependencyDescriptor dependencyDescriptor) {
        this.dds.put(ivyNode, dependencyDescriptor);
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode ivyNode) {
        return (DependencyDescriptor)this.dds.get(ivyNode);
    }

    private boolean isDependencyModuleExcluded(DependencyDescriptor object, String string, ModuleRevisionId extendableItem, String string2) {
        extendableItem = DefaultArtifact.newIvyArtifact(extendableItem, null);
        if (this.isRoot()) {
            IvyNode ivyNode = this;
            if ((object = ivyNode.doesExclude(ivyNode.md, string, new String[]{string}, (DependencyDescriptor)object, (Artifact)extendableItem, new Stack())) == null) {
                return false;
            }
            return (Boolean)object;
        }
        return this.callers.doesCallersExclude(string, (Artifact)extendableItem);
    }

    Boolean doesExclude(ModuleDescriptor object, String string, String[] stringArray, DependencyDescriptor dependencyDescriptor, Artifact artifact, Stack stack) {
        if (dependencyDescriptor != null && dependencyDescriptor.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        if (object.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        object = this.getData().getNode(object.getModuleRevisionId());
        if (object != null) {
            if (stack.contains(((IvyNode)object).getId())) {
                return null;
            }
            return ((IvyNode)object).doesCallersExclude(string, artifact, stack);
        }
        return Boolean.FALSE;
    }

    public boolean hasConfigurationsToLoad() {
        return !this.confsToFetch.isEmpty();
    }

    private boolean markRootModuleConfLoaded(String string) {
        return this.loadedRootModuleConfs.add(string);
    }

    private boolean isRootModuleConfLoaded(String string) {
        return this.loadedRootModuleConfs.contains(string);
    }

    private boolean handleConfiguration(boolean bl, String string, IvyNode ivyNode, String string2, String string3, boolean bl2, IvyNodeUsage ivyNodeUsage) {
        if (this.md != null) {
            String[] stringArray = this.getRealConfs(string3);
            this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                Configuration configuration = this.md.getConfiguration(stringArray[i]);
                if (configuration == null) {
                    this.confsToFetch.remove(string3);
                    if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                        Message.verbose("configuration required by evicted revision is not available in selected revision. skipping " + string3 + " in " + this);
                    } else {
                        this.problem = !string3.equals(stringArray[i]) ? new RuntimeException("configuration not found in " + this + ": '" + string3 + "'. Missing configuration: '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2) : new RuntimeException("configuration not found in " + this + ": '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2);
                    }
                    return false;
                }
                if (!bl2 || this.isRoot() || configuration.getVisibility() == Configuration.Visibility.PUBLIC) continue;
                this.confsToFetch.remove(string3);
                if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                    Message.verbose("configuration required by evicted revision is not visible in selected revision. skipping " + string3 + " in " + this);
                } else {
                    this.problem = new RuntimeException("configuration not public in " + this + ": '" + configuration + "'. It was required from " + ivyNode + " " + string2);
                }
                return false;
            }
            if (bl) {
                this.fetchedConfigurations.add(string3);
                this.confsToFetch.removeAll(Arrays.asList(stringArray));
                this.confsToFetch.remove(string3);
            }
        }
        return true;
    }

    private String getDefaultConf(String string) {
        Matcher matcher = FALLBACK_CONF_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }

    private String getMainConf(String object) {
        if (((Matcher)(object = FALLBACK_CONF_PATTERN.matcher((CharSequence)object))).matches()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    public void updateConfsToFetch(Collection collection) {
        this.confsToFetch.addAll(collection);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] object) {
        if (((String[])object).length == 1 && object[0].startsWith("*") && this.isLoaded()) {
            if ("*".equals(object = object[0])) {
                return this.getDescriptor().getPublicConfigurationsNames();
            }
            object = Arrays.asList(((String)object).substring(2).split("\\!"));
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getDescriptor().getPublicConfigurationsNames()));
            arrayList.removeAll((Collection<?>)object);
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2.toArray(new String[arrayList2.size()]);
        }
        return object;
    }

    public String[] getRequiredConfigurations(IvyNode ivyNode, String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getRequiredConfigurations(ivyNode, string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRequiredConfigurations(ivyNode, string));
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new String[linkedHashSet2.size()]);
    }

    private void addAllIfNotNull(Collection collection, Collection collection2) {
        if (collection2 != null) {
            collection.addAll(collection2);
        }
    }

    public Configuration getConfiguration(String object) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String string = this.getDefaultConf((String)object);
        object = this.getMainConf((String)object);
        if ((object = this.md.getConfiguration((String)object)) == null) {
            object = this.md.getConfiguration(string);
        }
        return object;
    }

    public String[] getConfigurations(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getConfigurations(string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getConfigurations(string));
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new String[linkedHashSet2.size()]);
    }

    protected boolean isConfRequiredByMergedUsageOnly(String object, String string) {
        return (object = this.usage.getConfigurations((String)object)) == null || !object.contains(string);
    }

    private void addRootModuleConfigurations(IvyNodeUsage ivyNodeUsage, String string, String[] stringArray) {
        Set set = ivyNodeUsage.addAndGetConfigurations(string);
        if (this.md != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
                String[] stringArray2 = this.md.getConfiguration(stringArray[i]);
                if (stringArray2 == null) continue;
                stringArray2 = stringArray2.getExtends();
                this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray2);
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            set.add(stringArray[i]);
        }
    }

    public String[] getRootModuleConfigurations() {
        Set set = this.getRootModuleConfigurationsSet();
        return set.toArray(new String[set.size()]);
    }

    public Set getRootModuleConfigurationsSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getRootModuleConfigurations());
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRootModuleConfigurations());
        }
        return linkedHashSet;
    }

    public String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public String[] getRealConfs(String string) {
        if (this.md == null) {
            return new String[]{string};
        }
        String[] stringArray = this.getDefaultConf(string);
        if (this.md.getConfiguration(string = this.getMainConf(string)) == null || Configuration.Visibility.PRIVATE.equals(this.md.getConfiguration(string).getVisibility())) {
            if ("".equals(stringArray)) {
                return new String[0];
            }
            string = stringArray;
        }
        if (string.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{string});
        }
        if (string.indexOf(44) != -1) {
            stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return new String[]{string};
    }

    private Collection findPath(ModuleId moduleId) {
        return this.findPath(moduleId, this, new LinkedList());
    }

    private Collection findPath(ModuleId moduleId, IvyNode ivyNode, List list) {
        while (true) {
            if ((ivyNode = ivyNode.getDirectCallerFor(moduleId)) == null) {
                throw new IllegalArgumentException("no path from " + moduleId + " to " + this.getId() + " found");
            }
            if (list.contains(ivyNode)) {
                list.add(0, ivyNode);
                List list2 = list;
                Message.verbose("circular dependency found while looking for the path for another one: was looking for " + moduleId + " as a caller of " + list2.get(list2.size() - 1));
                return list;
            }
            list.add(0, ivyNode);
            if (!ivyNode.getId().getModuleId().equals(moduleId)) continue;
            return list;
        }
    }

    private void updateDataFrom(IvyNode ivyNode, String string, boolean bl) {
        this.callers.updateFrom(ivyNode.callers, string, bl);
        if (bl) {
            this.usage.updateDataFrom(ivyNode.getAllUsages(), string);
        } else {
            IvyNodeUsage ivyNodeUsage = (IvyNodeUsage)this.mergedUsages.get(ivyNode.getId());
            if (ivyNodeUsage == null) {
                ivyNodeUsage = new IvyNodeUsage(ivyNode);
                this.mergedUsages.put(ivyNode.getId(), ivyNodeUsage);
            }
            ivyNodeUsage.updateDataFrom(ivyNode.getAllUsages(), string);
        }
        this.updateConfsToFetch(ivyNode.fetchedConfigurations);
        this.updateConfsToFetch(ivyNode.confsToFetch);
    }

    private Collection getAllUsages() {
        ArrayList<IvyNodeUsage> arrayList = new ArrayList<IvyNodeUsage>();
        arrayList.add(this.usage);
        arrayList.addAll(this.mergedUsages.values());
        return arrayList;
    }

    public Artifact[] getSelectedArtifacts(Filter filter) {
        Collection<Artifact> collection = new HashSet();
        for (String string : this.getRootModuleConfigurationsSet()) {
            if (this.isEvicted(string) || this.isBlacklisted(string)) continue;
            collection.addAll(Arrays.asList(this.getArtifacts(string)));
        }
        collection = FilterHelper.filter(collection, filter);
        return collection.toArray(new Artifact[collection.size()]);
    }

    public Artifact[] getArtifacts(String string) {
        Object object;
        String[] stringArray = this.getConfigurations(string);
        if (stringArray == null || stringArray.length == 0) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artifacts when data has not been loaded. IvyNode = " + this.toString());
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        Set set = this.usage.getDependencyArtifactsSet(string);
        if (this.md.isDefault() && set != null && !set.isEmpty()) {
            this.addArtifactsFromOwnUsage(hashSet, set);
            this.addArtifactsFromMergedUsage(string, hashSet);
        } else {
            object = new LinkedHashSet();
            this.addAllIfNotNull((Collection)object, this.usage.getDependencyIncludesSet(string));
            for (Object object2 : this.mergedUsages.values()) {
                this.addAllIfNotNull((Collection)object, ((IvyNodeUsage)object2).getDependencyIncludesSet(string));
            }
            if ((set == null || set.isEmpty()) && object.isEmpty()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.addAll(Arrays.asList(this.md.getArtifacts(stringArray[i])));
                }
            } else {
                Object object3;
                Object object2;
                HashMap hashMap = new HashMap();
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = this.md.getArtifacts(stringArray[i]);
                    for (int j = 0; j < ((Artifact[])object3).length; ++j) {
                        hashMap.put(object3[j].getId().getArtifactId(), object3[j]);
                    }
                }
                if (set != null) {
                    this.addArtifactsFromOwnUsage(hashSet, set);
                }
                this.addArtifactsFromMergedUsage(string, hashSet);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    object3 = (IncludeRule)object2.next();
                    Collection collection = IvyNode.findArtifactsMatching((IncludeRule)object3, hashMap);
                    if (collection.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + object3.getId());
                        object2.remove();
                        continue;
                    }
                    Message.debug(this + " in " + string + ": including " + collection);
                    hashSet.addAll(collection);
                }
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Artifact artifact = (Artifact)object.next();
            boolean bl = this.callers.doesCallersExclude(string, artifact);
            if (!bl) continue;
            Message.debug(this + " in " + string + ": excluding " + artifact);
            object.remove();
        }
        HashSet<Artifact> hashSet2 = hashSet;
        return hashSet2.toArray(new Artifact[hashSet2.size()]);
    }

    private void addArtifactsFromOwnUsage(Set set, Set object) {
        object = object.iterator();
        while (object.hasNext()) {
            DependencyArtifactDescriptor dependencyArtifactDescriptor = (DependencyArtifactDescriptor)object.next();
            set.add(new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), dependencyArtifactDescriptor.getQualifiedExtraAttributes()));
        }
    }

    private void addArtifactsFromMergedUsage(String string, Set set) {
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            Object object = ivyNodeUsage.getDependencyArtifactsSet(string);
            if (object == null) continue;
            object = object.iterator();
            while (object.hasNext()) {
                DependencyArtifactDescriptor dependencyArtifactDescriptor = (DependencyArtifactDescriptor)object.next();
                HashMap<String, String> hashMap = new HashMap<String, String>(dependencyArtifactDescriptor.getQualifiedExtraAttributes());
                MDArtifact mDArtifact = new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), hashMap);
                if (set.contains(mDArtifact)) continue;
                hashMap.put("ivy:merged", dependencyArtifactDescriptor.getDependencyDescriptor().getParentRevisionId() + " -> " + ivyNodeUsage.getNode().getId());
                set.add(mDArtifact);
            }
        }
    }

    private static Collection findArtifactsMatching(IncludeRule includeRule, Map map) {
        ArrayList arrayList = new ArrayList();
        for (ArtifactId artifactId : map.keySet()) {
            if (!MatcherHelper.matches(includeRule.getMatcher(), includeRule.getId(), artifactId)) continue;
            arrayList.add(map.get(artifactId));
        }
        return arrayList;
    }

    public boolean hasProblem() {
        return this.problem != null;
    }

    public Exception getProblem() {
        return this.problem;
    }

    public String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public boolean isLoaded() {
        return this.md != null;
    }

    public IvyNode findNode(ModuleRevisionId moduleRevisionId) {
        return this.data.getNode(moduleRevisionId);
    }

    boolean isRoot() {
        return this.root == this;
    }

    public IvyNode getRoot() {
        return this.root;
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this.toString());
        }
        ConflictManager conflictManager = this.md.getConflictManager(moduleId);
        if (conflictManager == null) {
            return this.settings.getConflictManager(moduleId);
        }
        return conflictManager;
    }

    public IvyNode getRealNode() {
        IvyNode ivyNode = this.data.getNode(this.getId());
        if (ivyNode != null) {
            return ivyNode;
        }
        return this;
    }

    public ModuleRevisionId getId() {
        return this.id;
    }

    public ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public ResolveData getData() {
        return this.data;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.getId();
    }

    public void clean() {
        this.confsToFetch.clear();
    }

    boolean canExclude(String callerArray) {
        callerArray = this.getCallers((String)callerArray);
        for (int i = 0; i < callerArray.length; ++i) {
            if (!callerArray[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    private IvyNode getDirectCallerFor(ModuleId moduleId) {
        return this.callers.getDirectCallerFor(moduleId);
    }

    public IvyNodeCallers.Caller[] getCallers(String string) {
        return this.callers.getCallers(string);
    }

    public Collection getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public IvyNodeCallers.Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    public void addCaller(String string, IvyNode ivyNode, String string2, String string3, String[] stringArray, DependencyDescriptor dependencyDescriptor) {
        this.callers.addCaller(string, ivyNode, string2, string3, stringArray, dependencyDescriptor);
        boolean bl = this.callers.getAllCallersModuleIds().contains(this.getId().getModuleId());
        if (bl) {
            IvyNode ivyNode2 = this;
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(ivyNode2.toMrids(ivyNode2.findPath(this.getId().getModuleId()), this));
        }
    }

    public boolean doesCallersExclude(String string, Artifact artifact, Stack stack) {
        return this.callers.doesCallersExclude(string, artifact, stack);
    }

    private ModuleRevisionId[] toMrids(Collection object, IvyNode ivyNode) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[object.size() + 1];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            IvyNode ivyNode2 = (IvyNode)object.next();
            moduleRevisionIdArray[n] = ivyNode2.getId();
            ++n;
        }
        moduleRevisionIdArray[moduleRevisionIdArray.length - 1] = ivyNode.getId();
        return moduleRevisionIdArray;
    }

    public Set getResolvedNodes(ModuleId moduleId, String string) {
        return this.eviction.getResolvedNodes(moduleId, string);
    }

    public Collection getResolvedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getResolvedRevisions(moduleId, string);
    }

    public void markEvicted(IvyNodeEviction.EvictionData object) {
        this.eviction.markEvicted((IvyNodeEviction.EvictionData)object);
        String string = ((IvyNodeEviction.EvictionData)object).getRootModuleConf();
        if (((IvyNodeEviction.EvictionData)object).getSelected() != null) {
            for (IvyNode ivyNode : ((IvyNodeEviction.EvictionData)object).getSelected()) {
                ivyNode.updateDataFrom(this, string, false);
            }
        }
    }

    public Collection getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public Collection getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public IvyNodeEviction.EvictionData getEvictedData(String string) {
        return this.eviction.getEvictedData(string);
    }

    public Collection getEvictedNodes(ModuleId moduleId, String string) {
        return this.eviction.getEvictedNodes(moduleId, string);
    }

    public Collection getEvictedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getEvictedRevisions(moduleId, string);
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String string, IvyNode ivyNode) {
        return this.eviction.getEvictionDataInRoot(string, ivyNode);
    }

    public boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public boolean isEvicted(String string) {
        return this.eviction.isEvicted(string);
    }

    public void markEvicted(String object, IvyNode ivyNode, ConflictManager conflictManager, Collection collection) {
        object = new IvyNodeEviction.EvictionData((String)object, ivyNode, conflictManager, collection);
        this.markEvicted((IvyNodeEviction.EvictionData)object);
    }

    public void setEvictedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setEvictedNodes(moduleId, string, collection);
    }

    public void setResolvedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setResolvedNodes(moduleId, string, collection);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IvyNode)) {
            return false;
        }
        object = (IvyNode)object;
        return ((IvyNode)object).getId().equals(this.getId());
    }

    public int compareTo(Object object) {
        object = (IvyNode)object;
        return this.getModuleId().compareTo(((IvyNode)object).getModuleId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Collection getPendingConflicts(String string, ModuleId moduleId) {
        return this.eviction.getPendingConflicts(string, moduleId);
    }

    public void setPendingConflicts(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setPendingConflicts(moduleId, string, collection);
    }

    public void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + ivyNodeBlacklist);
        } else {
            Message.verbose("BLACKLISTING " + ivyNodeBlacklist);
        }
        Stack<IvyNode> stack = new Stack<IvyNode>();
        stack.push(this);
        this.clearEvictionDataInAllCallers(ivyNodeBlacklist.getRootModuleConf(), stack);
        this.usage.blacklist(ivyNodeBlacklist);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String string, Stack stack) {
        IvyNodeCallers.Caller[] callerArray = (IvyNodeCallers.Caller[])stack.peek();
        callerArray = callerArray.getCallers(string);
        for (int i = 0; i < callerArray.length; ++i) {
            IvyNode ivyNode = this.findNode(callerArray[i].getModuleRevisionId());
            if (ivyNode == null) continue;
            ivyNode.eviction = new IvyNodeEviction(ivyNode);
            if (stack.contains(ivyNode)) continue;
            stack.push(ivyNode);
            this.clearEvictionDataInAllCallers(string, stack);
            stack.pop();
        }
    }

    public boolean isBlacklisted(String string) {
        return this.usage.isBlacklisted(string);
    }

    public boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        String[] stringArray = this.getRootModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isBlacklisted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public IvyNodeBlacklist getBlacklistData(String string) {
        return this.usage.getBlacklistData(string);
    }

    public IvyNodeUsage getMainUsage() {
        return this.usage;
    }

    public boolean hasAnyMergedUsageWithTransitiveDependency(String string) {
        if (this.mergedUsages == null) {
            return false;
        }
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            if (!ivyNodeUsage.hasTransitiveDepender(string)) continue;
            return true;
        }
        return false;
    }
}

