/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.math.BigInteger;
import org.apache.tomcat.util.res.StringManager;

public class Asn1Parser {
    private static final StringManager sm = StringManager.getManager(Asn1Parser.class);
    public static final int TAG_INTEGER = 2;
    public static final int TAG_OCTET_STRING = 4;
    public static final int TAG_NULL = 5;
    public static final int TAG_OID = 6;
    public static final int TAG_SEQUENCE = 48;
    public static final int TAG_ATTRIBUTE_BASE = 160;
    private final byte[] source;
    private int pos = 0;

    public Asn1Parser(byte[] byArray) {
        this.source = byArray;
    }

    public boolean eof() {
        return this.pos == this.source.length;
    }

    public int peekTag() {
        return this.source[this.pos] & 0xFF;
    }

    public void parseTagSequence() {
        this.parseTag(48);
    }

    public void parseTag(int n) {
        int n2 = this.next();
        if (n2 != n) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.tagMismatch", n, n2));
        }
    }

    public void parseFullLength() {
        int n = this.parseLength();
        if (n + this.pos != this.source.length) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.lengthInvalid", n, this.source.length - this.pos));
        }
    }

    public int parseLength() {
        int n = this.next();
        if (n > 127) {
            int n2 = n - 128;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                n <<= 8;
                n += this.next();
            }
        }
        return n;
    }

    public BigInteger parseInt() {
        byte[] byArray = this.parseBytes(2);
        return new BigInteger(byArray);
    }

    public byte[] parseOctetString() {
        return this.parseBytes(4);
    }

    public void parseNull() {
        this.parseBytes(5);
    }

    public byte[] parseOIDAsBytes() {
        return this.parseBytes(6);
    }

    public byte[] parseAttributeAsBytes(int n) {
        return this.parseBytes(160 + n);
    }

    private byte[] parseBytes(int n) {
        this.parseTag(n);
        int n2 = this.parseLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(this.source, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
        return byArray;
    }

    public void parseBytes(byte[] byArray) {
        System.arraycopy(this.source, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    private int next() {
        return this.source[this.pos++] & 0xFF;
    }
}

