/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;
import org.openide.text.PrintPreferences;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class DefaultPrintable
implements Printable {
    private static final int ARG_SIZE = 3;
    private static Font fontInstance;
    private AttributedCharacterIterator[] styledTexts;
    private int startPage = -1;
    private List<TextLayout> textLayouts;
    private int[] pageIndices;
    private int pageIndicesSize;
    private int currentLayout;
    private int currentStyledText;
    private LineBreakMeasurer lineBreakMeasurer;
    private int maxPage;
    private List<TextLayout> startLayouts;
    private int[] lineIndices;
    private Object[] pageArgs;
    private MessageFormat header;
    private boolean printHeader;
    private MessageFormat footer;
    private boolean printFooter;
    private CancellationPanel cancellationPanel;
    private Dialog cancellationDialog;

    private DefaultPrintable(AttributedCharacterIterator[] attributedCharacterIteratorArray, String string) {
        if (attributedCharacterIteratorArray == null || attributedCharacterIteratorArray.length == 0) {
            throw new IllegalArgumentException();
        }
        DefaultPrintable.replaceEmptyIterators(attributedCharacterIteratorArray);
        this.styledTexts = attributedCharacterIteratorArray;
        this.textLayouts = new ArrayList<TextLayout>(100);
        this.pageIndices = new int[50];
        this.pageIndicesSize = 0;
        this.currentLayout = 0;
        this.currentStyledText = 0;
        this.lineBreakMeasurer = null;
        this.maxPage = Integer.MAX_VALUE;
        this.startLayouts = new ArrayList<TextLayout>(10);
        this.lineIndices = new int[this.pageIndices.length];
        this.pageArgs = new Object[3];
        this.pageArgs[2] = string;
        this.pageArgs[1] = new Date(System.currentTimeMillis());
        this.header = new MessageFormat(DefaultPrintable.getHeaderFormat());
        this.printHeader = !DefaultPrintable.getHeaderFormat().equals("");
        this.footer = new MessageFormat(DefaultPrintable.getFooterFormat());
        this.printFooter = !DefaultPrintable.getFooterFormat().equals("");
    }

    public DefaultPrintable(Document document) {
        this(DefaultPrintable.getIterators(document), DefaultPrintable.getFilename(document));
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        boolean bl = false;
        if (this.startPage == -1) {
            bl = true;
            this.startPage = n;
        }
        if (bl) {
            for (int i = 0; i < this.startPage; ++i) {
                this.printImpl(graphics, pageFormat, i, false);
            }
        }
        return this.printImpl(graphics, pageFormat, n, true);
    }

    private int printImpl(Graphics graphics, PageFormat pageFormat, int n, boolean bl) throws PrinterException {
        float f;
        if (n > this.maxPage) {
            this.closeDialog();
            return 1;
        }
        if (n < 0) {
            this.closeDialog();
            throw new IllegalArgumentException("Illegal page number=" + n);
        }
        if (graphics instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)graphics)).getPrinterJob())) {
            this.closeDialog();
            throw new PrinterAbortException();
        }
        if (this.cancellationPanel == null && graphics instanceof PrinterGraphics) {
            PrinterJob printerJob = ((PrinterGraphics)((Object)graphics)).getPrinterJob();
            this.createCancellationPanel(printerJob);
        }
        if (this.cancellationPanel != null) {
            int n2 = bl ? n : this.startPage;
            this.cancellationPanel.setPageno(n2);
            this.packDialog();
        }
        boolean bl2 = false;
        int n3 = 3;
        graphics.setColor(Color.black);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Float float_ = new Point2D.Float(this.getImageableXPatch(pageFormat), this.getImageableYPatch(pageFormat));
        this.pageArgs[0] = new Integer(n + 1);
        float f2 = 0.0f;
        TextLayout textLayout = null;
        TextLayout textLayout2 = null;
        if (this.printHeader) {
            textLayout = new TextLayout(this.header.format(this.pageArgs), DefaultPrintable.getHeaderFont(), graphics2D.getFontRenderContext());
            f2 += textLayout.getAscent() + (textLayout.getDescent() + textLayout.getLeading()) * 2.0f;
        }
        if (this.printFooter) {
            textLayout2 = new TextLayout(this.footer.format(this.pageArgs), DefaultPrintable.getFooterFont(), graphics2D.getFontRenderContext());
            f2 += textLayout2.getAscent() * 2.0f + textLayout2.getDescent() + textLayout2.getLeading();
        }
        float f3 = DefaultPrintable.wrap() ? (float)pageFormat.getImageableWidth() - (float)n3 : Float.MAX_VALUE;
        float f4 = (float)pageFormat.getImageableHeight() + (float)pageFormat.getImageableY() - f2;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        boolean bl3 = false;
        TextLayout textLayout3 = this.layoutForPage(n, f3, fontRenderContext);
        while (float_.y < f4) {
            if (textLayout3 == null) {
                this.maxPage = n;
                break;
            }
            if (!bl3) {
                if (this.printHeader && textLayout != null) {
                    float f5;
                    float_.y += textLayout.getAscent();
                    f = DefaultPrintable.computeStart(textLayout.getBounds(), (float)pageFormat.getImageableWidth(), DefaultPrintable.getHeaderAlignment());
                    float f6 = f5 = textLayout.isLeftToRight() ? f : f3 - textLayout.getAdvance() - f;
                    if (bl) {
                        textLayout.draw(graphics2D, float_.x + f5, float_.y);
                    }
                    float_.y += (textLayout.getDescent() + textLayout.getLeading()) * 2.0f;
                }
                bl3 = true;
            }
            float_.y += textLayout3.getAscent() * DefaultPrintable.getLineAscentCorrection();
            float f7 = f = textLayout3.isLeftToRight() ? 0.0f : f3 - textLayout3.getAdvance();
            if (bl) {
                textLayout3.draw(graphics2D, (float)n3 + float_.x + f, float_.y);
            }
            float_.y += (textLayout3.getDescent() + textLayout3.getLeading()) * DefaultPrintable.getLineAscentCorrection();
            textLayout3 = this.nextLayout(f3, fontRenderContext);
        }
        if (this.printFooter && bl3 && textLayout2 != null) {
            float_.y = f4;
            float_.y += textLayout2.getAscent() * 2.0f;
            float f8 = DefaultPrintable.computeStart(textLayout2.getBounds(), (float)pageFormat.getImageableWidth(), DefaultPrintable.getFooterAlignment());
            float f9 = f = textLayout2.isLeftToRight() ? 0.0f + f8 : f3 - textLayout2.getAdvance() - f8;
            if (bl) {
                textLayout2.draw(graphics2D, float_.x + f, float_.y);
            }
        }
        if (graphics instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)graphics)).getPrinterJob())) {
            this.closeDialog();
            throw new PrinterAbortException();
        }
        if (!bl3) {
            this.closeDialog();
            return 1;
        }
        return 0;
    }

    private float getImageableXPatch(PageFormat pageFormat) {
        if (pageFormat.getOrientation() == 0) {
            double d = pageFormat.getPaper().getHeight() - (pageFormat.getImageableX() + pageFormat.getImageableWidth());
            return Math.round(d);
        }
        return (float)pageFormat.getImageableX();
    }

    private float getImageableYPatch(PageFormat pageFormat) {
        if (pageFormat.getOrientation() == 0) {
            double d = pageFormat.getPaper().getWidth() - (pageFormat.getImageableY() + pageFormat.getImageableHeight());
            return Math.round(d);
        }
        return (float)pageFormat.getImageableY();
    }

    private boolean isNewline(TextLayout textLayout, int n) {
        if (n >= this.startLayouts.size()) {
            return false;
        }
        return this.startLayouts.get(n) == textLayout;
    }

    private static float computeStart(Rectangle2D rectangle2D, float f, PrintPreferences.Alignment alignment) {
        float f2 = rectangle2D instanceof Rectangle2D.Float ? ((Rectangle2D.Float)rectangle2D).width : (float)((Rectangle2D.Double)rectangle2D).width;
        if (f2 >= f) {
            return 0.0f;
        }
        if (alignment == PrintPreferences.Alignment.LEFT) {
            return 0.0f;
        }
        if (alignment == PrintPreferences.Alignment.RIGHT) {
            return f - f2;
        }
        return (f - f2) / 2.0f;
    }

    private TextLayout nextLayout(float f, FontRenderContext fontRenderContext) {
        TextLayout textLayout;
        if (this.currentLayout == this.textLayouts.size()) {
            LineBreakMeasurer lineBreakMeasurer = this.lineBreakMeasurer;
            LineBreakMeasurer lineBreakMeasurer2 = this.getMeasurer(fontRenderContext);
            if (lineBreakMeasurer2 == null) {
                return null;
            }
            textLayout = lineBreakMeasurer2.nextLayout(f);
            this.textLayouts.add(textLayout);
            if (lineBreakMeasurer != lineBreakMeasurer2) {
                this.startLayouts.add(textLayout);
            }
        } else {
            textLayout = this.textLayouts.get(this.currentLayout);
        }
        ++this.currentLayout;
        return textLayout;
    }

    private TextLayout layoutForPage(int n, float f, FontRenderContext fontRenderContext) {
        if (n > this.pageIndicesSize + 1) {
            throw new IllegalArgumentException("Page number " + n + " is bigger than array size " + (this.pageIndicesSize + 1));
        }
        if (n == this.pageIndicesSize) {
            if (this.pageIndicesSize >= this.pageIndices.length) {
                this.pageIndices = DefaultPrintable.increaseArray(this.pageIndices);
                this.lineIndices = DefaultPrintable.increaseArray(this.lineIndices);
            }
            this.pageIndices[this.pageIndicesSize] = Math.max(this.textLayouts.size() - 1, 0);
            this.lineIndices[this.pageIndicesSize++] = Math.max(this.startLayouts.size() - 1, 0);
        }
        this.currentLayout = this.pageIndices[n];
        return this.nextLayout(f, fontRenderContext);
    }

    private LineBreakMeasurer getMeasurer(FontRenderContext fontRenderContext) {
        if (this.lineBreakMeasurer == null) {
            this.lineBreakMeasurer = new LineBreakMeasurer(this.styledTexts[this.currentStyledText], fontRenderContext);
        } else if (this.lineBreakMeasurer.getPosition() >= this.styledTexts[this.currentStyledText].getEndIndex()) {
            if (this.currentStyledText == this.styledTexts.length - 1) {
                return null;
            }
            this.lineBreakMeasurer = new LineBreakMeasurer(this.styledTexts[++this.currentStyledText], fontRenderContext);
        }
        return this.lineBreakMeasurer;
    }

    private static boolean wrap() {
        return PrintPreferences.getWrap();
    }

    private static String getHeaderFormat() {
        return PrintPreferences.getHeaderFormat();
    }

    private static String getFooterFormat() {
        return PrintPreferences.getFooterFormat();
    }

    private static Font getHeaderFont() {
        return PrintPreferences.getHeaderFont();
    }

    private static Font getFooterFont() {
        return PrintPreferences.getFooterFont();
    }

    private static PrintPreferences.Alignment getFooterAlignment() {
        return PrintPreferences.getFooterAlignment();
    }

    private static PrintPreferences.Alignment getHeaderAlignment() {
        return PrintPreferences.getHeaderAlignment();
    }

    private static float getLineAscentCorrection() {
        return PrintPreferences.getLineAscentCorrection();
    }

    private static boolean lineNumbers() {
        return false;
    }

    private static Font lineNumbersFont() {
        return new Font("Courier", 0, 6);
    }

    private static AttributedCharacterIterator[] getIterators(Document document) {
        AttributedCharacterIterator[] attributedCharacterIteratorArray;
        if (document instanceof NbDocument.Printable) {
            return ((NbDocument.Printable)document).createPrintIterators();
        }
        Font font = new Font("Courier", 0, 8);
        AttributedCharacters attributedCharacters = null;
        char[] cArray = null;
        ArrayList<AttributedCharacterIterator> arrayList = new ArrayList<AttributedCharacterIterator>(300);
        try {
            attributedCharacterIteratorArray = document.getText(0, document.getLength());
            int n = 0;
            for (int i = 0; i < attributedCharacterIteratorArray.length(); ++i) {
                if (attributedCharacterIteratorArray.charAt(i) != '\n') continue;
                cArray = new char[i - n + 1];
                attributedCharacterIteratorArray.getChars(n, cArray.length + n, cArray, 0);
                attributedCharacters = new AttributedCharacters();
                attributedCharacters.append(cArray, font, Color.black);
                arrayList.add(attributedCharacters.iterator());
                n = i + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        attributedCharacterIteratorArray = new AttributedCharacterIterator[arrayList.size()];
        arrayList.toArray(attributedCharacterIteratorArray);
        return attributedCharacterIteratorArray;
    }

    private static String getFilename(Document document) {
        String string = (String)document.getProperty("title");
        return string == null ? "UNKNOWN" : string;
    }

    private static int[] increaseArray(int[] nArray) {
        int[] nArray2 = new int[2 * nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private void createCancellationPanel(final PrinterJob printerJob) {
        this.cancellationPanel = new CancellationPanel(printerJob);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.cancellationPanel, NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Print_cancellation"), false, new Object[]{NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Cancel")}, (Object)NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Cancel"), 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultPrintable.this.setCancelled(printerJob);
                DefaultPrintable.this.closeDialog();
            }
        });
        this.setDialog(DialogDisplayer.getDefault().createDialog(dialogDescriptor));
    }

    void closeDialog() {
        if (this.cancellationDialog != null) {
            this.cancellationDialog.setVisible(false);
            this.cancellationDialog.dispose();
        }
    }

    void setDialog(Dialog dialog) {
        dialog.setVisible(true);
        dialog.pack();
        this.cancellationDialog = dialog;
    }

    void packDialog() {
        if (this.cancellationDialog != null) {
            this.cancellationDialog.pack();
        }
    }

    void setCancelled(PrinterJob printerJob) {
        printerJob.cancel();
    }

    boolean isCancelled(PrinterJob printerJob) {
        return printerJob.isCancelled();
    }

    private static void replaceEmptyIterators(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
            AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[i];
            if (attributedCharacterIterator.getBeginIndex() != attributedCharacterIterator.getEndIndex()) continue;
            AttributedCharacters attributedCharacters = new AttributedCharacters();
            attributedCharacters.append(' ', DefaultPrintable.getFontInstance(), Color.white);
            attributedCharacterIteratorArray[i] = attributedCharacters.iterator();
        }
    }

    static Font getFontInstance() {
        if (fontInstance == null) {
            fontInstance = new Font("Dialog", 0, 14);
        }
        return fontInstance;
    }

    static final class CancellationPanel
    extends JPanel {
        static final long serialVersionUID = -6419253408585188541L;
        private final JLabel printProgress;
        private final MessageFormat format;
        private final Object[] msgParams;

        public CancellationPanel(PrinterJob printerJob) {
            if (printerJob == null) {
                throw new IllegalArgumentException();
            }
            this.format = new MessageFormat(NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Print_progress"));
            this.msgParams = new Object[1];
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(12, 12, 0, 12));
            this.printProgress = new JLabel();
            this.printProgress.setHorizontalAlignment(0);
            this.add(this.printProgress);
        }

        public void setPageno(int n) {
            this.msgParams[0] = new Integer(n + 1);
            this.printProgress.setText(this.format.format(this.msgParams));
            this.getAccessibleContext().setAccessibleDescription(this.printProgress.getText());
        }
    }
}

