"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.rangeIntersects = exports.rangeContains = exports.modifyRange = exports.areRangesEqual = exports.makeRange = exports.isRange = void 0;
const position_1 = require("./position");
function isRange(thing) {
    if (!thing) {
        return false;
    }
    return (0, position_1.isPosition)(thing.start)
        && (0, position_1.isPosition)(thing.end);
}
exports.isRange = isRange;
function makeRange(startOrStartLine, endOrStartCharacter, endLine, endCharacter) {
    if (typeof startOrStartLine === 'number') {
        return {
            start: { line: startOrStartLine, character: endOrStartCharacter },
            end: { line: endLine, character: endCharacter },
        };
    }
    return { start: startOrStartLine, end: endOrStartCharacter };
}
exports.makeRange = makeRange;
function areRangesEqual(a, b) {
    return (0, position_1.arePositionsEqual)(a.start, b.start) && (0, position_1.arePositionsEqual)(a.end, b.end);
}
exports.areRangesEqual = areRangesEqual;
function modifyRange(range, start, end) {
    return {
        start: start ?? range.start,
        end: end ?? range.end,
    };
}
exports.modifyRange = modifyRange;
function rangeContains(range, other) {
    if (isRange(other)) {
        return rangeContains(range, other.start) && rangeContains(range, other.end);
    }
    return !(0, position_1.isBefore)(other, range.start) && !(0, position_1.isBefore)(range.end, other);
}
exports.rangeContains = rangeContains;
function rangeIntersects(a, b) {
    if (rangeContains(a, b.start) || rangeContains(a, b.end)) {
        return true;
    }
    // Check case where `a` is entirely contained in `b`
    return rangeContains(b, a.start) || rangeContains(b, a.end);
}
exports.rangeIntersects = rangeIntersects;
//# sourceMappingURL=range.js.map