/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public abstract class Shape {
    public String myType;
    public static final float RADIUS_MAX = 4.0f;
    public Viewer vwr;
    public ModelSet ms;
    public int shapeID;
    public int vf;
    protected float translucentLevel;
    public boolean translucentAllowed = true;
    public boolean isBioShape;
    public BS bsSizeSet;
    public BS bsColixSet;

    public abstract String getShapeState();

    public abstract void setProperty(String var1, Object var2, BS var3);

    public final void initializeShape(Viewer vwr, ModelSet modelSet, int shapeID) {
        this.vwr = vwr;
        this.shapeID = shapeID;
        this.vf = JC.getShapeVisibilityFlag(shapeID);
        this.setModelSet(modelSet);
        this.initShape();
    }

    public abstract void initShape();

    public void setModelVisibilityFlags(BS bsModels) {
    }

    public int getSize(int atomIndex) {
        return 0;
    }

    public int getSizeG(Group group) {
        return 0;
    }

    public void replaceGroup(Group g0, Group g1) {
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = modelSet;
        this.initModelSet();
    }

    protected void initModelSet() {
    }

    public void setShapeSizeRD(int size, RadiusData rd, BS bsSelected) {
        if (rd == null) {
            this.setSize(size, bsSelected);
        } else {
            this.setSizeRD(rd, bsSelected);
        }
    }

    protected void setSize(int size, BS bsSelected) {
    }

    protected void setSizeRD(RadiusData rd, BS bsSelected) {
    }

    protected void setPropS(String propertyName, Object value, BS bsSelected) {
        if (propertyName == "setProperties") {
            if (bsSelected == null) {
                bsSelected = this.vwr.bsA();
            }
            Lst propertyList = (Lst)value;
            while (propertyList.size() > 0) {
                Object[] data = (Object[])propertyList.removeItemAt(0);
                this.setProperty(((String)data[0]).intern(), data[1], bsSelected);
            }
            return;
        }
        if (propertyName == "translucentLevel") {
            this.translucentLevel = ((Float)value).floatValue();
            return;
        }
        if (propertyName == "refreshTrajectories") {
            return;
        }
        Logger.warn("unassigned " + JC.shapeClassBases[this.shapeID] + " + shape setProperty:" + propertyName + ":" + value);
    }

    public boolean getPropertyData(String property, Object[] data) {
        return this.getPropShape(property, data);
    }

    protected boolean getPropShape(String property, Object[] data) {
        if (data[1] instanceof Integer) {
            int index = (Integer)data[1];
            data[1] = this.getProperty(property, index);
            return data[1] != null;
        }
        return false;
    }

    public Object getProperty(String property, int index) {
        return null;
    }

    public int getIndexFromName(String thisID) {
        return -1;
    }

    public boolean wasClicked(int x, int y) {
        return false;
    }

    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest, BS bsNot) {
    }

    public void checkBoundsMinMax(P3 pointMin, P3 pointMax) {
    }

    public void setAtomClickability() {
    }

    public Map<String, Object> checkObjectClicked(int x, int y, int modifiers, BS bsVisible, boolean drawPicking) {
        return null;
    }

    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        return false;
    }

    public boolean checkObjectDragged(int prevX, int prevY, int x, int y, int dragAction, BS bsVisible) {
        return false;
    }

    protected int coordinateInRange(int x, int y, T3 vertex, int dmin2, P3i ptXY) {
        this.vwr.tm.transformPtScr(vertex, ptXY);
        int d2 = (x - ptXY.x) * (x - ptXY.x) + (y - ptXY.y) * (y - ptXY.y);
        return d2 <= dmin2 ? d2 : -1;
    }

    public short getColixI(short colix, byte paletteID, int atomIndex) {
        return this.getColixA(colix, paletteID, this.ms.at[atomIndex]);
    }

    protected short getColixA(short colix, byte paletteID, Atom atom) {
        return colix == 2 ? this.vwr.cm.getColixAtomPalette(atom, paletteID) : colix;
    }

    protected short getColixB(short colix, int pid, Bond bond) {
        return colix == 2 ? this.vwr.cm.getColixBondPalette(bond, pid) : colix;
    }

    public Object getShapeDetail() {
        return null;
    }

    public static short getColix(short[] colixes, int i, Atom atom) {
        return C.getColixInherited(colixes == null || i >= colixes.length ? (short)0 : colixes[i], atom.colixAtom);
    }

    public static String getFontCommand(String type, Font font) {
        if (font == null) {
            return "";
        }
        return "font " + type + " " + font.getInfo();
    }

    public static String getColorCommandUnk(String type, short colix, boolean translucentAllowed) {
        return Shape.getColorCommand(type, PAL.UNKNOWN.id, colix, translucentAllowed);
    }

    public static String getColorCommand(String type, byte pid, short colix, boolean translucentAllowed) {
        if (pid == PAL.UNKNOWN.id && colix == 0) {
            return "";
        }
        String s = pid == PAL.UNKNOWN.id && colix == 0 ? "" : (translucentAllowed ? Shape.getTranslucentLabel(colix) + " " : "") + (pid != PAL.UNKNOWN.id && !PAL.isPaletteVariable(pid) ? PAL.getPaletteName(pid) : Shape.encodeColor(colix));
        return "color " + type + " " + s;
    }

    public static String encodeColor(short colix) {
        return C.isColixColorInherited(colix) ? "none" : C.getHexCode(colix);
    }

    public static String getTranslucentLabel(short colix) {
        return C.isColixTranslucent(colix) ? C.getColixTranslucencyLabel(colix) : "opaque";
    }

    protected static void appendCmd(SB s, String cmd) {
        if (cmd.length() == 0) {
            return;
        }
        s.append("  ").append(cmd).append(";\n");
    }
}

