/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class BcChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] ZEROES = new byte[15];
    protected final ChaCha7539Engine cipher = new ChaCha7539Engine();
    protected final Poly1305 mac = new Poly1305();
    protected final boolean isEncrypting;

    public BcChaCha20Poly1305(boolean bl) {
        this.isEncrypting = bl;
    }

    @Override
    public int doFinal(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws IOException {
        boolean bl;
        int n4 = 0;
        if (!Arrays.isNullOrEmpty((byte[])byArray)) {
            n4 = byArray.length;
            this.updateMAC(byArray, 0, byArray.length);
        }
        if (this.isEncrypting) {
            int n5 = n2;
            int n6 = this.cipher.processBytes(byArray2, n, n2, byArray3, n3);
            if (n5 != n6) {
                throw new IllegalStateException();
            }
            this.updateMAC(byArray3, n3, n5);
            byte[] byArray4 = new byte[16];
            Pack.longToLittleEndian((long)((long)n4 & 0xFFFFFFFFL), (byte[])byArray4, (int)0);
            Pack.longToLittleEndian((long)((long)n5 & 0xFFFFFFFFL), (byte[])byArray4, (int)8);
            this.mac.update(byArray4, 0, 16);
            this.mac.doFinal(byArray3, n3 + n5);
            return n5 + 16;
        }
        int n7 = n2 - 16;
        this.updateMAC(byArray2, n, n7);
        byte[] byArray5 = new byte[16];
        Pack.longToLittleEndian((long)((long)n4 & 0xFFFFFFFFL), (byte[])byArray5, (int)0);
        Pack.longToLittleEndian((long)((long)n7 & 0xFFFFFFFFL), (byte[])byArray5, (int)8);
        this.mac.update(byArray5, 0, 16);
        this.mac.doFinal(byArray5, 0);
        boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(16, byArray5, 0, byArray2, n + n7);
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        int n8 = this.cipher.processBytes(byArray2, n, n7, byArray3, n3);
        if (n7 != n8) {
            throw new IllegalStateException();
        }
        return n7;
    }

    @Override
    public int getOutputSize(int n) {
        return this.isEncrypting ? n + 16 : n - 16;
    }

    @Override
    public void init(byte[] byArray, int n) throws IOException {
        if (byArray == null || byArray.length != 12 || n != 16) {
            throw new TlsFatalAlert(80);
        }
        this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, byArray));
        this.initMAC();
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) throws IOException {
        KeyParameter keyParameter = new KeyParameter(byArray, n, n2);
        this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, ZEROES, 0, 12));
    }

    protected void initMAC() {
        byte[] byArray = new byte[64];
        this.cipher.processBytes(byArray, 0, 64, byArray, 0);
        this.mac.init((CipherParameters)new KeyParameter(byArray, 0, 32));
        Arrays.fill((byte[])byArray, (byte)0);
    }

    protected void updateMAC(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        int n3 = n2 % 16;
        if (n3 != 0) {
            this.mac.update(ZEROES, 0, 16 - n3);
        }
    }
}

