/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat.application;

import java.net.URISyntaxException;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.host.Host;
import org.openide.util.Exceptions;
import sun.jvmstat.monitor.HostIdentifier;

class ConnectionDescriptor {
    static final ConnectionDescriptor DEFAULT_LOCAL_DESCRIPTOR = new ConnectionDescriptor(-1, GlobalPreferences.sharedInstance().getMonitoredHostPoll());
    private int port;
    private double refreshRate;

    ConnectionDescriptor(int port, double refreshRate) {
        this.setPort(port);
        this.setRefreshRate(refreshRate);
    }

    static ConnectionDescriptor createDefault() {
        return new ConnectionDescriptor(1099, GlobalPreferences.sharedInstance().getMonitoredHostPoll());
    }

    final void setPort(int port) {
        this.port = port;
    }

    final int getPort() {
        return this.port;
    }

    final void setRefreshRate(double refreshRate) {
        this.refreshRate = refreshRate;
    }

    final double getRefreshRate() {
        return this.refreshRate;
    }

    final HostIdentifier createHostIdentifier(Host host) {
        String hostId = null;
        if (this != DEFAULT_LOCAL_DESCRIPTOR) {
            hostId = "rmi://" + host.getHostName();
            if (this.port != 1099) {
                hostId = hostId + ":" + this.port;
            }
        }
        try {
            return new HostIdentifier(hostId);
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionDescriptor)) {
            return false;
        }
        return this.port == ((ConnectionDescriptor)o).port;
    }

    public int hashCode() {
        return this.port;
    }

    public String toString() {
        return "Port: " + this.port + ", Refresh Rate: " + this.refreshRate;
    }
}

