/*! For license information please see bookmarks-src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue.js.LICENSE.txt */
(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue"],{53535:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n.bookmark__title > h3 {\n\tmargin: 0;\n}\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 24px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 15px;\n}\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n}\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n.item--gridview .bookmark__icon {\n\tmargin: 0 5px 0 8px;\n}\n","",{version:3,sources:["webpack://./src/components/Bookmark.vue"],names:[],mappings:";AA8RA;CACA,qBAAA;CACA,OAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,aAAA;CACA,2BAAA;AACA;AAEA;;CAEA,uBAAA;CACA,gBAAA;CACA,mBAAA;AACA;AAEA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;CACA,OAAA;CACA,iBAAA;CACA,YAAA;CACA,gCAAA;CACA,uBAAA;CACA,gBAAA;CACA,eAAA;AACA;AAEA;CACA,wBAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;CACA,OAAA;AACA;AAEA;CACA,gCAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :title=\"bookmark.title\"\n\t\t:tags=\"bookmark.tags\"\n\t\t:rename-placeholder=\"t('bookmarks', 'Enter new title')\"\n\t\t:select-label=\"t('bookmarks', 'Select bookmark')\"\n\t\t:active=\"isActive\"\n\t\t:editable=\"isEditable\"\n\t\t:selected=\"selected\"\n\t\t:draggable=\"isEditable\"\n\t\t:renaming=\"renaming\"\n\t\t:background=\"background\"\n\t\t:url=\"url\"\n\t\t:selectable=\"selectable\"\n\t\t@select=\"onSelect\"\n\t\t@rename=\"onRenameSubmit\"\n\t\t@rename-cancel=\"renaming = false\"\n\t\t@click=\"onClick\">\n\t\t<template #title>\n\t\t\t<div class=\"bookmark__title\">\n\t\t\t\t<h3 :title=\"bookmark.title\">\n\t\t\t\t\t<span v-if=\"bookmark.preliminary\" class=\"icon-loading-small bookmark__icon\" />\n\t\t\t\t\t<figure v-else\n\t\t\t\t\t\tclass=\"bookmark__icon\"\n\t\t\t\t\t\t:style=\"{ backgroundImage: 'url(' + iconUrl + ')' }\" />\n\t\t\t\t\t{{ bookmark.title }}\n\t\t\t\t</h3>\n\t\t\t\t<span v-if=\"bookmark.description\"\n\t\t\t\t\tv-tooltip=\"bookmark.description\"\n\t\t\t\t\tclass=\"bookmark__description\"><figure class=\"icon-file\" />\n\t\t\t\t\t{{ bookmark.description }}</span>\n\t\t\t</div>\n\t\t</template>\n\t\t<template #actions>\n\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t@click=\"onDetails\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<InformationVariantIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Details') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionCheckbox @change=\"onSelect\">\n\t\t\t\t{{ t('bookmarks', 'Select bookmark') }}\n\t\t\t</NcActionCheckbox>\n\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t@click=\"onRename\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PencilIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Rename') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t@click=\"onCopyUrl\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<ContentCopyIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Copy link') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click=\"true\" @click=\"onMove\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Move') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click=\"true\" @click=\"onCopy\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderPlusIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Add to folders') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t@click=\"onDelete\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DeleteIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Delete') }}\n\t\t\t</NcActionButton>\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport Item from './Item.vue'\nimport { NcActionButton, NcActionCheckbox } from '@nextcloud/vue'\nimport FolderPlusIcon from 'vue-material-design-icons/FolderPlus.vue'\nimport FolderMoveIcon from 'vue-material-design-icons/FolderMove.vue'\nimport ContentCopyIcon from 'vue-material-design-icons/ContentCopy.vue'\nimport PencilIcon from 'vue-material-design-icons/Pencil.vue'\nimport InformationVariantIcon from 'vue-material-design-icons/InformationVariant.vue'\nimport DeleteIcon from 'vue-material-design-icons/Delete.vue'\nimport { getCurrentUser } from '@nextcloud/auth'\nimport { generateUrl } from '@nextcloud/router'\nimport { actions, mutations } from '../store/index.js'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'Bookmark',\n\tcomponents: {\n\t\tItem,\n\t\tNcActionButton,\n\t\tNcActionCheckbox,\n\t\tFolderPlusIcon,\n\t\tFolderMoveIcon,\n\t\tContentCopyIcon,\n\t\tPencilIcon,\n\t\tInformationVariantIcon,\n\t\tDeleteIcon,\n\t},\n\tprops: {\n\t\tbookmark: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\ttitle: this.bookmark.title,\n\t\t\trenaming: false,\n\t\t\tbackgroundImage: undefined,\n\t\t}\n\t},\n\tcomputed: {\n\t\tapiUrl() {\n\t\t\tif (this.isPublic) {\n\t\t\t\treturn generateUrl('/apps/bookmarks/public/rest/v2')\n\t\t\t}\n\t\t\treturn generateUrl('/apps/bookmarks')\n\t\t},\n\t\ticonUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ '/bookmark/'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ '/favicon'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? '?token=' + this.$store.state.authToken\n\t\t\t\t\t: '')\n\t\t\t)\n\t\t},\n\t\timageUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ '/bookmark/'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ '/image'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? '?token=' + this.$store.state.authToken\n\t\t\t\t\t: '')\n\t\t\t)\n\t\t},\n\t\turl() {\n\t\t\treturn this.bookmark.url\n\t\t},\n\t\tisOpen() {\n\t\t\treturn this.$store.state.sidebar\n\t\t\t\t&& this.$store.state.sidebar.type === 'bookmark'\n\t\t\t\t? this.$store.state.sidebar.id === this.bookmark.id\n\t\t\t\t: false\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.bookmark.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForBookmark(\n\t\t\t\tthis.bookmark.id\n\t\t\t)\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(\n\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t\t|| this.$store.state.selection.folders.length\n\t\t\t)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedBookmarks\n\t\t\t\t.map(b => b.id)\n\t\t\t\t.includes(this.bookmark.id)\n\t\t},\n\t\tisActive() {\n\t\t\treturn this.isOpen || this.selected\n\t\t},\n\t\tbackground() {\n\t\t\treturn this.viewMode === 'grid' ? this.backgroundImage : undefined\n\t\t},\n\t},\n\tmounted() {\n\t\tthis.fetchBackgroundImage()\n\t},\n\tmethods: {\n\t\tonDelete() {\n\t\t\tif (\n\t\t\t\t!confirm(\n\t\t\t\t\tt(\n\t\t\t\t\t\t'bookmarks',\n\t\t\t\t\t\t'Do you really want to delete this bookmark?'\n\t\t\t\t\t)\n\t\t\t\t)\n\t\t\t) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.DELETE_BOOKMARK, {\n\t\t\t\tid: this.bookmark.id,\n\t\t\t\tfolder: this.$store.state.fetchState.query.folder,\n\t\t\t})\n\t\t},\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_BOOKMARK, this.bookmark.id)\n\t\t},\n\t\tonMove() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonCopy() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tasync onRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.bookmark.title = title\n\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tonSelect() {\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.ADD_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark\n\t\t\t\t)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.REMOVE_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark\n\t\t\t\t)\n\t\t\t}\n\t\t},\n\t\tonClick() {\n\t\t\tif (this.bookmark.url.startsWith('file:')) {\n\t\t\t\tthis.$store.commit(mutations.SET_ERROR, 'Most browsers will not allow clicking on file links. Try copying the URL')\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.CLICK_BOOKMARK, this.bookmark)\n\t\t},\n\t\tonCopyUrl() {\n\t\t\tnavigator.clipboard.writeText(this.bookmark.target)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, this.t('bookmarks', 'Link copied to clipboard'))\n\t\t},\n\t\tasync fetchBackgroundImage() {\n\t\t\tif (this.colorMainBackground === '#ffffff') {\n\t\t\t\tthis.backgroundImage = 'var(--icon-link-000) no-repeat center 25% / 50% !important'\n\t\t\t} else {\n\t\t\t\tthis.backgroundImage = 'var(--icon-link-fff) no-repeat center 25% / 50% !important'\n\t\t\t}\n\t\t\ttry {\n\t\t\t\tconst response = await axios.get(this.imageUrl, { responseType: 'blob' })\n\t\t\t\tconst url = URL.createObjectURL(response.data)\n\t\t\t\tthis.backgroundImage = `linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url('${url}')`\n\t\t\t} catch (e) {\n\t\t\t\tif (this.colorMainBackground === '#ffffff') {\n\t\t\t\t\tthis.backgroundImage = 'var(--icon-link-000) no-repeat center 25% / 50% !important'\n\t\t\t\t} else {\n\t\t\t\t\tthis.backgroundImage = 'var(--icon-link-fff) no-repeat center 25% / 50% !important'\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n\n.bookmark__title > h3 {\n\tmargin: 0;\n}\n\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 24px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 15px;\n}\n\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n}\n\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n\n.item--gridview .bookmark__icon {\n\tmargin: 0 5px 0 8px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},36946:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmark-content {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tright: max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1499;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n","",{version:3,sources:["webpack://./src/components/BookmarkContent.vue"],names:[],mappings:";AAmEA;CACA,kBAAA;CACA,MAAA;CACA,OAAA;CACA,oCAAA,EAAA,aAAA;CACA,SAAA;CACA,wCAAA;CACA,aAAA;CACA,aAAA;CACA,gBAAA;CACA,sBAAA;AACA;AAEA;CACA,iBAAA;CACA,YAAA;CACA,eAAA;CACA,mBAAA;CACA,kBAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,kBAAA;CACA,gBAAA;CACA,WAAA;AACA;AAEA;CACA,YAAA;CACA,WAAA;AACA;AAEA;CACA,2BAAA;AACA;AAEA;;CAEA,qCAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div v-if=\"isActive && hasMinLength && !archivedFile && isWebLink\" class=\"bookmark-content\">\n\t\t<div v-if=\"bookmark.textContent\" class=\"content\" v-html=\"content\" />\n\t\t<div v-else>\n\t\t\t<NcEmptyContent :title=\"t('bookmarks', 'Content pending')\"\n\t\t\t\t:description=\"t('bookmarks', 'This content is being downloaded for offline use. Please check back later.')\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DownloadIcon />\n\t\t\t\t</template>\n\t\t\t</NcEmptyContent>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport DownloadIcon from 'vue-material-design-icons/Download.vue'\nimport sanitizeHtml from 'sanitize-html'\nimport { generateUrl, generateRemoteUrl } from '@nextcloud/router'\nimport { NcEmptyContent } from '@nextcloud/vue'\n\nconst MIN_TEXT_LENGTH = 350\n\nexport default {\n\tname: 'BookmarkContent',\n\tcomponents: { NcEmptyContent, DownloadIcon },\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === 'bookmark'\n\t\t},\n\t\tisWebLink() {\n\t\t\treturn this.bookmark.url.startsWith('http')\n\t\t},\n\t\tbookmark() {\n\t\t\tif (!this.isActive) return\n\t\t\treturn this.$store.getters.getBookmark(this.$store.state.sidebar.id)\n\t\t},\n\t\thasMinLength() {\n\t\t\treturn !this.bookmark.textContent || this.bookmark.textContent.length >= MIN_TEXT_LENGTH\n\t\t},\n\t\tcontent() {\n\t\t\treturn sanitizeHtml(this.bookmark.htmlContent, {\n\t\t\t\tallowProtocolRelative: false,\n\t\t\t})\n\t\t},\n\t\tarchivedFileUrl() {\n\t\t\t// remove `/username/files/`\n\t\t\tconst barePath = this.bookmark.archivedFilePath.split('/').slice(3).join('/')\n\t\t\treturn generateRemoteUrl(`webdav/${barePath}`)\n\t\t},\n\t\tarchivedFile() {\n\t\t\tif (this.bookmark.archivedFile) {\n\t\t\t\treturn generateUrl(`/apps/files/?fileid=${this.bookmark.archivedFile}`)\n\t\t\t}\n\t\t\treturn null\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.bookmark-content {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tright: max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1499;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n</style>\n"],sourceRoot:""}]);const s=a},75:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmarkslist__description {\n\twidth: 100%;\n\tmargin: 10px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n","",{version:3,sources:["webpack://./src/components/BookmarksList.vue"],names:[],mappings:";AAoKA;CACA,WAAA;CACA,iBAAA;CACA,YAAA;CACA,cAAA;CACA,kBAAA;AACA;AAEA;;;;CAIA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,mCAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class="{\n\t\tbookmarkslist: true,\n\t\t\'bookmarkslist--gridview\': viewMode === \'grid\'\n\t}">\n\t\t<div v-if="$route.name === routes.ARCHIVED && bookmarks.length" class="bookmarkslist__description">\n\t\t\t{{\n\t\t\t\tt(\'bookmarks\', \'Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.\')\n\t\t\t}}\n\t\t</div>\n\t\t<div v-if="$route.name === routes.UNAVAILABLE && bookmarks.length" class="bookmarkslist__description">\n\t\t\t{{\n\t\t\t\tt(\'bookmarks\', \'Bookmarked links are checked regularly and the ones that cannot be reached are listed here.\')\n\t\t\t}}\n\t\t</div>\n\t\t<div v-if="$route.name === routes.SHARED_FOLDERS && bookmarks.length" class="bookmarkslist__description">\n\t\t\t{{\n\t\t\t\tt(\'bookmarks\', \'You can share bookmark folders with others. All folders shared with you are listed here.\')\n\t\t\t}}\n\t\t</div>\n\t\t<div v-if="$route.name === routes.DUPLICATED && bookmarks.length" class="bookmarkslist__description">\n\t\t\t{{\n\t\t\t\tt(\'bookmarks\', \'One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.\')\n\t\t\t}}\n\t\t</div>\n\t\t<VirtualScroll :reached-end="reachedEnd" @load-more="loadMore">\n\t\t\t<CreateBookmark v-if="newBookmark" />\n\t\t\t<CreateFolder v-if="newFolder" />\n\t\t\t<template v-if="$route.name === routes.FOLDER || $route.name === routes.HOME">\n\t\t\t\t\x3c!-- FOLDER VIEW WITH CUSTOM SORTING --\x3e\n\t\t\t\t<template v-if="sortOrder === \'index\' && children.length">\n\t\t\t\t\t<template v-for="item in children">\n\t\t\t\t\t\t<Folder v-if="item.type === \'folder\' && getFolder(item.id)"\n\t\t\t\t\t\t\t:key="item.type + item.id"\n\t\t\t\t\t\t\t:folder="getFolder(item.id)" />\n\t\t\t\t\t\t<Bookmark v-if="item.type === \'bookmark\' && getBookmark(item.id)"\n\t\t\t\t\t\t\t:key="item.type + item.id"\n\t\t\t\t\t\t\t:bookmark="getBookmark(item.id)" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t\x3c!-- FOLDER VIEW WITH NORMAL SORTING --\x3e\n\t\t\t\t<template v-else-if="(subFolders.length || bookmarks.length) && !loading">\n\t\t\t\t\t<Folder v-for="folder in subFolders"\n\t\t\t\t\t\t:key="\'folder\' + folder.id"\n\t\t\t\t\t\t:folder="folder" />\n\t\t\t\t\t<template v-if="bookmarks.length">\n\t\t\t\t\t\t<Bookmark v-for="bookmark in bookmarks"\n\t\t\t\t\t\t\t:key="\'bookmark\' + bookmark.id"\n\t\t\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t<NoBookmarks v-else-if="!loading && (allBookmarksCount > 0 || isPublic)" />\n\t\t\t\t<FirstRun v-else-if="!loading" />\n\t\t\t</template>\n\t\t\t\x3c!-- NON-FOLDER VIEW --\x3e\n\t\t\t<template v-else-if="subFolders.length || bookmarks.length">\n\t\t\t\t<Folder v-for="folder in subFolders"\n\t\t\t\t\t:key="\'folder\' + folder.id"\n\t\t\t\t\t:folder="folder" />\n\t\t\t\t<Bookmark v-for="bookmark in bookmarks"\n\t\t\t\t\t:key="\'bookmark\' + bookmark.id"\n\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t</template>\n\t\t\t<NoBookmarks v-else-if="!loading && (allBookmarksCount > 0 || isPublic)" />\n\t\t\t<FirstRun v-else-if="!loading" />\n\t\t</VirtualScroll>\n\t</div>\n</template>\n\n<script>\nimport Bookmark from \'./Bookmark.vue\'\nimport Folder from \'./Folder.vue\'\nimport CreateBookmark from \'./CreateBookmark.vue\'\nimport CreateFolder from \'./CreateFolder.vue\'\nimport { actions, mutations } from \'../store/index.js\'\nimport NoBookmarks from \'./NoBookmarks.vue\'\nimport FirstRun from \'./FirstRun.vue\'\nimport VirtualScroll from \'./VirtualScroll.vue\'\nimport { privateRoutes } from \'../router.js\'\n\nexport default {\n\tname: \'BookmarksList\',\n\tcomponents: {\n\t\tCreateFolder,\n\t\tCreateBookmark,\n\t\tVirtualScroll,\n\t\tFirstRun,\n\t\tNoBookmarks,\n\t\tBookmark,\n\t\tFolder,\n\t},\n\tcomputed: {\n\t\tbookmarks() {\n\t\t\treturn this.$store.state.bookmarks\n\t\t},\n\t\treachedEnd() {\n\t\t\treturn this.$store.state.fetchState.reachedEnd\n\t\t},\n\t\tallBookmarksCount() {\n\t\t\treturn this.$store.state.countsByFolder[-1]\n\t\t},\n\t\tchildren() {\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\treturn this.$store.getters.getFolderChildren(folderId)\n\t\t},\n\t\tsubFolders() {\n\t\t\tif (this.$route.name === this.routes.SHARED_FOLDERS) {\n\t\t\t\treturn Object.keys(this.$store.state.sharedFoldersById)\n\t\t\t\t\t.map(folderId => this.$store.getters.getFolder(folderId)[0])\n\t\t\t}\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\tconst folder = this.$store.getters.getFolder(folderId)[0]\n\t\t\tif (!folder) return []\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, folderId)\n\t\t\treturn folder.children\n\t\t},\n\t\tnewBookmark() {\n\t\t\treturn this.$store.state.displayNewBookmark\n\t\t},\n\t\tnewFolder() {\n\t\t\treturn this.$store.state.displayNewFolder\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tsortOrder() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.bookmarks || this.$store.state.loading.folders\n\t\t},\n\t},\n\tmethods: {\n\t\tloadMore() {\n\t\t\tif (this.$route.name === privateRoutes.SHARED_FOLDERS) {\n\t\t\t\tthis.$store.commit(mutations.REACHED_END)\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.FETCH_PAGE)\n\t\t},\n\t\tgetFolder(id) {\n\t\t\treturn this.$store.getters.getFolder(id)[0]\n\t\t},\n\t\tgetBookmark(id) {\n\t\t\treturn this.$store.getters.getBookmark(id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmarkslist__description {\n\twidth: 100%;\n\tmargin: 10px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n</style>\n'],sourceRoot:""}]);const s=a},43328:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n\tmin-width: 500px;\n}\n","",{version:3,sources:["webpack://./src/components/BulkEditing.vue"],names:[],mappings:";AAoKA;CACA,qBAAA;CACA,qBAAA;CACA,eAAA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bulkediting\">\n\t\t<NcActions :primary=\"true\" :menu-title=\"selectionDescription\">\n\t\t\t<NcActionButton close-after-click @click=\"onBulkOpen\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<OpenInNewIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Open all selected') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton close-after-click @click=\"onBulkMove\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Move selection') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton v-if=\"!selectedFolders.length\" close-after-click @click=\"onBulkCopy\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderPlusIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Add to folders') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionInput v-if=\"!selectedFolders.length\"\n\t\t\t\t:value=\"selectionTags\"\n\t\t\t\ttype=\"multiselect\"\n\t\t\t\t:options=\"allTags\"\n\t\t\t\t:multiple=\"true\"\n\t\t\t\t:taggable=\"true\"\n\t\t\t\t@tag=\"onBulkTag([...selectionTags, $event])\"\n\t\t\t\t@input=\"onBulkTag\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<TagIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Edit tags of selection') }}\n\t\t\t</NcActionInput>\n\t\t\t<NcActionButton close-after-click @click=\"onBulkDelete\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DeleteIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Delete selection') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionSeparator />\n\t\t\t<NcActionButton @click=\"onSelectAll\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<SelectAllIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Select all') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton @click=\"onCancelSelection\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<SelectOffIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Cancel selection') }}\n\t\t\t</NcActionButton>\n\t\t</NcActions>\n\t</div>\n</template>\n\n<script>\n\nimport { NcActions, NcActionSeparator, NcActionButton, NcActionInput } from '@nextcloud/vue'\nimport FolderPlusIcon from 'vue-material-design-icons/FolderPlus.vue'\nimport FolderMoveIcon from 'vue-material-design-icons/FolderMove.vue'\nimport OpenInNewIcon from 'vue-material-design-icons/OpenInNew.vue'\nimport TagIcon from 'vue-material-design-icons/Tag.vue'\nimport SelectAllIcon from 'vue-material-design-icons/SelectAll.vue'\nimport SelectOffIcon from 'vue-material-design-icons/SelectOff.vue'\nimport DeleteIcon from 'vue-material-design-icons/Delete.vue'\nimport { actions, mutations } from '../store/index.js'\nimport intersection from 'lodash/intersection.js'\n\nexport default {\n\tname: 'BulkEditing',\n\tcomponents: { NcActionInput, NcActionSeparator, FolderPlusIcon, FolderMoveIcon, NcActionButton, NcActions, OpenInNewIcon, TagIcon, SelectAllIcon, SelectOffIcon, DeleteIcon },\n\tdata() {\n\t\treturn {\n\t\t\tselectionTags: [],\n\t\t}\n\t},\n\tcomputed: {\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'Selected {folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length }\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n bookmark',\n\t\t\t\t\t'Selected %n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n folder',\n\t\t\t\t\t'Selected %n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n\twatch: {\n\t\tselectedBookmarks(bookmarks) {\n\t\t\tthis.updateSelectionTags()\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onBulkOpen() {\n\t\t\tfor (const { url } of this.$store.state.selection.bookmarks) {\n\t\t\t\twindow.open(url)\n\t\t\t\tawait new Promise(resolve => setTimeout(resolve, 200))\n\t\t\t}\n\t\t},\n\t\tasync onBulkDelete() {\n\t\t\tif (!confirm(t('bookmarks', 'Do you really want to delete these items?'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tawait this.$store.dispatch(actions.DELETE_SELECTION, { folder: this.$route.params.folder })\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonBulkMove() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonBulkCopy() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onBulkTag(tags) {\n\t\t\tconst originalTags = this.selectionTags\n\t\t\tthis.selectionTags = tags\n\t\t\tawait this.$store.dispatch(actions.TAG_SELECTION, { tags, originalTags })\n\t\t},\n\t\tonCancelSelection() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tasync onSelectAll() {\n\t\t\tawait this.$store.dispatch(actions.FETCH_ALL)\n\t\t\tthis.$store.state.bookmarks.forEach(bookmark => {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, bookmark)\n\t\t\t})\n\t\t},\n\t\tupdateSelectionTags() {\n\t\t\tthis.selectionTags = intersection(...this.selectedBookmarks.map((bm) => bm.tags))\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n\tmin-width: 500px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},24750:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.controls {\n\tpadding: 4px 8px 0 44px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tborder-bottom: var(--color-border) 1px solid;\n}\n.controls h2 {\n\tmargin: 0;\n\tmargin-left: 10px;\n\tmargin-right: 10px;\n\tdisplay: flex;\n\tflex-shrink: 0;\n}\n.controls h2 :nth-child(2) {\n\tmargin-left: 5px;\n}\n.controls .action-item {\n\theight: 45px;\n}\n.controls.wide {\n\tpadding: 0 8px;\n}\n.controls .custom-button:hover,\n.controls .custom-button:active {\n\tbackground-color: var(--color-background-hover);\n}\n.controls + * {\n\tmargin-top: 50px;\n}\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n.controls__right > * {\n\tmin-width: 30px;\n}\n.controls__right .inline-search {\n\tmax-width: 150px !important;\n\tposition: relative;\n\ttop: 4px;\n}\n","",{version:3,sources:["webpack://./src/components/Controls.vue"],names:[],mappings:";AAkTA;CACA,uBAAA;CACA,aAAA;CACA,kBAAA;CACA,YAAA;CACA,oDAAA;CACA,OAAA;CACA,QAAA;CACA,MAAA;CACA,4CAAA;AACA;AAEA;CACA,SAAA;CACA,iBAAA;CACA,kBAAA;CACA,aAAA;CACA,cAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,cAAA;AACA;AAEA;;CAEA,+CAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,OAAA;AACA;AAEA;CACA,YAAA;CACA,OAAA;AACA;AAEA;CACA,OAAA;CACA,aAAA;CACA,2BAAA;CACA,UAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;CACA,2BAAA;CACA,kBAAA;CACA,QAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class=\"['controls', $store.state.public && 'wide']\">\n\t\t<div class=\"controls__left\">\n\t\t\t<NcActions v-if=\"$route.name === routes.FOLDER\">\n\t\t\t\t<NcActionButton @click=\"onClickBack\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ArrowLeftIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Go back') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<template v-if=\"$route.name === routes.FOLDER\">\n\t\t\t\t<h2><FolderIcon /> <span>{{ folder.title }}</span></h2>\n\t\t\t\t<NcActions v-if=\"permissions.canShare\">\n\t\t\t\t\t<NcActionButton :close-after-click=\"true\" @click=\"onOpenFolderShare\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ShareVariantIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t{{ t('bookmarks', 'Share folder') }}\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t</template>\n\t\t\t<template v-if=\"$route.name === routes.TAGS\">\n\t\t\t\t<TagIcon />\n\t\t\t\t<NcMultiselect class=\"controls__tags\"\n\t\t\t\t\t:value=\"tags\"\n\t\t\t\t\t:auto-limit=\"false\"\n\t\t\t\t\t:limit=\"7\"\n\t\t\t\t\t:options=\"allTags\"\n\t\t\t\t\t:multiple=\"true\"\n\t\t\t\t\t:placeholder=\"t('bookmarks', 'Select one or more tags')\"\n\t\t\t\t\t@input=\"onTagsChange\" />\n\t\t\t</template>\n\t\t\t<NcActions v-if=\"!isPublic\"\n\t\t\t\tv-tooltip=\"t('bookmarks', 'New')\"\n\t\t\t\t:title=\"t('bookmarks', 'New')\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PlusIcon />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddBookmark\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<EarthIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{\n\t\t\t\t\t\tt('bookmarks', 'New bookmark')\n\t\t\t\t\t}}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddFolder\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<FolderIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'New folder') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<BulkEditing v-if=\"hasSelection\" />\n\t\t</div>\n\t\t<div class=\"controls__right\">\n\t\t\t<NcActions>\n\t\t\t\t<NcActionButton @click=\"onToggleViewMode\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ViewListIcon v-if=\"viewMode !== 'list'\" />\n\t\t\t\t\t\t<ViewGridIcon v-else />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ viewMode === 'list' ? t('bookmarks', 'Change to grid view') : t('bookmarks', 'Change to list view') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcActions v-tooltip=\"sortingOptions[sorting].description\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<component :is=\"sortingOptions[sorting].icon\" :size=\"20\" :fill-color=\"colorMainText\" />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton v-for=\"(option, key) in sortingOptions\"\n\t\t\t\t\t:key=\"key\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"onChangeSorting(key)\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<component :is=\"option.icon\"\n\t\t\t\t\t\t\t:fill-color=\"key === sorting? colorPrimaryElement : colorMainText\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ option.description }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcActions force-menu>\n\t\t\t\t<template #icon>\n\t\t\t\t\t<RssIcon />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton :title=\"t('bookmarks', 'Copy RSS Feed of current view')\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"copyRssUrl\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<RssIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ !$store.state.public? t('bookmarks', 'The RSS feed requires authentication with your Nextcloud credentials') : '' }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcTextField\n\t\t\t\t:value.sync=\"search\"\n\t\t\t\t:label=\"t('bookmarks','Search')\"\n\t\t\t\t:placeholder=\"t('bookmarks','Search')\"\n\t\t\t\tclass=\"inline-search\"\n\t\t\t\t@update:value=\"onSearch($event)\">\n\t\t\t\t<MagnifyIcon />\n\t\t\t</NcTextField>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport { NcMultiselect, NcActions, NcActionButton, NcActionInput, NcActionRouter, NcTextField } from '@nextcloud/vue'\nimport MagnifyIcon from 'vue-material-design-icons/Magnify.vue'\nimport EarthIcon from 'vue-material-design-icons/Earth.vue'\nimport ViewGridIcon from 'vue-material-design-icons/ViewGrid.vue'\nimport ViewListIcon from 'vue-material-design-icons/ViewList.vue'\nimport PlusIcon from 'vue-material-design-icons/Plus.vue'\nimport FolderIcon from 'vue-material-design-icons/Folder.vue'\nimport ArrowLeftIcon from 'vue-material-design-icons/ArrowLeft.vue'\nimport RssIcon from 'vue-material-design-icons/Rss.vue'\nimport SortAlphabeticalAscendingIcon from 'vue-material-design-icons/SortAlphabeticalAscending.vue'\nimport SortBoolAscendingIcon from 'vue-material-design-icons/SortBoolAscending.vue'\nimport SortClockAscendingOutlineIcon from 'vue-material-design-icons/SortClockAscendingOutline.vue'\nimport SortCalendarAscendingIcon from 'vue-material-design-icons/SortCalendarAscending.vue'\nimport SortNumericAscendingIcon from 'vue-material-design-icons/SortNumericAscending.vue'\nimport SortAscendingIcon from 'vue-material-design-icons/SortAscending.vue'\nimport ShareVariantIcon from 'vue-material-design-icons/ShareVariant.vue'\nimport TagIcon from 'vue-material-design-icons/Tag.vue'\nimport { actions, mutations } from '../store/index.js'\nimport { generateUrl } from '@nextcloud/router'\nimport BulkEditing from './BulkEditing.vue'\n\nexport default {\n\tname: 'Controls',\n\tcomponents: {\n\t\tBulkEditing,\n\t\tNcMultiselect,\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tNcActionInput,\n\t\tNcActionRouter,\n\t\tRssIcon,\n\t\tSortAscendingIcon,\n\t\tSortCalendarAscendingIcon,\n\t\tSortAlphabeticalAscendingIcon,\n\t\tSortClockAscendingOutlineIcon,\n\t\tSortBoolAscendingIcon,\n\t\tSortNumericAscendingIcon,\n\t\tFolderIcon,\n\t\tArrowLeftIcon,\n\t\tPlusIcon,\n\t\tViewGridIcon,\n\t\tViewListIcon,\n\t\tEarthIcon,\n\t\tShareVariantIcon,\n\t\tTagIcon,\n\t\tNcTextField,\n\t\tMagnifyIcon,\n\t},\n\tprops: {},\n\tdata() {\n\t\treturn {\n\t\t\turl: '',\n\t\t\tsearch: this.$route.params.search || '',\n\t\t\tsortingOptions: {\n\t\t\t\tadded: { icon: 'SortCalendarAscendingIcon', description: this.t('bookmarks', 'Sort by created date') },\n\t\t\t\tlastmodified: { icon: 'SortClockAscendingOutlineIcon', description: this.t('bookmarks', 'Sort by last modified') },\n\t\t\t\ttitle: { icon: 'SortAlphabeticalAscendingIcon', description: this.t('bookmarks', 'Sort by title') },\n\t\t\t\tclickcount: { icon: 'SortBoolAscendingIcon', description: this.t('bookmarks', 'Sort by click count') },\n\t\t\t\tindex: { icon: 'SortAscendingIcon', description: this.t('bookmarks', 'Sort by manual order') },\n\t\t\t\turl: { icon: 'SortNumericAscendingIcon', description: this.t('bookmarks', 'Sort by URL') },\n\t\t\t},\n\t\t}\n\t},\n\tcomputed: {\n\t\tbackLink() {\n\t\t\tif (this.folder && this.folderPath.length > 1) {\n\t\t\t\treturn { name: this.routes.FOLDER, params: { folder: this.folder.parent_folder } }\n\t\t\t}\n\n\t\t\treturn { name: this.routes.HOME }\n\t\t},\n\t\tpermissions() {\n\t\t\tconst folder = this.folder\n\t\t\tif (!folder) {\n\t\t\t\treturn {}\n\t\t\t}\n\t\t\treturn this.$store.getters.getPermissionsForFolder(folder.id)\n\t\t},\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\ttags() {\n\t\t\tconst tags = this.$route.params.tags\n\t\t\tif (!tags) return []\n\t\t\treturn tags.split(',')\n\t\t},\n\t\tfolderPath() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return []\n\t\t\treturn this.$store.getters.getFolder(folder).reverse()\n\t\t},\n\t\tfolder() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return\n\t\t\treturn this.$store.getters.getFolder(folder)[0]\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\thasSelection() {\n\t\t\treturn this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length\n\t\t},\n\t\trssURL() {\n\t\t\tconst params = new URLSearchParams()\n\t\t\tfor (const field in this.$store.state.fetchState.query) {\n\t\t\t\tif (Array.isArray(this.$store.state.fetchState.query[field])) {\n\t\t\t\t\tthis.$store.state.fetchState.query[field].forEach(value => {\n\t\t\t\t\t\tparams.append(field + '[]', value)\n\t\t\t\t\t})\n\t\t\t\t} else {\n\t\t\t\t\tparams.append(field, this.$store.state.fetchState.query[field])\n\t\t\t\t}\n\t\t\t}\n\t\t\tparams.set('format', 'rss')\n\t\t\tparams.set('page', '-1')\n\t\t\tif (this.$store.state.public) {\n\t\t\t\tparams.set('token', this.$store.state.authToken)\n\t\t\t}\n\t\t\treturn (\n\t\t\t\twindow.location.origin\n\t\t\t\t\t+ generateUrl(\n\t\t\t\t\t\t'/apps/bookmarks/public/rest/v2/bookmark?'\n\t\t\t\t\t\t\t+ params.toString()\n\t\t\t\t\t)\n\t\t\t)\n\t\t},\n\t\tsorting() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tonSelectHome() {\n\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t},\n\n\t\tonClickBack() {\n\t\t\tthis.$router.push(this.backLink)\n\t\t},\n\n\t\tonTagsChange(tags) {\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tags.join(',') } })\n\t\t},\n\n\t\tonSelectFolder(folder) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder } })\n\t\t},\n\n\t\tonOpenFolderShare() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\n\t\tonAddFolder() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\t!this.$store.state.displayNewFolder\n\t\t\t)\n\t\t},\n\t\tonAddBookmark() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\t!this.$store.state.displayNewBookmark\n\t\t\t)\n\t\t},\n\n\t\tonToggleViewMode() {\n\t\t\tthis.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'viewMode',\n\t\t\t\tvalue: this.$store.state.viewMode === 'grid' ? 'list' : 'grid',\n\t\t\t})\n\t\t},\n\n\t\tonSearch(query) {\n\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search: query } })\n\t\t},\n\n\t\tcopyRssUrl() {\n\t\t\tnavigator.clipboard.writeText(this.rssURL)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'RSS feed copied'))\n\t\t},\n\n\t\tasync onChangeSorting(value) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'sorting',\n\t\t\t\tvalue,\n\t\t\t})\n\t\t\tawait this.$store.dispatch(actions.FETCH_PAGE)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.controls {\n\tpadding: 4px 8px 0 44px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tborder-bottom: var(--color-border) 1px solid;\n}\n\n.controls h2 {\n\tmargin: 0;\n\tmargin-left: 10px;\n\tmargin-right: 10px;\n\tdisplay: flex;\n\tflex-shrink: 0;\n}\n\n.controls h2 :nth-child(2) {\n\tmargin-left: 5px;\n}\n\n.controls .action-item {\n\theight: 45px;\n}\n\n.controls.wide {\n\tpadding: 0 8px;\n}\n\n.controls .custom-button:hover,\n.controls .custom-button:active {\n\tbackground-color: var(--color-background-hover);\n}\n\n.controls + * {\n\tmargin-top: 50px;\n}\n\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n\n.controls__right > * {\n\tmin-width: 30px;\n}\n\n.controls__right .inline-search {\n\tmax-width: 150px !important;\n\tposition: relative;\n\ttop: 4px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},2828:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.icon[data-v-2b4ea42e] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-2b4ea42e] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://./src/components/CreateBookmark.vue"],names:[],mappings:";AAyDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a link\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<EarthIcon :fill-color="colorMainText" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport EarthIcon from \'vue-material-design-icons/Earth.vue\'\nimport Item from \'./Item.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'CreateBookmark\',\n\tcomponents: { Item, EarthIcon },\n\tcomputed: {\n\t\tcreating() {\n\t\t\treturn this.$store.state.loading.createBookmark\n\t\t},\n\t\tisFolderView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().FOLDER\n\t\t},\n\t\tisTagView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().TAGS\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(url) {\n\t\t\tthis.$store.dispatch(actions.CREATE_BOOKMARK, {\n\t\t\t\turl,\n\t\t\t\t...(this.isFolderView && { folders: [this.$route.params.folder] }),\n\t\t\t\t...(this.isTagView && { tags: this.$route.params.tags.split(\',\') }),\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\tfalse\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const s=a},31656:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.icon[data-v-47929df1] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-47929df1] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://./src/components/CreateFolder.vue"],names:[],mappings:";AAmDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a title\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<FolderIcon :fill-color="colorPrimaryElement" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport Item from \'./Item.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'CreateFolder\',\n\tcomponents: { Item, FolderIcon },\n\tcomputed: {\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.createFolder\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(title) {\n\t\t\tconst parentFolder = this.$route.params.folder\n\t\t\tthis.$store.dispatch(actions.CREATE_FOLDER, {\n\t\t\t\tparentFolder,\n\t\t\t\ttitle,\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\tfalse\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const s=a},83469:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.dragImage[data-v-4fd4b205] {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n.dragImage .description[data-v-4fd4b205] {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-left: 3px;\n}\n","",{version:3,sources:["webpack://./src/components/DragImage.vue"],names:[],mappings:";AAsDA;CACA,wCAAA;CACA,qCAAA;CACA,oCAAA;CACA,yCAAA;CACA,YAAA;CACA,aAAA;CACA,aAAA;CACA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,uBAAA;CACA,gBAAA;CACA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"dragImage\">\n\t\t<FolderIcon v-if=\"$store.state.selection.folders.length\" :fill-color=\"colorPrimaryElement\" />\n\t\t<EarthIcon v-else :fill-color=\"colorPrimaryElement\" /><span class=\"description\">{{ selectionDescription }}</span>\n\t</div>\n</template>\n\n<script>\nimport FolderIcon from 'vue-material-design-icons/Folder.vue'\nimport EarthIcon from 'vue-material-design-icons/Earth.vue'\nexport default {\n\tname: 'DragImage',\n\tcomponents: { FolderIcon, EarthIcon },\n\tcomputed: {\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'{folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length }\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.bookmarks[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n bookmark',\n\t\t\t\t\t'%n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.folders.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.folders[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n folder',\n\t\t\t\t\t'%n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n.dragImage {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.dragImage .description {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-left: 3px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},60466:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmarkslist__emptyBookmarks[data-v-0526fb54] {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n.import[data-v-0526fb54] {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\nbutton[data-v-0526fb54] {\n\tmargin-bottom: 15px;\n}\n","",{version:3,sources:["webpack://./src/components/FirstRun.vue"],names:[],mappings:";AAqFA;CACA,YAAA;CACA,cAAA;AACA;AAEA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,aAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bookmarkslist__emptyBookmarks\">\n\t\t<NcEmptyContent :title=\"t('bookmarks', 'Welcome to Bookmarks')\" :description=\"t('bookmarks', 'This app allows you to manage links to your favorite places on the web. Sort your bookmarks into folders, label them with tags and share them with others! The app will regularly check all your links for availability and display unavailable links. If you add a link to a file on the web, the file will be automatically downloaded to your Nextcloud Files. You can also import bookmarks exported from other services or directly sync bookmarks from all your browsers with this app.')\">\n\t\t\t<template #icon>\n\t\t\t\t<StarShootingIcon />\n\t\t\t</template>\n\t\t\t<template #action>\n\t\t\t\t<input ref=\"import\"\n\t\t\t\t\ttype=\"file\"\n\t\t\t\t\tclass=\"import\"\n\t\t\t\t\tsize=\"5\"\n\t\t\t\t\t@change=\"onImportSubmit\">\n\t\t\t\t<NcButton @click=\"onCreateOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<PlusIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Add a bookmark') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click=\"onImportOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<UploadIcon v-if=\"!importing\" />\n\t\t\t\t\t\t<NcLoadingIcon v-else />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Import bookmarks') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click=\"onSyncOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<SyncIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Sync with your browser') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t</div>\n</template>\n\n<script>\nimport { NcEmptyContent, NcButton, NcLoadingIcon } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport { privateRoutes } from '../router.js'\nimport SyncIcon from 'vue-material-design-icons/Sync.vue'\nimport PlusIcon from 'vue-material-design-icons/Plus.vue'\nimport UploadIcon from 'vue-material-design-icons/Upload.vue'\nimport StarShootingIcon from 'vue-material-design-icons/StarShooting.vue'\n\nexport default {\n\tname: 'FirstRun',\n\tcomponents: { NcEmptyContent, SyncIcon, NcButton, PlusIcon, UploadIcon, NcLoadingIcon, StarShootingIcon },\n\tdata() {\n\t\treturn { importing: false }\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn privateRoutes\n\t\t},\n\t},\n\tmethods: {\n\t\tonCreateOpen() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_NEW_BOOKMARK, true)\n\t\t},\n\t\tonImportOpen() {\n\t\t\tthis.$refs.import.click()\n\t\t},\n\t\tonSyncOpen() {\n\t\t\twindow.open('https://floccus.org', '_blank')\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.bookmarkslist__emptyBookmarks {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n\nbutton {\n\tmargin-bottom: 15px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},89770:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.folder__icon.shared {\n\ttransform: scale(0.4);\n\tposition: absolute;\n\ttop: -1px;\n\theight: auto;\n\twidth: auto;\n\tleft: -2px;\n}\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n.item--gridview .folder__icon.shared {\n\ttransform: translate(87%, 110%) scale(1.5);\n}\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n}\n.item--gridview .folder__title {\n\tmargin-left: 15px;\n}\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n}\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-primary-element-light);\n}\n","",{version:3,sources:["webpack://./src/components/Folder.vue"],names:[],mappings:";AA8NA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,qBAAA;CACA,kBAAA;CACA,SAAA;CACA,YAAA;CACA,WAAA;CACA,UAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA;AAEA;CACA,0CAAA;AACA;AAEA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,mBAAA;CACA,eAAA;CACA,SAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,UAAA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,iBAAA;CACA,oDAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :active="selected"\n\t\t:editable="isEditable"\n\t\t:draggable="isEditable"\n\t\t:selected="selected"\n\t\t:title="folder.title"\n\t\t:renaming="renaming"\n\t\t:select-label="t(\'bookmarks\', \'Select folder\')"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter folder title\')"\n\t\t:selectable="selectable"\n\t\t:allow-drop="allowDrop"\n\t\t@drop="onDrop"\n\t\t@select="clickSelect"\n\t\t@rename="onRenameSubmit"\n\t\t@rename-cancel="renaming = false"\n\t\t@click="onSelect">\n\t\t<template #icon>\n\t\t\t<FolderIcon :fill-color="colorPrimaryElement" :class="\'folder__icon\'" @click="onSelect" />\n\t\t\t<ShareVariantIcon v-if="(isShared || !isOwner) || isSharedPublicly"\n\t\t\t\t:fill-color="colorPrimaryText"\n\t\t\t\t:class="[\'folder__icon\', \'shared\']" />\n\t\t</template>\n\t\t<template #title>\n\t\t\t<h3 class="folder__title">\n\t\t\t\t{{ folder.title }}\n\t\t\t</h3>\n\t\t</template>\n\t\t<template #tags>\n\t\t\t<div class="folder__tags">\n\t\t\t\t<div v-if="!isOwner && !isSharedPublicly" class="folder__tag">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Shared by {user}\', {user: folder.userDisplayName}) }}\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</template>\n\t\t<template #actions>\n\t\t\t<NcActionButton :close-after-click="true" @click="onDetails">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<InformationVariantIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Details\') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionCheckbox @change="clickSelect">\n\t\t\t\t{{ t(\'bookmarks\', \'Select folder\') }}\n\t\t\t</NcActionCheckbox>\n\t\t\t<NcActionButton v-if="permissions.canShare"\n\t\t\t\ticon="icon-share"\n\t\t\t\t:close-after-click="true"\n\t\t\t\t@click="onShare">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<ShareVariantIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Share folder\') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click="true" @click="onRename">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PencilIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Rename folder\') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click="true" @click="onMove">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon :fill-color="colorMainText" />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Move folder\') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton :close-after-click="true" @click="onDelete">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DeleteIcon />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Delete folder\') }}\n\t\t\t</NcActionButton>\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport FolderMoveIcon from \'vue-material-design-icons/FolderMove.vue\'\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport ShareVariantIcon from \'vue-material-design-icons/ShareVariant.vue\'\nimport DeleteIcon from \'vue-material-design-icons/Delete.vue\'\nimport PencilIcon from \'vue-material-design-icons/Pencil.vue\'\nimport InformationVariantIcon from \'vue-material-design-icons/InformationVariant.vue\'\nimport { NcActionButton, NcActionCheckbox } from \'@nextcloud/vue\'\nimport { actions, mutations } from \'../store/index.js\'\nimport Item from \'./Item.vue\'\n\nexport default {\n\tname: \'Folder\',\n\tcomponents: {\n\t\tItem,\n\t\tNcActionButton,\n\t\tNcActionCheckbox,\n\t\tFolderIcon,\n\t\tFolderMoveIcon,\n\t\tShareVariantIcon,\n\t\tDeleteIcon,\n\t\tPencilIcon,\n\t\tInformationVariantIcon,\n\t},\n\tprops: {\n\t\tfolder: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn { renaming: false }\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tcurrentUser() {\n\t\t\treturn getCurrentUser().uid\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.folder.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForFolder(this.folder.id)\n\t\t},\n\t\tisDirectShare() {\n\t\t\treturn this.$store.state.sharedFoldersById[this.folder.id] !== undefined\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || this.isDirectShare || this.permissions.canWrite\n\t\t},\n\t\tshares() {\n\t\t\treturn this.$store.getters.getSharesOfFolder(this.folder.id)\n\t\t},\n\t\tpublicToken() {\n\t\t\treturn this.$store.getters.getTokenOfFolder(this.folder.id)\n\t\t},\n\t\tisShared() {\n\t\t\treturn Boolean(this.shares.length)\n\t\t},\n\t\tisSharedPublicly() {\n\t\t\treturn Boolean(this.publicToken)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedFolders.map(f => f.id).includes(this.folder.id)\n\t\t},\n\t},\n\tmounted() {\n\t\t// This slows down initial load otherwise and it\'s not directly necessary\n\t\tsetTimeout(() => {\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.LOAD_PUBLIC_LINK, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.COUNT_BOOKMARKS, this.folder.id)\n\t\t}, 2000)\n\t},\n\tmethods: {\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, this.folder.id)\n\t\t},\n\t\tonShare() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\t\tonDelete() {\n\t\t\tif (!confirm(t(\'bookmarks\', \'Do you really want to delete this folder?\'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.DELETE_FOLDER, { id: this.folder.id })\n\t\t},\n\t\tonMove() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonSelect(e) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: this.folder.id } })\n\t\t\te.preventDefault()\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tonRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.folder.title = title\n\t\t\tthis.$store.dispatch(actions.SAVE_FOLDER, this.folder.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tclickSelect(e) {\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(mutations.REMOVE_SELECTION_FOLDER, this.folder)\n\t\t\t}\n\t\t},\n\t\tonEnter(e) {\n\t\t\tif (e.key === \'Enter\') {\n\t\t\t\tthis.onSelect(e)\n\t\t\t}\n\t\t},\n\t\tallowDrop() {\n\t\t\treturn !this.$store.state.selection.folders.includes(this.folder) && (this.$store.state.selection.folders.length || this.$store.state.selection.bookmarks.length)\n\t\t},\n\t\tasync onDrop(e) {\n\t\t\te.preventDefault()\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.MOVE_SELECTION, this.folder.id)\n\t\t\t} finally {\n\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.folder__icon.shared {\n\ttransform: scale(0.4);\n\tposition: absolute;\n\ttop: -1px;\n\theight: auto;\n\twidth: auto;\n\tleft: -2px;\n}\n\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n\n.item--gridview .folder__icon.shared {\n\ttransform: translate(87%, 110%) scale(1.5);\n}\n\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n}\n\n.item--gridview .folder__title {\n\tmargin-left: 15px;\n}\n\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n}\n\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-primary-element-light);\n}\n</style>\n'],sourceRoot:""}]);const s=a},88483:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n.item__rename {\n\tpadding: 0 8px 0 0;\n}\n.item__icon {\n\tposition: relative;\n}\n.item--gridview .item__icon {\n\ttop: -155px;\n\tleft: 110px;\n}\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n.item.dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n.item__checkbox {\n\tdisplay: inline-block;\n}\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n}\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tleft: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n.item__NcActions {\n\tflex: 0;\n}\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n\tright: 10px;\n}\n.item--gridview .item__checkbox input[type='checkbox'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n","",{version:3,sources:["webpack://./src/components/Item.vue"],names:[],mappings:";AAoOA;CACA,4CAAA;CACA,sCAAA;CACA,iCAAA;CACA,8CAAA;CACA,kBAAA;AACA;AAEA;CACA,YAAA;CACA,aAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,yCAAA;AACA;AAEA;;CAEA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,WAAA;CACA,WAAA;AACA;AAEA;CACA,uBAAA;AACA;AAEA;;CAEA,kBAAA;CACA,SAAA;CACA,OAAA;CACA,QAAA;CACA,MAAA;CACA,aAAA;CACA,qBAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;;;CAGA,wCAAA;AACA;AAEA;CACA,0CAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,YAAA;CACA,qBAAA;AACA;AAEA;CACA,aAAA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,cAAA;AACA;AAEA;CACA,WAAA;AACA;AAEA;CACA,kBAAA;CACA,SAAA;CACA,UAAA;CACA,iBAAA;CACA,mCAAA;CACA,8BAAA;AACA;AAEA;CACA,OAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,UAAA;CACA,SAAA;CACA,WAAA;AACA;AAEA;CACA,qBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div v-drop-target="{allow: allowDrop, drop: (e) => $emit(\'drop\', e)}"\n\t\t:class="{\n\t\t\titem: true,\n\t\t\tactive,\n\t\t\t\'item--gridview\': viewMode === \'grid\'\n\t\t}"\n\t\t:style="{ background }"\n\t\t:draggable="draggable && !renaming"\n\t\t@dragstart="onDragStart">\n\t\t<template v-if="!renaming">\n\t\t\t<component :is="url? \'a\' : \'span\'"\n\t\t\t\t:href="url"\n\t\t\t\tclass="item__clickLink"\n\t\t\t\ttabindex="0"\n\t\t\t\ttarget="_blank"\n\t\t\t\t@click="onClick"\n\t\t\t\t@contextmenu="onRightClick">\n\t\t\t\t<div v-if="editable && selectable" ref="checkbox" class="item__checkbox">\n\t\t\t\t\t<input :checked="selected" class="checkbox" type="checkbox"><label v-tooltip="selectLabel"\n\t\t\t\t\t\t:aria-label="selectLabel"\n\t\t\t\t\t\t@click="$event.preventDefault(); $event.stopImmediatePropagation(); $emit(\'select\');" />\n\t\t\t\t</div>\n\t\t\t\t<div class="item__icon">\n\t\t\t\t\t<slot name="icon" />\n\t\t\t\t</div>\n\t\t\t\t<div class="item__labels">\n\t\t\t\t\t<slot name="title" />\n\t\t\t\t\t<slot name="tags">\n\t\t\t\t\t\t<TagLine :tags="tags" />\n\t\t\t\t\t</slot>\n\t\t\t\t</div>\n\t\t\t\t<div v-if="editable && !selected"\n\t\t\t\t\tref="actions"\n\t\t\t\t\tclass="item__NcActions"\n\t\t\t\t\t@click="$event.preventDefault(); $event.stopPropagation()">\n\t\t\t\t\t<NcActions ref="actions">\n\t\t\t\t\t\t<slot name="actions" />\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t</component>\n\t\t</template>\n\t\t<div v-else class="item__rename">\n\t\t\t<slot name="icon" />\n\t\t\t<input ref="input"\n\t\t\t\tv-model="newTitle"\n\t\t\t\ttype="text"\n\t\t\t\t:placeholder="renamePlaceholder"\n\t\t\t\t@keyup.enter="onRenameSubmit">\n\t\t\t<NcActions>\n\t\t\t\t<NcActionButton @click="onRenameSubmit">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<CheckIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Submit\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcActions>\n\t\t\t\t<NcActionButton @click="$emit(\'rename-cancel\')">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<CloseIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Cancel\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport Vue from \'vue\'\nimport { NcActions, NcActionButton } from \'@nextcloud/vue\'\nimport TagLine from \'./TagLine.vue\'\nimport DragImage from \'./DragImage.vue\'\nimport { mutations } from \'../store/index.js\'\nimport CheckIcon from \'vue-material-design-icons/Check.vue\'\nimport CloseIcon from \'vue-material-design-icons/Close.vue\'\n\nexport default {\n\tname: \'Item\',\n\tcomponents: {\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tTagLine,\n\t\tCheckIcon,\n\t\tCloseIcon,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\turl: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\tactive: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\teditable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselected: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tdraggable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tallowDrop: {\n\t\t\ttype: Function,\n\t\t\tdefault: () => false,\n\t\t},\n\t\trenaming: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectLabel: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\trenamePlaceholder: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\tbackground: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\tdefault: undefined,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewTitle: this.title,\n\t\t}\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t},\n\twatch: {\n\t\tasync renaming() {\n\t\t\tif (this.renaming) {\n\t\t\t\tawait Vue.nextTick()\n\t\t\t\tthis.$refs.input.focus()\n\t\t\t}\n\t\t},\n\t},\n\tmounted() {\n\t\tif (typeof this.$refs.input !== \'undefined\') {\n\t\t\tthis.$refs.input.focus()\n\t\t}\n\t},\n\tmethods: {\n\t\tasync onRenameSubmit(event) {\n\t\t\tthis.$emit(\'rename\', this.newTitle)\n\t\t},\n\t\tonClick(e) {\n\t\t\tif (this.$refs.actions === e.target\n\t\t\t\t\t|| (this.$refs.actions && this.$refs.actions.contains(e.target))\n\t\t\t\t\t|| (this.$refs.checkbox\n\t\t\t\t\t\t\t&& (this.$refs.checkbox.contains(e.target) || this.$refs.checkbox === e.target)\n\t\t\t\t\t)) {\n\t\t\t\te.stopImmediatePropagation()\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$emit(\'click\', e)\n\t\t},\n\t\tonRightClick(e) {\n\t\t\tif (this.$refs.actions) {\n\t\t\t\te.preventDefault()\n\t\t\t\tif (this.$refs.actions.openMenu) {\n\t\t\t\t\tthis.$refs.actions.openMenu()\n\t\t\t\t} else if (this.$refs.actions.querySelector) {\n\t\t\t\t\tthis.$refs.actions.querySelector(\'button\').click()\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tasync onDragStart(e) {\n\t\t\tif (!this.draggable || this.renaming) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif (!this.selected) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length) {\n\t\t\t\t\t// If something is already selected not including the current element, reset selection\n\t\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t\t}\n\t\t\t\t// Select the current item\n\t\t\t\tthis.$emit(\'select\')\n\t\t\t\tawait this.$nextTick()\n\t\t\t}\n\t\t\t// Build the drag image\n\t\t\tconst element = document.createElement(\'div\')\n\t\t\tconst placeholder = element.appendChild(document.createElement(\'div\'))\n\t\t\tdocument.body.appendChild(element)\n\t\t\tconst vueInstance = new Vue({ el: placeholder, store: this.$store, render: (h) => h(DragImage) })\n\t\t\tawait vueInstance.$nextTick()\n\n\t\t\t// set drag data and drag image\n\t\t\te.dataTransfer.clearData()\n\t\t\te.dataTransfer.setData(\'text/plain\', JSON.stringify(this.$store.state.selection))\n\t\t\te.dataTransfer.setDragImage(element, 0, 0)\n\n\t\t\t// dispose of drag image element, as the browser only takes a visual snapshot once\n\t\t\tawait new Promise(resolve => setTimeout(resolve, 0))\n\t\t\tdocument.body.removeChild(element)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.item__rename {\n\tpadding: 0 8px 0 0;\n}\n\n.item__icon {\n\tposition: relative;\n}\n\n.item--gridview .item__icon {\n\ttop: -155px;\n\tleft: 110px;\n}\n\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n\n.item.dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n\n.item__checkbox {\n\tdisplay: inline-block;\n}\n\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n}\n\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tleft: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n\n.item__NcActions {\n\tflex: 0;\n}\n\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n\tright: 10px;\n}\n\n.item--gridview .item__checkbox input[type=\'checkbox\'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n</style>\n'],sourceRoot:""}]);const s=a},65535:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmarkslist__emptyBookmarks[data-v-70a527cb] {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n.import[data-v-70a527cb] {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\nbutton[data-v-70a527cb] {\n\tmargin-bottom: 15px;\n}\n","",{version:3,sources:["webpack://./src/components/NoBookmarks.vue"],names:[],mappings:";AA6GA;CACA,YAAA;CACA,cAAA;AACA;AAEA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,aAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bookmarkslist__emptyBookmarks\">\n\t\t<NcEmptyContent v-if=\"$route.name === routes.ARCHIVED\"\n\t\t\t:title=\"t('bookmarks', 'No bookmarked files')\"\n\t\t\t:description=\"t('bookmarks', 'Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.')\">\n\t\t\t<template #icon>\n\t\t\t\t<FileDocumentMultipleIcon />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if=\"$route.name === routes.UNAVAILABLE\"\n\t\t\t:title=\"t('bookmarks', 'No broken links')\"\n\t\t\t:description=\"t('bookmarks', 'Bookmarked links are checked regularly and the ones that cannot be reached are listed here.')\">\n\t\t\t<template #icon>\n\t\t\t\t<LinkVariantOffIcon />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if=\"$route.name === routes.SHARED_FOLDERS\"\n\t\t\t:title=\"t('bookmarks', 'No shared folders')\"\n\t\t\t:description=\"t('bookmarks', 'You can share bookmark folders with others. All folders shared with you are listed here.')\">\n\t\t\t<template #icon>\n\t\t\t\t<ShareVariantIcon />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if=\"$route.name === routes.DUPLICATED\"\n\t\t\t:title=\"t('bookmarks', 'No duplicated bookmarks')\"\n\t\t\t:description=\"t('bookmarks', 'One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.')\">\n\t\t\t<template #icon>\n\t\t\t\t<VectorLinkIcon />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else\n\t\t\t:title=\"t('bookmarks', 'No bookmarks here')\"\n\t\t\t:description=\"t('bookmarks', 'Add bookmarks manually or import bookmarks from a HTML file.')\">\n\t\t\t<template #icon>\n\t\t\t\t<StarShootingIcon />\n\t\t\t</template>\n\t\t\t<template v-if=\"!isPublic\" #action>\n\t\t\t\t<input ref=\"import\"\n\t\t\t\t\ttype=\"file\"\n\t\t\t\t\tclass=\"import\"\n\t\t\t\t\tsize=\"5\"\n\t\t\t\t\t@change=\"onImportSubmit\">\n\t\t\t\t<NcButton @click=\"onCreateOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<PlusIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Add a bookmark') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click=\"onImportOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<UploadIcon v-if=\"!importing\" />\n\t\t\t\t\t\t<NcLoadingIcon v-else />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Import bookmarks') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t</div>\n</template>\n\n<script>\nimport { NcEmptyContent, NcButton, NcLoadingIcon } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport { privateRoutes } from '../router.js'\nimport StarShootingIcon from 'vue-material-design-icons/StarShooting.vue'\nimport UploadIcon from 'vue-material-design-icons/Upload.vue'\nimport PlusIcon from 'vue-material-design-icons/Plus.vue'\nimport ShareVariantIcon from 'vue-material-design-icons/ShareVariant.vue'\nimport VectorLinkIcon from 'vue-material-design-icons/VectorLink.vue'\nimport LinkVariantOffIcon from 'vue-material-design-icons/LinkVariantOff.vue'\nimport FileDocumentMultipleIcon from 'vue-material-design-icons/FileDocumentMultiple.vue'\n\nexport default {\n\tname: 'NoBookmarks',\n\tcomponents: { NcEmptyContent, StarShootingIcon, NcButton, NcLoadingIcon, UploadIcon, PlusIcon, ShareVariantIcon, VectorLinkIcon, LinkVariantOffIcon, FileDocumentMultipleIcon },\n\tdata() {\n\t\treturn { importing: false }\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn privateRoutes\n\t\t},\n\t},\n\tmethods: {\n\t\tonCreateOpen() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_NEW_BOOKMARK, true)\n\t\t},\n\t\tonImportOpen() {\n\t\t\tthis.$refs.import.click()\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.bookmarkslist__emptyBookmarks {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n\nbutton {\n\tmargin-bottom: 15px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},13880:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n","",{version:3,sources:["webpack://./src/components/TagLine.vue"],names:[],mappings:";AAiDA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,iBAAA;CACA,8CAAA;CACA,eAAA;AACA;AAEA;;CAEA,8CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="tagline">\n\t\t<div v-for="tag in tags"\n\t\t\t:key="tag"\n\t\t\tclass="tagline__tag"\n\t\t\trole="button"\n\t\t\t@click="clickTag($event, tag)">\n\t\t\t{{ tag }}\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport { privateRoutes, publicRoutes } from \'../router.js\'\n\nexport default {\n\tname: \'TagLine\',\n\tcomponents: {},\n\tprops: {\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {}\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn this.$store.state.public ? publicRoutes : privateRoutes\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tclickTag(e, tag) {\n\t\t\te.preventDefault()\n\t\t\te.stopImmediatePropagation()\n\t\t\te.stopPropagation()\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tag } })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n</style>\n'],sourceRoot:""}]);const s=a},56497:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.virtual-scroll[data-v-03474f23] {\n\theight: calc(100vh - 50px - 50px - 10px);\n\tposition: relative;\n\toverflow-y: scroll;\n}\n.bookmarkslist--gridview .container-window[data-v-03474f23] {\n\tdisplay: flex;\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n\tpadding-top: 10px;\n}\n","",{version:3,sources:["webpack://./src/components/VirtualScroll.vue"],names:[],mappings:";AAkIA;CACA,wCAAA;CACA,kBAAA;CACA,kBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,eAAA;CACA,oBAAA;CACA,SAAA;CACA,eAAA;CACA,iBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n<script>\nimport ItemSkeleton from './ItemSkeleton.vue'\n\nconst GRID_ITEM_HEIGHT = 200 + 10\nconst GRID_ITEM_WIDTH = 250 + 10\nconst LIST_ITEM_HEIGHT = 45 + 1\n\nexport default {\n\tname: 'VirtualScroll',\n\tprops: {\n\t\treachedEnd: {\n\t\t\ttype: Boolean,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tviewport: { width: 0, height: 0 },\n\t\t\tscrollTop: 0,\n\t\t\tscrollHeight: 500,\n\t\t\tinitialLoadingSkeleton: false,\n\t\t\tinitialLoadingTimeout: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tnewBookmark() {\n\t\t\treturn this.$store.state.displayNewBookmark\n\t\t},\n\t\tnewFolder() {\n\t\t\treturn this.$store.state.displayNewFolder\n\t\t},\n\t\tfetching() {\n\t\t\treturn this.$store.state.loading.bookmarks\n\t\t},\n\t},\n\twatch: {\n\t\tnewBookmark() {\n\t\t\tthis.$el.scrollTop = 0\n\t\t},\n\t\tnewFolder() {\n\t\t\tthis.$el.scrollTop = 0\n\t\t},\n\t},\n\tmounted() {\n\t\tthis.onScroll()\n\t\twindow.addEventListener('resize', this.onScroll)\n\t},\n\tdestroyed() {\n\t\twindow.removeEventListener('resize', this.onScroll)\n\t},\n\tmethods: {\n\t\tonScroll() {\n\t\t\tthis.scrollTop = this.$el.scrollTop\n\t\t\tthis.scrollHeight = this.$el.scrollHeight\n\t\t},\n\t},\n\trender(h) {\n\t\tlet children = []\n\t\tlet itemsPerRow = 1\n\t\tlet renderedItems = 0\n\t\tlet upperPaddingItems = 0\n\t\tlet lowerPaddingItems = 0\n\t\tlet itemHeight = 1\n\t\tconst padding = GRID_ITEM_HEIGHT\n\t\tif (this.$slots.default && this.$el) {\n\t\t\tconst childComponents = this.$slots.default.filter(child => !!child.componentOptions)\n\t\t\tconst viewport = this.$el.getBoundingClientRect()\n\t\t\titemHeight = this.viewMode === 'grid' ? GRID_ITEM_HEIGHT : LIST_ITEM_HEIGHT\n\t\t\titemsPerRow = this.viewMode === 'grid' ? Math.floor(viewport.width / GRID_ITEM_WIDTH) : 1\n\t\t\trenderedItems = itemsPerRow * Math.floor((viewport.height + padding + padding) / itemHeight)\n\t\t\tupperPaddingItems = itemsPerRow * Math.floor(Math.max(this.scrollTop - padding, 0) / itemHeight)\n\t\t\tchildren = childComponents.slice(upperPaddingItems, upperPaddingItems + renderedItems)\n\t\t\trenderedItems = children.length\n\t\t\tlowerPaddingItems = Math.max(childComponents.length - upperPaddingItems - renderedItems, 0)\n\t\t}\n\n\t\tif (!this.reachedEnd && lowerPaddingItems === 0) {\n\t\t\tif (!this.fetching) {\n\t\t\t\tthis.$emit('load-more')\n\t\t\t}\n\t\t\tif (upperPaddingItems + renderedItems + lowerPaddingItems === 0) {\n\t\t\t\tif (!this.initialLoadingSkeleton) {\n\t\t\t\t\t// The first 350ms don't display skeletons\n\t\t\t\t\tthis.initialLoadingTimeout = setTimeout(() => {\n\t\t\t\t\t\tthis.initialLoadingSkeleton = true\n\t\t\t\t\t\tthis.$forceUpdate()\n\t\t\t\t\t}, 350)\n\t\t\t\t\treturn h('div', { class: 'virtual-scroll' })\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tchildren = [...children, ...Array(40).fill(0).map(() =>\n\t\t\t\th(ItemSkeleton)\n\t\t\t)]\n\t\t}\n\n\t\tif (upperPaddingItems + renderedItems + lowerPaddingItems > 0) {\n\t\t\tthis.initialLoadingSkeleton = false\n\t\t\tif (this.initialLoadingTimeout) {\n\t\t\t\tclearTimeout(this.initialLoadingTimeout)\n\t\t\t}\n\t\t}\n\n\t\tconst scrollTop = this.scrollTop\n\t\tthis.$nextTick(() => {\n\t\t\tthis.$el.scrollTop = scrollTop\n\t\t})\n\n\t\treturn h('div', {\n\t\t\tclass: 'virtual-scroll',\n\t\t\ton: { scroll: () => this.onScroll() },\n\t\t},\n\t\t[\n\t\t\th('div', { class: 'upper-padding', style: { height: Math.max((upperPaddingItems / itemsPerRow) * itemHeight, 0) + 'px' } }),\n\t\t\th('div', { class: 'container-window', style: { height: Math.max((renderedItems / itemsPerRow) * itemHeight, 0) + 'px' } }, children),\n\t\t\th('div', { class: 'lower-padding', style: { height: Math.max((lowerPaddingItems / itemsPerRow) * itemHeight, 0) + 'px' } }),\n\t\t])\n\t},\n}\n<\/script>\n\n<style scoped>\n.virtual-scroll {\n\theight: calc(100vh - 50px - 50px - 10px);\n\tposition: relative;\n\toverflow-y: scroll;\n}\n\n.bookmarkslist--gridview .container-window {\n\tdisplay: flex;\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n\tpadding-top: 10px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},94378:(t,e,n)=>{"use strict";n.d(e,{Z:()=>w});var o=n(41293),r=n(91036),i=n.n(r),a=n(79753),s=n(15961);const c={name:"BookmarkContent",components:{NcEmptyContent:s.SL,DownloadIcon:o.Z},computed:{isActive:function(){return!!this.$store.state.sidebar&&"bookmark"===this.$store.state.sidebar.type},isWebLink:function(){return this.bookmark.url.startsWith("http")},bookmark:function(){if(this.isActive)return this.$store.getters.getBookmark(this.$store.state.sidebar.id)},hasMinLength:function(){return!this.bookmark.textContent||this.bookmark.textContent.length>=350},content:function(){return i()(this.bookmark.htmlContent,{allowProtocolRelative:!1})},archivedFileUrl:function(){var t=this.bookmark.archivedFilePath.split("/").slice(3).join("/");return(0,a.generateRemoteUrl)("webdav/".concat(t))},archivedFile:function(){return this.bookmark.archivedFile?(0,a.generateUrl)("/apps/files/?fileid=".concat(this.bookmark.archivedFile)):null}}};var l=n(93379),u=n.n(l),d=n(7795),m=n.n(d),h=n(90569),p=n.n(h),f=n(3565),A=n.n(f),k=n(19216),g=n.n(k),v=n(44589),b=n.n(v),y=n(36946),C={};C.styleTagTransform=b(),C.setAttributes=A(),C.insert=p().bind(null,"head"),C.domAPI=m(),C.insertStyleElement=g();u()(y.Z,C);y.Z&&y.Z.locals&&y.Z.locals;const w=(0,n(51900).Z)(c,(function(){var t=this,e=t._self._c;return t.isActive&&t.hasMinLength&&!t.archivedFile&&t.isWebLink?e("div",{staticClass:"bookmark-content"},[t.bookmark.textContent?e("div",{staticClass:"content",domProps:{innerHTML:t._s(t.content)}}):e("div",[e("NcEmptyContent",{attrs:{title:t.t("bookmarks","Content pending"),description:t.t("bookmarks","This content is being downloaded for offline use. Please check back later.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DownloadIcon")]},proxy:!0}],null,!1,2378230876)})],1)]):t._e()}),[],!1,null,null,null).exports},53642:(e,n,o)=>{"use strict";o.d(n,{Z:()=>ne});var r=o(20144),i=o(15961),a=o(41209);const s={name:"TagLine",components:{},props:{tags:{type:Array,required:!0}},data:function(){return{}},computed:{routes:function(){return this.$store.state.public?a.jE:a.xu}},created:function(){},methods:{clickTag:function(t,e){t.preventDefault(),t.stopImmediatePropagation(),t.stopPropagation(),this.$router.push({name:this.routes.TAGS,params:{tags:e}})}}};var c=o(93379),l=o.n(c),u=o(7795),d=o.n(u),m=o(90569),h=o.n(m),p=o(3565),f=o.n(p),A=o(19216),k=o.n(A),g=o(44589),v=o.n(g),b=o(13880),y={};y.styleTagTransform=v(),y.setAttributes=f(),y.insert=h().bind(null,"head"),y.domAPI=d(),y.insertStyleElement=k();l()(b.Z,y);b.Z&&b.Z.locals&&b.Z.locals;var C=o(51900);const w=(0,C.Z)(s,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"tagline"},t._l(t.tags,(function(n){return e("div",{key:n,staticClass:"tagline__tag",attrs:{role:"button"},on:{click:function(e){return t.clickTag(e,n)}}},[t._v("\n\t\t"+t._s(n)+"\n\t")])})),0)}),[],!1,null,null,null).exports;var _=o(34829),x=o(3970);const S={name:"DragImage",components:{FolderIcon:_.default,EarthIcon:x.Z},computed:{selectionDescription:function(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","{folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?1===this.$store.state.selection.bookmarks.length?this.$store.state.selection.bookmarks[0].title:this.n("bookmarks","%n bookmark","%n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?1===this.$store.state.selection.folders.length?this.$store.state.selection.folders[0].title:this.n("bookmarks","%n folder","%n folders",this.$store.state.selection.folders.length):""}}};var E=o(83469),I={};I.styleTagTransform=v(),I.setAttributes=f(),I.insert=h().bind(null,"head"),I.domAPI=d(),I.insertStyleElement=k();l()(E.Z,I);E.Z&&E.Z.locals&&E.Z.locals;const N=(0,C.Z)(S,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"dragImage"},[t.$store.state.selection.folders.length?e("FolderIcon",{attrs:{"fill-color":t.colorPrimaryElement}}):e("EarthIcon",{attrs:{"fill-color":t.colorPrimaryElement}}),e("span",{staticClass:"description"},[t._v(t._s(t.selectionDescription))])],1)}),[],!1,null,"4fd4b205",null).exports;var $=o(81283),O=o(80419),L=o(82675);function B(t){return B="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},B(t)}function T(){T=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==B(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function P(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function F(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){P(i,o,r,a,s,"next",t)}function s(t){P(i,o,r,a,s,"throw",t)}a(void 0)}))}}const D={name:"Item",components:{NcActions:i.O3,NcActionButton:i.Js,TagLine:w,CheckIcon:O.default,CloseIcon:L.default},props:{title:{type:String,required:!0},url:{type:String,default:void 0},active:{type:Boolean,default:!1},editable:{type:Boolean,default:!1},selected:{type:Boolean,default:!1},selectable:{type:Boolean,default:!1},draggable:{type:Boolean,default:!1},allowDrop:{type:Function,default:function(){return!1}},renaming:{type:Boolean,default:!1},selectLabel:{type:String,required:!0},renamePlaceholder:{type:String,required:!0},background:{type:String,default:void 0},tags:{type:Array,default:void 0}},data:function(){return{newTitle:this.title}},computed:{viewMode:function(){return this.$store.state.viewMode}},watch:{renaming:function(){var t=this;return F(T().mark((function e(){return T().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:if(!t.renaming){e.next=4;break}return e.next=3,r.default.nextTick();case 3:t.$refs.input.focus();case 4:case"end":return e.stop()}}),e)})))()}},mounted:function(){void 0!==this.$refs.input&&this.$refs.input.focus()},methods:{onRenameSubmit:function(t){var e=this;return F(T().mark((function t(){return T().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e.$emit("rename",e.newTitle);case 1:case"end":return t.stop()}}),t)})))()},onClick:function(t){this.$refs.actions===t.target||this.$refs.actions&&this.$refs.actions.contains(t.target)||this.$refs.checkbox&&(this.$refs.checkbox.contains(t.target)||this.$refs.checkbox===t.target)?t.stopImmediatePropagation():this.$emit("click",t)},onRightClick:function(t){this.$refs.actions&&(t.preventDefault(),this.$refs.actions.openMenu?this.$refs.actions.openMenu():this.$refs.actions.querySelector&&this.$refs.actions.querySelector("button").click())},onDragStart:function(t){var e=this;return F(T().mark((function n(){var o,i,a;return T().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:if(e.draggable&&!e.renaming){n.next=2;break}return n.abrupt("return");case 2:if(e.selected){n.next=7;break}return(e.$store.state.selection.bookmarks.length||e.$store.state.selection.folders.length)&&e.$store.commit($.P$.RESET_SELECTION),e.$emit("select"),n.next=7,e.$nextTick();case 7:return o=document.createElement("div"),i=o.appendChild(document.createElement("div")),document.body.appendChild(o),a=new r.default({el:i,store:e.$store,render:function(t){return t(N)}}),n.next=13,a.$nextTick();case 13:return t.dataTransfer.clearData(),t.dataTransfer.setData("text/plain",JSON.stringify(e.$store.state.selection)),t.dataTransfer.setDragImage(o,0,0),n.next=18,new Promise((function(t){return setTimeout(t,0)}));case 18:document.body.removeChild(o);case 19:case"end":return n.stop()}}),n)})))()}}};var R=o(88483),M={};M.styleTagTransform=v(),M.setAttributes=f(),M.insert=h().bind(null,"head"),M.domAPI=d(),M.insertStyleElement=k();l()(R.Z,M);R.Z&&R.Z.locals&&R.Z.locals;const j=(0,C.Z)(D,(function(){var t=this,e=t._self._c;return e("div",{directives:[{name:"drop-target",rawName:"v-drop-target",value:{allow:t.allowDrop,drop:function(e){return t.$emit("drop",e)}},expression:"{allow: allowDrop, drop: (e) => $emit('drop', e)}"}],class:{item:!0,active:t.active,"item--gridview":"grid"===t.viewMode},style:{background:t.background},attrs:{draggable:t.draggable&&!t.renaming},on:{dragstart:t.onDragStart}},[t.renaming?e("div",{staticClass:"item__rename"},[t._t("icon"),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.newTitle,expression:"newTitle"}],ref:"input",attrs:{type:"text",placeholder:t.renamePlaceholder},domProps:{value:t.newTitle},on:{keyup:function(e){return!e.type.indexOf("key")&&t._k(e.keyCode,"enter",13,e.key,"Enter")?null:t.onRenameSubmit.apply(null,arguments)},input:function(e){e.target.composing||(t.newTitle=e.target.value)}}}),t._v(" "),e("NcActions",[e("NcActionButton",{on:{click:t.onRenameSubmit},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CheckIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Submit"))+"\n\t\t\t")])],1),t._v(" "),e("NcActions",[e("NcActionButton",{on:{click:function(e){return t.$emit("rename-cancel")}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Cancel"))+"\n\t\t\t")])],1)],2):[e(t.url?"a":"span",{tag:"component",staticClass:"item__clickLink",attrs:{href:t.url,tabindex:"0",target:"_blank"},on:{click:t.onClick,contextmenu:t.onRightClick}},[t.editable&&t.selectable?e("div",{ref:"checkbox",staticClass:"item__checkbox"},[e("input",{staticClass:"checkbox",attrs:{type:"checkbox"},domProps:{checked:t.selected}}),e("label",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.selectLabel,expression:"selectLabel"}],attrs:{"aria-label":t.selectLabel},on:{click:function(e){e.preventDefault(),e.stopImmediatePropagation(),t.$emit("select")}}})]):t._e(),t._v(" "),e("div",{staticClass:"item__icon"},[t._t("icon")],2),t._v(" "),e("div",{staticClass:"item__labels"},[t._t("title"),t._v(" "),t._t("tags",(function(){return[e("TagLine",{attrs:{tags:t.tags}})]}))],2),t._v(" "),t.editable&&!t.selected?e("div",{ref:"actions",staticClass:"item__NcActions",on:{click:function(t){t.preventDefault(),t.stopPropagation()}}},[e("NcActions",{ref:"actions"},[t._t("actions")],2)],1):t._e()])]],2)}),[],!1,null,null,null).exports;var G=o(53614),Z=o(56606),V=o(85226),U=o(73229),Y=o(24601),H=o(57612),K=o(77958),q=o(79753),W=o(88911);function z(t){return z="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},z(t)}function Q(){Q=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==z(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function J(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function X(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){J(i,o,r,a,s,"next",t)}function s(t){J(i,o,r,a,s,"throw",t)}a(void 0)}))}}const tt={name:"Bookmark",components:{Item:j,NcActionButton:i.Js,NcActionCheckbox:i.Bt,FolderPlusIcon:G.Z,FolderMoveIcon:Z.Z,ContentCopyIcon:V.Z,PencilIcon:U.default,InformationVariantIcon:Y.Z,DeleteIcon:H.Z},props:{bookmark:{type:Object,required:!0}},data:function(){return{title:this.bookmark.title,renaming:!1,backgroundImage:void 0}},computed:{apiUrl:function(){return this.isPublic?(0,q.generateUrl)("/apps/bookmarks/public/rest/v2"):(0,q.generateUrl)("/apps/bookmarks")},iconUrl:function(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/favicon"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},imageUrl:function(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/image"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},url:function(){return this.bookmark.url},isOpen:function(){return!(!this.$store.state.sidebar||"bookmark"!==this.$store.state.sidebar.type)&&this.$store.state.sidebar.id===this.bookmark.id},viewMode:function(){return this.$store.state.viewMode},isOwner:function(){var t=(0,K.ts)();return t&&this.bookmark.userId===t.uid},permissions:function(){return this.$store.getters.getPermissionsForBookmark(this.bookmark.id)},isEditable:function(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},selectedBookmarks:function(){return this.$store.state.selection.bookmarks},selectable:function(){return Boolean(this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)},selected:function(){return this.selectedBookmarks.map((function(t){return t.id})).includes(this.bookmark.id)},isActive:function(){return this.isOpen||this.selected},background:function(){return"grid"===this.viewMode?this.backgroundImage:void 0}},mounted:function(){this.fetchBackgroundImage()},methods:{onDelete:function(){confirm(t("bookmarks","Do you really want to delete this bookmark?"))&&this.$store.dispatch($.Nw.DELETE_BOOKMARK,{id:this.bookmark.id,folder:this.$store.state.fetchState.query.folder})},onDetails:function(){this.$store.dispatch($.Nw.OPEN_BOOKMARK,this.bookmark.id)},onMove:function(){this.$store.commit($.P$.RESET_SELECTION),this.$store.commit($.P$.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit($.P$.DISPLAY_MOVE_DIALOG,!0)},onCopy:function(){this.$store.commit($.P$.RESET_SELECTION),this.$store.commit($.P$.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit($.P$.DISPLAY_COPY_DIALOG,!0)},onRename:function(){var t=this;return X(Q().mark((function e(){return Q().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:t.renaming=!0;case 1:case"end":return e.stop()}}),e)})))()},onRenameSubmit:function(t){var e=this;return X(Q().mark((function n(){return Q().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return e.bookmark.title=t,n.next=3,e.$store.dispatch($.Nw.SAVE_BOOKMARK,e.bookmark.id);case 3:e.renaming=!1;case 4:case"end":return n.stop()}}),n)})))()},onSelect:function(){this.selected?this.$store.commit($.P$.REMOVE_SELECTION_BOOKMARK,this.bookmark):this.$store.commit($.P$.ADD_SELECTION_BOOKMARK,this.bookmark)},onClick:function(){this.bookmark.url.startsWith("file:")&&this.$store.commit($.P$.SET_ERROR,"Most browsers will not allow clicking on file links. Try copying the URL"),this.$store.dispatch($.Nw.CLICK_BOOKMARK,this.bookmark)},onCopyUrl:function(){navigator.clipboard.writeText(this.bookmark.target),this.$store.commit($.P$.SET_NOTIFICATION,this.t("bookmarks","Link copied to clipboard"))},fetchBackgroundImage:function(){var t=this;return X(Q().mark((function e(){var n,o;return Q().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return"#ffffff"===t.colorMainBackground?t.backgroundImage="var(--icon-link-000) no-repeat center 25% / 50% !important":t.backgroundImage="var(--icon-link-fff) no-repeat center 25% / 50% !important",e.prev=1,e.next=4,W.Z.get(t.imageUrl,{responseType:"blob"});case 4:n=e.sent,o=URL.createObjectURL(n.data),t.backgroundImage="linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url('".concat(o,"')"),e.next=12;break;case 9:e.prev=9,e.t0=e.catch(1),"#ffffff"===t.colorMainBackground?t.backgroundImage="var(--icon-link-000) no-repeat center 25% / 50% !important":t.backgroundImage="var(--icon-link-fff) no-repeat center 25% / 50% !important";case 12:case"end":return e.stop()}}),e,null,[[1,9]])})))()}}};var et=o(53535),nt={};nt.styleTagTransform=v(),nt.setAttributes=f(),nt.insert=h().bind(null,"head"),nt.domAPI=d(),nt.insertStyleElement=k();l()(et.Z,nt);et.Z&&et.Z.locals&&et.Z.locals;const ot=(0,C.Z)(tt,(function(){var t=this,e=t._self._c;return e("Item",{attrs:{title:t.bookmark.title,tags:t.bookmark.tags,"rename-placeholder":t.t("bookmarks","Enter new title"),"select-label":t.t("bookmarks","Select bookmark"),active:t.isActive,editable:t.isEditable,selected:t.selected,draggable:t.isEditable,renaming:t.renaming,background:t.background,url:t.url,selectable:t.selectable},on:{select:t.onSelect,rename:t.onRenameSubmit,"rename-cancel":function(e){t.renaming=!1},click:t.onClick},scopedSlots:t._u([{key:"title",fn:function(){return[e("div",{staticClass:"bookmark__title"},[e("h3",{attrs:{title:t.bookmark.title}},[t.bookmark.preliminary?e("span",{staticClass:"icon-loading-small bookmark__icon"}):e("figure",{staticClass:"bookmark__icon",style:{backgroundImage:"url("+t.iconUrl+")"}}),t._v("\n\t\t\t\t"+t._s(t.bookmark.title)+"\n\t\t\t")]),t._v(" "),t.bookmark.description?e("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.bookmark.description,expression:"bookmark.description"}],staticClass:"bookmark__description"},[e("figure",{staticClass:"icon-file"}),t._v("\n\t\t\t\t"+t._s(t.bookmark.description))]):t._e()])]},proxy:!0},{key:"actions",fn:function(){return[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDetails},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t")]),t._v(" "),e("NcActionCheckbox",{on:{change:t.onSelect}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select bookmark"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onRename},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Rename"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onCopyUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ContentCopyIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Copy link"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete"))+"\n\t\t")])]},proxy:!0}])})}),[],!1,null,null,null).exports;var rt=o(83422);function it(t){return it="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},it(t)}function at(){at=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==it(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function st(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function ct(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){st(i,o,r,a,s,"next",t)}function s(t){st(i,o,r,a,s,"throw",t)}a(void 0)}))}}const lt={name:"Folder",components:{Item:j,NcActionButton:i.Js,NcActionCheckbox:i.Bt,FolderIcon:_.default,FolderMoveIcon:Z.Z,ShareVariantIcon:rt.Z,DeleteIcon:H.Z,PencilIcon:U.default,InformationVariantIcon:Y.Z},props:{folder:{type:Object,required:!0}},data:function(){return{renaming:!1}},computed:{viewMode:function(){return this.$store.state.viewMode},currentUser:function(){return(0,K.ts)().uid},isOwner:function(){var t=(0,K.ts)();return t&&this.folder.userId===t.uid},permissions:function(){return this.$store.getters.getPermissionsForFolder(this.folder.id)},isDirectShare:function(){return void 0!==this.$store.state.sharedFoldersById[this.folder.id]},isEditable:function(){return this.isOwner||this.isDirectShare||this.permissions.canWrite},shares:function(){return this.$store.getters.getSharesOfFolder(this.folder.id)},publicToken:function(){return this.$store.getters.getTokenOfFolder(this.folder.id)},isShared:function(){return Boolean(this.shares.length)},isSharedPublicly:function(){return Boolean(this.publicToken)},selectedFolders:function(){return this.$store.state.selection.folders},selectable:function(){return Boolean(this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)},selected:function(){return this.selectedFolders.map((function(t){return t.id})).includes(this.folder.id)}},mounted:function(){var t=this;setTimeout((function(){t.$store.dispatch($.Nw.LOAD_SHARES_OF_FOLDER,t.folder.id),t.$store.dispatch($.Nw.LOAD_PUBLIC_LINK,t.folder.id),t.$store.dispatch($.Nw.COUNT_BOOKMARKS,t.folder.id)}),2e3)},methods:{onDetails:function(){this.$store.dispatch($.Nw.OPEN_FOLDER_DETAILS,this.folder.id)},onShare:function(){this.$store.dispatch($.Nw.OPEN_FOLDER_SHARING,this.folder.id)},onDelete:function(){confirm(t("bookmarks","Do you really want to delete this folder?"))&&this.$store.dispatch($.Nw.DELETE_FOLDER,{id:this.folder.id})},onMove:function(){this.$store.commit($.P$.RESET_SELECTION),this.$store.commit($.P$.ADD_SELECTION_FOLDER,this.folder),this.$store.commit($.P$.DISPLAY_MOVE_DIALOG,!0)},onSelect:function(t){this.$router.push({name:this.routes.FOLDER,params:{folder:this.folder.id}}),t.preventDefault()},onRename:function(){var t=this;return ct(at().mark((function e(){return at().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:t.renaming=!0;case 1:case"end":return e.stop()}}),e)})))()},onRenameSubmit:function(t){this.folder.title=t,this.$store.dispatch($.Nw.SAVE_FOLDER,this.folder.id),this.renaming=!1},clickSelect:function(t){this.selected?this.$store.commit($.P$.REMOVE_SELECTION_FOLDER,this.folder):this.$store.commit($.P$.ADD_SELECTION_FOLDER,this.folder)},onEnter:function(t){"Enter"===t.key&&this.onSelect(t)},allowDrop:function(){return!this.$store.state.selection.folders.includes(this.folder)&&(this.$store.state.selection.folders.length||this.$store.state.selection.bookmarks.length)},onDrop:function(t){var e=this;return ct(at().mark((function n(){return at().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return t.preventDefault(),n.prev=1,n.next=4,e.$store.dispatch($.Nw.MOVE_SELECTION,e.folder.id);case 4:return n.prev=4,e.$store.commit($.P$.RESET_SELECTION),n.finish(4);case 7:case"end":return n.stop()}}),n,null,[[1,,4,7]])})))()}}};var ut=o(89770),dt={};dt.styleTagTransform=v(),dt.setAttributes=f(),dt.insert=h().bind(null,"head"),dt.domAPI=d(),dt.insertStyleElement=k();l()(ut.Z,dt);ut.Z&&ut.Z.locals&&ut.Z.locals;const mt=(0,C.Z)(lt,(function(){var t=this,e=t._self._c;return e("Item",{attrs:{active:t.selected,editable:t.isEditable,draggable:t.isEditable,selected:t.selected,title:t.folder.title,renaming:t.renaming,"select-label":t.t("bookmarks","Select folder"),"rename-placeholder":t.t("bookmarks","Enter folder title"),selectable:t.selectable,"allow-drop":t.allowDrop},on:{drop:t.onDrop,select:t.clickSelect,rename:t.onRenameSubmit,"rename-cancel":function(e){t.renaming=!1},click:t.onSelect},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{class:"folder__icon",attrs:{"fill-color":t.colorPrimaryElement},on:{click:t.onSelect}}),t._v(" "),t.isShared||!t.isOwner||t.isSharedPublicly?e("ShareVariantIcon",{class:["folder__icon","shared"],attrs:{"fill-color":t.colorPrimaryText}}):t._e()]},proxy:!0},{key:"title",fn:function(){return[e("h3",{staticClass:"folder__title"},[t._v("\n\t\t\t"+t._s(t.folder.title)+"\n\t\t")])]},proxy:!0},{key:"tags",fn:function(){return[e("div",{staticClass:"folder__tags"},[t.isOwner||t.isSharedPublicly?t._e():e("div",{staticClass:"folder__tag"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Shared by {user}",{user:t.folder.userDisplayName}))+"\n\t\t\t")])])]},proxy:!0},{key:"actions",fn:function(){return[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDetails},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t")]),t._v(" "),e("NcActionCheckbox",{on:{change:t.clickSelect}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select folder"))+"\n\t\t")]),t._v(" "),t.permissions.canShare?e("NcActionButton",{attrs:{icon:"icon-share","close-after-click":!0},on:{click:t.onShare},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon")]},proxy:!0}],null,!1,3668921682)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t")]):t._e(),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onRename},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Rename folder"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move folder"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete folder"))+"\n\t\t")])]},proxy:!0}])})}),[],!1,null,null,null).exports;function ht(t){return ht="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ht(t)}function pt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(t);e&&(o=o.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,o)}return n}function ft(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?pt(Object(n),!0).forEach((function(e){At(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):pt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function At(t,e,n){return(e=function(t){var e=function(t,e){if("object"!==ht(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var o=n.call(t,e||"default");if("object"!==ht(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"===ht(e)?e:String(e)}(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}const kt={name:"CreateBookmark",components:{Item:j,EarthIcon:x.Z},computed:{creating:function(){return this.$store.state.loading.createBookmark},isFolderView:function(){return this.$route.name===this.$store.getters.getRoutes().FOLDER},isTagView:function(){return this.$route.name===this.$store.getters.getRoutes().TAGS}},methods:{submit:function(t){this.$store.dispatch($.Nw.CREATE_BOOKMARK,ft(ft({url:t},this.isFolderView&&{folders:[this.$route.params.folder]}),this.isTagView&&{tags:this.$route.params.tags.split(",")}))},cancel:function(){this.$store.commit($.P$.DISPLAY_NEW_BOOKMARK,!1)}}};var gt=o(2828),vt={};vt.styleTagTransform=v(),vt.setAttributes=f(),vt.insert=h().bind(null,"head"),vt.domAPI=d(),vt.insertStyleElement=k();l()(gt.Z,vt);gt.Z&&gt.Z.locals&&gt.Z.locals;const bt=(0,C.Z)(kt,(function(){var t=this,e=t._self._c;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a link"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("EarthIcon",{staticClass:"icon",attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])})}),[],!1,null,"2b4ea42e",null).exports;const yt={name:"CreateFolder",components:{Item:j,FolderIcon:_.default},computed:{loading:function(){return this.$store.state.loading.createFolder}},methods:{submit:function(t){var e=this.$route.params.folder;this.$store.dispatch($.Nw.CREATE_FOLDER,{parentFolder:e,title:t})},cancel:function(){this.$store.commit($.P$.DISPLAY_NEW_FOLDER,!1)}}};var Ct=o(31656),wt={};wt.styleTagTransform=v(),wt.setAttributes=f(),wt.insert=h().bind(null,"head"),wt.domAPI=d(),wt.insertStyleElement=k();l()(Ct.Z,wt);Ct.Z&&Ct.Z.locals&&Ct.Z.locals;const _t=(0,C.Z)(yt,(function(){var t=this,e=t._self._c;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a title"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{staticClass:"icon",attrs:{"fill-color":t.colorPrimaryElement}})]},proxy:!0}])})}),[],!1,null,"47929df1",null).exports;var xt=o(79311),St=o(75762),Et=o(61149),It=o(52731),Nt=o(49247),$t=o(52680);function Ot(t){return Ot="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Ot(t)}function Lt(){Lt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==Ot(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function Bt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}const Tt={name:"NoBookmarks",components:{NcEmptyContent:i.SL,StarShootingIcon:xt.Z,NcButton:i.P2,NcLoadingIcon:i.lb,UploadIcon:St.Z,PlusIcon:Et.Z,ShareVariantIcon:rt.Z,VectorLinkIcon:It.Z,LinkVariantOffIcon:Nt.Z,FileDocumentMultipleIcon:$t.Z},data:function(){return{importing:!1}},computed:{routes:function(){return a.xu}},methods:{onCreateOpen:function(){this.$store.commit($.P$.DISPLAY_NEW_BOOKMARK,!0)},onImportOpen:function(){this.$refs.import.click()},onImportSubmit:function(t){var e,n=this;return(e=Lt().mark((function e(){return Lt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return n.importing=!0,e.prev=1,e.next=4,n.$store.dispatch($.Nw.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:n.$route.params.folder||-1});case 4:e.next=9;break;case 6:e.prev=6,e.t0=e.catch(1),console.warn(e.t0);case 9:n.importing=!1;case 10:case"end":return e.stop()}}),e,null,[[1,6]])})),function(){var t=this,n=arguments;return new Promise((function(o,r){var i=e.apply(t,n);function a(t){Bt(i,o,r,a,s,"next",t)}function s(t){Bt(i,o,r,a,s,"throw",t)}a(void 0)}))})()}}};var Pt=o(65535),Ft={};Ft.styleTagTransform=v(),Ft.setAttributes=f(),Ft.insert=h().bind(null,"head"),Ft.domAPI=d(),Ft.insertStyleElement=k();l()(Pt.Z,Ft);Pt.Z&&Pt.Z.locals&&Pt.Z.locals;const Dt=(0,C.Z)(Tt,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"bookmarkslist__emptyBookmarks"},[t.$route.name===t.routes.ARCHIVED?e("NcEmptyContent",{attrs:{title:t.t("bookmarks","No bookmarked files"),description:t.t("bookmarks","Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FileDocumentMultipleIcon")]},proxy:!0}],null,!1,3035097329)}):t.$route.name===t.routes.UNAVAILABLE?e("NcEmptyContent",{attrs:{title:t.t("bookmarks","No broken links"),description:t.t("bookmarks","Bookmarked links are checked regularly and the ones that cannot be reached are listed here.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("LinkVariantOffIcon")]},proxy:!0}])}):t.$route.name===t.routes.SHARED_FOLDERS?e("NcEmptyContent",{attrs:{title:t.t("bookmarks","No shared folders"),description:t.t("bookmarks","You can share bookmark folders with others. All folders shared with you are listed here.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon")]},proxy:!0}])}):t.$route.name===t.routes.DUPLICATED?e("NcEmptyContent",{attrs:{title:t.t("bookmarks","No duplicated bookmarks"),description:t.t("bookmarks","One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("VectorLinkIcon")]},proxy:!0}])}):e("NcEmptyContent",{attrs:{title:t.t("bookmarks","No bookmarks here"),description:t.t("bookmarks","Add bookmarks manually or import bookmarks from a HTML file.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("StarShootingIcon")]},proxy:!0},t.isPublic?null:{key:"action",fn:function(){return[e("input",{ref:"import",staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("NcButton",{on:{click:t.onCreateOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon")]},proxy:!0}],null,!1,1789392498)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Add a bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onImportOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[t.importing?e("NcLoadingIcon"):e("UploadIcon")]},proxy:!0}],null,!1,3982872974)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t\t")])]},proxy:!0}],null,!0)})],1)}),[],!1,null,"70a527cb",null).exports;var Rt=o(6975);function Mt(t){return Mt="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Mt(t)}function jt(){jt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==Mt(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function Gt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}const Zt={name:"FirstRun",components:{NcEmptyContent:i.SL,SyncIcon:Rt.Z,NcButton:i.P2,PlusIcon:Et.Z,UploadIcon:St.Z,NcLoadingIcon:i.lb,StarShootingIcon:xt.Z},data:function(){return{importing:!1}},computed:{routes:function(){return a.xu}},methods:{onCreateOpen:function(){this.$store.commit($.P$.DISPLAY_NEW_BOOKMARK,!0)},onImportOpen:function(){this.$refs.import.click()},onSyncOpen:function(){window.open("https://floccus.org","_blank")},onImportSubmit:function(t){var e,n=this;return(e=jt().mark((function e(){return jt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return n.importing=!0,e.prev=1,e.next=4,n.$store.dispatch($.Nw.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:n.$route.params.folder||-1});case 4:e.next=9;break;case 6:e.prev=6,e.t0=e.catch(1),console.warn(e.t0);case 9:n.importing=!1;case 10:case"end":return e.stop()}}),e,null,[[1,6]])})),function(){var t=this,n=arguments;return new Promise((function(o,r){var i=e.apply(t,n);function a(t){Gt(i,o,r,a,s,"next",t)}function s(t){Gt(i,o,r,a,s,"throw",t)}a(void 0)}))})()}}};var Vt=o(60466),Ut={};Ut.styleTagTransform=v(),Ut.setAttributes=f(),Ut.insert=h().bind(null,"head"),Ut.domAPI=d(),Ut.insertStyleElement=k();l()(Vt.Z,Ut);Vt.Z&&Vt.Z.locals&&Vt.Z.locals;const Yt=(0,C.Z)(Zt,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"bookmarkslist__emptyBookmarks"},[e("NcEmptyContent",{attrs:{title:t.t("bookmarks","Welcome to Bookmarks"),description:t.t("bookmarks","This app allows you to manage links to your favorite places on the web. Sort your bookmarks into folders, label them with tags and share them with others! The app will regularly check all your links for availability and display unavailable links. If you add a link to a file on the web, the file will be automatically downloaded to your Nextcloud Files. You can also import bookmarks exported from other services or directly sync bookmarks from all your browsers with this app.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("StarShootingIcon")]},proxy:!0},{key:"action",fn:function(){return[e("input",{ref:"import",staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("NcButton",{on:{click:t.onCreateOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Add a bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onImportOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[t.importing?e("NcLoadingIcon"):e("UploadIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onSyncOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SyncIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Sync with your browser"))+"\n\t\t\t")])]},proxy:!0}])})],1)}),[],!1,null,"0526fb54",null).exports;const Ht={name:"ItemSkeleton",components:{},computed:{viewMode:function(){return this.$store.state.settings.viewMode}}};const Kt=(0,C.Z)(Ht,(function(){var t=this,e=t._self._c;return e("div",{class:{item:!0,"item--gridview":"grid"===t.viewMode},style:{background:"var(--color-placeholder-dark)",height:"grid"!==t.viewMode?"45px":""}},[e("div",{staticClass:"item__labels"}),t._v(" "),e("div",{staticClass:"item__actions"})])}),[],!1,null,null,null).exports;function qt(t){return function(t){if(Array.isArray(t))return Wt(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return Wt(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return Wt(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function Wt(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}const zt={name:"VirtualScroll",props:{reachedEnd:{type:Boolean,required:!0}},data:function(){return{viewport:{width:0,height:0},scrollTop:0,scrollHeight:500,initialLoadingSkeleton:!1,initialLoadingTimeout:null}},computed:{viewMode:function(){return this.$store.state.viewMode},newBookmark:function(){return this.$store.state.displayNewBookmark},newFolder:function(){return this.$store.state.displayNewFolder},fetching:function(){return this.$store.state.loading.bookmarks}},watch:{newBookmark:function(){this.$el.scrollTop=0},newFolder:function(){this.$el.scrollTop=0}},mounted:function(){this.onScroll(),window.addEventListener("resize",this.onScroll)},destroyed:function(){window.removeEventListener("resize",this.onScroll)},methods:{onScroll:function(){this.scrollTop=this.$el.scrollTop,this.scrollHeight=this.$el.scrollHeight}},render:function(t){var e=this,n=[],o=1,r=0,i=0,a=0,s=1;if(this.$slots.default&&this.$el){var c=this.$slots.default.filter((function(t){return!!t.componentOptions})),l=this.$el.getBoundingClientRect();s="grid"===this.viewMode?210:46,r=(o="grid"===this.viewMode?Math.floor(l.width/260):1)*Math.floor((l.height+210+210)/s),i=o*Math.floor(Math.max(this.scrollTop-210,0)/s),r=(n=c.slice(i,i+r)).length,a=Math.max(c.length-i-r,0)}if(!this.reachedEnd&&0===a){if(this.fetching||this.$emit("load-more"),i+r+a===0&&!this.initialLoadingSkeleton)return this.initialLoadingTimeout=setTimeout((function(){e.initialLoadingSkeleton=!0,e.$forceUpdate()}),350),t("div",{class:"virtual-scroll"});n=[].concat(qt(n),qt(Array(40).fill(0).map((function(){return t(Kt)}))))}i+r+a>0&&(this.initialLoadingSkeleton=!1,this.initialLoadingTimeout&&clearTimeout(this.initialLoadingTimeout));var u=this.scrollTop;return this.$nextTick((function(){e.$el.scrollTop=u})),t("div",{class:"virtual-scroll",on:{scroll:function(){return e.onScroll()}}},[t("div",{class:"upper-padding",style:{height:Math.max(i/o*s,0)+"px"}}),t("div",{class:"container-window",style:{height:Math.max(r/o*s,0)+"px"}},n),t("div",{class:"lower-padding",style:{height:Math.max(a/o*s,0)+"px"}})])}};var Qt=o(56497),Jt={};Jt.styleTagTransform=v(),Jt.setAttributes=f(),Jt.insert=h().bind(null,"head"),Jt.domAPI=d(),Jt.insertStyleElement=k();l()(Qt.Z,Jt);Qt.Z&&Qt.Z.locals&&Qt.Z.locals;const Xt={name:"BookmarksList",components:{CreateFolder:_t,CreateBookmark:bt,VirtualScroll:(0,C.Z)(zt,undefined,undefined,!1,null,"03474f23",null).exports,FirstRun:Yt,NoBookmarks:Dt,Bookmark:ot,Folder:mt},computed:{bookmarks:function(){return this.$store.state.bookmarks},reachedEnd:function(){return this.$store.state.fetchState.reachedEnd},allBookmarksCount:function(){return this.$store.state.countsByFolder[-1]},children:function(){if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];var t=this.$route.params.folder||"-1";return t?this.$store.getters.getFolderChildren(t):[]},subFolders:function(){var t=this;if(this.$route.name===this.routes.SHARED_FOLDERS)return Object.keys(this.$store.state.sharedFoldersById).map((function(e){return t.$store.getters.getFolder(e)[0]}));if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];var e=this.$route.params.folder||"-1";if(!e)return[];var n=this.$store.getters.getFolder(e)[0];return n?(this.$store.dispatch($.Nw.LOAD_SHARES_OF_FOLDER,e),n.children):[]},newBookmark:function(){return this.$store.state.displayNewBookmark},newFolder:function(){return this.$store.state.displayNewFolder},viewMode:function(){return this.$store.state.viewMode},sortOrder:function(){return this.$store.state.settings.sorting},loading:function(){return this.$store.state.loading.bookmarks||this.$store.state.loading.folders}},methods:{loadMore:function(){this.$route.name!==a.xu.SHARED_FOLDERS?this.$store.dispatch($.Nw.FETCH_PAGE):this.$store.commit($.P$.REACHED_END)},getFolder:function(t){return this.$store.getters.getFolder(t)[0]},getBookmark:function(t){return this.$store.getters.getBookmark(t)}}};var te=o(75),ee={};ee.styleTagTransform=v(),ee.setAttributes=f(),ee.insert=h().bind(null,"head"),ee.domAPI=d(),ee.insertStyleElement=k();l()(te.Z,ee);te.Z&&te.Z.locals&&te.Z.locals;const ne=(0,C.Z)(Xt,(function(){var t=this,e=t._self._c;return e("div",{class:{bookmarkslist:!0,"bookmarkslist--gridview":"grid"===t.viewMode}},[t.$route.name===t.routes.ARCHIVED&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[t._v("\n\t\t"+t._s(t.t("bookmarks","Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline."))+"\n\t")]):t._e(),t._v(" "),t.$route.name===t.routes.UNAVAILABLE&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[t._v("\n\t\t"+t._s(t.t("bookmarks","Bookmarked links are checked regularly and the ones that cannot be reached are listed here."))+"\n\t")]):t._e(),t._v(" "),t.$route.name===t.routes.SHARED_FOLDERS&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[t._v("\n\t\t"+t._s(t.t("bookmarks","You can share bookmark folders with others. All folders shared with you are listed here."))+"\n\t")]):t._e(),t._v(" "),t.$route.name===t.routes.DUPLICATED&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[t._v("\n\t\t"+t._s(t.t("bookmarks","One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience."))+"\n\t")]):t._e(),t._v(" "),e("VirtualScroll",{attrs:{"reached-end":t.reachedEnd},on:{"load-more":t.loadMore}},[t.newBookmark?e("CreateBookmark"):t._e(),t._v(" "),t.newFolder?e("CreateFolder"):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER||t.$route.name===t.routes.HOME?["index"===t.sortOrder&&t.children.length?[t._l(t.children,(function(n){return["folder"===n.type&&t.getFolder(n.id)?e("Folder",{key:n.type+n.id,attrs:{folder:t.getFolder(n.id)}}):t._e(),t._v(" "),"bookmark"===n.type&&t.getBookmark(n.id)?e("Bookmark",{key:n.type+n.id,attrs:{bookmark:t.getBookmark(n.id)}}):t._e()]}))]:!t.subFolders.length&&!t.bookmarks.length||t.loading?!t.loading&&(t.allBookmarksCount>0||t.isPublic)?e("NoBookmarks"):t.loading?t._e():e("FirstRun"):[t._l(t.subFolders,(function(t){return e("Folder",{key:"folder"+t.id,attrs:{folder:t}})})),t._v(" "),t.bookmarks.length?t._l(t.bookmarks,(function(t){return e("Bookmark",{key:"bookmark"+t.id,attrs:{bookmark:t}})})):t._e()]]:t.subFolders.length||t.bookmarks.length?[t._l(t.subFolders,(function(t){return e("Folder",{key:"folder"+t.id,attrs:{folder:t}})})),t._v(" "),t._l(t.bookmarks,(function(t){return e("Bookmark",{key:"bookmark"+t.id,attrs:{bookmark:t}})}))]:!t.loading&&(t.allBookmarksCount>0||t.isPublic)?e("NoBookmarks"):t.loading?t._e():e("FirstRun")],2)],1)}),[],!1,null,null,null).exports},56867:(e,n,o)=>{"use strict";o.d(n,{Z:()=>lt});var r=o(15961),i=o(93234),a=o(3970),s=o(68804),c=o(55304),l=o(61149),u=o(34829),d=o(32219),m=o(15753),h=o(59552),p=o(81212),f=o(84709),A=o(60533),k=o(19537),g=o(20228),v=o(83422),b=o(41307),y=o(81283),C=o(79753);function w(t){return function(t){if(Array.isArray(t))return _(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return _(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function _(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}var x=o(53614),S=o(56606),E=o(71598),I=o(97661),N=o(85066),$=o(57612),O=o(25325),L=o.n(O);function B(t){return B="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},B(t)}function T(t){return function(t){if(Array.isArray(t))return R(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||D(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function P(){P=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==B(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function F(t,e){var n="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!n){if(Array.isArray(t)||(n=D(t))||e&&t&&"number"==typeof t.length){n&&(t=n);var o=0,r=function(){};return{s:r,n:function(){return o>=t.length?{done:!0}:{done:!1,value:t[o++]}},e:function(t){throw t},f:r}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,a=!0,s=!1;return{s:function(){n=n.call(t)},n:function(){var t=n.next();return a=t.done,t},e:function(t){s=!0,i=t},f:function(){try{a||null==n.return||n.return()}finally{if(s)throw i}}}}function D(t,e){if(t){if("string"==typeof t)return R(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?R(t,e):void 0}}function R(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}function M(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function j(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){M(i,o,r,a,s,"next",t)}function s(t){M(i,o,r,a,s,"throw",t)}a(void 0)}))}}const G={name:"BulkEditing",components:{NcActionInput:r.Iw,NcActionSeparator:r.rr,FolderPlusIcon:x.Z,FolderMoveIcon:S.Z,NcActionButton:r.Js,NcActions:r.O3,OpenInNewIcon:E.Z,TagIcon:b.Z,SelectAllIcon:I.Z,SelectOffIcon:N.Z,DeleteIcon:$.Z},data:function(){return{selectionTags:[]}},computed:{allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},selectedFolders:function(){return this.$store.state.selection.folders},selectedBookmarks:function(){return this.$store.state.selection.bookmarks},selectionDescription:function(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","Selected {folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?this.n("bookmarks","Selected %n bookmark","Selected %n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?this.n("bookmarks","Selected %n folder","Selected %n folders",this.$store.state.selection.folders.length):""}},watch:{selectedBookmarks:function(t){this.updateSelectionTags()}},methods:{onBulkOpen:function(){var t=this;return j(P().mark((function e(){var n,o,r;return P().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:n=F(t.$store.state.selection.bookmarks),e.prev=1,n.s();case 3:if((o=n.n()).done){e.next=10;break}return r=o.value.url,window.open(r),e.next=8,new Promise((function(t){return setTimeout(t,200)}));case 8:e.next=3;break;case 10:e.next=15;break;case 12:e.prev=12,e.t0=e.catch(1),n.e(e.t0);case 15:return e.prev=15,n.f(),e.finish(15);case 18:case"end":return e.stop()}}),e,null,[[1,12,15,18]])})))()},onBulkDelete:function(){var e=this;return j(P().mark((function n(){return P().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:if(confirm(t("bookmarks","Do you really want to delete these items?"))){n.next=2;break}return n.abrupt("return");case 2:return n.next=4,e.$store.dispatch(y.Nw.DELETE_SELECTION,{folder:e.$route.params.folder});case 4:e.$store.commit(y.P$.RESET_SELECTION);case 5:case"end":return n.stop()}}),n)})))()},onBulkMove:function(){this.$store.commit(y.P$.DISPLAY_MOVE_DIALOG,!0)},onBulkCopy:function(){this.$store.commit(y.P$.DISPLAY_COPY_DIALOG,!0)},onBulkTag:function(t){var e=this;return j(P().mark((function n(){var o;return P().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return o=e.selectionTags,e.selectionTags=t,n.next=4,e.$store.dispatch(y.Nw.TAG_SELECTION,{tags:t,originalTags:o});case 4:case"end":return n.stop()}}),n)})))()},onCancelSelection:function(){this.$store.commit(y.P$.RESET_SELECTION)},onSelectAll:function(){var t=this;return j(P().mark((function e(){return P().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch(y.Nw.FETCH_ALL);case 2:t.$store.state.bookmarks.forEach((function(e){t.$store.commit(y.P$.ADD_SELECTION_BOOKMARK,e)}));case 3:case"end":return e.stop()}}),e)})))()},updateSelectionTags:function(){this.selectionTags=L().apply(void 0,T(this.selectedBookmarks.map((function(t){return t.tags}))))}}};var Z=o(93379),V=o.n(Z),U=o(7795),Y=o.n(U),H=o(90569),K=o.n(H),q=o(3565),W=o.n(q),z=o(19216),Q=o.n(z),J=o(44589),X=o.n(J),tt=o(43328),et={};et.styleTagTransform=X(),et.setAttributes=W(),et.insert=K().bind(null,"head"),et.domAPI=Y(),et.insertStyleElement=Q();V()(tt.Z,et);tt.Z&&tt.Z.locals&&tt.Z.locals;var nt=o(51900);function ot(t){return ot="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ot(t)}function rt(){rt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof m?e:m,a=Object.create(i.prototype),s=new x(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function m(){}function h(){}function p(){}var f={};c(f,i,(function(){return this}));var A=Object.getPrototypeOf,k=A&&A(A(S([])));k&&k!==e&&n.call(k,i)&&(f=k);var g=p.prototype=m.prototype=Object.create(f);function v(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==ot(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=C(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function C(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,C(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function _(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function x(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return h.prototype=p,o(g,"constructor",{value:p,configurable:!0}),o(p,"constructor",{value:h,configurable:!0}),h.displayName=c(p,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===h||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,p):(t.__proto__=p,c(t,s,"GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(g),c(g,s,"Generator"),c(g,i,(function(){return this})),c(g,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,x.prototype={constructor:x,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(_),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),_(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;_(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function it(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}const at={name:"Controls",components:{BulkEditing:(0,nt.Z)(G,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"bulkediting"},[e("NcActions",{attrs:{primary:!0,"menu-title":t.selectionDescription}},[e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("OpenInNewIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Open all selected"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move selection"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon")]},proxy:!0}],null,!1,2881211620)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("NcActionInput",{attrs:{value:t.selectionTags,type:"multiselect",options:t.allTags,multiple:!0,taggable:!0},on:{tag:function(e){return t.onBulkTag([].concat(w(t.selectionTags),[e]))},input:t.onBulkTag},scopedSlots:t._u([{key:"icon",fn:function(){return[e("TagIcon")]},proxy:!0}],null,!1,3117570426)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Edit tags of selection"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkDelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete selection"))+"\n\t\t")]),t._v(" "),e("NcActionSeparator"),t._v(" "),e("NcActionButton",{on:{click:t.onSelectAll},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SelectAllIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select all"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{on:{click:t.onCancelSelection},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SelectOffIcon")]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Cancel selection"))+"\n\t\t")])],1)],1)}),[],!1,null,null,null).exports,NcMultiselect:r.Z2,NcActions:r.O3,NcActionButton:r.Js,NcActionInput:r.Iw,NcActionRouter:r.xU,RssIcon:m.Z,SortAscendingIcon:g.Z,SortCalendarAscendingIcon:A.Z,SortAlphabeticalAscendingIcon:h.Z,SortClockAscendingOutlineIcon:f.Z,SortBoolAscendingIcon:p.Z,SortNumericAscendingIcon:k.Z,FolderIcon:u.default,ArrowLeftIcon:d.default,PlusIcon:l.Z,ViewGridIcon:s.Z,ViewListIcon:c.Z,EarthIcon:a.Z,ShareVariantIcon:v.Z,TagIcon:b.Z,NcTextField:r.h3,MagnifyIcon:i.default},props:{},data:function(){return{url:"",search:this.$route.params.search||"",sortingOptions:{added:{icon:"SortCalendarAscendingIcon",description:this.t("bookmarks","Sort by created date")},lastmodified:{icon:"SortClockAscendingOutlineIcon",description:this.t("bookmarks","Sort by last modified")},title:{icon:"SortAlphabeticalAscendingIcon",description:this.t("bookmarks","Sort by title")},clickcount:{icon:"SortBoolAscendingIcon",description:this.t("bookmarks","Sort by click count")},index:{icon:"SortAscendingIcon",description:this.t("bookmarks","Sort by manual order")},url:{icon:"SortNumericAscendingIcon",description:this.t("bookmarks","Sort by URL")}}}},computed:{backLink:function(){return this.folder&&this.folderPath.length>1?{name:this.routes.FOLDER,params:{folder:this.folder.parent_folder}}:{name:this.routes.HOME}},permissions:function(){var t=this.folder;return t?this.$store.getters.getPermissionsForFolder(t.id):{}},allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},tags:function(){var t=this.$route.params.tags;return t?t.split(","):[]},folderPath:function(){var t=this.$route.params.folder;return t?this.$store.getters.getFolder(t).reverse():[]},folder:function(){var t=this.$route.params.folder;if(t)return this.$store.getters.getFolder(t)[0]},viewMode:function(){return this.$store.state.viewMode},hasSelection:function(){return this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length},rssURL:function(){var t=this,e=new URLSearchParams,n=function(n){Array.isArray(t.$store.state.fetchState.query[n])?t.$store.state.fetchState.query[n].forEach((function(t){e.append(n+"[]",t)})):e.append(n,t.$store.state.fetchState.query[n])};for(var o in this.$store.state.fetchState.query)n(o);return e.set("format","rss"),e.set("page","-1"),this.$store.state.public&&e.set("token",this.$store.state.authToken),window.location.origin+(0,C.generateUrl)("/apps/bookmarks/public/rest/v2/bookmark?"+e.toString())},sorting:function(){return this.$store.state.settings.sorting}},created:function(){},methods:{onSelectHome:function(){this.$router.push({name:this.routes.HOME})},onClickBack:function(){this.$router.push(this.backLink)},onTagsChange:function(t){this.$router.push({name:this.routes.TAGS,params:{tags:t.join(",")}})},onSelectFolder:function(t){this.$router.push({name:this.routes.FOLDER,params:{folder:t}})},onOpenFolderShare:function(){this.$store.dispatch(y.Nw.OPEN_FOLDER_SHARING,this.folder.id)},onAddFolder:function(){this.$store.commit(y.P$.DISPLAY_NEW_FOLDER,!this.$store.state.displayNewFolder)},onAddBookmark:function(){this.$store.commit(y.P$.DISPLAY_NEW_BOOKMARK,!this.$store.state.displayNewBookmark)},onToggleViewMode:function(){this.$store.dispatch(y.Nw.SET_SETTING,{key:"viewMode",value:"grid"===this.$store.state.viewMode?"list":"grid"})},onSearch:function(t){this.$router.push({name:this.routes.SEARCH,params:{search:t}})},copyRssUrl:function(){navigator.clipboard.writeText(this.rssURL),this.$store.commit(y.P$.SET_NOTIFICATION,t("bookmarks","RSS feed copied"))},onChangeSorting:function(t){var e,n=this;return(e=rt().mark((function e(){return rt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,n.$store.dispatch(y.Nw.SET_SETTING,{key:"sorting",value:t});case 2:return e.next=4,n.$store.dispatch(y.Nw.FETCH_PAGE);case 4:case"end":return e.stop()}}),e)})),function(){var t=this,n=arguments;return new Promise((function(o,r){var i=e.apply(t,n);function a(t){it(i,o,r,a,s,"next",t)}function s(t){it(i,o,r,a,s,"throw",t)}a(void 0)}))})()}}};var st=o(24750),ct={};ct.styleTagTransform=X(),ct.setAttributes=W(),ct.insert=K().bind(null,"head"),ct.domAPI=Y(),ct.insertStyleElement=Q();V()(st.Z,ct);st.Z&&st.Z.locals&&st.Z.locals;const lt=(0,nt.Z)(at,(function(){var t=this,e=t._self._c;return e("div",{class:["controls",t.$store.state.public&&"wide"]},[e("div",{staticClass:"controls__left"},[t.$route.name===t.routes.FOLDER?e("NcActions",[e("NcActionButton",{on:{click:t.onClickBack},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowLeftIcon")]},proxy:!0}],null,!1,3001860362)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Go back"))+"\n\t\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER?[e("h2",[e("FolderIcon"),t._v(" "),e("span",[t._v(t._s(t.folder.title))])],1),t._v(" "),t.permissions.canShare?e("NcActions",[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onOpenFolderShare},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon")]},proxy:!0}],null,!1,3668921682)},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t\t\t")])],1):t._e()]:t._e(),t._v(" "),t.$route.name===t.routes.TAGS?[e("TagIcon"),t._v(" "),e("NcMultiselect",{staticClass:"controls__tags",attrs:{value:t.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,placeholder:t.t("bookmarks","Select one or more tags")},on:{input:t.onTagsChange}})]:t._e(),t._v(" "),t.isPublic?t._e():e("NcActions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","New"),expression:"t('bookmarks', 'New')"}],attrs:{title:t.t("bookmarks","New")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon")]},proxy:!0}],null,!1,1789392498)},[t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onAddBookmark},scopedSlots:t._u([{key:"icon",fn:function(){return[e("EarthIcon")]},proxy:!0}],null,!1,3514212386)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onAddFolder},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon")]},proxy:!0}],null,!1,1472452094)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New folder"))+"\n\t\t\t")])],1),t._v(" "),t.hasSelection?e("BulkEditing"):t._e()],2),t._v(" "),e("div",{staticClass:"controls__right"},[e("NcActions",[e("NcActionButton",{on:{click:t.onToggleViewMode},scopedSlots:t._u([{key:"icon",fn:function(){return["list"!==t.viewMode?e("ViewListIcon"):e("ViewGridIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s("list"===t.viewMode?t.t("bookmarks","Change to grid view"):t.t("bookmarks","Change to list view"))+"\n\t\t\t")])],1),t._v(" "),e("NcActions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.sortingOptions[t.sorting].description,expression:"sortingOptions[sorting].description"}],scopedSlots:t._u([{key:"icon",fn:function(){return[e(t.sortingOptions[t.sorting].icon,{tag:"component",attrs:{size:20,"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v(" "),t._l(t.sortingOptions,(function(n,o){return e("NcActionButton",{key:o,attrs:{"close-after-click":!0},on:{click:function(e){return t.onChangeSorting(o)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e(n.icon,{tag:"component",attrs:{"fill-color":o===t.sorting?t.colorPrimaryElement:t.colorMainText}})]},proxy:!0}],null,!0)},[t._v("\n\t\t\t\t"+t._s(n.description)+"\n\t\t\t")])}))],2),t._v(" "),e("NcActions",{attrs:{"force-menu":""},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon")]},proxy:!0}])},[t._v(" "),e("NcActionButton",{attrs:{title:t.t("bookmarks","Copy RSS Feed of current view"),"close-after-click":!0},on:{click:t.copyRssUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon")]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.$store.state.public?"":t.t("bookmarks","The RSS feed requires authentication with your Nextcloud credentials"))+"\n\t\t\t")])],1),t._v(" "),e("NcTextField",{staticClass:"inline-search",attrs:{value:t.search,label:t.t("bookmarks","Search"),placeholder:t.t("bookmarks","Search")},on:{"update:value":[function(e){t.search=e},function(e){return t.onSearch(e)}]}},[e("MagnifyIcon")],1)],1)])}),[],!1,null,null,null).exports},22868:()=>{},14777:()=>{},99830:()=>{},70209:()=>{},87414:()=>{}}]);
//# sourceMappingURL=bookmarks-src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue.js.map?v=71917fbe559e07e478c1