/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchShardIterator;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.common.Nullable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.concurrent.AtomicArray;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.transport.Transport;

public interface SearchPhaseContext
extends Executor {
    public int getNumShards();

    public Logger getLogger();

    public SearchTask getTask();

    public SearchRequest getRequest();

    public SearchPhase getCurrentPhase();

    public void sendSearchResponse(InternalSearchResponse var1, AtomicArray<SearchPhaseResult> var2);

    public void onFailure(Exception var1);

    public void onPhaseFailure(SearchPhase var1, String var2, Throwable var3);

    public void onShardFailure(int var1, @Nullable SearchShardTarget var2, Exception var3);

    public Transport.Connection getConnection(String var1, String var2);

    public SearchTransportService getSearchTransport();

    default public void sendReleaseSearchContext(ShardSearchContextId contextId, Transport.Connection connection, OriginalIndices originalIndices) {
        if (connection != null) {
            this.getSearchTransport().sendFreeContext(connection, contextId, originalIndices);
        }
    }

    public ShardSearchRequest buildShardSearchRequest(SearchShardIterator var1);

    public void executeNextPhase(SearchPhase var1, SearchPhase var2);

    public void addReleasable(Releasable var1);
}

