/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.opensearch.common.io.Streams;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.common.lucene.store.IndexOutputOutputStream;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.gateway.CorruptStateException;
import org.opensearch.index.store.exception.ChecksumCombinationException;

public final class ChecksumBlobStoreFormat<T extends ToXContent> {
    private static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedFunction<XContentParser, T, IOException> reader;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name, NamedXContentRegistry namedXContentRegistry) throws IOException {
        String blobName = this.blobName(name);
        return this.deserialize(blobName, namedXContentRegistry, Streams.readFully(blobContainer.readBlob(blobName)));
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, NamedXContentRegistry namedXContentRegistry, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            Object indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers((BytesReference)bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)1, (int)1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            try (XContentParser parser = XContentHelper.createParser(namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), (MediaType)XContentType.SMILE);){
                ToXContent toXContent = (ToXContent)this.reader.apply((Object)parser);
                return (T)toXContent;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, Compressor compressor) throws IOException {
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, compressor);
        blobContainer.writeBlob(blobName, (InputStream)bytes.streamInput(), bytes.length(), false);
    }

    public void writeAsync(T obj, BlobContainer blobContainer, String name, Compressor compressor, ActionListener<Void> listener) throws IOException {
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, compressor);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, compressor);
        String resourceDescription = "ChecksumBlobStoreFormat.writeAsync(blob=\"" + blobName + "\")";
        try (ByteArrayIndexInput input = new ByteArrayIndexInput(resourceDescription, BytesReference.toBytes((BytesReference)bytes));){
            long expectedChecksum;
            try {
                expectedChecksum = RemoteTransferContainer.checksumOfChecksum(input.clone(), 8);
            }
            catch (Exception e) {
                throw new ChecksumCombinationException("Potentially corrupted file: Checksum combination failed while combining stored checksum and calculated checksum of stored checksum", resourceDescription, e);
            }
            try (RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length(), true, WritePriority.HIGH, (size, position) -> new OffsetRangeIndexInputStream(input, size, position), expectedChecksum, ((AsyncMultiStreamBlobContainer)blobContainer).remoteIntegrityCheckSupported());){
                ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
            }
        }
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor) throws IOException {
        try (BytesStreamOutput outputStream = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, (OutputStream)((Object)outputStream), 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream((IndexOutput)indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };
                     XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)XContentType.SMILE, (OutputStream)compressor.threadLocalOutputStream((OutputStream)indexOutputOutputStream));){
                    builder.startObject();
                    obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
                    builder.endObject();
                }
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            BytesReference bytesReference = outputStream.bytes();
            return bytesReference;
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

