/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class ModuleDetailsProvider
extends DetailsProvider.Basic {
    private static final String MODULE_MASK = "java.lang.Module";
    private static final String MODULE_DESCR_MASK = "java.lang.module.ModuleDescriptor";
    private static final String MODULE_VERSION_MASK = "java.lang.module.ModuleDescriptor$Version";
    private static final String MODULE_REF_MASK = "java.lang.module.ModuleReference+";
    private static final String RES_MODULE_MASK = "java.lang.module.ResolvedModule";

    public ModuleDetailsProvider() {
        super(MODULE_MASK, MODULE_DESCR_MASK, MODULE_VERSION_MASK, MODULE_REF_MASK, RES_MODULE_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.lang.Module": {
                String name = DetailsUtils.getInstanceFieldString(instance, "descriptor");
                if (name == null) {
                    return "unnamed module #" + instance.getInstanceNumber();
                }
                return name;
            }
            case "java.lang.module.ModuleDescriptor": {
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                String version = DetailsUtils.getInstanceFieldString(instance, "version");
                if (version == null) {
                    return name;
                }
                return name + "@" + version;
            }
            case "java.lang.module.ModuleDescriptor$Version": {
                return DetailsUtils.getInstanceFieldString(instance, "version");
            }
            case "java.lang.module.ResolvedModule": {
                return DetailsUtils.getInstanceFieldString(instance, "mref");
            }
            case "java.lang.module.ModuleReference+": {
                String patched;
                String name = DetailsUtils.getInstanceFieldString(instance, "descriptor");
                String loc = DetailsUtils.getInstanceFieldString(instance, "location");
                boolean patcher = instance.getValueOfField("patcher") != null;
                String string = patched = patcher ? " (patched)" : "";
                if (loc == null) {
                    return String.valueOf(name) + patched;
                }
                return String.valueOf(name) + ", " + loc + patched;
            }
        }
        return null;
    }
}

