/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.CanRaise;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;

public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode,
CanRaise {
    private final Node receiverNode;
    private Node argsNode;
    protected Node iterNode;
    private RubySymbol name;
    private final boolean isLazy;

    public CallNode(int line, Node receiverNode, RubySymbol name2, Node argsNode, Node iterNode, boolean isLazy) {
        super(line, receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        this.name = name2;
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        this.iterNode = iterNode;
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        return argsNode;
    }

    @Override
    public RubySymbol getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    protected String toStringInternal() {
        return this.isLazy ? "lazy" : null;
    }
}

