/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;

public class NeighborArray {
    private final boolean scoresDescOrder;
    private int size;
    float[] score;
    int[] node;
    private int sortedNodeSize;

    public NeighborArray(int maxSize, boolean descOrder) {
        this.node = new int[maxSize];
        this.score = new float[maxSize];
        this.scoresDescOrder = descOrder;
    }

    public void addInOrder(int newNode, float newScore) {
        assert (this.size == this.sortedNodeSize) : "cannot call addInOrder after addOutOfOrder";
        if (this.size == this.node.length) {
            this.node = ArrayUtil.grow(this.node);
            this.score = ArrayUtil.growExact(this.score, this.node.length);
        }
        if (this.size > 0) {
            float previousScore = this.score[this.size - 1];
            assert (this.scoresDescOrder && previousScore >= newScore || !this.scoresDescOrder && previousScore <= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.score, 0, this.size));
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
        ++this.sortedNodeSize;
    }

    public void addOutOfOrder(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.node = ArrayUtil.grow(this.node);
            this.score = ArrayUtil.growExact(this.score, this.node.length);
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    public int[] sort() {
        if (this.size == this.sortedNodeSize) {
            return null;
        }
        assert (this.sortedNodeSize < this.size);
        int[] uncheckedIndexes = new int[this.size - this.sortedNodeSize];
        int count = 0;
        while (this.sortedNodeSize != this.size) {
            uncheckedIndexes[count] = this.insertSortedInternal();
            for (int i = 0; i < count; ++i) {
                if (uncheckedIndexes[i] < uncheckedIndexes[count]) continue;
                int n = i;
                uncheckedIndexes[n] = uncheckedIndexes[n] + 1;
            }
            ++count;
        }
        Arrays.sort(uncheckedIndexes);
        return uncheckedIndexes;
    }

    private int insertSortedInternal() {
        assert (this.sortedNodeSize < this.size) : "Call this method only when there's unsorted node";
        int tmpNode = this.node[this.sortedNodeSize];
        float tmpScore = this.score[this.sortedNodeSize];
        int insertionPoint = this.scoresDescOrder ? this.descSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize) : this.ascSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize);
        System.arraycopy(this.node, insertionPoint, this.node, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        System.arraycopy(this.score, insertionPoint, this.score, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        this.node[insertionPoint] = tmpNode;
        this.score[insertionPoint] = tmpScore;
        ++this.sortedNodeSize;
        return insertionPoint;
    }

    void insertSorted(int newNode, float newScore) {
        this.addOutOfOrder(newNode, newScore);
        this.insertSortedInternal();
    }

    public int size() {
        return this.size;
    }

    public int[] node() {
        return this.node;
    }

    public float[] score() {
        return this.score;
    }

    public void clear() {
        this.size = 0;
        this.sortedNodeSize = 0;
    }

    public void removeLast() {
        --this.size;
        this.sortedNodeSize = Math.min(this.sortedNodeSize, this.size);
    }

    public void removeIndex(int idx) {
        System.arraycopy(this.node, idx + 1, this.node, idx, this.size - idx - 1);
        System.arraycopy(this.score, idx + 1, this.score, idx, this.size - idx - 1);
        if (idx < this.sortedNodeSize) {
            --this.sortedNodeSize;
        }
        --this.size;
    }

    public String toString() {
        return "NeighborArray[" + this.size + "]";
    }

    private int ascSortFindRightMostInsertionPoint(float newScore, int bound) {
        int insertionPoint = Arrays.binarySearch(this.score, 0, bound, newScore);
        if (insertionPoint >= 0) {
            while (insertionPoint < bound - 1 && this.score[insertionPoint + 1] == this.score[insertionPoint]) {
                ++insertionPoint;
            }
            ++insertionPoint;
        } else {
            insertionPoint = -insertionPoint - 1;
        }
        return insertionPoint;
    }

    private int descSortFindRightMostInsertionPoint(float newScore, int bound) {
        int start = 0;
        int end = bound - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.score[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }
}

