/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.action.index;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.MetadataMappingService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.EmptyTransportResponseHandler;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;

public class NodeMappingRefreshAction {
    private static final Logger logger = LogManager.getLogger(NodeMappingRefreshAction.class);
    public static final String ACTION_NAME = "internal:cluster/node/mapping/refresh";
    private final TransportService transportService;
    private final MetadataMappingService metadataMappingService;

    @Inject
    public NodeMappingRefreshAction(TransportService transportService, MetadataMappingService metadataMappingService) {
        this.transportService = transportService;
        this.metadataMappingService = metadataMappingService;
        transportService.registerRequestHandler(ACTION_NAME, "same", NodeMappingRefreshRequest::new, new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(DiscoveryNode clusterManagerNode, NodeMappingRefreshRequest request) {
        if (clusterManagerNode == null) {
            logger.warn("can't send mapping refresh for [{}], no cluster-manager known.", (Object)request.index());
            return;
        }
        this.transportService.sendRequest(clusterManagerNode, ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String nodeId;

        public NodeMappingRefreshRequest(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.nodeId = in.readString();
            this.indexUUID = in.readString();
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.nodeId = nodeId;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
            out.writeString(this.indexUUID);
        }
    }

    private class NodeMappingRefreshTransportHandler
    implements TransportRequestHandler<NodeMappingRefreshRequest> {
        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel, Task task) throws Exception {
            NodeMappingRefreshAction.this.metadataMappingService.refreshMapping(request.index(), request.indexUUID());
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        }
    }
}

