/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.opensearch.cluster.routing.allocation.AllocationDecision;
import org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public final class MoveDecision
extends AbstractAllocationDecision {
    public static final MoveDecision NOT_TAKEN = new MoveDecision(null, null, AllocationDecision.NO_ATTEMPT, null, null, 0);
    private static final MoveDecision CACHED_STAY_DECISION = new MoveDecision(Decision.YES, null, AllocationDecision.NO_ATTEMPT, null, null, 0);
    private static final MoveDecision CACHED_CANNOT_MOVE_DECISION = new MoveDecision(Decision.NO, null, AllocationDecision.NO, null, null, 0);
    @Nullable
    AllocationDecision allocationDecision;
    @Nullable
    private final Decision canRemainDecision;
    @Nullable
    private final Decision clusterRebalanceDecision;
    private final int currentNodeRanking;

    private MoveDecision(Decision canRemainDecision, Decision clusterRebalanceDecision, AllocationDecision allocationDecision, DiscoveryNode assignedNode, List<NodeAllocationResult> nodeDecisions, int currentNodeRanking) {
        super(assignedNode, nodeDecisions);
        this.allocationDecision = allocationDecision;
        this.canRemainDecision = canRemainDecision;
        this.clusterRebalanceDecision = clusterRebalanceDecision;
        this.currentNodeRanking = currentNodeRanking;
    }

    public MoveDecision(StreamInput in) throws IOException {
        super(in);
        this.allocationDecision = (AllocationDecision)in.readOptionalWriteable(AllocationDecision::readFrom);
        this.canRemainDecision = (Decision)in.readOptionalWriteable(Decision::readFrom);
        this.clusterRebalanceDecision = (Decision)in.readOptionalWriteable(Decision::readFrom);
        this.currentNodeRanking = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.allocationDecision);
        out.writeOptionalWriteable((Writeable)this.canRemainDecision);
        out.writeOptionalWriteable((Writeable)this.clusterRebalanceDecision);
        out.writeVInt(this.currentNodeRanking);
    }

    public static MoveDecision stay(Decision canRemainDecision) {
        if (canRemainDecision != null) {
            assert (canRemainDecision.type() != Decision.Type.NO);
            return new MoveDecision(canRemainDecision, null, AllocationDecision.NO_ATTEMPT, null, null, 0);
        }
        return CACHED_STAY_DECISION;
    }

    public static MoveDecision cannotRemain(Decision canRemainDecision, AllocationDecision allocationDecision, DiscoveryNode assignedNode, List<NodeAllocationResult> nodeDecisions) {
        assert (canRemainDecision != null);
        assert (canRemainDecision.type() != Decision.Type.YES) : "create decision with MoveDecision#stay instead";
        if (nodeDecisions == null && allocationDecision == AllocationDecision.NO) {
            return CACHED_CANNOT_MOVE_DECISION;
        }
        assert (assignedNode == null == (allocationDecision != AllocationDecision.YES));
        return new MoveDecision(canRemainDecision, null, allocationDecision, assignedNode, nodeDecisions, 0);
    }

    public static MoveDecision cannotRebalance(Decision canRebalanceDecision, AllocationDecision allocationDecision, int currentNodeRanking, List<NodeAllocationResult> nodeDecisions) {
        return new MoveDecision(null, canRebalanceDecision, allocationDecision, null, nodeDecisions, currentNodeRanking);
    }

    public static MoveDecision rebalance(Decision canRebalanceDecision, AllocationDecision allocationDecision, @Nullable DiscoveryNode assignedNode, int currentNodeRanking, List<NodeAllocationResult> nodeDecisions) {
        return new MoveDecision(null, canRebalanceDecision, allocationDecision, assignedNode, nodeDecisions, currentNodeRanking);
    }

    @Override
    public boolean isDecisionTaken() {
        return this.canRemainDecision != null || this.clusterRebalanceDecision != null;
    }

    public MoveDecision withRemainDecision(Decision canRemainDecision) {
        return new MoveDecision(canRemainDecision, this.clusterRebalanceDecision, this.allocationDecision, this.targetNode, this.nodeDecisions, this.currentNodeRanking);
    }

    public boolean forceMove() {
        this.checkDecisionState();
        return !this.canRemain() && this.allocationDecision == AllocationDecision.YES;
    }

    public boolean canRemain() {
        this.checkDecisionState();
        return this.canRemainDecision.type() == Decision.Type.YES;
    }

    public Decision getCanRemainDecision() {
        this.checkDecisionState();
        return this.canRemainDecision;
    }

    public boolean canRebalanceCluster() {
        this.checkDecisionState();
        return this.clusterRebalanceDecision != null && this.clusterRebalanceDecision.type() == Decision.Type.YES;
    }

    @Nullable
    public Decision getClusterRebalanceDecision() {
        this.checkDecisionState();
        return this.clusterRebalanceDecision;
    }

    @Nullable
    public AllocationDecision getAllocationDecision() {
        return this.allocationDecision;
    }

    public int getCurrentNodeRanking() {
        this.checkDecisionState();
        return this.currentNodeRanking;
    }

    @Override
    public String getExplanation() {
        Object explanation;
        this.checkDecisionState();
        if (this.clusterRebalanceDecision != null) {
            if (this.allocationDecision == AllocationDecision.AWAITING_INFO) {
                explanation = "cannot rebalance as information about existing copies of this shard in the cluster is still being gathered";
            } else if (this.clusterRebalanceDecision.type() == Decision.Type.NO) {
                explanation = "rebalancing is not allowed" + (this.atLeastOneNodeWithYesDecision() ? ", even though there is at least one node on which the shard can be allocated" : "");
            } else if (this.clusterRebalanceDecision.type() == Decision.Type.THROTTLE) {
                explanation = "rebalancing is throttled";
            } else {
                assert (this.clusterRebalanceDecision.type() == Decision.Type.YES);
                explanation = this.getTargetNode() != null ? (this.allocationDecision == AllocationDecision.THROTTLED ? "shard rebalancing throttled" : "can rebalance shard") : "cannot rebalance as no target node exists that can both allocate this shard and improve the cluster balance";
            }
        } else {
            assert (!this.canRemain());
            if (this.allocationDecision == AllocationDecision.YES) {
                explanation = "shard cannot remain on this node and is force-moved to another node";
            } else if (this.allocationDecision == AllocationDecision.THROTTLED) {
                explanation = "shard cannot remain on this node but is throttled on moving to another node";
            } else {
                assert (this.allocationDecision == AllocationDecision.NO);
                explanation = "cannot move shard to another node, even though it is not allowed to remain on its current node";
            }
        }
        return explanation;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.checkDecisionState();
        if (this.targetNode != null) {
            builder.startObject("target_node");
            MoveDecision.discoveryNodeToXContent(this.targetNode, true, builder);
            builder.endObject();
        }
        builder.field("can_remain_on_current_node", this.canRemain() ? "yes" : "no");
        if (!this.canRemain() && !this.canRemainDecision.getDecisions().isEmpty()) {
            builder.startArray("can_remain_decisions");
            this.canRemainDecision.toXContent(builder, params);
            builder.endArray();
        }
        if (this.clusterRebalanceDecision != null) {
            AllocationDecision rebalanceDecision = AllocationDecision.fromDecisionType(this.clusterRebalanceDecision.type());
            builder.field("can_rebalance_cluster", (Object)rebalanceDecision);
            if (rebalanceDecision != AllocationDecision.YES && !this.clusterRebalanceDecision.getDecisions().isEmpty()) {
                builder.startArray("can_rebalance_cluster_decisions");
                this.clusterRebalanceDecision.toXContent(builder, params);
                builder.endArray();
            }
        }
        if (this.clusterRebalanceDecision != null) {
            builder.field("can_rebalance_to_other_node", (Object)this.allocationDecision);
            builder.field("rebalance_explanation", this.getExplanation());
        } else {
            builder.field("can_move_to_other_node", this.forceMove() ? "yes" : "no");
            builder.field("move_explanation", this.getExplanation());
        }
        this.nodeDecisionsToXContent(this.nodeDecisions, builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof MoveDecision)) {
            return false;
        }
        MoveDecision that = (MoveDecision)other;
        return Objects.equals((Object)this.allocationDecision, (Object)that.allocationDecision) && Objects.equals(this.canRemainDecision, that.canRemainDecision) && Objects.equals(this.clusterRebalanceDecision, that.clusterRebalanceDecision) && this.currentNodeRanking == that.currentNodeRanking;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.allocationDecision, this.canRemainDecision, this.clusterRebalanceDecision, this.currentNodeRanking});
    }
}

