/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class ReplicationStats
implements ToXContentFragment,
Writeable {
    public long maxBytesBehind;
    public long maxReplicationLag;
    public long totalBytesBehind;

    public ReplicationStats(long maxBytesBehind, long totalBytesBehind, long maxReplicationLag) {
        this.maxBytesBehind = maxBytesBehind;
        this.totalBytesBehind = totalBytesBehind;
        this.maxReplicationLag = maxReplicationLag;
    }

    public ReplicationStats(StreamInput in) throws IOException {
        this.maxBytesBehind = in.readVLong();
        this.totalBytesBehind = in.readVLong();
        this.maxReplicationLag = in.readVLong();
    }

    public ReplicationStats() {
    }

    public void add(ReplicationStats other) {
        if (other != null) {
            this.maxBytesBehind = Math.max(other.maxBytesBehind, this.maxBytesBehind);
            this.totalBytesBehind += other.totalBytesBehind;
            this.maxReplicationLag = Math.max(other.maxReplicationLag, this.maxReplicationLag);
        }
    }

    public long getMaxBytesBehind() {
        return this.maxBytesBehind;
    }

    public long getTotalBytesBehind() {
        return this.totalBytesBehind;
    }

    public long getMaxReplicationLag() {
        return this.maxReplicationLag;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.maxBytesBehind);
        out.writeVLong(this.totalBytesBehind);
        out.writeVLong(this.maxReplicationLag);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segment_replication");
        builder.field("max_bytes_behind", new ByteSizeValue(this.maxBytesBehind).toString());
        builder.field("total_bytes_behind", new ByteSizeValue(this.totalBytesBehind).toString());
        builder.field("max_replication_lag", (Object)new TimeValue(this.maxReplicationLag));
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SEGMENT_REPLICATION = "segment_replication";
        static final String MAX_BYTES_BEHIND = "max_bytes_behind";
        static final String TOTAL_BYTES_BEHIND = "total_bytes_behind";
        static final String MAX_REPLICATION_LAG = "max_replication_lag";

        Fields() {
        }
    }
}

