/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.cache.bitset;

import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.AbstractIndexShardComponent;

public class ShardBitsetFilterCache
extends AbstractIndexShardComponent {
    private final CounterMetric totalMetric = new CounterMetric();

    public ShardBitsetFilterCache(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }

    public long getMemorySizeInBytes() {
        return this.totalMetric.count();
    }
}

