/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.aggregators;

public class MovingAverage {
    private double sum;
    private int oldestElementIndex;
    private double[] lastNElements;
    private boolean isArrayFull;

    public MovingAverage(int window_length) {
        this.lastNElements = new double[window_length];
        this.oldestElementIndex = 0;
        this.sum = 0.0;
        this.isArrayFull = false;
    }

    public double next(double val) {
        this.sum -= this.lastNElements[this.oldestElementIndex];
        this.sum += val;
        this.lastNElements[this.oldestElementIndex] = val;
        this.oldestElementIndex = (this.oldestElementIndex + 1) % this.lastNElements.length;
        if (!this.isArrayFull && this.oldestElementIndex == 0) {
            this.isArrayFull = true;
        }
        int count = this.lastNElements.length;
        if (!this.isArrayFull) {
            count = this.oldestElementIndex;
            return -1.0;
        }
        return this.sum * 1.0 / (double)count;
    }
}

