/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.state.ReplicationStateMetadataKt;
import org.opensearch.replication.task.CrossClusterReplicationTask;
import org.opensearch.replication.task.shard.FollowerClusterStats;
import org.opensearch.replication.task.shard.ShardReplicationParams;
import org.opensearch.replication.task.shard.ShardReplicationTask;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011JJ\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0014J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J\u0018\u0010)\u001a\u00020%2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationExecutor;", "Lorg/opensearch/persistent/PersistentTasksExecutor;", "Lorg/opensearch/replication/task/shard/ShardReplicationParams;", "executor", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "client", "Lorg/opensearch/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "stats", "Lorg/opensearch/replication/task/shard/FollowerClusterStats;", "(Ljava/lang/String;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/ReplicationSettings;Lorg/opensearch/replication/task/shard/FollowerClusterStats;)V", "createTask", "Lorg/opensearch/persistent/AllocatedPersistentTask;", "id", "", "type", "action", "parentTaskId", "Lorg/opensearch/core/tasks/TaskId;", "taskInProgress", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$PersistentTask;", "headers", "", "getAssignment", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$Assignment;", "params", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "getDescription", "nodeOperation", "", "task", "state", "Lorg/opensearch/persistent/PersistentTaskState;", "validate", "Companion", "opensearch-cross-cluster-replication"})
public final class ShardReplicationExecutor
extends PersistentTasksExecutor<ShardReplicationParams> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    @NotNull
    private final ReplicationSettings replicationSettings;
    @NotNull
    private final FollowerClusterStats stats;
    @NotNull
    public static final String TASK_NAME = "cluster:indices/shards/replication";
    @NotNull
    private static final PersistentTasksCustomMetadata.Assignment SHARD_NOT_ACTIVE = new PersistentTasksCustomMetadata.Assignment(null, "No active shard found");
    private static final Logger log = LogManager.getLogger(ShardReplicationExecutor.class);

    public ShardReplicationExecutor(@NotNull String executor, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull ReplicationSettings replicationSettings, @NotNull FollowerClusterStats stats) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        super(TASK_NAME, executor);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
        this.replicationSettings = replicationSettings;
        this.stats = stats;
    }

    public void validate(@NotNull ShardReplicationParams params, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        ShardRouting shardRouting = clusterState.getRoutingTable().shardRoutingTable(params.getFollowerShardId()).primaryShard();
        if (shardRouting == null) {
            throw new OpenSearchException("no primary shard available for " + params.getFollowerShardId(), new Object[0]);
        }
        String string = params.getFollowerShardId().getIndexName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.followerShardId.indexName");
        Map<String, String> map = ReplicationStateMetadataKt.getReplicationStateParamsForIndex(this.clusterService, string);
        if (map == null) {
            throw new IllegalStateException("Cant find replication details metadata for followIndex:" + params.getFollowerShardId().getIndexName() + ". Seems like replication is not in progress, so not starting shard task for shardId:" + params.getFollowerShardId());
        }
        Map<String, String> replicationStateParams = map;
        if (!Intrinsics.areEqual((Object)replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE"), (Object)"RUNNING")) {
            throw new IllegalStateException("Unknown replication state metadata:" + replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE") + "  followIndex:" + params.getFollowerShardId().getIndexName());
        }
    }

    @NotNull
    public PersistentTasksCustomMetadata.Assignment getAssignment(@NotNull ShardReplicationParams params, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        try {
            ShardRouting primaryShard = clusterState.routingTable().shardRoutingTable(params.getFollowerShardId()).primaryShard();
            if (!primaryShard.active()) {
                return SHARD_NOT_ACTIVE;
            }
            return new PersistentTasksCustomMetadata.Assignment(primaryShard.currentNodeId(), "node with primary shard");
        }
        catch (Exception e) {
            log.error("Failed to assign shard replication task with id  " + params.getFollowerShardId(), (Throwable)e);
            return SHARD_NOT_ACTIVE;
        }
    }

    protected void nodeOperation(@NotNull AllocatedPersistentTask task, @NotNull ShardReplicationParams params, @Nullable PersistentTaskState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (task instanceof ShardReplicationTask) {
            log.info("starting persistent replication task: " + params + ", " + state + ", " + ((ShardReplicationTask)task).getAllocationId() + ", " + ((ShardReplicationTask)task).getStatus());
            CrossClusterReplicationTask.run$default((CrossClusterReplicationTask)task, null, 1, null);
        } else {
            task.markAsFailed((Exception)new IllegalArgumentException("Unknown task class " + task.getClass()));
        }
    }

    @NotNull
    protected AllocatedPersistentTask createTask(long id, @NotNull String type, @NotNull String action, @NotNull TaskId parentTaskId, @NotNull PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams> taskInProgress, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)parentTaskId, (String)"parentTaskId");
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String string = this.getDescription(taskInProgress);
        PersistentTaskParams persistentTaskParams = taskInProgress.getParams();
        Intrinsics.checkNotNull((Object)persistentTaskParams);
        ShardReplicationParams shardReplicationParams = (ShardReplicationParams)persistentTaskParams;
        String string2 = this.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"executor");
        return new ShardReplicationTask(id, type, action, string, parentTaskId, shardReplicationParams, string2, this.clusterService, this.threadPool, this.client, this.replicationMetadataManager, this.replicationSettings, this.stats);
    }

    @NotNull
    protected String getDescription(@NotNull PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams> taskInProgress) {
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        PersistentTaskParams persistentTaskParams = taskInProgress.getParams();
        if (persistentTaskParams == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)persistentTaskParams, (String)"requireNotNull(taskInProgress.params)");
        ShardReplicationParams params = (ShardReplicationParams)persistentTaskParams;
        return "replication:" + params.getLeaderAlias() + ':' + params.getLeaderShardId() + " -> " + params.getFollowerShardId();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationExecutor$Companion;", "", "()V", "SHARD_NOT_ACTIVE", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$Assignment;", "getSHARD_NOT_ACTIVE", "()Lorg/opensearch/persistent/PersistentTasksCustomMetadata$Assignment;", "TASK_NAME", "", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/logging/log4j/Logger;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PersistentTasksCustomMetadata.Assignment getSHARD_NOT_ACTIVE() {
            return SHARD_NOT_ACTIVE;
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

