/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.github.wnameless.json.base.JsonPrinter;
import com.github.wnameless.json.flattener.JsonifyLinkedHashMap;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public JsonifyArrayList() {
    }

    public JsonifyArrayList(Collection<E> coll) {
        super(coll);
    }

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        switch (printMode) {
            case PRETTY: {
                return JsonPrinter.prettyPrint((String)this.toString());
            }
        }
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object e : this) {
            if (e instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)e)));
                sb.append('\"');
            } else if (e instanceof Collection) {
                sb.append(new JsonifyArrayList<E>((Collection)e));
            } else if (e instanceof Map) {
                sb.append(new JsonifyLinkedHashMap((Map)e));
            } else {
                sb.append(e);
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }
}

