/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public interface TruffleLocalObjectNode<O extends TruffleObject>
extends TruffleObjectNode<O> {

    public static class Renderer
    extends MultiRenderer
    implements HeapViewerRenderer {
        private final LabelRenderer lvRenderer = new LabelRenderer(){

            public String toString() {
                return this.getText() + " ";
            }
        };
        private final TruffleObjectNode.Renderer dobjectRenderer;
        private final ProfilerRenderer[] renderers;

        public Renderer(Heap heap, Icon icon) {
            this.lvRenderer.setText("local object");
            this.lvRenderer.setMargin(3, 3, 3, 1);
            this.dobjectRenderer = new TruffleObjectNode.Renderer(heap, icon);
            this.renderers = new ProfilerRenderer[]{this.lvRenderer, this.dobjectRenderer};
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            this.dobjectRenderer.setValue(value, row);
        }

        public Icon getIcon() {
            return this.dobjectRenderer.getIcon();
        }

        public String getShortName() {
            String name = this.dobjectRenderer.getShortName();
            int nameIdx = name.lastIndexOf(91);
            if (nameIdx != -1) {
                name = name.substring(0, nameIdx).trim();
            }
            return name;
        }
    }

    public static class InstanceBased<O extends TruffleObject.InstanceBased>
    extends TruffleObjectNode.InstanceBased<O>
    implements TruffleLocalObjectNode<O> {
        public InstanceBased(O object, String type) {
            super(object, type);
        }

        @Override
        public String getName() {
            return "local object " + this.getObjectName();
        }

        public InstanceNode createCopy() {
            return null;
        }

        protected void setupCopy(InstanceBased copy) {
            super.setupCopy(copy);
        }
    }
}

