/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.storage;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClientBuilder;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.client.Client;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.spark.client.EmrClientImpl;
import org.opensearch.sql.spark.client.SparkClient;
import org.opensearch.sql.spark.helper.FlintHelper;
import org.opensearch.sql.spark.response.SparkResponse;
import org.opensearch.sql.spark.storage.SparkStorageEngine;
import org.opensearch.sql.storage.DataSourceFactory;
import org.opensearch.sql.storage.StorageEngine;

public class SparkStorageFactory
implements DataSourceFactory {
    private final Client client;
    private final Settings settings;
    public static final String CONNECTOR_TYPE = "spark.connector";
    public static final String SPARK_SQL_APPLICATION = "spark.sql.application";
    public static final String EMR_CLUSTER = "emr.cluster";
    public static final String EMR_AUTH_TYPE = "emr.auth.type";
    public static final String EMR_REGION = "emr.auth.region";
    public static final String EMR_ROLE_ARN = "emr.auth.role_arn";
    public static final String EMR_ACCESS_KEY = "emr.auth.access_key";
    public static final String EMR_SECRET_KEY = "emr.auth.secret_key";
    public static final String FLINT_INTEGRATION = "spark.datasource.flint.integration";
    public static final String FLINT_HOST = "spark.datasource.flint.host";
    public static final String FLINT_PORT = "spark.datasource.flint.port";
    public static final String FLINT_SCHEME = "spark.datasource.flint.scheme";
    public static final String FLINT_AUTH = "spark.datasource.flint.auth";
    public static final String FLINT_REGION = "spark.datasource.flint.region";

    public DataSourceType getDataSourceType() {
        return DataSourceType.SPARK;
    }

    public DataSource createDataSource(DataSourceMetadata metadata) {
        return new DataSource(metadata.getName(), DataSourceType.SPARK, this.getStorageEngine(metadata.getProperties()));
    }

    StorageEngine getStorageEngine(Map<String, String> requiredConfig) {
        if (!requiredConfig.get(CONNECTOR_TYPE).equals("emr")) {
            throw new InvalidParameterException("Spark connector type is invalid.");
        }
        SparkClient sparkClient = AccessController.doPrivileged(() -> {
            this.validateEMRConfigProperties(requiredConfig);
            return new EmrClientImpl(this.getEMRClient((String)requiredConfig.get(EMR_ACCESS_KEY), (String)requiredConfig.get(EMR_SECRET_KEY), (String)requiredConfig.get(EMR_REGION)), (String)requiredConfig.get(EMR_CLUSTER), new FlintHelper((String)requiredConfig.get(FLINT_INTEGRATION), (String)requiredConfig.get(FLINT_HOST), (String)requiredConfig.get(FLINT_PORT), (String)requiredConfig.get(FLINT_SCHEME), (String)requiredConfig.get(FLINT_AUTH), (String)requiredConfig.get(FLINT_REGION)), new SparkResponse(this.client, null, "stepId.keyword"), (String)requiredConfig.get(SPARK_SQL_APPLICATION));
        });
        return new SparkStorageEngine(sparkClient);
    }

    private void validateEMRConfigProperties(Map<String, String> dataSourceMetadataConfig) throws IllegalArgumentException {
        if (dataSourceMetadataConfig.get(EMR_CLUSTER) == null || dataSourceMetadataConfig.get(EMR_AUTH_TYPE) == null) {
            throw new IllegalArgumentException("EMR config properties are missing.");
        }
        if (dataSourceMetadataConfig.get(EMR_AUTH_TYPE).equals(AuthenticationType.AWSSIGV4AUTH.getName()) && (dataSourceMetadataConfig.get(EMR_ACCESS_KEY) == null || dataSourceMetadataConfig.get(EMR_SECRET_KEY) == null)) {
            throw new IllegalArgumentException("EMR auth keys are missing.");
        }
        if (!dataSourceMetadataConfig.get(EMR_AUTH_TYPE).equals(AuthenticationType.AWSSIGV4AUTH.getName())) {
            throw new IllegalArgumentException("Invalid auth type.");
        }
    }

    private AmazonElasticMapReduce getEMRClient(String emrAccessKey, String emrSecretKey, String emrRegion) {
        return (AmazonElasticMapReduce)((AmazonElasticMapReduceClientBuilder)((AmazonElasticMapReduceClientBuilder)AmazonElasticMapReduceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(emrAccessKey, emrSecretKey)))).withRegion(emrRegion)).build();
    }

    @Generated
    public SparkStorageFactory(Client client, Settings settings) {
        this.client = client;
        this.settings = settings;
    }
}

