/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class IOUtils {
    public static final int CR = 13;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int EOF = -1;
    public static final int LF = 10;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int size) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, size);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int size) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, size);
    }

    public static BufferedReader buffer(Reader reader2) {
        return reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2);
    }

    public static BufferedReader buffer(Reader reader2, int size) {
        return reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, size);
    }

    public static BufferedWriter buffer(Writer writer2) {
        return writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter(writer2);
    }

    public static BufferedWriter buffer(Writer writer2, int size) {
        return writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter(writer2, size);
    }

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int size) {
        return new char[size];
    }

    static void clear() {
        SCRATCH_BYTE_BUFFER_RW.remove();
        SCRATCH_CHAR_BUFFER_RW.remove();
        Arrays.fill(SCRATCH_BYTE_BUFFER_WO, (byte)0);
        Arrays.fill(SCRATCH_CHAR_BUFFER_WO, '\u0000');
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeables) throws IOExceptionList {
        IOConsumer.forAll(IOUtils::close, closeables);
    }

    public static void close(Closeable closeable, IOConsumer<IOException> consumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e2) {
                    if (consumer == null) break block3;
                    consumer.accept(e2);
                }
            }
        }
    }

    public static void close(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    private static void closeQ(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables != null) {
            IOUtils.closeQuietly(Arrays.stream(closeables));
        }
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e2) {
                    if (consumer == null) break block3;
                    consumer.accept(e2);
                }
            }
        }
    }

    public static void closeQuietly(InputStream input) {
        IOUtils.closeQ(input);
    }

    public static void closeQuietly(Iterable<Closeable> closeables) {
        if (closeables != null) {
            closeables.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(OutputStream output) {
        IOUtils.closeQ(output);
    }

    public static void closeQuietly(Reader reader2) {
        IOUtils.closeQ(reader2);
    }

    public static void closeQuietly(Selector selector) {
        IOUtils.closeQ(selector);
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        IOUtils.closeQ(serverSocket);
    }

    public static void closeQuietly(Socket socket) {
        IOUtils.closeQ(socket);
    }

    public static void closeQuietly(Stream<Closeable> closeables) {
        if (closeables != null) {
            closeables.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(Writer writer2) {
        IOUtils.closeQ(writer2);
    }

    public static long consume(InputStream input) throws IOException {
        return IOUtils.copyLarge(input, NullOutputStream.INSTANCE);
    }

    public static long consume(Reader input) throws IOException {
        return IOUtils.copyLarge(input, NullWriter.INSTANCE);
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null || input2 == null) {
            return false;
        }
        byte[] array1 = IOUtils.getScratchByteArray();
        byte[] array2 = IOUtils.byteArray();
        block0: while (true) {
            int pos1 = 0;
            int pos2 = 0;
            int index2 = 0;
            while (true) {
                if (index2 >= 8192) continue block0;
                if (pos1 == index2) {
                    int count1;
                    while ((count1 = input1.read(array1, pos1, 8192 - pos1)) == 0) {
                    }
                    if (count1 == -1) {
                        return pos2 == index2 && input2.read() == -1;
                    }
                    pos1 += count1;
                }
                if (pos2 == index2) {
                    int count2;
                    while ((count2 = input2.read(array2, pos2, 8192 - pos2)) == 0) {
                    }
                    if (count2 == -1) {
                        return pos1 == index2 && input1.read() == -1;
                    }
                    pos2 += count2;
                }
                if (array1[index2] != array2[index2]) {
                    return false;
                }
                ++index2;
            }
            break;
        }
    }

    private static boolean contentEquals(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (Objects.equals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null || input2 == null) {
            return false;
        }
        char[] array1 = IOUtils.getScratchCharArray();
        char[] array2 = IOUtils.charArray();
        block0: while (true) {
            int pos1 = 0;
            int pos2 = 0;
            int index2 = 0;
            while (true) {
                if (index2 >= 8192) continue block0;
                if (pos1 == index2) {
                    int count1;
                    while ((count1 = input1.read(array1, pos1, 8192 - pos1)) == 0) {
                    }
                    if (count1 == -1) {
                        return pos2 == index2 && input2.read() == -1;
                    }
                    pos1 += count1;
                }
                if (pos2 == index2) {
                    int count2;
                    while ((count2 = input2.read(array2, pos2, 8192 - pos2)) == 0) {
                    }
                    if (count2 == -1) {
                        return pos1 == index2 && input1.read() == -1;
                    }
                    pos2 += count2;
                }
                if (array1[index2] != array2[index2]) {
                    return false;
                }
                ++index2;
            }
            break;
        }
    }

    private static boolean contentEquals(Stream<?> stream1, Stream<?> stream2) {
        if (stream1 == stream2) {
            return true;
        }
        if (stream1 == null || stream2 == null) {
            return false;
        }
        return IOUtils.contentEquals(stream1.iterator(), stream2.iterator());
    }

    private static boolean contentEqualsIgnoreEOL(BufferedReader reader1, BufferedReader reader2) {
        if (reader1 == reader2) {
            return true;
        }
        if (reader1 == null || reader2 == null) {
            return false;
        }
        return IOUtils.contentEquals(reader1.lines(), reader2.lines());
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader1, Reader reader2) throws UncheckedIOException {
        if (reader1 == reader2) {
            return true;
        }
        if (reader1 == null || reader2 == null) {
            return false;
        }
        return IOUtils.contentEqualsIgnoreEOL(IOUtils.toBufferedReader(reader1), IOUtils.toBufferedReader(reader2));
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long count2 = IOUtils.copyLarge(inputStream, outputStream);
        return count2 > Integer.MAX_VALUE ? -1 : (int)count2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(bufferSize));
    }

    @Deprecated
    public static void copy(InputStream input, Writer writer2) throws IOException {
        IOUtils.copy(input, writer2, Charset.defaultCharset());
    }

    public static void copy(InputStream input, Writer writer2, Charset inputCharset) throws IOException {
        InputStreamReader reader2 = new InputStreamReader(input, Charsets.toCharset(inputCharset));
        IOUtils.copy((Reader)reader2, writer2);
    }

    public static void copy(InputStream input, Writer writer2, String inputCharsetName) throws IOException {
        IOUtils.copy(input, writer2, Charsets.toCharset(inputCharsetName));
    }

    public static QueueInputStream copy(java.io.ByteArrayOutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "outputStream");
        QueueInputStream in = new QueueInputStream();
        outputStream.writeTo(in.newQueueOutputStream());
        return in;
    }

    public static long copy(Reader reader2, Appendable output) throws IOException {
        return IOUtils.copy(reader2, output, CharBuffer.allocate(8192));
    }

    public static long copy(Reader reader2, Appendable output, CharBuffer buffer2) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = reader2.read(buffer2))) {
            buffer2.flip();
            output.append(buffer2, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    @Deprecated
    public static void copy(Reader reader2, OutputStream output) throws IOException {
        IOUtils.copy(reader2, output, Charset.defaultCharset());
    }

    public static void copy(Reader reader2, OutputStream output, Charset outputCharset) throws IOException {
        OutputStreamWriter writer2 = new OutputStreamWriter(output, Charsets.toCharset(outputCharset));
        IOUtils.copy(reader2, (Writer)writer2);
        writer2.flush();
    }

    public static void copy(Reader reader2, OutputStream output, String outputCharsetName) throws IOException {
        IOUtils.copy(reader2, output, Charsets.toCharset(outputCharsetName));
    }

    public static int copy(Reader reader2, Writer writer2) throws IOException {
        long count2 = IOUtils.copyLarge(reader2, writer2);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copy(URL url, File file2) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(Objects.requireNonNull(file2, "file").toPath(), new OpenOption[0]);){
            long l = IOUtils.copy(url, outputStream);
            return l;
        }
    }

    public static long copy(URL url, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = Objects.requireNonNull(url, "url").openStream();){
            long l = IOUtils.copyLarge(inputStream, outputStream);
            return l;
        }
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer2) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count2 = 0L;
        while (-1 != (n = inputStream.read(buffer2))) {
            outputStream.write(buffer2, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, IOUtils.getScratchByteArray());
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length, byte[] buffer2) throws IOException {
        int read2;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer2.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read2 = input.read(buffer2, 0, bytesToRead))) {
            output.write(buffer2, 0, read2);
            totalRead += (long)read2;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    public static long copyLarge(Reader reader2, Writer writer2) throws IOException {
        return IOUtils.copyLarge(reader2, writer2, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader2, Writer writer2, char[] buffer2) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = reader2.read(buffer2))) {
            writer2.write(buffer2, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static long copyLarge(Reader reader2, Writer writer2, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(reader2, writer2, inputOffset, length, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader2, Writer writer2, long inputOffset, long length, char[] buffer2) throws IOException {
        int read2;
        if (inputOffset > 0L) {
            IOUtils.skipFully(reader2, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = buffer2.length;
        if (length > 0L && length < (long)buffer2.length) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read2 = reader2.read(buffer2, 0, bytesToRead))) {
            writer2.write(buffer2, 0, read2);
            totalRead += (long)read2;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)buffer2.length);
        }
        return totalRead;
    }

    private static byte[] fill0(byte[] arr) {
        Arrays.fill(arr, (byte)0);
        return arr;
    }

    private static char[] fill0(char[] arr) {
        Arrays.fill(arr, '\u0000');
        return arr;
    }

    static byte[] getScratchByteArray() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_RW.get());
    }

    static byte[] getScratchByteArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_WO);
    }

    static char[] getScratchCharArray() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_RW.get());
    }

    static char[] getScratchCharArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_WO);
    }

    public static int length(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    public static int length(char[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    public static int length(CharSequence csq) {
        return csq == null ? 0 : csq.length();
    }

    public static int length(Object[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    public static LineIterator lineIterator(InputStream input, Charset charset) {
        return new LineIterator(new InputStreamReader(input, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream input, String charsetName) {
        return IOUtils.lineIterator(input, Charsets.toCharset(charsetName));
    }

    public static LineIterator lineIterator(Reader reader2) {
        return new LineIterator(reader2);
    }

    public static int read(InputStream input, byte[] buffer2) throws IOException {
        return IOUtils.read(input, buffer2, 0, buffer2.length);
    }

    public static int read(InputStream input, byte[] buffer2, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return IOUtils.read(input::read, buffer2, offset, length);
    }

    static int read(IOTriFunction<byte[], Integer, Integer, Integer> input, byte[] buffer2, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count2;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count2 = input.apply(buffer2, offset + (location = length - remaining), remaining).intValue()); remaining -= count2) {
        }
        return length - remaining;
    }

    public static int read(ReadableByteChannel input, ByteBuffer buffer2) throws IOException {
        int count2;
        int length = buffer2.remaining();
        while (buffer2.remaining() > 0 && -1 != (count2 = input.read(buffer2))) {
        }
        return length - buffer2.remaining();
    }

    public static int read(Reader reader2, char[] buffer2) throws IOException {
        return IOUtils.read(reader2, buffer2, 0, buffer2.length);
    }

    public static int read(Reader reader2, char[] buffer2, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count2;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count2 = reader2.read(buffer2, offset + (location = length - remaining), remaining)); remaining -= count2) {
        }
        return length - remaining;
    }

    public static void readFully(InputStream input, byte[] buffer2) throws IOException {
        IOUtils.readFully(input, buffer2, 0, buffer2.length);
    }

    public static void readFully(InputStream input, byte[] buffer2, int offset, int length) throws IOException {
        int actual = IOUtils.read(input, buffer2, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static byte[] readFully(InputStream input, int length) throws IOException {
        byte[] buffer2 = IOUtils.byteArray(length);
        IOUtils.readFully(input, buffer2, 0, buffer2.length);
        return buffer2;
    }

    public static void readFully(ReadableByteChannel input, ByteBuffer buffer2) throws IOException {
        int expected = buffer2.remaining();
        int actual = IOUtils.read(input, buffer2);
        if (actual != expected) {
            throw new EOFException("Length to read: " + expected + " actual: " + actual);
        }
    }

    public static void readFully(Reader reader2, char[] buffer2) throws IOException {
        IOUtils.readFully(reader2, buffer2, 0, buffer2.length);
    }

    public static void readFully(Reader reader2, char[] buffer2, int offset, int length) throws IOException {
        int actual = IOUtils.read(reader2, buffer2, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    @Deprecated
    public static List<String> readLines(InputStream input) throws UncheckedIOException {
        return IOUtils.readLines(input, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream input, Charset charset) throws UncheckedIOException {
        return IOUtils.readLines(new InputStreamReader(input, Charsets.toCharset(charset)));
    }

    public static List<String> readLines(InputStream input, String charsetName) throws UncheckedIOException {
        return IOUtils.readLines(input, Charsets.toCharset(charsetName));
    }

    public static List<String> readLines(Reader reader2) throws UncheckedIOException {
        return IOUtils.toBufferedReader(reader2).lines().collect(Collectors.toList());
    }

    public static byte[] resourceToByteArray(String name2) throws IOException {
        return IOUtils.resourceToByteArray(name2, null);
    }

    public static byte[] resourceToByteArray(String name2, ClassLoader classLoader) throws IOException {
        return IOUtils.toByteArray(IOUtils.resourceToURL(name2, classLoader));
    }

    public static String resourceToString(String name2, Charset charset) throws IOException {
        return IOUtils.resourceToString(name2, charset, null);
    }

    public static String resourceToString(String name2, Charset charset, ClassLoader classLoader) throws IOException {
        return IOUtils.toString(IOUtils.resourceToURL(name2, classLoader), charset);
    }

    public static URL resourceToURL(String name2) throws IOException {
        return IOUtils.resourceToURL(name2, null);
    }

    public static URL resourceToURL(String name2, ClassLoader classLoader) throws IOException {
        URL resource2;
        URL uRL = resource2 = classLoader == null ? IOUtils.class.getResource(name2) : classLoader.getResource(name2);
        if (resource2 == null) {
            throw new IOException("Resource not found: " + name2);
        }
        return resource2;
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        return IOUtils.skip(input, toSkip, IOUtils::getScratchByteArrayWriteOnly);
    }

    public static long skip(InputStream input, long toSkip, Supplier<byte[]> skipBufferSupplier) throws IOException {
        byte[] skipBuffer;
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(skipBuffer = skipBufferSupplier.get(), 0, (int)Math.min(remain, (long)skipBuffer.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static long skip(ReadableByteChannel input, long toSkip) throws IOException {
        long remain;
        int n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        ByteBuffer skipByteBuffer = ByteBuffer.allocate((int)Math.min(toSkip, 8192L));
        for (remain = toSkip; remain > 0L; remain -= (long)n) {
            skipByteBuffer.position(0);
            skipByteBuffer.limit((int)Math.min(remain, 8192L));
            n = input.read(skipByteBuffer);
            if (n == -1) break;
        }
        return toSkip - remain;
    }

    public static long skip(Reader reader2, long toSkip) throws IOException {
        char[] charArray;
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)reader2.read(charArray = IOUtils.getScratchCharArrayWriteOnly(), 0, (int)Math.min(remain, (long)charArray.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(InputStream input, long toSkip) throws IOException {
        long skipped = IOUtils.skip(input, toSkip, IOUtils::getScratchByteArrayWriteOnly);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(InputStream input, long toSkip, Supplier<byte[]> skipBufferSupplier) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip, skipBufferSupplier);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(ReadableByteChannel input, long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(Reader reader2, long toSkip) throws IOException {
        long skipped = IOUtils.skip(reader2, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Chars to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static InputStream toBufferedInputStream(InputStream input) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input);
    }

    public static InputStream toBufferedInputStream(InputStream input, int size) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input, size);
    }

    public static BufferedReader toBufferedReader(Reader reader2) {
        return reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2);
    }

    public static BufferedReader toBufferedReader(Reader reader2, int size) {
        return reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, size);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (UnsynchronizedByteArrayOutputStream ubaOutput = UnsynchronizedByteArrayOutputStream.builder().get();){
            byte[] byArray;
            try (ThresholdingOutputStream thresholdOutput = new ThresholdingOutputStream(Integer.MAX_VALUE, os -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, os -> ubaOutput);){
                IOUtils.copy(inputStream, (OutputStream)thresholdOutput);
                byArray = ubaOutput.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] toByteArray(InputStream input, int size) throws IOException {
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return IOUtils.toByteArray(Objects.requireNonNull(input, "input")::read, size);
    }

    public static byte[] toByteArray(InputStream input, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtils.toByteArray(input, (int)size);
    }

    static byte[] toByteArray(IOTriFunction<byte[], Integer, Integer, Integer> input, int size) throws IOException {
        int offset;
        int read2;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] data2 = IOUtils.byteArray(size);
        for (offset = 0; offset < size && (read2 = input.apply(data2, offset, size - offset).intValue()) != -1; offset += read2) {
        }
        if (offset != size) {
            throw new IOException("Unexpected read size, current: " + offset + ", expected: " + size);
        }
        return data2;
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader2) throws IOException {
        return IOUtils.toByteArray(reader2, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader2, Charset charset) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(reader2, (OutputStream)output, charset);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(Reader reader2, String charsetName) throws IOException {
        return IOUtils.toByteArray(reader2, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static byte[] toByteArray(String input) {
        return input.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uri) throws IOException {
        return IOUtils.toByteArray(uri.toURL());
    }

    public static byte[] toByteArray(URL url) throws IOException {
        try (CloseableURLConnection urlConnection = CloseableURLConnection.open(url);){
            byte[] byArray = IOUtils.toByteArray(urlConnection);
            return byArray;
        }
    }

    public static byte[] toByteArray(URLConnection urlConnection) throws IOException {
        try (InputStream inputStream = urlConnection.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) throws IOException {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) throws IOException {
        CharArrayWriter writer2 = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)writer2, charset);
        return writer2.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String charsetName) throws IOException {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(charsetName));
    }

    public static char[] toCharArray(Reader reader2) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(reader2, (Writer)sw);
        return sw.toCharArray();
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence input, Charset charset) {
        return IOUtils.toInputStream(input.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence input, String charsetName) {
        return IOUtils.toInputStream(input, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static InputStream toInputStream(String input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String input, Charset charset) {
        return new ByteArrayInputStream(input.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String input, String charsetName) {
        return new ByteArrayInputStream(input.getBytes(Charsets.toCharset(charsetName)));
    }

    @Deprecated
    public static String toString(byte[] input) {
        return new String(input, Charset.defaultCharset());
    }

    public static String toString(byte[] input, String charsetName) {
        return new String(input, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, Charset.defaultCharset());
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(input, (Writer)sw, charset);
            String string2 = sw.toString();
            return string2;
        }
    }

    public static String toString(InputStream input, String charsetName) throws IOException {
        return IOUtils.toString(input, Charsets.toCharset(charsetName));
    }

    public static String toString(IOSupplier<InputStream> input, Charset charset) throws IOException {
        return IOUtils.toString(input, charset, () -> {
            throw new NullPointerException("input");
        });
    }

    public static String toString(IOSupplier<InputStream> input, Charset charset, IOSupplier<String> defaultString) throws IOException {
        if (input == null) {
            return defaultString.get();
        }
        try (InputStream inputStream = input.get();){
            String string2 = inputStream != null ? IOUtils.toString(inputStream, charset) : defaultString.get();
            return string2;
        }
    }

    public static String toString(Reader reader2) throws IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(reader2, (Writer)sw);
            String string2 = sw.toString();
            return string2;
        }
    }

    @Deprecated
    public static String toString(URI uri) throws IOException {
        return IOUtils.toString(uri, Charset.defaultCharset());
    }

    public static String toString(URI uri, Charset encoding2) throws IOException {
        return IOUtils.toString(uri.toURL(), Charsets.toCharset(encoding2));
    }

    public static String toString(URI uri, String charsetName) throws IOException {
        return IOUtils.toString(uri, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static String toString(URL url) throws IOException {
        return IOUtils.toString(url, Charset.defaultCharset());
    }

    public static String toString(URL url, Charset encoding2) throws IOException {
        return IOUtils.toString(url::openStream, encoding2);
    }

    public static String toString(URL url, String charsetName) throws IOException {
        return IOUtils.toString(url, Charsets.toCharset(charsetName));
    }

    public static void write(byte[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    @Deprecated
    public static void write(byte[] data2, Writer writer2) throws IOException {
        IOUtils.write(data2, writer2, Charset.defaultCharset());
    }

    public static void write(byte[] data2, Writer writer2, Charset charset) throws IOException {
        if (data2 != null) {
            writer2.write(new String(data2, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] data2, Writer writer2, String charsetName) throws IOException {
        IOUtils.write(data2, writer2, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static void write(char[] data2, OutputStream output) throws IOException {
        IOUtils.write(data2, output, Charset.defaultCharset());
    }

    public static void write(char[] data2, OutputStream output, Charset charset) throws IOException {
        if (data2 != null) {
            IOUtils.write(new String(data2), output, charset);
        }
    }

    public static void write(char[] data2, OutputStream output, String charsetName) throws IOException {
        IOUtils.write(data2, output, Charsets.toCharset(charsetName));
    }

    public static void write(char[] data2, Writer writer2) throws IOException {
        if (data2 != null) {
            writer2.write(data2);
        }
    }

    @Deprecated
    public static void write(CharSequence data2, OutputStream output) throws IOException {
        IOUtils.write(data2, output, Charset.defaultCharset());
    }

    public static void write(CharSequence data2, OutputStream output, Charset charset) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output, charset);
        }
    }

    public static void write(CharSequence data2, OutputStream output, String charsetName) throws IOException {
        IOUtils.write(data2, output, Charsets.toCharset(charsetName));
    }

    public static void write(CharSequence data2, Writer writer2) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), writer2);
        }
    }

    @Deprecated
    public static void write(String data2, OutputStream output) throws IOException {
        IOUtils.write(data2, output, Charset.defaultCharset());
    }

    public static void write(String data2, OutputStream output, Charset charset) throws IOException {
        if (data2 != null) {
            Channels.newChannel(output).write(Charsets.toCharset(charset).encode(data2));
        }
    }

    public static void write(String data2, OutputStream output, String charsetName) throws IOException {
        IOUtils.write(data2, output, Charsets.toCharset(charsetName));
    }

    public static void write(String data2, Writer writer2) throws IOException {
        if (data2 != null) {
            writer2.write(data2);
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output) throws IOException {
        IOUtils.write(data2, output, (String)null);
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output, String charsetName) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output, Charsets.toCharset(charsetName));
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, Writer writer2) throws IOException {
        if (data2 != null) {
            writer2.write(data2.toString());
        }
    }

    public static void writeChunked(byte[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            int bytes2 = data2.length;
            int offset = 0;
            while (bytes2 > 0) {
                int chunk2 = Math.min(bytes2, 8192);
                output.write(data2, offset, chunk2);
                bytes2 -= chunk2;
                offset += chunk2;
            }
        }
    }

    public static void writeChunked(char[] data2, Writer writer2) throws IOException {
        if (data2 != null) {
            int bytes2 = data2.length;
            int offset = 0;
            while (bytes2 > 0) {
                int chunk2 = Math.min(bytes2, 8192);
                writer2.write(data2, offset, chunk2);
                bytes2 -= chunk2;
                offset += chunk2;
            }
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output) throws IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output, Charset charset) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = System.lineSeparator();
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            charset = StandardCharsets.UTF_16BE;
        }
        byte[] eolBytes = lineEnding.getBytes(charset);
        for (Object line : lines) {
            if (line != null) {
                IOUtils.write(line.toString(), output, charset);
            }
            output.write(eolBytes);
        }
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output, String charsetName) throws IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charsets.toCharset(charsetName));
    }

    public static void writeLines(Collection<?> lines, String lineEnding, Writer writer2) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = System.lineSeparator();
        }
        for (Object line : lines) {
            if (line != null) {
                writer2.write(line.toString());
            }
            writer2.write(lineEnding);
        }
    }

    public static Writer writer(Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter<Appendable>(appendable);
    }

    @Deprecated
    public IOUtils() {
    }
}

