/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.compact.CompactSyntax;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.MediaTypedIdentifier;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.Uri;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.xml.sax.ErrorHandler;

public class CompactParseable<P, NC, L, EA, CL extends CommentList<L>, A extends Annotations<L, EA, CL>>
implements SubParseable<P, NC, L, EA, CL, A> {
    private final Input in;
    private final Resolver resolver;
    private final ErrorHandler eh;
    private static final String MEDIA_TYPE = "application/relax-ng-compact-syntax";
    private static final String UTF8 = EncodingMap.getJavaName("UTF-8");
    private static final String UTF16 = EncodingMap.getJavaName("UTF-16");

    public CompactParseable(Input input, Resolver resolver, ErrorHandler errorHandler) {
        this.in = input;
        this.resolver = resolver;
        this.eh = errorHandler;
    }

    @Override
    public P parse(SchemaBuilder<P, NC, L, EA, CL, A> schemaBuilder, Scope<P, L, EA, CL, A> scope) throws BuildException, IllegalSchemaException {
        return new CompactSyntax<P, NC, L, EA, CL, A>(this.makeReader(this.in), this.in.getUri(), schemaBuilder, this.eh).parse(scope);
    }

    @Override
    public SubParseable<P, NC, L, EA, CL, A> createSubParseable(String string, String string2) throws BuildException {
        MediaTypedIdentifier mediaTypedIdentifier = new MediaTypedIdentifier(string, string2, MEDIA_TYPE);
        Input input = new Input();
        try {
            this.resolver.resolve(mediaTypedIdentifier, input);
        }
        catch (ResolverException resolverException) {
            throw BuildException.fromResolverException(resolverException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        return new CompactParseable<P, NC, L, EA, CL, A>(input, this.resolver, this.eh);
    }

    @Override
    public P parseAsInclude(SchemaBuilder<P, NC, L, EA, CL, A> schemaBuilder, IncludedGrammar<P, L, EA, CL, A> includedGrammar) throws BuildException, IllegalSchemaException {
        return new CompactSyntax<P, NC, L, EA, CL, A>(this.makeReader(this.in), this.in.getUri(), schemaBuilder, this.eh).parseInclude(includedGrammar);
    }

    @Override
    public String getUri() {
        String string = this.in.getUri();
        if (string == null) {
            return null;
        }
        return Uri.escapeDisallowedChars(string);
    }

    private Reader makeReader(Input input) throws BuildException {
        try {
            this.resolver.open(input);
            Reader reader = input.getCharacterStream();
            if (reader == null) {
                InputStream inputStream = input.getByteStream();
                if (inputStream == null) {
                    throw new IllegalArgumentException("invalid input for CompactParseable");
                }
                String string = input.getEncoding();
                if (string == null) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    string = CompactParseable.detectEncoding(pushbackInputStream);
                    inputStream = pushbackInputStream;
                }
                reader = new InputStreamReader(inputStream, string);
            }
            return reader;
        }
        catch (ResolverException resolverException) {
            throw BuildException.fromResolverException(resolverException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static String detectEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        String string = UTF8;
        int n = pushbackInputStream.read();
        if (n != -1) {
            int n2 = pushbackInputStream.read();
            if (n2 != -1) {
                pushbackInputStream.unread(n2);
                if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
                    string = UTF16;
                }
            }
            pushbackInputStream.unread(n);
        }
        return string;
    }
}

