/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeSystem {
    private int typeid = 128;
    private TypeBinding[][] types;
    protected HashedParameterizedTypes parameterizedTypes;
    private SimpleLookupTable annotationTypes;
    LookupEnvironment environment;

    public TypeSystem(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeBinding getUnannotatedType(TypeBinding typeBinding) {
        ReferenceBinding referenceBinding;
        UnresolvedReferenceBinding unresolvedReferenceBinding = null;
        if (typeBinding.isUnresolvedType()) {
            unresolvedReferenceBinding = (UnresolvedReferenceBinding)typeBinding;
            referenceBinding = unresolvedReferenceBinding.resolvedType;
            if (referenceBinding != null) {
                typeBinding = referenceBinding;
            }
        }
        try {
            if (typeBinding.id == Integer.MAX_VALUE) {
                if (typeBinding.hasTypeAnnotations()) {
                    throw new IllegalStateException();
                }
                int n = this.types.length;
                if (this.typeid == n) {
                    this.types = new TypeBinding[n * 2][];
                    System.arraycopy(this.types, 0, this.types, 0, n);
                }
                typeBinding.id = this.typeid++;
                this.types[typeBinding.id] = new TypeBinding[4];
            } else {
                TypeBinding typeBinding2 = referenceBinding = this.types[typeBinding.id] == null ? null : this.types[typeBinding.id][0];
                if (typeBinding.hasTypeAnnotations() && referenceBinding == null) {
                    throw new IllegalStateException();
                }
                if (referenceBinding != null) {
                    ReferenceBinding referenceBinding2 = referenceBinding;
                    return referenceBinding2;
                }
                this.types[typeBinding.id] = new TypeBinding[4];
            }
        }
        finally {
            if (unresolvedReferenceBinding != null && unresolvedReferenceBinding.id == Integer.MAX_VALUE) {
                unresolvedReferenceBinding.id = typeBinding.id;
            }
        }
        TypeBinding typeBinding3 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding3;
        return typeBinding3;
    }

    public void forceRegisterAsDerived(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        int n = typeBinding.id;
        if (n != Integer.MAX_VALUE && this.types[n] != null) {
            typeBinding2 = this.types[n][0];
            if (typeBinding2 == typeBinding) {
                this.types[n][0] = typeBinding2 = typeBinding.clone(null);
            }
        } else {
            throw new IllegalStateException("Type was not yet registered as expected: " + typeBinding);
        }
        this.cacheDerivedType(typeBinding2, typeBinding);
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        return Binding.NO_TYPES;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n) {
        TypeBinding typeBinding2;
        int n2;
        if (typeBinding instanceof ArrayBinding) {
            n += typeBinding.dimensions();
            typeBinding = typeBinding.leafComponentType();
        }
        TypeBinding typeBinding3 = this.getUnannotatedType(typeBinding);
        TypeBinding[] typeBindingArray = this.types[typeBinding3.id];
        int n3 = typeBindingArray.length;
        for (n2 = 0; n2 < n3 && (typeBinding2 = typeBindingArray[n2]) != null; ++n2) {
            if (!typeBinding2.isArrayType() || typeBinding2.hasTypeAnnotations() || typeBinding2.leafComponentType() != typeBinding3 || typeBinding2.dimensions() != n) continue;
            return (ArrayBinding)typeBinding2;
        }
        if (n2 == n3) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n3 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n3);
            this.types[typeBinding3.id] = typeBindingArray;
        }
        typeBinding2 = typeBindingArray[n2] = new ArrayBinding(typeBinding3, n, this.environment);
        int n4 = this.types.length;
        if (this.typeid == n4) {
            this.types = new TypeBinding[n4 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n4);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (ArrayBinding)typeBinding4;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        return this.getArrayType(typeBinding, n);
    }

    public ReferenceBinding getMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return referenceBinding;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        if (referenceBinding2 == null && referenceBinding instanceof UnresolvedReferenceBinding && !(referenceBinding3 instanceof UnresolvedReferenceBinding)) {
            referenceBinding2 = referenceBinding3.enclosingType();
        }
        int n = typeBindingArray == null ? 0 : typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = typeBindingArray == null ? null : new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            typeBindingArray2[i] = this.getUnannotatedType(typeBindingArray[i]);
        }
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        ParameterizedTypeBinding parameterizedTypeBinding = this.parameterizedTypes.get(referenceBinding3, typeBindingArray2, referenceBinding4, Binding.NO_ANNOTATIONS);
        if (parameterizedTypeBinding != null) {
            return parameterizedTypeBinding;
        }
        parameterizedTypeBinding = new ParameterizedTypeBinding(referenceBinding3, typeBindingArray2, referenceBinding4, this.environment);
        this.cacheDerivedType(referenceBinding3, parameterizedTypeBinding);
        this.parameterizedTypes.put(referenceBinding, typeBindingArray, referenceBinding2, parameterizedTypeBinding);
        int n2 = this.types.length;
        if (this.typeid == n2) {
            this.types = new TypeBinding[n2 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n2);
        }
        this.types[this.typeid] = new TypeBinding[1];
        parameterizedTypeBinding.id = this.typeid++;
        ParameterizedTypeBinding parameterizedTypeBinding2 = parameterizedTypeBinding;
        this.types[parameterizedTypeBinding.id][0] = parameterizedTypeBinding2;
        return parameterizedTypeBinding2;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        TypeBinding typeBinding;
        int n;
        if (!referenceBinding.hasEnclosingInstanceContext() && referenceBinding2 != null) {
            referenceBinding2 = (ReferenceBinding)referenceBinding2.original();
        }
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        TypeBinding[] typeBindingArray = this.types[referenceBinding3.id];
        int n2 = typeBindingArray.length;
        for (n = 0; n < n2 && (typeBinding = typeBindingArray[n]) != null; ++n) {
            if (!typeBinding.isRawType() || typeBinding.actualType() != referenceBinding3 || typeBinding.hasTypeAnnotations() || typeBinding.enclosingType() != referenceBinding4) continue;
            return (RawTypeBinding)typeBinding;
        }
        if (n == n2) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n2 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n2);
            this.types[referenceBinding3.id] = typeBindingArray;
        }
        typeBinding = typeBindingArray[n] = new RawTypeBinding(referenceBinding3, referenceBinding4, this.environment);
        int n3 = this.types.length;
        if (this.typeid == n3) {
            this.types = new TypeBinding[n3 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n3);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding.id = this.typeid++;
        TypeBinding typeBinding2 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding2;
        return (RawTypeBinding)typeBinding2;
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getRawType(referenceBinding, referenceBinding2);
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        TypeBinding typeBinding2;
        int n3;
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        int n4 = typeBindingArray == null ? 0 : typeBindingArray.length;
        Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n4];
        for (int i = 0; i < n4; ++i) {
            objectArray[i] = this.getUnannotatedType(typeBindingArray[i]);
        }
        TypeBinding typeBinding3 = typeBinding == null ? null : this.getUnannotatedType(typeBinding);
        boolean bl = typeBinding3 instanceof TypeVariableBinding || typeBinding3 instanceof ParameterizedTypeBinding && !(typeBinding3 instanceof RawTypeBinding);
        TypeBinding[] typeBindingArray2 = this.types[bl ? typeBinding3.id : referenceBinding2.id];
        int n5 = typeBindingArray2.length;
        for (n3 = 0; n3 < n5 && (typeBinding2 = typeBindingArray2[n3]) != null; ++n3) {
            if (!typeBinding2.isWildcard() || typeBinding2.actualType() != referenceBinding2 || typeBinding2.hasTypeAnnotations() || typeBinding2.rank() != n || typeBinding2.boundKind() != n2 || typeBinding2.bound() != typeBinding3 || !Util.effectivelyEqual(typeBinding2.additionalBounds(), objectArray)) continue;
            return (WildcardBinding)typeBinding2;
        }
        if (n3 == n5) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n5 * 2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n5);
            this.types[bl ? typeBinding3.id : referenceBinding2.id] = typeBindingArray2;
        }
        typeBinding2 = typeBindingArray2[n3] = new WildcardBinding(referenceBinding2, n, typeBinding3, (TypeBinding[])objectArray, n2, this.environment);
        int n6 = this.types.length;
        if (this.typeid == n6) {
            this.types = new TypeBinding[n6 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n6);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (WildcardBinding)typeBinding4;
    }

    public final CaptureBinding getCapturedWildcard(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n, int n2, ASTNode aSTNode, int n3) {
        int n4;
        int n5;
        WildcardBinding wildcardBinding2 = (WildcardBinding)this.getUnannotatedType(wildcardBinding);
        TypeBinding[] typeBindingArray = this.types[wildcardBinding2.id];
        int n6 = n5 = typeBindingArray.length;
        for (n4 = n5 - 1; n4 >= -1; --n4) {
            if (n4 == -1) {
                n4 = n6;
                break;
            }
            TypeBinding typeBinding = typeBindingArray[n4];
            if (typeBinding == null) {
                n6 = n4;
                continue;
            }
            if (!typeBinding.isCapture()) continue;
            CaptureBinding captureBinding = (CaptureBinding)typeBinding;
            if (captureBinding.cud != aSTNode) {
                n4 = n6;
                break;
            }
            if (captureBinding.sourceType != referenceBinding || captureBinding.start != n || captureBinding.end != n2) continue;
            return captureBinding;
        }
        if (n4 == n5) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n5 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n5);
            this.types[wildcardBinding2.id] = typeBindingArray;
        }
        typeBindingArray[n4] = new CaptureBinding(wildcardBinding, referenceBinding, n, n2, aSTNode, n3);
        return typeBindingArray[n4];
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        return this.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
    }

    public TypeBinding getAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        return typeBinding;
    }

    protected final TypeBinding[] getDerivedTypes(TypeBinding typeBinding) {
        typeBinding = this.getUnannotatedType(typeBinding);
        return this.types[typeBinding.id];
    }

    private TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null || typeBinding.id == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        TypeBinding[] typeBindingArray = this.types[typeBinding.id];
        int n = typeBindingArray.length;
        int n2 = 0;
        int n3 = n;
        int n4 = (n2 + n3) / 2;
        do {
            if (typeBindingArray[n4] == null) {
                if (n4 == n2 || n4 > 0 && typeBindingArray[n4 - 1] != null) break;
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        } while ((n4 = (n2 + n3) / 2) < n && n2 <= n3);
        if (n4 == n) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            this.types[typeBinding.id] = typeBindingArray;
        }
        typeBindingArray[n4] = typeBinding2;
        return typeBindingArray[n4];
    }

    protected final TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        this.cacheDerivedType(typeBinding, typeBinding3);
        if (typeBinding2.id != typeBinding.id) {
            this.cacheDerivedType(typeBinding2, typeBinding3);
        }
        return typeBinding3;
    }

    public final AnnotationBinding getAnnotationType(ReferenceBinding referenceBinding, boolean bl) {
        AnnotationBinding annotationBinding = (AnnotationBinding)this.annotationTypes.get(referenceBinding);
        if (annotationBinding == null) {
            annotationBinding = bl ? new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS) : new UnresolvedAnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS, this.environment);
            this.annotationTypes.put(referenceBinding, annotationBinding);
        }
        if (bl) {
            annotationBinding.resolve();
        }
        return annotationBinding;
    }

    public boolean isAnnotatedTypeSystem() {
        return false;
    }

    public void cleanUp(int n) {
        TypeBinding[] typeBindingArray;
        if (n != -1 && n < this.typeid && this.types != null && (typeBindingArray = this.types[n]) != null) {
            for (TypeBinding typeBinding : typeBindingArray) {
                if (!(typeBinding instanceof SourceTypeBinding)) continue;
                ((SourceTypeBinding)typeBinding).scope = null;
            }
        }
    }

    public void reset() {
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    public void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = unresolvedReferenceBinding.id;
        if (referenceBinding.id != Integer.MAX_VALUE) {
            unresolvedReferenceBinding.id = referenceBinding.id;
        }
        if (n3 != Integer.MAX_VALUE) {
            objectArray = this.types[n3];
            int n4 = n2 = objectArray == null ? 0 : objectArray.length;
            for (n = 0; n < n2 && objectArray[n] != null; ++n) {
                if (objectArray[n] != unresolvedReferenceBinding) continue;
                if (referenceBinding.id == Integer.MAX_VALUE) {
                    referenceBinding.id = n3;
                }
                objectArray[n] = referenceBinding;
            }
        }
        if (this.annotationTypes.get(unresolvedReferenceBinding) != null) {
            objectArray = this.annotationTypes.keyTable;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] != unresolvedReferenceBinding) continue;
                objectArray[n] = referenceBinding;
                break;
            }
        }
    }

    public final TypeBinding getIntersectionType18(ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n == 0) {
            return null;
        }
        ReferenceBinding referenceBinding = referenceBindingArray[0];
        if (referenceBinding == null || n == 1) {
            return referenceBinding;
        }
        block0: for (TypeBinding typeBinding : this.getDerivedTypes(referenceBinding)) {
            ReferenceBinding[] referenceBindingArray2;
            if (typeBinding == null) break;
            if (!typeBinding.isIntersectionType18() || (referenceBindingArray2 = typeBinding.getIntersectingTypes()).length != n) continue;
            for (int i = 0; i < n; ++i) {
                if (referenceBindingArray[i] != referenceBindingArray2[i]) continue block0;
            }
            return typeBinding;
        }
        return this.cacheDerivedType(referenceBinding, new IntersectionTypeBinding18(referenceBindingArray, this.environment));
    }

    public void fixTypeVariableDeclaringElement(TypeVariableBinding typeVariableBinding, Binding binding) {
        int n = typeVariableBinding.id;
        if (n < this.typeid && this.types[n] != null) {
            for (TypeBinding typeBinding : this.types[n]) {
                if (!(typeBinding instanceof TypeVariableBinding)) continue;
                ((TypeVariableBinding)typeBinding).declaringElement = binding;
            }
        } else {
            typeVariableBinding.declaringElement = binding;
        }
    }

    public final class HashedParameterizedTypes {
        HashMap<PTBKey, ParameterizedTypeBinding[]> hashedParameterizedTypes = new HashMap(256);

        ParameterizedTypeBinding get(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
            int n;
            ReferenceBinding referenceBinding3 = (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding);
            int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
            Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = TypeSystem.this.getUnannotatedType(typeBindingArray[i]);
            }
            ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding2);
            PTBKey pTBKey = new PTBKey(referenceBinding3, (TypeBinding[])objectArray, referenceBinding4, null);
            ReferenceBinding referenceBinding5 = referenceBinding3;
            ReferenceBinding referenceBinding6 = referenceBinding4;
            Object[] objectArray2 = objectArray;
            if (TypeSystem.this instanceof AnnotatableTypeSystem) {
                referenceBinding5 = referenceBinding;
                referenceBinding6 = referenceBinding2;
                objectArray2 = typeBindingArray;
            }
            ParameterizedTypeBinding[] parameterizedTypeBindingArray = this.hashedParameterizedTypes.get(pTBKey);
            int n3 = n = parameterizedTypeBindingArray == null ? 0 : parameterizedTypeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                ParameterizedTypeBinding parameterizedTypeBinding = parameterizedTypeBindingArray[i];
                if (parameterizedTypeBinding.actualType() != referenceBinding5 || parameterizedTypeBinding.enclosingType != referenceBinding6 || !Util.effectivelyEqual(parameterizedTypeBinding.typeArguments(), objectArray2) || !Util.effectivelyEqual(annotationBindingArray, parameterizedTypeBinding.getTypeAnnotations())) continue;
                return parameterizedTypeBinding;
            }
            return null;
        }

        void put(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, ParameterizedTypeBinding parameterizedTypeBinding) {
            int n;
            ReferenceBinding referenceBinding3 = (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding);
            int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = typeBindingArray == null ? null : new TypeBinding[n2];
            for (int i = 0; i < n2; ++i) {
                typeBindingArray2[i] = TypeSystem.this.getUnannotatedType(typeBindingArray[i]);
            }
            ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding2);
            PTBKey pTBKey = new PTBKey(referenceBinding3, typeBindingArray2, referenceBinding4, TypeSystem.this.environment);
            ParameterizedTypeBinding[] parameterizedTypeBindingArray = this.hashedParameterizedTypes.get(pTBKey);
            if (parameterizedTypeBindingArray == null) {
                n = 0;
                parameterizedTypeBindingArray = new ParameterizedTypeBinding[1];
            } else {
                n = parameterizedTypeBindingArray.length;
                ParameterizedTypeBinding[] parameterizedTypeBindingArray2 = parameterizedTypeBindingArray;
                parameterizedTypeBindingArray = new ParameterizedTypeBinding[n + 1];
                System.arraycopy(parameterizedTypeBindingArray2, 0, parameterizedTypeBindingArray, 0, n);
            }
            parameterizedTypeBindingArray[n] = parameterizedTypeBinding;
            this.hashedParameterizedTypes.put(pTBKey, parameterizedTypeBindingArray);
        }

        private final class PTBKey
        extends ReferenceBinding {
            protected ReferenceBinding type;
            public TypeBinding[] arguments;
            private ReferenceBinding enclosingType;

            public PTBKey(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
                this.type = referenceBinding;
                this.arguments = typeBindingArray;
                this.enclosingType = referenceBinding2;
                if (lookupEnvironment != null) {
                    if (referenceBinding instanceof UnresolvedReferenceBinding) {
                        ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
                    }
                    if (typeBindingArray != null) {
                        int n = typeBindingArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (typeBindingArray[i] instanceof UnresolvedReferenceBinding) {
                                ((UnresolvedReferenceBinding)typeBindingArray[i]).addWrapper(this, lookupEnvironment);
                            }
                            if (!typeBindingArray[i].hasNullTypeAnnotations()) continue;
                            this.tagBits |= 0x100000L;
                        }
                    }
                }
            }

            @Override
            public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
                if (this.type == unresolvedReferenceBinding) {
                    this.type = referenceBinding;
                    ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
                    if (referenceBinding2 != null) {
                        ReferenceBinding referenceBinding3 = this.enclosingType = referenceBinding.isStatic() ? referenceBinding2 : (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding2);
                    }
                }
                if (this.arguments != null) {
                    int n = this.arguments.length;
                    for (int i = 0; i < n; ++i) {
                        if (this.arguments[i] != unresolvedReferenceBinding) continue;
                        this.arguments[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                    }
                }
            }

            public boolean equals(Object object) {
                PTBKey pTBKey = (PTBKey)object;
                return this.type == pTBKey.type && this.enclosingType == pTBKey.enclosingType && Util.effectivelyEqual(this.arguments, pTBKey.arguments);
            }

            final int hash(TypeBinding typeBinding) {
                if (typeBinding instanceof WildcardBinding || typeBinding instanceof TypeVariableBinding || typeBinding.getClass() == ParameterizedTypeBinding.class) {
                    return System.identityHashCode(typeBinding);
                }
                return typeBinding.hashCode();
            }

            @Override
            public int hashCode() {
                int n;
                int n2 = 1 + this.hash(this.type);
                int n3 = n = this.arguments == null ? 0 : this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    n2 = n2 * 31 + this.hash(this.arguments[i]);
                }
                return n2;
            }
        }
    }
}

