/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.jmdns.NetworkTopologyDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyDiscoveryImpl
implements NetworkTopologyDiscovery {
    private static final Logger logger = LoggerFactory.getLogger((String)NetworkTopologyDiscoveryImpl.class.getName());

    @Override
    public InetAddress[] getInetAddresses() {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> iaenum = nif.getInetAddresses();
                while (iaenum.hasMoreElements()) {
                    InetAddress interfaceAddress = iaenum.nextElement();
                    logger.trace("Found NetworkInterface/InetAddress: {} -- {}", (Object)nif, (Object)interfaceAddress);
                    if (!this.useInetAddress(nif, interfaceAddress)) continue;
                    result.add(interfaceAddress);
                }
            }
        }
        catch (SocketException se) {
            logger.warn("Error while fetching network interfaces addresses: " + se);
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    @Override
    public void lockInetAddress(InetAddress interfaceAddress) {
    }

    @Override
    public void unlockInetAddress(InetAddress interfaceAddress) {
    }

    @Override
    public boolean useInetAddress(NetworkInterface networkInterface, InetAddress interfaceAddress) {
        try {
            if (!networkInterface.isUp()) {
                return false;
            }
            if (!networkInterface.supportsMulticast()) {
                return false;
            }
            return !networkInterface.isLoopback();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

