/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.Theme;
import processing.app.helpers.CircularBuffer;
import processing.app.helpers.Ticks;
import processing.app.legacy.PApplet;

public class SerialPlotter
extends AbstractMonitor {
    private final StringBuffer messageBuffer;
    private JComboBox<String> serialRates;
    private Serial serial;
    private int serialRate = PreferencesData.getInteger((String)"serial.debug_rate");
    private int xCount;
    private JLabel noLineEndingAlert;
    private JTextField textField;
    private JButton sendButton;
    private JComboBox<String> lineEndings;
    private ArrayList<Graph> graphs;
    private static final int BUFFER_CAPACITY = 500;

    public SerialPlotter(BoardPort port) {
        super(port);
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n.tr((String)"baud"));
        this.onSerialRateChange(event -> {
            String wholeString = (String)this.serialRates.getSelectedItem();
            String rateString = wholeString.substring(0, wholeString.indexOf(32));
            this.serialRate = Integer.parseInt(rateString);
            PreferencesData.set((String)"serial.debug_rate", (String)rateString);
            if (this.serial != null) {
                try {
                    this.close();
                    Thread.sleep(100L);
                    this.open();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.messageBuffer = new StringBuffer();
        this.graphs = new ArrayList();
    }

    @Override
    protected void onCreateWindow(Container mainPane) {
        mainPane.setLayout(new BorderLayout());
        GraphPanel graphPanel = new GraphPanel();
        mainPane.add((Component)graphPanel, "Center");
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.serialRates = new JComboBox();
        for (String serialRateString : this.serialRateStrings) {
            this.serialRates.addItem(serialRateString + " " + I18n.tr((String)"baud"));
        }
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(Box.createHorizontalGlue());
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        mainPane.add((Component)pane, "South");
        this.textField = new JTextField(40);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SerialPlotter.this.textField.requestFocusInWindow();
            }
        });
        JPopupMenu menu = new JPopupMenu();
        DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
        cut.putValue("Name", I18n.tr((String)"Cut"));
        menu.add(cut);
        DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", I18n.tr((String)"Copy"));
        menu.add(copy);
        DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
        paste.putValue("Name", I18n.tr((String)"Paste"));
        menu.add(paste);
        this.textField.setComponentPopupMenu(menu);
        this.sendButton = new JButton(I18n.tr((String)"Send"));
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new BoxLayout(lowerPane, 0));
        lowerPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.noLineEndingAlert = new JLabel(I18n.format((String)I18n.tr((String)"You've pressed {0} but nothing was sent. Should you select a line ending?"), (Object[])new Object[]{I18n.tr((String)"Send")}));
        this.noLineEndingAlert.setToolTipText(this.noLineEndingAlert.getText());
        this.noLineEndingAlert.setForeground(pane.getBackground());
        Dimension minimumSize = new Dimension(this.noLineEndingAlert.getMinimumSize());
        minimumSize.setSize(minimumSize.getWidth() / 3.0, minimumSize.getHeight());
        this.noLineEndingAlert.setMinimumSize(minimumSize);
        this.lineEndings = new JComboBox<String>(new String[]{I18n.tr((String)"No line ending"), I18n.tr((String)"Newline"), I18n.tr((String)"Carriage return"), I18n.tr((String)"Both NL & CR")});
        this.lineEndings.addActionListener(event -> {
            PreferencesData.setInteger((String)"serial.line_ending", (int)this.lineEndings.getSelectedIndex());
            this.noLineEndingAlert.setForeground(pane.getBackground());
        });
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        lowerPane.add(this.textField);
        lowerPane.add(Box.createRigidArea(new Dimension(4, 0)));
        lowerPane.add(this.sendButton);
        pane.add(lowerPane);
        pane.add(this.noLineEndingAlert);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.lineEndings);
        this.applyPreferences();
        this.onSendCommand(event -> {
            this.send(this.textField.getText());
            this.textField.setText("");
        });
    }

    private void send(String string) {
        String s = string;
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                    break;
                }
            }
            if ("".equals(s) && this.lineEndings.getSelectedIndex() == 0 && !PreferencesData.has((String)"runtime.line.ending.alert.notified")) {
                this.noLineEndingAlert.setForeground(Color.RED);
                PreferencesData.set((String)"runtime.line.ending.alert.notified", (String)"true");
            }
            this.serial.write(s);
        }
    }

    public void onSendCommand(ActionListener listener) {
        this.textField.addActionListener(listener);
        this.sendButton.addActionListener(listener);
    }

    @Override
    public void applyPreferences() {
        if (PreferencesData.get((String)"serial.line_ending") != null) {
            this.lineEndings.setSelectedIndex(PreferencesData.getInteger((String)"serial.line_ending"));
        }
    }

    @Override
    protected void onEnableWindow(boolean enable) {
        this.textField.setEnabled(enable);
        this.sendButton.setEnabled(enable);
    }

    private void onSerialRateChange(ActionListener listener) {
        this.serialRates.addActionListener(listener);
    }

    @Override
    public void message(String s) {
        int linebreak;
        this.messageBuffer.append(s);
        while ((linebreak = this.messageBuffer.indexOf("\n")) != -1) {
            String[] parts;
            ++this.xCount;
            String line = this.messageBuffer.substring(0, linebreak);
            this.messageBuffer.delete(0, linebreak + 1);
            if ((line = line.trim()).length() == 0 || (parts = line.split("[, \t]+")).length == 0) continue;
            int validParts = 0;
            int validLabels = 0;
            for (int i = 0; i < parts.length; ++i) {
                Double value = null;
                String label = null;
                if (parts[i].contains(":")) {
                    String[] subString = parts[i].split("[:]+");
                    if (subString.length > 0) {
                        int labelLength = subString[0].length();
                        if (labelLength > 32) {
                            labelLength = 32;
                        }
                        label = subString[0].substring(0, labelLength);
                    } else {
                        label = "";
                    }
                    parts[i] = subString.length > 1 ? subString[1] : "";
                }
                try {
                    value = Double.valueOf(parts[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (label == null && value == null) {
                    label = parts[i];
                }
                if (value != null) {
                    if (validParts >= this.graphs.size()) {
                        this.graphs.add(new Graph(validParts));
                    }
                    this.graphs.get((int)validParts).buffer.add(value);
                    ++validParts;
                }
                if (label != null) {
                    if (validLabels >= this.graphs.size()) {
                        this.graphs.add(new Graph(validLabels));
                    }
                    this.graphs.get((int)validLabels).label = label;
                    ++validLabels;
                }
                if (validParts > validLabels) {
                    validLabels = validParts;
                    continue;
                }
                if (validLabels <= validParts) continue;
                validParts = validLabels;
            }
        }
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.getBoardPort().getAddress(), this.serialRate){

            protected void message(char[] buff, int n) {
                SerialPlotter.this.addToUpdateBuffer(buff, n);
            }
        };
    }

    @Override
    public void close() throws Exception {
        if (this.serial != null) {
            super.close();
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)"last.serial.location", (String)locationStr);
            this.serial.dispose();
            this.serial = null;
        }
    }

    private class GraphPanel
    extends JPanel {
        private double minY;
        private double maxY;
        private double rangeY;
        private Rectangle bounds;
        private int xOffset = 20;
        private int xPadding = 20;
        private final Font font = Theme.getFont("console.font");
        private final Color bgColor = Theme.getColor("plotting.bgcolor");
        private final Color gridColor = Theme.getColor("plotting.gridcolor");
        private final Color boundsColor = Theme.getColor("plotting.boundscolor");

        private Ticks computeBounds() {
            this.minY = Double.POSITIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            for (Graph g : SerialPlotter.this.graphs) {
                if (g.buffer.isEmpty()) continue;
                this.minY = Math.min(g.buffer.min(), this.minY);
                this.maxY = Math.max(g.buffer.max(), this.maxY);
            }
            double MIN_DELTA = 10.0;
            if (this.maxY - this.minY < 10.0) {
                double mid = (this.maxY + this.minY) / 2.0;
                this.maxY = mid + 5.0;
                this.minY = mid - 5.0;
            }
            Ticks ticks = new Ticks(this.minY, this.maxY, 5);
            this.minY = Math.min(this.minY, ticks.getTick(0));
            this.maxY = Math.max(this.maxY, ticks.getTick(ticks.getTickCount() - 1));
            this.rangeY = this.maxY - this.minY;
            this.minY -= 0.05 * this.rangeY;
            this.maxY += 0.05 * this.rangeY;
            this.rangeY = this.maxY - this.minY;
            return ticks;
        }

        @Override
        public void paintComponent(Graphics g1) {
            Rectangle2D fBounds;
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(this.font);
            super.paintComponent(g);
            this.bounds = g.getClipBounds();
            this.setBackground(this.bgColor);
            if (SerialPlotter.this.graphs.isEmpty()) {
                return;
            }
            Ticks ticks = this.computeBounds();
            g.setStroke(new BasicStroke(1.0f));
            FontMetrics fm = g.getFontMetrics();
            for (int i = 0; i < ticks.getTickCount(); ++i) {
                double tick = ticks.getTick(i);
                Rectangle2D fRect = fm.getStringBounds(String.valueOf(tick), g);
                this.xOffset = Math.max(this.xOffset, (int)fRect.getWidth() + 15);
                g.setColor(this.boundsColor);
                g.drawLine(this.xOffset - 5, (int)this.transformY(tick), this.xOffset + 2, (int)this.transformY(tick));
                g.drawString(String.valueOf(tick), (float)(this.xOffset - (int)fRect.getWidth() - 10), this.transformY(tick) - (float)fRect.getHeight() * 0.5f + (float)fm.getAscent());
                g.setColor(this.gridColor);
                g.drawLine(this.xOffset + 3, (int)this.transformY(tick), this.bounds.width - this.xPadding, (int)this.transformY(tick));
            }
            int cnt = SerialPlotter.this.xCount - 500;
            if (SerialPlotter.this.xCount < 500) {
                cnt = 0;
            }
            double zeroTick = ticks.getTick(0);
            double lastTick = ticks.getTick(ticks.getTickCount() - 1);
            double xTickRange = 500 / ticks.getTickCount();
            for (int i = 0; i < ticks.getTickCount() + 1; ++i) {
                int xValue;
                int sWidth;
                String s;
                if (i == 0) {
                    s = String.valueOf(cnt);
                    fBounds = fm.getStringBounds(s, g);
                    sWidth = (int)fBounds.getWidth() / 2;
                    xValue = this.xOffset;
                } else {
                    s = String.valueOf((int)(xTickRange * (double)i) + cnt);
                    fBounds = fm.getStringBounds(s, g);
                    sWidth = (int)fBounds.getWidth() / 2;
                    xValue = (int)((double)(this.bounds.width - this.xOffset - this.xPadding) * (xTickRange * (double)i / 500.0) + (double)this.xOffset);
                }
                g.setColor(this.boundsColor);
                g.drawString(s, xValue - sWidth, this.bounds.y + (int)this.transformY(zeroTick) + 15);
                g.drawLine(xValue, (int)this.transformY(zeroTick) - 2, xValue, this.bounds.y + (int)this.transformY(zeroTick) + 5);
                g.setColor(this.gridColor);
                g.drawLine(xValue, (int)this.transformY(zeroTick) - 3, xValue, this.bounds.y + (int)this.transformY(lastTick));
            }
            g.setColor(this.boundsColor);
            g.drawLine(this.bounds.x + this.xOffset, (int)this.transformY(lastTick) - 5, this.bounds.x + this.xOffset, this.bounds.y + (int)this.transformY(zeroTick) + 5);
            g.drawLine(this.xOffset, (int)this.transformY(zeroTick), this.bounds.width - this.xPadding, (int)this.transformY(zeroTick));
            g.setTransform(AffineTransform.getTranslateInstance(this.xOffset, 0.0));
            float xstep = (float)(this.bounds.width - this.xOffset - this.xPadding) / 500.0f;
            int legendXOffset = 0;
            for (int i = 0; i < SerialPlotter.this.graphs.size(); ++i) {
                ((Graph)SerialPlotter.this.graphs.get(i)).paint(g, xstep, this.minY, this.maxY, this.rangeY, this.bounds.height);
                if (SerialPlotter.this.graphs.size() <= 1) continue;
                g.fillRect(10 + legendXOffset, 10, 10, 10);
                legendXOffset += 13;
                g.setColor(this.boundsColor);
                String s = ((Graph)((SerialPlotter)SerialPlotter.this).graphs.get((int)i)).label;
                if (s == null || s.length() <= 0) continue;
                fBounds = fm.getStringBounds(s, g);
                int sWidth = (int)fBounds.getWidth();
                g.drawString(s, 10 + legendXOffset, 10 + (int)fBounds.getHeight() / 2);
                legendXOffset += sWidth + 3;
            }
        }

        private float transformY(double rawY) {
            return (float)(5.0 + (double)(this.bounds.height - 10) * (1.0 - (rawY - this.minY) / this.rangeY));
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(200, 100);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(500, 250);
        }
    }

    private static class Graph {
        public CircularBuffer buffer = new CircularBuffer(500);
        private Color color;
        public String label;

        public Graph(int id) {
            this.color = Theme.getColorCycleColor("plotting.graphcolor", id);
        }

        public void paint(Graphics2D g, float xstep, double minY, double maxY, double rangeY, double height) {
            g.setColor(this.color);
            g.setStroke(new BasicStroke(1.0f));
            for (int i = 0; i < this.buffer.size() - 1; ++i) {
                g.drawLine((int)((float)i * xstep), (int)this.transformY(this.buffer.get(i), minY, rangeY, height), (int)((float)(i + 1) * xstep), (int)this.transformY(this.buffer.get(i + 1), minY, rangeY, height));
            }
        }

        private float transformY(double rawY, double minY, double rangeY, double height) {
            return (float)(5.0 + (height - 10.0) * (1.0 - (rawY - minY) / rangeY));
        }
    }
}

