/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.lang.reflect.Member;
import java.util.Arrays;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyStandardError;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;
    private String providedMessage;

    protected RaiseException(String message2, RubyException exception2) {
        super(message2);
        this.setException(exception2);
        this.preRaise(exception2.getRuntime().getCurrentContext(), RubyException.retrieveBacktrace(exception2), true);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    public static RaiseException from(Ruby runtime2, RubyClass exceptionClass, String msg) {
        return RubyException.newException(runtime2, exceptionClass, msg).toThrowable();
    }

    public static RaiseException from(Ruby runtime2, RubyClass exceptionClass, String msg, IRubyObject backtrace2) {
        RubyException exception2 = RubyException.newException(runtime2, exceptionClass, msg);
        exception2.setBacktrace(backtrace2);
        return exception2.toThrowable();
    }

    public static RaiseException from(Ruby runtime2, RubyClass exceptionClass, IRubyObject ... args2) {
        RubyException exception2 = RubyException.newException(runtime2.getCurrentContext(), exceptionClass, args2);
        return exception2.toThrowable();
    }

    public static RaiseException from(Ruby runtime2, String exceptionPath, String msg) {
        RubyClass exceptionClass = RaiseException.findExceptionClass(runtime2, exceptionPath);
        return RaiseException.from(runtime2, exceptionClass, msg);
    }

    public static RaiseException from(Ruby runtime2, String exceptionPath, String msg, IRubyObject backtrace2) {
        RubyClass exceptionClass = RaiseException.findExceptionClass(runtime2, exceptionPath);
        return RaiseException.from(runtime2, exceptionClass, msg, backtrace2);
    }

    public static RaiseException from(Ruby runtime2, String exceptionPath, IRubyObject ... args2) {
        RubyClass exceptionClass = RaiseException.findExceptionClass(runtime2, exceptionPath);
        return RaiseException.from(runtime2, exceptionClass, args2);
    }

    private static RubyClass findExceptionClass(Ruby runtime2, String exceptionPath) {
        IRubyObject exceptionClass = runtime2.getObject().getConstant(exceptionPath);
        if (exceptionClass == null) {
            throw runtime2.newNameError("exception class not found", exceptionPath);
        }
        if (!(exceptionClass instanceof RubyClass)) {
            throw runtime2.newTypeError("expected to find exception class for " + exceptionPath + " but got " + exceptionClass.inspect());
        }
        return (RubyClass)exceptionClass;
    }

    @Override
    public String getMessage() {
        if (this.providedMessage == null) {
            this.providedMessage = '(' + this.exception.getMetaClass().getBaseName() + ") " + this.exception.message(this.exception.getRuntime().getCurrentContext()).asJavaString();
        }
        return this.providedMessage;
    }

    @Override
    public Throwable getCause() {
        Throwable cause2 = super.getCause();
        if (cause2 == null && this.exception != null) {
            Object rubyCause = this.exception.getCause();
            if (rubyCause instanceof RubyException) {
                cause2 = ((RubyException)rubyCause).toThrowable();
            } else if (rubyCause instanceof IRubyObject && (rubyCause = JavaUtil.unwrapIfJavaObject((IRubyObject)rubyCause)) instanceof Throwable) {
                cause2 = (Throwable)rubyCause;
            }
        }
        return cause2;
    }

    public final RubyException getException() {
        return this.exception;
    }

    private void preRaise(ThreadContext context, IRubyObject backtrace2, boolean capture) {
        context.runtime.incrementExceptionCount();
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.logException(this.exception);
        }
        this.doSetLastError(context);
        if (backtrace2 == null) {
            if (capture) {
                if (this.requiresBacktrace(context)) {
                    this.exception.captureBacktrace(context);
                }
                this.setStackTraceFromException();
            }
        } else {
            this.exception.setBacktrace(backtrace2);
            if (!backtrace2.isNil() && !RaiseException.isEmptyArray(backtrace2) && this.requiresBacktrace(context)) {
                this.exception.captureBacktrace(context);
            }
            this.setStackTraceFromException();
        }
        IRRuntimeHelpers.traceRaise(context);
    }

    private void setStackTraceFromException() {
        RubyStackTraceElement[] rubyTrace = this.exception.getBacktraceElements();
        if (rubyTrace.length > 5 && "getStackTrace".equals(rubyTrace[0].getMethodName())) {
            int skip2 = 0;
            if ("preRaise".equals(rubyTrace[4].getMethodName())) {
                skip2 = 5;
            } else if ("preRaise".equals(rubyTrace[3].getMethodName())) {
                skip2 = 4;
            }
            rubyTrace = Arrays.copyOfRange(rubyTrace, skip2, rubyTrace.length);
        }
        this.setStackTrace(RaiseException.javaTraceFromRubyTrace(rubyTrace));
    }

    private StackTraceElement[] skipFillInStackTracePart(StackTraceElement[] trace2) {
        int len = trace2.length;
        if (len >= 3) {
            int skip2 = 0;
            if ("preRaise".equals(trace2[2].getMethodName())) {
                skip2 = 3;
            } else if ("preRaise".equals(trace2[1].getMethodName())) {
                skip2 = 2;
            } else if ("fillInStackTrace".equals(trace2[2].getMethodName())) {
                skip2 = 3;
            }
            return Arrays.copyOfRange(trace2, skip2, len);
        }
        return trace2;
    }

    private void fillInStackTraceSkipPreRaise() {
        this.originalFillInStackTrace();
        StackTraceElement[] curTrace = this.getStackTrace();
        StackTraceElement[] newTrace = this.skipFillInStackTracePart(curTrace);
        if (newTrace != curTrace) {
            this.setStackTrace(newTrace);
        }
    }

    private void doSetLastError(ThreadContext context) {
        context.setErrorInfo(this.exception);
    }

    protected final void setException(RubyException newException) {
        this.exception = newException;
    }

    public static StackTraceElement[] javaTraceFromRubyTrace(RubyStackTraceElement[] trace2) {
        StackTraceElement[] newTrace = new StackTraceElement[trace2.length];
        for (int i2 = 0; i2 < newTrace.length; ++i2) {
            newTrace[i2] = trace2[i2].asStackTraceElement();
        }
        return newTrace;
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2) {
        return RaiseException.createNativeRaiseException(runtime2, cause2, null);
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2, Member target) {
        NativeException nativeException = new NativeException(runtime2, runtime2.getNativeException(), cause2);
        return new RaiseException(cause2, nativeException);
    }

    @Deprecated
    public RaiseException(Throwable cause2, NativeException nativeException) {
        super(nativeException.getMessageAsJavaString(), cause2);
        this.providedMessage = super.getMessage();
        this.setException(nativeException);
        this.preRaise(nativeException.getRuntime().getCurrentContext(), nativeException.getCause().getStackTrace());
        this.setStackTraceFromException();
    }

    @Deprecated
    public RaiseException(RubyException exception2) {
        this(exception2.getMessageAsJavaString(), exception2);
    }

    @Deprecated
    public RaiseException(RubyException exception2, boolean unused2) {
        this(exception2.getMessageAsJavaString(), exception2);
    }

    @Deprecated
    public RaiseException(RubyException exception2, IRubyObject backtrace2) {
        super(exception2.getMessageAsJavaString());
        this.setException(exception2);
        this.preRaise(exception2.getRuntime().getCurrentContext(), backtrace2, true);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass exceptionClass, String msg) {
        this(runtime2, exceptionClass, msg, null);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass exceptionClass, String msg, boolean unused2) {
        this(runtime2, exceptionClass, msg, null);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass exceptionClass, String msg, IRubyObject backtrace2) {
        super(msg == null ? (msg = "No message available") : msg);
        this.providedMessage = '(' + exceptionClass.getName() + ") " + msg;
        ThreadContext context = runtime2.getCurrentContext();
        this.setException(RubyException.newException(context, exceptionClass, RubyString.newUnicodeString(runtime2, msg)));
        this.preRaise(context, backtrace2, true);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass exceptionClass, String msg, IRubyObject backtrace2, boolean unused2) {
        this(runtime2, exceptionClass, msg, backtrace2);
    }

    @Deprecated
    protected final void setException(RubyException newException, boolean unused2) {
        this.exception = newException;
    }

    @Deprecated
    private void preRaise(ThreadContext context, StackTraceElement[] javaTrace) {
        this.preRaise(context, null, false);
        if (this.requiresBacktrace(context)) {
            this.exception.prepareIntegratedBacktrace(context, javaTrace);
            this.setStackTraceFromException();
        } else {
            this.setStackTrace(this.skipFillInStackTracePart(javaTrace));
        }
    }

    @Deprecated
    public static RaiseException from(RubyException exception2, IRubyObject backtrace2) {
        return new RaiseException(exception2, backtrace2);
    }

    private boolean requiresBacktrace(ThreadContext context) {
        return context.exceptionRequiresBacktrace || !(this.exception instanceof RubyStandardError);
    }

    private static boolean isEmptyArray(IRubyObject ary) {
        return ary instanceof RubyArray && ((RubyArray)ary).size() == 0;
    }

    private static JavaSites.RaiseExceptionSites sites(ThreadContext context) {
        return context.sites.RaiseException;
    }
}

