/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ga extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Am Caighde\u00e1nach Mhosc\u00f3",
               "",
               "Am Samhraidh Mhosc\u00f3",
               "",
               "Am Mhosc\u00f3",
               "",
            };
        final String[] Pakistan = new String[] {
               "Am Caighde\u00e1nach na Pacast\u00e1ine",
               "",
               "Am Samhraidh na Pacast\u00e1ine",
               "",
               "Am na Pacast\u00e1ine",
               "",
            };
        final String[] Magadan = new String[] {
               "Am Caighde\u00e1nach Mhagadan",
               "",
               "Am Samhraidh Mhagadan",
               "",
               "Am Mhagadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hEorpa",
               "CET",
               "Am Samhraidh L\u00e1r na hEorpa",
               "CEST",
               "Am L\u00e1r na hEorpa",
               "CET",
            };
        final String[] Acre = new String[] {
               "Am Caighde\u00e1nach Acre",
               "",
               "Am Samhraidh Acre",
               "",
               "Am Acre",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Am Caighde\u00e1nach an Oirthir",
               "",
               "Am Samhraidh an Oirthir",
               "",
               "Am an Oirthir",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Am Caighde\u00e1nach Lord Howe",
               "",
               "Am Samhraidh Lord Howe",
               "",
               "Am Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Am Caighde\u00e1nach na Nua-Sh\u00e9alainne",
               "",
               "Am Samhraidh na Nua-Sh\u00e9alainne",
               "",
               "Am na Nua-Sh\u00e9alainne",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Am an Aig\u00e9in Indiaigh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Am Caighde\u00e1nach Iac\u00fatsc",
               "",
               "Am Samhraidh Iac\u00fatsc",
               "",
               "Am Iac\u00fatsc",
               "",
            };
        final String[] East_Timor = new String[] {
               "Am Th\u00edom\u00f3r Thoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Am Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hEorpa",
               "EET",
               "Am Samhraidh Oirthear na hEorpa",
               "EEST",
               "Am Oirthear na hEorpa",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAirgint\u00edne",
               "",
               "Am Samhraidh Iarthar na hAirgint\u00edne",
               "",
               "Am Iarthar na hAirgint\u00edne",
               "",
            };
        final String[] Ponape = new String[] {
               "Am Phohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Am na Bolaive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Am Caighde\u00e1nach Saint-Pierre-et-Miquelon",
               "",
               "Am Samhraidh Saint-Pierre-et-Miquelon",
               "",
               "Am Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Am na hInd-S\u00edne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Am Caighde\u00e1nach Yekaterinburg",
               "",
               "Am Samhraidh Yekaterinburg",
               "",
               "Am Yekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Am Oile\u00e1in Mhaild\u00edve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Am Thaih\u00edt\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Am Vail\u00eds agus Fut\u00fana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Am Caighde\u00e1nach na hAfraice Theas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Am St\u00e1isi\u00fan Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Am Oile\u00e1in na L\u00edne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Am Caighde\u00e1nach na h\u00daisb\u00e9iceast\u00e1ine",
               "",
               "Am Samhraidh na h\u00daisb\u00e9iceast\u00e1ine",
               "",
               "Am na h\u00daisb\u00e9iceast\u00e1ine",
               "",
            };
        final String[] Mongolia = new String[] {
               "Am Caighde\u00e1nach Ul\u00e1nb\u00e1tar",
               "",
               "Am Samhraidh Ul\u00e1nb\u00e1tar",
               "",
               "Am Ul\u00e1nb\u00e1tar",
               "",
            };
        final String[] America_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1rnach",
               "",
               "Am Samhraidh L\u00e1rnach",
               "",
               "Am L\u00e1rnach",
               "",
            };
        final String[] Niue = new String[] {
               "Am Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Am Oile\u00e1n Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Fh\u00e1clainne",
               "",
               "Am Samhraidh Oile\u00e1in Fh\u00e1clainne",
               "",
               "Am Oile\u00e1in Fh\u00e1clainne",
               "",
            };
        final String[] Apia = new String[] {
               "Am Caighde\u00e1nach Apia",
               "",
               "Am Samhraidh Apia",
               "",
               "Am Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Am na B\u00fat\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Am N\u00e1r\u00fa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Am Iarthar na Casacst\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Am Oile\u00e1n na Nollag",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Am R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Am Oile\u00e1in Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Am Caighde\u00e1nach Chatham",
               "",
               "Am Samhraidh Chatham",
               "",
               "Am Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Am St\u00e1isi\u00fan Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Am Caighde\u00e1nach na hAirgint\u00edne",
               "",
               "Am Samhraidh na hAirgint\u00edne",
               "",
               "Am na hAirgint\u00edne",
               "",
            };
        final String[] Gambier = new String[] {
               "Am Ghambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Am Oile\u00e1in Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Am Veinis\u00e9ala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Am Oile\u00e1in an Fh\u00e9inics",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Am Caighde\u00e1nach Rinn Verde",
               "",
               "Am Samhraidh Rinn Verde",
               "",
               "Am Rinn Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Am Oile\u00e1n Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Am Caighde\u00e1nach Sham\u00f3",
               "",
               "Am Samhraidh Sham\u00f3",
               "",
               "Am Sham\u00f3",
               "",
            };
        final String[] Davis = new String[] {
               "Am St\u00e1isi\u00fan Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Am Caighde\u00e1nach Ch\u00faba",
               "",
               "Am Samhraidh Ch\u00faba",
               "",
               "Am Ch\u00faba",
               "",
            };
        final String[] GMT = new String[] {
               "Me\u00e1n-Am Greenwich",
               "MAG",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Am Caighde\u00e1nach na nOile\u00e1n Filip\u00edneach",
               "",
               "Am Samhraidh na nOile\u00e1n Filip\u00edneach",
               "",
               "Am na nOile\u00e1n Filip\u00edneach",
               "",
            };
        final String[] French_Southern = new String[] {
               "Am Chr\u00edocha Francacha Deisceart an Domhain",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Am Caighde\u00e1nach na Nua-Chalad\u00f3ine",
               "",
               "Am Samhraidh na Nua-Chalad\u00f3ine",
               "",
               "Am na Nua-Chalad\u00f3ine",
               "",
            };
        final String[] Brunei = new String[] {
               "Am Br\u00fain\u00e9 Darasal\u00e1m",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Am Caighde\u00e1nach na hIar\u00e1ine",
               "",
               "Am Samhraidh na hIar\u00e1ine",
               "",
               "Am na hIar\u00e1ine",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Am na T\u00e1ids\u00edceast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Am Caighde\u00e1nach Thonga",
               "",
               "Am Samhraidh Thonga",
               "",
               "Am Thonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Am Caighde\u00e1nach na Banglaid\u00e9ise",
               "",
               "Am Samhraidh na Banglaid\u00e9ise",
               "",
               "Am na Banglaid\u00e9ise",
               "",
            };
        final String[] Peru = new String[] {
               "Am Caighde\u00e1nach Pheiri\u00fa",
               "",
               "Am Samhraidh Pheiri\u00fa",
               "",
               "Am Pheiri\u00fa",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na Graonlainne",
               "",
               "Am Samhraidh Oirthear na Graonlainne",
               "",
               "Am Oirthear na Graonlainne",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Am Oirthear na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Am na Cirgeast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hAstr\u00e1ile",
               "",
               "Am Samhraidh Oirthear na hAstr\u00e1ile",
               "",
               "Am Oirthear na hAstr\u00e1ile",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Am Ghu\u00e1in na Fraince",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Am Caighde\u00e1nach na Col\u00f3ime",
               "",
               "Am Samhraidh na Col\u00f3ime",
               "",
               "Am na Col\u00f3ime",
               "",
            };
        final String[] Chile = new String[] {
               "Am Caighde\u00e1nach na Sile",
               "",
               "Am Samhraidh na Sile",
               "",
               "Am na Sile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Am Chireabait\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Am Caighde\u00e1nach Irkutsk",
               "",
               "Am Samhraidh Irkutsk",
               "",
               "Am Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Am Caighde\u00e1nach na Seoirsia",
               "",
               "Am Samhraidh na Seoirsia",
               "",
               "Am na Seoirsia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Am Caighde\u00e1nach Choibalsan",
               "",
               "Am Samhraidh Choibalsan",
               "",
               "Am Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Am Caighde\u00e1nach na S\u00edne",
               "",
               "Am Samhraidh na S\u00edne",
               "",
               "Am na S\u00edne",
               "",
            };
        final String[] Armenia = new String[] {
               "Am Caighde\u00e1nach na hAirm\u00e9ine",
               "",
               "Am Samhraidh na hAirm\u00e9ine",
               "",
               "Am na hAirm\u00e9ine",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Am L\u00e1r na hAfraice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Am Caighde\u00e1nach na Seap\u00e1ine",
               "",
               "Am Samhraidh na Seap\u00e1ine",
               "",
               "Am na Seap\u00e1ine",
               "",
            };
        final String[] Taipei = new String[] {
               "Am Caighde\u00e1nach Thaipei",
               "",
               "Am Samhraidh Thaipei",
               "",
               "Am Thaipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Am Caighde\u00e1nach Hovd",
               "",
               "Am Samhraidh Hovd",
               "",
               "Am Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Am Caighde\u00e1nach Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
               "Am Samhraidh Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
               "Am Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Am Caighde\u00e1nach Shakhalin",
               "",
               "Am Samhraidh Shakhalin",
               "",
               "Am Shakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Am Caighde\u00e1nach Pharagua",
               "",
               "Am Samhraidh Pharagua",
               "",
               "Am Pharagua",
               "",
            };
        final String[] Casey = new String[] {
               "Am St\u00e1isi\u00fan Casey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "Am na Malaeisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Am Uil\u00edoch L\u00e1rnach",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n Mhuir\u00eds",
               "",
               "Am Samhraidh Oile\u00e1n Mhuir\u00eds",
               "",
               "Am Oile\u00e1n Mhuir\u00eds",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Am Oirthear na hAfraice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Am Oile\u00e1in Sholom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Am Oile\u00e1in Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Am Caighde\u00e1nach Thalamh an \u00c9isc",
               "",
               "Am Samhraidh Thalamh an \u00c9isc",
               "",
               "Am Thalamh an \u00c9isc",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Am na hAfganast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Am Caighde\u00e1nach Hong Cong",
               "",
               "Am Samhraidh Hong Cong",
               "",
               "Am Hong Cong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Am Caighde\u00e1nach an Atlantaigh",
               "",
               "Am Samhraidh an Atlantaigh",
               "",
               "Am an Atlantaigh",
               "",
            };
        final String[] Israel = new String[] {
               "Am Caighde\u00e1nach Iosrael",
               "",
               "Am Samhraidh Iosrael",
               "",
               "Am Iosrael",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Am L\u00e1r na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Am Caighde\u00e1nach Omsk",
               "",
               "Am Samhraidh Omsk",
               "",
               "Am Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Am na S\u00e9is\u00e9al",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Am Caighde\u00e1nach Uragua",
               "",
               "Am Samhraidh Uragua",
               "",
               "Am Uragua",
               "",
            };
        final String[] Nepal = new String[] {
               "Am Neipeal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Am Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Am Caighde\u00e1nach Vanuat\u00fa",
               "",
               "Am Samhraidh Vanuat\u00fa",
               "",
               "Am Vanuat\u00fa",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Am Caighde\u00e1nach Novosibirsk",
               "",
               "Am Samhraidh Novosibirsk",
               "",
               "Am Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Am Caighde\u00e1nach Shingeap\u00f3r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Am Caighde\u00e1nach na nAs\u00f3r",
               "",
               "Am Samhraidh na nAs\u00f3r",
               "",
               "Am na nAs\u00f3r",
               "",
            };
        final String[] Suriname = new String[] {
               "Am Shuranam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Am Caighde\u00e1nach Krasnoyarsk",
               "",
               "Am Samhraidh Krasnoyarsk",
               "",
               "Am Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "Am Mhaenmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Am Caighde\u00e1nach na hAmas\u00f3ine",
               "",
               "Am Samhraidh na hAmas\u00f3ine",
               "",
               "Am na hAmas\u00f3ine",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Am Oirthear na Casacst\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Am Caighde\u00e1nach Fhids\u00ed",
               "",
               "Am Samhraidh Fhids\u00ed",
               "",
               "Am Fhids\u00ed",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Am Caighde\u00e1nach Phetropavlovsk-Kamchatski",
               "",
               "Am Samhraidh Phetropavlovsk-Kamchatski",
               "",
               "Am Phetropavlovsk-Kamchatski",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Am Thuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Am Oile\u00e1n Mhic Guaire",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Am Caighde\u00e1nach Hav\u00e1\u00ed-Aili\u00fait",
               "",
               "Am Samhraidh Hav\u00e1\u00ed-Aili\u00fait",
               "",
               "Am Hav\u00e1\u00ed-Aili\u00fait",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hAstr\u00e1ile",
               "",
               "Am Samhraidh L\u00e1r na hAstr\u00e1ile",
               "",
               "Am L\u00e1r na hAstr\u00e1ile",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Am Caighde\u00e1nach an Aig\u00e9in Chi\u00fain",
               "ACAC",
               "Am Samhraidh an Aig\u00e9in Chi\u00fain",
               "ASAC",
               "Am an Aig\u00e9in Chi\u00fain",
               "AAC",
            };
        final String[] Turkmenistan = new String[] {
               "Am Caighde\u00e1nach na Tuircm\u00e9anast\u00e1ine",
               "",
               "Am Samhraidh na Tuircm\u00e9anast\u00e1ine",
               "",
               "Am na Tuircm\u00e9anast\u00e1ine",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hEorpa",
               "WET",
               "Am Samhraidh Iarthar na hEorpa",
               "WEST",
               "Am Iarthar na hEorpa",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Am na Gu\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Am Oile\u00e1n Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Am St\u00e1isi\u00fan Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Am Oile\u00e1in Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Am Caighde\u00e1nach na hAsarbaise\u00e1ine",
               "",
               "Am Samhraidh na hAsarbaise\u00e1ine",
               "",
               "Am na hAsarbaise\u00e1ine",
               "",
            };
        final String[] Mawson = new String[] {
               "Am St\u00e1isi\u00fan Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Am Caighde\u00e1nach Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
               "Am Samhraidh Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
               "Am Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAfraice",
               "",
               "Am Samhraidh Iarthar na hAfraice",
               "",
               "Am Iarthar na hAfraice",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Am na Seoirsia Theas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n na C\u00e1sca",
               "",
               "Am Samhraidh Oile\u00e1n na C\u00e1sca",
               "",
               "Am Oile\u00e1n na C\u00e1sca",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Am Caighde\u00e1nach Iarthuaisceart Mheicsiceo",
               "",
               "Am Samhraidh Iarthuaisceart Mheicsiceo",
               "",
               "Am Iarthuaisceart Mheicsiceo",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Am St\u00e1isi\u00fan Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na Graonlainne",
               "",
               "Am Samhraidh Iarthar na Graonlainne",
               "",
               "Am Iarthar na Graonlainne",
               "",
            };
        final String[] Ecuador = new String[] {
               "Am Eacuad\u00f3r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Am Caighde\u00e1nach na Murascaille",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Am Caighde\u00e1nach na C\u00f3ir\u00e9",
               "",
               "Am Samhraidh na C\u00f3ir\u00e9",
               "",
               "Am na C\u00f3ir\u00e9",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAstr\u00e1ile",
               "",
               "Am Samhraidh Iarthar na hAstr\u00e1ile",
               "",
               "Am Iarthar na hAstr\u00e1ile",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Am Iarthar na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Am Caighde\u00e1nach na Sl\u00e9ibhte",
               "",
               "Am Samhraidh na Sl\u00e9ibhte",
               "",
               "Am na Sl\u00e9ibhte",
               "",
            };
        final String[] Marquesas = new String[] {
               "Am na nOile\u00e1n Marcasach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Am Caighde\u00e1nach na hAraibe",
               "",
               "Am Samhraidh na hAraibe",
               "",
               "Am na hAraibe",
               "",
            };
        final String[] Alaska = new String[] {
               "Am Caighde\u00e1nach Alasca",
               "",
               "Am Samhraidh Alasca",
               "",
               "Am Alasca",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Am Caighde\u00e1nach Vladivostok",
               "",
               "Am Samhraidh Vladivostok",
               "",
               "Am Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Am Caighde\u00e1nach Seam\u00f3rach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Am Oile\u00e1in T\u00f3cal\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Am Nua-Ghuine Phapua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Am Caighde\u00e1nach Fhernando de Noronha",
               "",
               "Am Samhraidh Fhernando de Noronha",
               "",
               "Am Fhernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Am Caighde\u00e1nach Bhras\u00edlia",
               "",
               "Am Samhraidh Bhras\u00edlia",
               "",
               "Am Bhras\u00edlia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Am Caighde\u00e1nach Anadyr",
               "",
               "Am Samhraidh Anadyr",
               "",
               "Am Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Am Caighde\u00e1nach Shamara",
               "",
               "Am Samhraidh Shamara",
               "",
               "Am Shamara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Am Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Am Caighde\u00e1nach na hIndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Cook",
               "",
               "Am Leathshamhraidh Oile\u00e1in Cook",
               "",
               "Am Oile\u00e1in Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Li\u00faible\u00e1na" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "na hOile\u00e1in Mharcasacha" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fids\u00ed" },
            { "timezone.excity.Europe/Gibraltar", "Giobr\u00e1ltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dac\u00e1r" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adas Ababa" },
            { "timezone.excity.Africa/Kinshasa", "Cinseasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Taillinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vad\u00fas" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londain" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Beirl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Oile\u00e1in Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "an Bheil\u00eds" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Geirs\u00ed" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "an tSeoirsia Theas" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Hav\u00e1na" },
            { "timezone.excity.Europe/Madrid", "Maidrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grean\u00e1da" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "an R\u00f3imh" },
            { "timezone.excity.Asia/Hebron", "Heabr\u00f3n" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nuacsat" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "L\u00edoma" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nua-Eabhrac" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Cathair Anaithnid" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Mac Guaire" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogat\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Cathair na hAilg\u00e9ire" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Cart\u00fam" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Caighd\u00e9anach na h\u00c9ireann",
                    "AC\u00c9",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conacra\u00ed" },
            { "timezone.excity.Asia/Jakarta", "Iac\u00e1rta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "San H\u00e9ilin" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Lucsamburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bair\u00e9in" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Oile\u00e1n Mhanann" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "N\u00e1r\u00fa" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "an Ghu\u00e1in" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "P\u00e1ras" },
            { "timezone.excity.Europe/Zagreb", "S\u00e1grab" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "B\u00fadaipeist" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Heilsinc\u00ed" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "C\u00f3sta R\u00edce" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogaidisi\u00fa" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Cu\u00e1it" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Mosc\u00f3" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "T\u00f3iceo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Baile \u00c1tha Cliath" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Rinn Verde" },
            { "timezone.excity.Africa/Maputo", "Map\u00fat\u00f3" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "na hAs\u00f3ir" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anga\u00edle" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananair\u00edveo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Oile\u00e1n na Nollag" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirane" },
            { "timezone.excity.Europe/Prague", "Pr\u00e1g" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "As\u00fainseon" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "C\u00edsine\u00e1" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnias" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Mair\u00edne" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Sc\u00f3ip\u00e9" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "R\u00e9iciv\u00edc" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Iac\u00fatsc" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Vail\u00eds" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shang-hai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "an tSalvad\u00f3ir" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Oile\u00e1n na C\u00e1sca" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Oile\u00e1n Wake" },
            { "timezone.excity.Atlantic/Canary", "na hOile\u00e1in Chan\u00e1racha" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Eireav\u00e1n" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Caireo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "V\u00e1rs\u00e1" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadal\u00faip" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Cathair na Vatac\u00e1ine" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "And\u00f3ra" },
            { "timezone.excity.Europe/Minsk", "Mionsc" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "B\u00e9iri\u00fat" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "San Uinseann" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monac\u00f3" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripil\u00ed" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "B\u00facairist" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "an Aithin" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "C\u00f3banh\u00e1van" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Iar\u00fasail\u00e9im" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "an Damaisc" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Pacific/Tahiti", "Taih\u00edt\u00ed" },
            { "timezone.excity.America/St_Kitts", "San Cr\u00edost\u00f3ir" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u00e1rasal\u00e1m" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "S\u00f3ifia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "an Astrac\u00e1in" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "B\u00e9algr\u00e1d" },
            { "timezone.excity.America/Puerto_Rico", "Port\u00f3 R\u00edce" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calc\u00fata" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hong Cong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheicsiceo" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Liosp\u00f3in" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Doiminice" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Geansa\u00ed" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "R\u00edge" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Baile an tSaoir" },
            { "timezone.excity.Europe/Malta", "M\u00e1lta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Ar\u00faba" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Oile\u00e1n Mhuir\u00eds" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Saintiag\u00f3" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Mainile" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "S\u00fal" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Iostanb\u00fal" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sair\u00e9av\u00f3" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "T\u00fainis" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singeap\u00f3r" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "V\u00edn" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "an Bhratasl\u00e1iv" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbad\u00f3s" },
            { "timezone.excity.Asia/Nicosia", "an Nioc\u00f3is" },
            { "timezone.excity.Europe/Kiev", "C\u00edv" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Br\u00fain\u00e9" },
            { "timezone.excity.Atlantic/Faeroe", "Oile\u00e1in Fhar\u00f3" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Iam\u00e1ice" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgair\u00edtse" },
            { "timezone.excity.Indian/Reunion", "La R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "\u00c1idin" },
            { "timezone.excity.Europe/Oslo", "Osl\u00f3" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Cab\u00fal" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amstardam" },
            { "timezone.excity.Atlantic/Bermuda", "Beirmi\u00fada" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Oile\u00e1n Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "an Bhruis\u00e9il" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Maid\u00e9ara" },
            { "timezone.excity.Indian/Comoro", "Oile\u00e1in Chom\u00f3ra" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "St\u00f3c\u00f3lm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Oile\u00e1in Mhaild\u00edve" },
        };
        return data;
    }
}
