/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.argon2;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.sourceforge.plantuml.argon2.Constants;
import net.sourceforge.plantuml.argon2.Util;
import net.sourceforge.plantuml.argon2.Validation;
import net.sourceforge.plantuml.argon2.algorithm.FillMemory;
import net.sourceforge.plantuml.argon2.algorithm.Finalize;
import net.sourceforge.plantuml.argon2.algorithm.Initialize;
import net.sourceforge.plantuml.argon2.model.Argon2Type;
import net.sourceforge.plantuml.argon2.model.Instance;

public class Argon2 {
    private byte[] output;
    private int outputLength = 32;
    private double duration;
    private byte[] password;
    private byte[] salt;
    private byte[] secret;
    private byte[] additional;
    private int iterations = 3;
    private int memory = 4096;
    private int lanes = 1;
    private int version = 19;
    private Argon2Type type = Constants.Defaults.TYPE_DEF;
    private boolean clearMemory = true;
    private boolean encodedOnly = false;
    private boolean rawOnly = false;

    Argon2() {
    }

    private static byte[] toByteArray(char[] chars, Charset charset) {
        assert (chars != null);
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hashNow() {
        try {
            Validation.validateInput(this);
            long start = System.nanoTime();
            Instance instance = new Instance(this);
            Initialize.initialize(instance, this);
            FillMemory.fillMemoryBlocks(instance);
            Finalize.finalize(instance, this);
            this.duration = (double)(System.nanoTime() - start) / 1.0E9;
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        if (this.password != null) {
            Arrays.fill(this.password, 0, this.password.length - 1, (byte)0);
        }
        if (this.salt != null) {
            Arrays.fill(this.salt, 0, this.salt.length - 1, (byte)0);
        }
        if (this.secret != null) {
            Arrays.fill(this.secret, 0, this.secret.length - 1, (byte)0);
        }
        if (this.additional != null) {
            Arrays.fill(this.additional, 0, this.additional.length - 1, (byte)0);
        }
    }

    void printSummary() {
        if (this.encodedOnly) {
            System.out.println(this.getEncoded());
        } else if (this.rawOnly) {
            System.out.println(this.getOutputString());
        } else {
            System.out.println("Type:\t\t" + (Object)((Object)this.type));
            System.out.println("Iterations:\t" + this.iterations);
            System.out.println("Memory:\t\t" + this.memory + " KiB");
            System.out.println("Parallelism:\t" + this.lanes);
            System.out.println("Hash:\t\t" + this.getOutputString());
            System.out.println("Encoded:\t " + this.getEncoded());
            System.out.println(this.duration + " seconds");
        }
    }

    public Argon2 setMemoryInKiB(int memory) {
        this.memory = memory;
        return this;
    }

    public Argon2 setParallelism(int parallelism) {
        this.lanes = parallelism;
        return this;
    }

    public Argon2 setPassword(char[] password) {
        return this.setPassword(Argon2.toByteArray(password, StandardCharsets.UTF_8));
    }

    public Argon2 setSalt(String salt) {
        return this.setSalt(salt.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] getOutput() {
        return this.output;
    }

    public void setOutput(byte[] finalResult) {
        this.output = finalResult;
    }

    public String getOutputString() {
        return Util.bytesToHexString(this.output);
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public Argon2 setOutputLength(int outputLength) {
        this.outputLength = outputLength;
        return this;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public Argon2 setPassword(byte[] password) {
        this.password = password;
        return this;
    }

    public int getPasswordLength() {
        return this.password.length;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public Argon2 setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public int getSaltLength() {
        return this.salt.length;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public Argon2 setSecret(byte[] secret) {
        this.secret = secret;
        return this;
    }

    public int getSecretLength() {
        return this.secret != null ? this.secret.length : 0;
    }

    public byte[] getAdditional() {
        return this.additional;
    }

    public Argon2 setAdditional(byte[] additional) {
        this.additional = additional;
        return this;
    }

    public int getAdditionalLength() {
        return this.additional != null ? this.additional.length : 0;
    }

    public int getIterations() {
        return this.iterations;
    }

    public Argon2 setIterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public int getMemory() {
        return this.memory;
    }

    public Argon2 setMemory(int memory) {
        this.memory = 1 << memory;
        return this;
    }

    public int getLanes() {
        return this.lanes;
    }

    public int getVersion() {
        return this.version;
    }

    public Argon2 setVersion(int version) {
        this.version = version;
        return this;
    }

    public Argon2Type getType() {
        return this.type;
    }

    public Argon2 setType(Argon2Type type) {
        this.type = type;
        return this;
    }

    public boolean isClearMemory() {
        return this.clearMemory;
    }

    public void setClearMemory(boolean clearMemory) {
        this.clearMemory = clearMemory;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public void setEncodedOnly(boolean encodedOnly) {
        this.encodedOnly = encodedOnly;
    }

    public void setRawOnly(boolean rawOnly) {
        this.rawOnly = rawOnly;
    }

    public String getEncoded() {
        return "";
    }
}

