# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
CDM module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_cdm.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _CDM
else:
    import _CDM

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _CDM.delete_SwigPyIterator

    def value(self):
        return _CDM.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _CDM.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _CDM.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _CDM.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _CDM.SwigPyIterator_equal(self, x)

    def copy(self):
        return _CDM.SwigPyIterator_copy(self)

    def next(self):
        return _CDM.SwigPyIterator_next(self)

    def __next__(self):
        return _CDM.SwigPyIterator___next__(self)

    def previous(self):
        return _CDM.SwigPyIterator_previous(self)

    def advance(self, n):
        return _CDM.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _CDM.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _CDM.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _CDM.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _CDM.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _CDM.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _CDM.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _CDM:
_CDM.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _CDM.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.Resource

from enum import IntEnum
from OCC.Core.Exception import *

CDM_CCS_OK = _CDM.CDM_CCS_OK
CDM_CCS_NotOpen = _CDM.CDM_CCS_NotOpen
CDM_CCS_UnstoredReferenced = _CDM.CDM_CCS_UnstoredReferenced
CDM_CCS_ModifiedReferenced = _CDM.CDM_CCS_ModifiedReferenced
CDM_CCS_ReferenceRejection = _CDM.CDM_CCS_ReferenceRejection


class CDM_CanCloseStatus(IntEnum):
	CDM_CCS_OK = 0
	CDM_CCS_NotOpen = 1
	CDM_CCS_UnstoredReferenced = 2
	CDM_CCS_ModifiedReferenced = 3
	CDM_CCS_ReferenceRejection = 4
CDM_CCS_OK = CDM_CanCloseStatus.CDM_CCS_OK
CDM_CCS_NotOpen = CDM_CanCloseStatus.CDM_CCS_NotOpen
CDM_CCS_UnstoredReferenced = CDM_CanCloseStatus.CDM_CCS_UnstoredReferenced
CDM_CCS_ModifiedReferenced = CDM_CanCloseStatus.CDM_CCS_ModifiedReferenced
CDM_CCS_ReferenceRejection = CDM_CanCloseStatus.CDM_CCS_ReferenceRejection


def Handle_CDM_Application_Create():
    return _CDM.Handle_CDM_Application_Create()

def Handle_CDM_Application_DownCast(t):
    return _CDM.Handle_CDM_Application_DownCast(t)

def Handle_CDM_Application_IsNull(t):
    return _CDM.Handle_CDM_Application_IsNull(t)

def Handle_CDM_Document_Create():
    return _CDM.Handle_CDM_Document_Create()

def Handle_CDM_Document_DownCast(t):
    return _CDM.Handle_CDM_Document_DownCast(t)

def Handle_CDM_Document_IsNull(t):
    return _CDM.Handle_CDM_Document_IsNull(t)

def Handle_CDM_MetaData_Create():
    return _CDM.Handle_CDM_MetaData_Create()

def Handle_CDM_MetaData_DownCast(t):
    return _CDM.Handle_CDM_MetaData_DownCast(t)

def Handle_CDM_MetaData_IsNull(t):
    return _CDM.Handle_CDM_MetaData_IsNull(t)

def Handle_CDM_Reference_Create():
    return _CDM.Handle_CDM_Reference_Create()

def Handle_CDM_Reference_DownCast(t):
    return _CDM.Handle_CDM_Reference_DownCast(t)

def Handle_CDM_Reference_IsNull(t):
    return _CDM.Handle_CDM_Reference_IsNull(t)
class CDM_DocumentHasher(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def HashCode(theKey, theUpperBound):
        return _CDM.CDM_DocumentHasher_HashCode(theKey, theUpperBound)

    @staticmethod
    def IsEqual(theKey1, theKey2):
        return _CDM.CDM_DocumentHasher_IsEqual(theKey1, theKey2)

    def __init__(self):
        _CDM.CDM_DocumentHasher_swiginit(self, _CDM.new_CDM_DocumentHasher())
    __swig_destroy__ = _CDM.delete_CDM_DocumentHasher

# Register CDM_DocumentHasher in _CDM:
_CDM.CDM_DocumentHasher_swigregister(CDM_DocumentHasher)
class CDM_ListIteratorOfListOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _CDM.CDM_ListIteratorOfListOfDocument_swiginit(self, _CDM.new_CDM_ListIteratorOfListOfDocument(*args))

    def More(self):
        return _CDM.CDM_ListIteratorOfListOfDocument_More(self)

    def Next(self):
        return _CDM.CDM_ListIteratorOfListOfDocument_Next(self)

    def Value(self):
        return _CDM.CDM_ListIteratorOfListOfDocument_Value(self)

    def ChangeValue(self):
        return _CDM.CDM_ListIteratorOfListOfDocument_ChangeValue(self)
    __swig_destroy__ = _CDM.delete_CDM_ListIteratorOfListOfDocument

# Register CDM_ListIteratorOfListOfDocument in _CDM:
_CDM.CDM_ListIteratorOfListOfDocument_swigregister(CDM_ListIteratorOfListOfDocument)
class CDM_ListIteratorOfListOfReferences(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _CDM.CDM_ListIteratorOfListOfReferences_swiginit(self, _CDM.new_CDM_ListIteratorOfListOfReferences(*args))

    def More(self):
        return _CDM.CDM_ListIteratorOfListOfReferences_More(self)

    def Next(self):
        return _CDM.CDM_ListIteratorOfListOfReferences_Next(self)

    def Value(self):
        return _CDM.CDM_ListIteratorOfListOfReferences_Value(self)

    def ChangeValue(self):
        return _CDM.CDM_ListIteratorOfListOfReferences_ChangeValue(self)
    __swig_destroy__ = _CDM.delete_CDM_ListIteratorOfListOfReferences

# Register CDM_ListIteratorOfListOfReferences in _CDM:
_CDM.CDM_ListIteratorOfListOfReferences_swigregister(CDM_ListIteratorOfListOfReferences)
class CDM_ListOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _CDM.CDM_ListOfDocument_begin(self)

    def end(self):
        return _CDM.CDM_ListOfDocument_end(self)

    def cbegin(self):
        return _CDM.CDM_ListOfDocument_cbegin(self)

    def cend(self):
        return _CDM.CDM_ListOfDocument_cend(self)

    def __init__(self, *args):
        _CDM.CDM_ListOfDocument_swiginit(self, _CDM.new_CDM_ListOfDocument(*args))

    def Size(self):
        return _CDM.CDM_ListOfDocument_Size(self)

    def Assign(self, theOther):
        return _CDM.CDM_ListOfDocument_Assign(self, theOther)

    def Set(self, theOther):
        return _CDM.CDM_ListOfDocument_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _CDM.CDM_ListOfDocument_Clear(self, theAllocator)

    def First(self):
        return _CDM.CDM_ListOfDocument_First(self)

    def Last(self):
        return _CDM.CDM_ListOfDocument_Last(self)

    def Append(self, *args):
        return _CDM.CDM_ListOfDocument_Append(self, *args)

    def Prepend(self, *args):
        return _CDM.CDM_ListOfDocument_Prepend(self, *args)

    def RemoveFirst(self):
        return _CDM.CDM_ListOfDocument_RemoveFirst(self)

    def Remove(self, theIter):
        return _CDM.CDM_ListOfDocument_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _CDM.CDM_ListOfDocument_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _CDM.CDM_ListOfDocument_InsertAfter(self, *args)

    def Reverse(self):
        return _CDM.CDM_ListOfDocument_Reverse(self)
    __swig_destroy__ = _CDM.delete_CDM_ListOfDocument

    def __len__(self):
        return self.Size()


# Register CDM_ListOfDocument in _CDM:
_CDM.CDM_ListOfDocument_swigregister(CDM_ListOfDocument)
class CDM_ListOfReferences(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _CDM.CDM_ListOfReferences_begin(self)

    def end(self):
        return _CDM.CDM_ListOfReferences_end(self)

    def cbegin(self):
        return _CDM.CDM_ListOfReferences_cbegin(self)

    def cend(self):
        return _CDM.CDM_ListOfReferences_cend(self)

    def __init__(self, *args):
        _CDM.CDM_ListOfReferences_swiginit(self, _CDM.new_CDM_ListOfReferences(*args))

    def Size(self):
        return _CDM.CDM_ListOfReferences_Size(self)

    def Assign(self, theOther):
        return _CDM.CDM_ListOfReferences_Assign(self, theOther)

    def Set(self, theOther):
        return _CDM.CDM_ListOfReferences_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _CDM.CDM_ListOfReferences_Clear(self, theAllocator)

    def First(self):
        return _CDM.CDM_ListOfReferences_First(self)

    def Last(self):
        return _CDM.CDM_ListOfReferences_Last(self)

    def Append(self, *args):
        return _CDM.CDM_ListOfReferences_Append(self, *args)

    def Prepend(self, *args):
        return _CDM.CDM_ListOfReferences_Prepend(self, *args)

    def RemoveFirst(self):
        return _CDM.CDM_ListOfReferences_RemoveFirst(self)

    def Remove(self, theIter):
        return _CDM.CDM_ListOfReferences_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _CDM.CDM_ListOfReferences_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _CDM.CDM_ListOfReferences_InsertAfter(self, *args)

    def Reverse(self):
        return _CDM.CDM_ListOfReferences_Reverse(self)
    __swig_destroy__ = _CDM.delete_CDM_ListOfReferences

    def __len__(self):
        return self.Size()


# Register CDM_ListOfReferences in _CDM:
_CDM.CDM_ListOfReferences_swigregister(CDM_ListOfReferences)
class CDM_MapOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def cbegin(self):
        return _CDM.CDM_MapOfDocument_cbegin(self)

    def cend(self):
        return _CDM.CDM_MapOfDocument_cend(self)

    def __init__(self, *args):
        _CDM.CDM_MapOfDocument_swiginit(self, _CDM.new_CDM_MapOfDocument(*args))

    def Exchange(self, theOther):
        return _CDM.CDM_MapOfDocument_Exchange(self, theOther)

    def Assign(self, theOther):
        return _CDM.CDM_MapOfDocument_Assign(self, theOther)

    def Set(self, theOther):
        return _CDM.CDM_MapOfDocument_Set(self, theOther)

    def ReSize(self, N):
        return _CDM.CDM_MapOfDocument_ReSize(self, N)

    def Add(self, K):
        return _CDM.CDM_MapOfDocument_Add(self, K)

    def Added(self, K):
        return _CDM.CDM_MapOfDocument_Added(self, K)

    def Remove(self, K):
        return _CDM.CDM_MapOfDocument_Remove(self, K)

    def Clear(self, *args):
        return _CDM.CDM_MapOfDocument_Clear(self, *args)
    __swig_destroy__ = _CDM.delete_CDM_MapOfDocument

    def Size(self):
        return _CDM.CDM_MapOfDocument_Size(self)

    def IsEqual(self, theOther):
        return _CDM.CDM_MapOfDocument_IsEqual(self, theOther)

    def Contains(self, *args):
        return _CDM.CDM_MapOfDocument_Contains(self, *args)

    def Union(self, theLeft, theRight):
        return _CDM.CDM_MapOfDocument_Union(self, theLeft, theRight)

    def Unite(self, theOther):
        return _CDM.CDM_MapOfDocument_Unite(self, theOther)

    def HasIntersection(self, theMap):
        return _CDM.CDM_MapOfDocument_HasIntersection(self, theMap)

    def Intersection(self, theLeft, theRight):
        return _CDM.CDM_MapOfDocument_Intersection(self, theLeft, theRight)

    def Intersect(self, theOther):
        return _CDM.CDM_MapOfDocument_Intersect(self, theOther)

    def Subtraction(self, theLeft, theRight):
        return _CDM.CDM_MapOfDocument_Subtraction(self, theLeft, theRight)

    def Subtract(self, theOther):
        return _CDM.CDM_MapOfDocument_Subtract(self, theOther)

    def Difference(self, theLeft, theRight):
        return _CDM.CDM_MapOfDocument_Difference(self, theLeft, theRight)

    def Differ(self, theOther):
        return _CDM.CDM_MapOfDocument_Differ(self, theOther)

# Register CDM_MapOfDocument in _CDM:
_CDM.CDM_MapOfDocument_swigregister(CDM_MapOfDocument)
class CDM_MetaDataLookUpTable(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _CDM.CDM_MetaDataLookUpTable_begin(self)

    def end(self):
        return _CDM.CDM_MetaDataLookUpTable_end(self)

    def cbegin(self):
        return _CDM.CDM_MetaDataLookUpTable_cbegin(self)

    def cend(self):
        return _CDM.CDM_MetaDataLookUpTable_cend(self)

    def __init__(self, *args):
        _CDM.CDM_MetaDataLookUpTable_swiginit(self, _CDM.new_CDM_MetaDataLookUpTable(*args))

    def Exchange(self, theOther):
        return _CDM.CDM_MetaDataLookUpTable_Exchange(self, theOther)

    def Assign(self, theOther):
        return _CDM.CDM_MetaDataLookUpTable_Assign(self, theOther)

    def Set(self, theOther):
        return _CDM.CDM_MetaDataLookUpTable_Set(self, theOther)

    def ReSize(self, N):
        return _CDM.CDM_MetaDataLookUpTable_ReSize(self, N)

    def Bind(self, theKey, theItem):
        return _CDM.CDM_MetaDataLookUpTable_Bind(self, theKey, theItem)

    def Bound(self, theKey, theItem):
        return _CDM.CDM_MetaDataLookUpTable_Bound(self, theKey, theItem)

    def IsBound(self, theKey):
        return _CDM.CDM_MetaDataLookUpTable_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _CDM.CDM_MetaDataLookUpTable_UnBind(self, theKey)

    def Seek(self, theKey):
        return _CDM.CDM_MetaDataLookUpTable_Seek(self, theKey)

    def Find(self, *args):
        return _CDM.CDM_MetaDataLookUpTable_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _CDM.CDM_MetaDataLookUpTable_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _CDM.CDM_MetaDataLookUpTable_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _CDM.CDM_MetaDataLookUpTable___call__(self, *args)

    def Clear(self, *args):
        return _CDM.CDM_MetaDataLookUpTable_Clear(self, *args)
    __swig_destroy__ = _CDM.delete_CDM_MetaDataLookUpTable

    def Size(self):
        return _CDM.CDM_MetaDataLookUpTable_Size(self)

# Register CDM_MetaDataLookUpTable in _CDM:
_CDM.CDM_MetaDataLookUpTable_swigregister(CDM_MetaDataLookUpTable)
class CDM_Application(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BeginOfUpdate(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        This method is called before the update of a document. by default, writes in messagedriver().

        """
        return _CDM.CDM_Application_BeginOfUpdate(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _CDM.CDM_Application_DumpJsonToString(self, depth)

    def EndOfUpdate(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document
        theStatus: bool
        ErrorString: str

        Return
        -------
        None

        Description
        -----------
        This method is called affter the update of a document. by default, writes in messagedriver().

        """
        return _CDM.CDM_Application_EndOfUpdate(self, *args)

    def MessageDriver(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Message_Messenger>

        Description
        -----------
        Returns default messenger;.

        """
        return _CDM.CDM_Application_MessageDriver(self, *args)

    def MetaDataLookUpTable(self, *args):
        r"""
        Return
        -------
        CDM_MetaDataLookUpTable

        Description
        -----------
        Returns metadata lookuptable.

        """
        return _CDM.CDM_Application_MetaDataLookUpTable(self, *args)

    def Name(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Returns the application name.

        """
        return _CDM.CDM_Application_Name(self, *args)

    def Resources(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Resource_Manager>

        Description
        -----------
        The manager returned by this virtual method will be used to search for format.retrieval resource items.

        """
        return _CDM.CDM_Application_Resources(self, *args)

    def Version(self, *args):
        r"""
        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns the application version.

        """
        return _CDM.CDM_Application_Version(self, *args)

    def Write(self, *args):
        r"""

        Parameters
        ----------
        aString: Standard_ExtString

        Return
        -------
        None

        Description
        -----------
        Writes the string in the application messagerdriver.

        """
        return _CDM.CDM_Application_Write(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Application_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_Application

# Register CDM_Application in _CDM:
_CDM.CDM_Application_swigregister(CDM_Application)
class CDM_Document(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddComment(self, *args):
        r"""

        Parameters
        ----------
        aComment: str

        Return
        -------
        None

        Description
        -----------
        Appends a comment into comments of this document.

        """
        return _CDM.CDM_Document_AddComment(self, *args)

    def Application(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_Application>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_Application(self, *args)

    def CanClose(self, *args):
        r"""
        Return
        -------
        CDM_CanCloseStatus

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_CanClose(self, *args)

    def CanCloseReference(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        A referenced document may indicate through this virtual method that it does not allow the closing of adocument which it references through the reference areferenceidentifier. by default returns standard_true.

        """
        return _CDM.CDM_Document_CanCloseReference(self, *args)

    def Close(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_Close(self, *args)

    def CloseReference(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document
        aReferenceIdentifier: int

        Return
        -------
        None

        Description
        -----------
        A referenced document may update its internal data structure when {adocument} which it references through the reference {areferenceidentifier} is being closed. by default this method does nothing.

        """
        return _CDM.CDM_Document_CloseReference(self, *args)

    def Comment(self, *args):
        r"""
        Return
        -------
        Standard_ExtString

        Description
        -----------
        Returns the first of associated comments. by default the comment is an empty string.

        """
        return _CDM.CDM_Document_Comment(self, *args)

    def Comments(self, *args):
        r"""

        Parameters
        ----------
        aComments: TColStd_SequenceOfExtendedString

        Return
        -------
        None

        Description
        -----------
        Returns the associated comments through <acomments>. returns empty sequence if no comments are associated.

        """
        return _CDM.CDM_Document_Comments(self, *args)

    def CopyReference(self, *args):
        r"""

        Parameters
        ----------
        aFromDocument: CDM_Document
        aReferenceIdentifier: int

        Return
        -------
        int

        Description
        -----------
        Copies a reference to this document. this method avoid retrieval of referenced document. the arguments are the original document and a valid reference identifier returns the local identifier.

        """
        return _CDM.CDM_Document_CopyReference(self, *args)

    def CreateReference(self, *args):
        r"""

        Parameters
        ----------
        anOtherDocument: CDM_Document

        Return
        -------
        int

        Description
        -----------
        Creates a reference from this document to {anotherdocument}. returns a reference identifier. this reference identifier is unique in the document and will not be used for the next references, even after the storing of the document. if there is already a reference between the two documents, the reference is not created, but its reference identifier is returned.

        Parameters
        ----------
        aMetaData: CDM_MetaData
        aReferenceIdentifier: int
        anApplication: CDM_Application
        aToDocumentVersion: int
        UseStorageConfiguration: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aMetaData: CDM_MetaData
        anApplication: CDM_Application
        aDocumentVersion: int
        UseStorageConfiguration: bool

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_CreateReference(self, *args)

    def DeepReferences(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document

        Return
        -------
        bool

        Description
        -----------
        Returns true is this document references adocument;.

        """
        return _CDM.CDM_Document_DeepReferences(self, *args)

    def Description(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Gets the `fileformat`.description resource.

        """
        return _CDM.CDM_Document_Description(self, *args)

    def Document(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        opencascade::handle<CDM_Document>

        Description
        -----------
        Returns the to document of the reference identified by areferenceidentifier. if the todocument is stored and has not yet been retrieved, this method will retrieve it.

        """
        return _CDM.CDM_Document_Document(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _CDM.CDM_Document_DumpJsonToString(self, depth)

    def Extensions(self, *args):
        r"""

        Parameters
        ----------
        Extensions: TColStd_SequenceOfExtendedString

        Return
        -------
        None

        Description
        -----------
        By default empties the extensions.

        """
        return _CDM.CDM_Document_Extensions(self, *args)

    def FileExtension(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Gets the desktop.domain.application.`fileformat`.fileextension resource.

        """
        return _CDM.CDM_Document_FileExtension(self, *args)

    def FindDescription(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_FindDescription(self, *args)

    def FindFileExtension(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_FindFileExtension(self, *args)

    def Folder(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_Folder(self, *args)

    def FromReferencesNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of references having this document as to document.

        """
        return _CDM.CDM_Document_FromReferencesNumber(self, *args)

    def GetAlternativeDocument(self, *args):
        r"""

        Parameters
        ----------
        aFormat: str
        anAlternativeDocument: CDM_Document

        Return
        -------
        bool

        Description
        -----------
        This method can be redefined to extract another document in a different format. for example, to extract a shape from an applicative document.

        """
        return _CDM.CDM_Document_GetAlternativeDocument(self, *args)

    def HasRequestedFolder(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_HasRequestedFolder(self, *args)

    def HasRequestedPreviousVersion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_HasRequestedPreviousVersion(self, *args)

    def IsInSession(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the to document of the reference identified by areferenceidentifier is in session, false if it corresponds to a not yet retrieved document.

        """
        return _CDM.CDM_Document_IsInSession(self, *args)

    def IsModified(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the version is greater than the storage version.

        """
        return _CDM.CDM_Document_IsModified(self, *args)

    def IsOpened(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the document corresponding to the given reference has been retrieved and opened. otherwise returns false. this method does not retrieve the referenced document.

        """
        return _CDM.CDM_Document_IsOpened(self, *args)

    def IsReadOnly(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Indicates that this document cannot be modified.

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        Indicates that the referenced document cannot be modified,.

        """
        return _CDM.CDM_Document_IsReadOnly(self, *args)

    def IsStored(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the to document of the reference identified by areferenceidentifier has already been stored, false otherwise.
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_IsStored(self, *args)

    def IsUpToDate(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the modification counter found in the given reference is equal to the actual modification counter of the to document. this method is able to deal with a reference to a not retrieved document.

        """
        return _CDM.CDM_Document_IsUpToDate(self, *args)

    def LoadResources(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Read (or rereads) the following resource.

        """
        return _CDM.CDM_Document_LoadResources(self, *args)

    def MetaData(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_MetaData>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_MetaData(self, *args)

    def Modifications(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the current modification counter.

        """
        return _CDM.CDM_Document_Modifications(self, *args)

    def Modify(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Indicates that this document has been modified. this method increments the modification counter.

        """
        return _CDM.CDM_Document_Modify(self, *args)

    def Name(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Returns the name of the metadata of the to document of the reference identified by areferenceidentifier.

        """
        return _CDM.CDM_Document_Name(self, *args)

    def Open(self, *args):
        r"""

        Parameters
        ----------
        anApplication: CDM_Application

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_Open(self, *args)

    def PrintToString(self):
        r"""PrintToString(CDM_Document self) -> std::string"""
        return _CDM.CDM_Document_PrintToString(self)

    def Reference(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        opencascade::handle<CDM_Reference>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_Reference(self, *args)

    def ReferenceCounter(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_ReferenceCounter(self, *args)

    def RemoveAllReferences(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Removes all references having this document for from document.

        """
        return _CDM.CDM_Document_RemoveAllReferences(self, *args)

    def RemoveReference(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        None

        Description
        -----------
        Removes the reference between the from document and the to document identified by a reference identifier.

        """
        return _CDM.CDM_Document_RemoveReference(self, *args)

    def RequestedComment(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_RequestedComment(self, *args)

    def RequestedFolder(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_RequestedFolder(self, *args)

    def RequestedName(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Determines under which the document is going to be store. by default the name of the document will be used. if the document has no name its presentation will be used.

        """
        return _CDM.CDM_Document_RequestedName(self, *args)

    def RequestedPreviousVersion(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_RequestedPreviousVersion(self, *args)

    def SetComment(self, *args):
        r"""

        Parameters
        ----------
        aComment: str

        Return
        -------
        None

        Description
        -----------
        Associates a comment with this document.

        """
        return _CDM.CDM_Document_SetComment(self, *args)

    def SetComments(self, *args):
        r"""

        Parameters
        ----------
        aComments: TColStd_SequenceOfExtendedString

        Return
        -------
        None

        Description
        -----------
        Associates a comments with this document.

        """
        return _CDM.CDM_Document_SetComments(self, *args)

    def SetIsReadOnly(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_SetIsReadOnly(self, *args)

    def SetIsUpToDate(self, *args):
        r"""

        Parameters
        ----------
        aReferenceIdentifier: int

        Return
        -------
        None

        Description
        -----------
        Resets the modification counter in the given reference to the actual modification counter of its to document. this method should be called after the application has updated this document.

        """
        return _CDM.CDM_Document_SetIsUpToDate(self, *args)

    def SetMetaData(self, *args):
        r"""

        Parameters
        ----------
        aMetaData: CDM_MetaData

        Return
        -------
        None

        Description
        -----------
        Associates database information to a document which has been stored. the name of the document is now the name which has beenused to store the data.

        """
        return _CDM.CDM_Document_SetMetaData(self, *args)

    def SetModifications(self, *args):
        r"""

        Parameters
        ----------
        Modifications: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_SetModifications(self, *args)

    def SetReferenceCounter(self, *args):
        r"""

        Parameters
        ----------
        aReferenceCounter: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_SetReferenceCounter(self, *args)

    def SetRequestedComment(self, *args):
        r"""

        Parameters
        ----------
        aComment: str

        Return
        -------
        None

        Description
        -----------
        Defines the comment with which the object should be stored.

        """
        return _CDM.CDM_Document_SetRequestedComment(self, *args)

    def SetRequestedFolder(self, *args):
        r"""

        Parameters
        ----------
        aFolder: str

        Return
        -------
        None

        Description
        -----------
        Defines the folder in which the object should be stored.

        """
        return _CDM.CDM_Document_SetRequestedFolder(self, *args)

    def SetRequestedName(self, *args):
        r"""

        Parameters
        ----------
        aName: str

        Return
        -------
        None

        Description
        -----------
        Defines the name under which the object should be stored.

        """
        return _CDM.CDM_Document_SetRequestedName(self, *args)

    def SetRequestedPreviousVersion(self, *args):
        r"""

        Parameters
        ----------
        aPreviousVersion: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_SetRequestedPreviousVersion(self, *args)

    def ShallowReferences(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document

        Return
        -------
        bool

        Description
        -----------
        Returns true is this document references adocument;.

        """
        return _CDM.CDM_Document_ShallowReferences(self, *args)

    def StorageFormat(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        The storage format is the key which is used to determine in the application resources the storage driver plugin, the file extension and other data used to store the document.

        """
        return _CDM.CDM_Document_StorageFormat(self, *args)

    def StorageVersion(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the value of the modification counter at the time of storage. by default returns 0.

        """
        return _CDM.CDM_Document_StorageVersion(self, *args)

    def ToReferencesNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of references having this document as from document.

        """
        return _CDM.CDM_Document_ToReferencesNumber(self, *args)

    def UnModify(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_UnModify(self, *args)

    def UnsetIsReadOnly(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_UnsetIsReadOnly(self, *args)

    def UnsetIsStored(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_UnsetIsStored(self, *args)

    def UnsetRequestedPreviousVersion(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Document_UnsetRequestedPreviousVersion(self, *args)

    def Update(self, *args):
        r"""

        Parameters
        ----------
        aToDocument: CDM_Document
        aReferenceIdentifier: int
        aModifContext: Standard_Address

        Return
        -------
        None

        Description
        -----------
        The update method will be called once for each reference, but it should not perform any computation, to avoid multiple computation of a same document.

        Parameters
        ----------
        ErrorString: str

        Return
        -------
        bool

        Description
        -----------
        This method update will be called to signal the end of the modified references list. the document should be recomputed and updatefromdocuments should be called. update should returns true in case of success, false otherwise. in case of failure, additional information can be given in errorstring.
        Return
        -------
        None

        Description
        -----------
        The following method should be used instead: //! update(me:mutable; errorstring: out extendedstring from tcollection) returns boolean from standard.

        """
        return _CDM.CDM_Document_Update(self, *args)

    def UpdateFromDocuments(self, *args):
        r"""

        Parameters
        ----------
        aModifContext: Standard_Address

        Return
        -------
        None

        Description
        -----------
        Call virtual method update on all referencing documents. this method keeps the list of the -- documents to process.it may be the starting of an update -- cycle. if not, the reentrant calls made by update method (without argument) will append the referencing documents to the list and call the update method (with arguments). only the first call to updatefromdocuments generate call to update().

        """
        return _CDM.CDM_Document_UpdateFromDocuments(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Document_DownCast(t)


    __repr__ = _dumps_object


# Register CDM_Document in _CDM:
_CDM.CDM_Document_swigregister(CDM_Document)
class CDM_MetaData(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Document(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_Document>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_Document(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _CDM.CDM_MetaData_DumpJsonToString(self, depth)

    def FileName(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_FileName(self, *args)

    def Folder(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Returns the folder in which the meta-data has to be created or has to be found.

        """
        return _CDM.CDM_MetaData_Folder(self, *args)

    def HasVersion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Indicates that the version has to be taken into account when searching the corresponding meta-data.

        """
        return _CDM.CDM_MetaData_HasVersion(self, *args)

    def IsReadOnly(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_IsReadOnly(self, *args)

    def IsRetrieved(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_IsRetrieved(self, *args)

    @staticmethod
    def LookUp(*args):
        r"""

        Parameters
        ----------
        theLookUpTable: CDM_MetaDataLookUpTable
        aFolder: str
        aName: str
        aPath: str
        aFileName: str
        ReadOnly: bool

        Return
        -------
        opencascade::handle<CDM_MetaData>

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theLookUpTable: CDM_MetaDataLookUpTable
        aFolder: str
        aName: str
        aPath: str
        aVersion: str
        aFileName: str
        ReadOnly: bool

        Return
        -------
        opencascade::handle<CDM_MetaData>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_LookUp(*args)

    def Name(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Returns the name under which the meta-data has to be created or has to be found.

        """
        return _CDM.CDM_MetaData_Name(self, *args)

    def Path(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_Path(self, *args)

    def PrintToString(self):
        r"""PrintToString(CDM_MetaData self) -> std::string"""
        return _CDM.CDM_MetaData_PrintToString(self)

    def SetIsReadOnly(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_SetIsReadOnly(self, *args)

    def UnsetDocument(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_UnsetDocument(self, *args)

    def UnsetIsReadOnly(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_MetaData_UnsetIsReadOnly(self, *args)

    def Version(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Returns the version under which the meta-data has to be found. warning: raises nosuchobject from standard if no version has been defined.

        """
        return _CDM.CDM_MetaData_Version(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_MetaData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_MetaData

# Register CDM_MetaData in _CDM:
_CDM.CDM_MetaData_swigregister(CDM_MetaData)
class CDM_Reference(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DocumentVersion(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Reference_DocumentVersion(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _CDM.CDM_Reference_DumpJsonToString(self, depth)

    def FromDocument(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_Document>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Reference_FromDocument(self, *args)

    def IsReadOnly(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Reference_IsReadOnly(self, *args)

    def ReferenceIdentifier(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Reference_ReferenceIdentifier(self, *args)

    def ToDocument(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_Document>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_Reference_ToDocument(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Reference_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_Reference

# Register CDM_Reference in _CDM:
_CDM.CDM_Reference_swigregister(CDM_Reference)
class CDM_ReferenceIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _CDM.CDM_ReferenceIterator_swiginit(self, _CDM.new_CDM_ReferenceIterator(*args))

    def Document(self, *args):
        r"""
        Return
        -------
        opencascade::handle<CDM_Document>

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_ReferenceIterator_Document(self, *args)

    def DocumentVersion(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the document version in the reference.

        """
        return _CDM.CDM_ReferenceIterator_DocumentVersion(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_ReferenceIterator_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_ReferenceIterator_Next(self, *args)

    def ReferenceIdentifier(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _CDM.CDM_ReferenceIterator_ReferenceIdentifier(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_ReferenceIterator

# Register CDM_ReferenceIterator in _CDM:
_CDM.CDM_ReferenceIterator_swigregister(CDM_ReferenceIterator)

CDM_NamesDirectory=OCC.Core.TColStd.TColStd_DataMapOfStringInteger


@deprecated
def CDM_MetaData_LookUp(*args):
	return CDM_MetaData.LookUp(*args)

@deprecated
def CDM_MetaData_LookUp(*args):
	return CDM_MetaData.LookUp(*args)



