# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
SelectBasics module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_selectbasics.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _SelectBasics
else:
    import _SelectBasics

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _SelectBasics.delete_SwigPyIterator

    def value(self):
        return _SelectBasics.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _SelectBasics.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _SelectBasics.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _SelectBasics.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _SelectBasics.SwigPyIterator_equal(self, x)

    def copy(self):
        return _SelectBasics.SwigPyIterator_copy(self)

    def next(self):
        return _SelectBasics.SwigPyIterator_next(self)

    def __next__(self):
        return _SelectBasics.SwigPyIterator___next__(self)

    def previous(self):
        return _SelectBasics.SwigPyIterator_previous(self)

    def advance(self, n):
        return _SelectBasics.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _SelectBasics.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _SelectBasics.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _SelectBasics.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _SelectBasics.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _SelectBasics.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _SelectBasics.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _SelectBasics:
_SelectBasics.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _SelectBasics.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TColgp

from enum import IntEnum
from OCC.Core.Exception import *



class selectbasics(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def MaxOwnerPriority(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Structure to provide all-in-one result of selection of sensitive for 'matches' method of select3d_sensitiveentity.

        """
        return _SelectBasics.selectbasics_MaxOwnerPriority(*args)

    @staticmethod
    def MinOwnerPriority(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _SelectBasics.selectbasics_MinOwnerPriority(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _SelectBasics.selectbasics_swiginit(self, _SelectBasics.new_selectbasics())
    __swig_destroy__ = _SelectBasics.delete_selectbasics

# Register selectbasics in _SelectBasics:
_SelectBasics.selectbasics_swigregister(selectbasics)
class SelectBasics_PickResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor defining an invalid result.

        Parameters
        ----------
        theDepth: float
        theDistToCenter: float
        theObjPickedPnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization.

        """
        _SelectBasics.SelectBasics_PickResult_swiginit(self, _SelectBasics.new_SelectBasics_PickResult(*args))

    def Depth(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return depth along picking ray.

        """
        return _SelectBasics.SelectBasics_PickResult_Depth(self, *args)

    def DistToGeomCenter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return distance to geometry center (auxiliary value for comparing results).

        """
        return _SelectBasics.SelectBasics_PickResult_DistToGeomCenter(self, *args)

    def HasPickedPoint(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if picked point lying on detected entity was set.

        """
        return _SelectBasics.SelectBasics_PickResult_HasPickedPoint(self, *args)

    def Invalidate(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset depth value.

        """
        return _SelectBasics.SelectBasics_PickResult_Invalidate(self, *args)

    def IsValid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if result was been defined.

        """
        return _SelectBasics.SelectBasics_PickResult_IsValid(self, *args)

    @staticmethod
    def Min(*args):
        r"""

        Parameters
        ----------
        thePickResult1: SelectBasics_PickResult
        thePickResult2: SelectBasics_PickResult

        Return
        -------
        SelectBasics_PickResult

        Description
        -----------
        Return closest result between two pick results according to depth value.

        """
        return _SelectBasics.SelectBasics_PickResult_Min(*args)

    def PickedPoint(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Return picked point lying on detected entity. warning! point is defined in local coordinate system and should be translated into world system before usage!.

        """
        return _SelectBasics.SelectBasics_PickResult_PickedPoint(self, *args)

    def SetDepth(self, *args):
        r"""

        Parameters
        ----------
        theDepth: float

        Return
        -------
        None

        Description
        -----------
        Set depth along picking ray.

        """
        return _SelectBasics.SelectBasics_PickResult_SetDepth(self, *args)

    def SetDistToGeomCenter(self, *args):
        r"""

        Parameters
        ----------
        theDistToCenter: float

        Return
        -------
        None

        Description
        -----------
        Set distance to geometry center.

        """
        return _SelectBasics.SelectBasics_PickResult_SetDistToGeomCenter(self, *args)

    def SetPickedPoint(self, *args):
        r"""

        Parameters
        ----------
        theObjPickedPnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Set picked point.

        """
        return _SelectBasics.SelectBasics_PickResult_SetPickedPoint(self, *args)

    def SetSurfaceNormal(self, *args):
        r"""

        Parameters
        ----------
        theNormal: NCollection_Vec3<float>

        Return
        -------
        None

        Description
        -----------
        Set surface normal at picked point.

        Parameters
        ----------
        theNormal: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Set surface normal at picked point.

        """
        return _SelectBasics.SelectBasics_PickResult_SetSurfaceNormal(self, *args)

    def SurfaceNormal(self, *args):
        r"""
        Return
        -------
        NCollection_Vec3<float>

        Description
        -----------
        Return (unnormalized) surface normal at picked point or zero vector if undefined. warning! normal is defined in local coordinate system and should be translated into world system before usage!.

        """
        return _SelectBasics.SelectBasics_PickResult_SurfaceNormal(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _SelectBasics.delete_SelectBasics_PickResult

# Register SelectBasics_PickResult in _SelectBasics:
_SelectBasics.SelectBasics_PickResult_swigregister(SelectBasics_PickResult)
class SelectBasics_SelectingVolumeManager(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DetectedPoint(self, *args):
        r"""

        Parameters
        ----------
        theDepth: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        Return 3d point corresponding to specified depth within picking ray.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_DetectedPoint(self, *args)

    def DistToGeometryCenter(self, *args):
        r"""

        Parameters
        ----------
        theCOG: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Calculates distance from 3d projection of user-defined selection point to the given point thecog.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_DistToGeometryCenter(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _SelectBasics.SelectBasics_SelectingVolumeManager_DumpJsonToString(self, depth)

    def GetActiveSelectionType(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return selection type.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetActiveSelectionType(self, *args)

    def GetFarPickedPnt(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Valid only for point and rectangular selection. returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto far view frustum plane.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetFarPickedPnt(self, *args)

    def GetMousePosition(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns mouse coordinates for point selection mode. return infinite point in case of unsupport of mouse position for this active selection volume.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetMousePosition(self, *args)

    def GetNearPickedPnt(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Valid only for point and rectangular selection. returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto near view frustum plane.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetNearPickedPnt(self, *args)

    def GetPlanes(self, *args):
        r"""

        Parameters
        ----------
        thePlaneEquations: NCollection_Vector<NCollection_Vec4<float> >

        Return
        -------
        None

        Description
        -----------
        Stores plane equation coefficients (in the following form: ax + by + cz + d = 0) to the given vector.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetPlanes(self, *args)

    def GetViewRayDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Valid only for point and rectangular selection. returns view ray direction.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_GetViewRayDirection(self, *args)

    def IsOverlapAllowed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns flag indicating if partial overlapping of entities is allowed or should be rejected.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_IsOverlapAllowed(self, *args)

    def IsScalableActiveVolume(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks if it is possible to scale current active selecting volume.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_IsScalableActiveVolume(self, *args)

    def Overlaps(self, *args):
        r"""

        Parameters
        ----------
        theBoxMin: NCollection_Vec3<float>
        theBoxMax: NCollection_Vec3<float>
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theBoxMin: NCollection_Vec3<float>
        theBoxMax: NCollection_Vec3<float>
        theInside: bool * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePnt: gp_Pnt
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePnt: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theArrayOfPts: TColgp_HArray1OfPnt
        theSensType: int
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theArrayOfPts: TColgp_Array1OfPnt
        theSensType: int
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePnt1: gp_Pnt
        thePnt2: gp_Pnt
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePnt1: gp_Pnt
        thePnt2: gp_Pnt
        thePnt3: gp_Pnt
        theSensType: int
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_Overlaps(self, *args)

    def OverlapsBox(self, *args):
        r"""

        Parameters
        ----------
        theBoxMin: NCollection_Vec3<float>
        theBoxMax: NCollection_Vec3<float>
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by box thebox.

        Parameters
        ----------
        theBoxMin: NCollection_Vec3<float>
        theBoxMax: NCollection_Vec3<float>
        theInside: bool * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theminpt and maximum at point themaxpt.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsBox(self, *args)

    def OverlapsCircle(self, *args):
        r"""

        Parameters
        ----------
        theRadius: float
        theTrsf: gp_Trsf
        theIsFilled: bool
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by circle with radius theradius, the boolean theisfilled, and transformation to apply thetrsf. the position and orientation of the circle are specified via thetrsf transformation for gp::xoy() with center in gp::origin().

        Parameters
        ----------
        theRadius: float
        theTrsf: gp_Trsf
        theIsFilled: bool
        theInside: bool * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by circle with radius theradius, the boolean theisfilled, and transformation to apply thetrsf. the position and orientation of the circle are specified via thetrsf transformation for gp::xoy() with center in gp::origin().

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsCircle(self, *args)

    def OverlapsCylinder(self, *args):
        r"""

        Parameters
        ----------
        theBottomRad: float
        theTopRad: float
        theHeight: float
        theTrsf: gp_Trsf
        theIsHollow: bool
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses thebottomrad and thetoprad, height theheight, the boolean theishollow and transformation to apply thetrsf.

        Parameters
        ----------
        theBottomRad: float
        theTopRad: float
        theHeight: float
        theTrsf: gp_Trsf
        theIsHollow: bool
        theInside: bool * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses thebottomrad and thetoprad, height theheight, the boolean theishollow and transformation to apply thetrsf.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsCylinder(self, *args)

    def OverlapsPoint(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_Pnt
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by point thepnt.

        Parameters
        ----------
        thePnt: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by point thepnt. does not perform depth calculation, so this method is defined as helper function for inclusion test.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsPoint(self, *args)

    def OverlapsPolygon(self, *args):
        r"""

        Parameters
        ----------
        theArrayOfPts: TColgp_Array1OfPnt
        theSensType: int
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by planar convex polygon, which points are stored in thearrayofpts, taking into account sensitivity type thesenstype.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsPolygon(self, *args)

    def OverlapsSegment(self, *args):
        r"""

        Parameters
        ----------
        thePt1: gp_Pnt
        thePt2: gp_Pnt
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by line segment with start point at thept1 and end point at thept2.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsSegment(self, *args)

    def OverlapsSphere(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_Pnt
        theRadius: float
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by sphere with center thecenter and radius theradius.

        Parameters
        ----------
        theCenter: gp_Pnt
        theRadius: float
        theInside: bool * (optional, default to NULL)

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by sphere with center thecenter and radius theradius.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsSphere(self, *args)

    def OverlapsTriangle(self, *args):
        r"""

        Parameters
        ----------
        thePt1: gp_Pnt
        thePt2: gp_Pnt
        thePt3: gp_Pnt
        theSensType: int
        thePickResult: SelectBasics_PickResult

        Return
        -------
        bool

        Description
        -----------
        Returns true if selecting volume is overlapped by triangle with vertices thept1, thept2 and thept3, taking into account sensitivity type thesenstype.

        """
        return _SelectBasics.SelectBasics_SelectingVolumeManager_OverlapsTriangle(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _SelectBasics.delete_SelectBasics_SelectingVolumeManager

# Register SelectBasics_SelectingVolumeManager in _SelectBasics:
_SelectBasics.SelectBasics_SelectingVolumeManager_swigregister(SelectBasics_SelectingVolumeManager)



@deprecated
def selectbasics_MaxOwnerPriority(*args):
	return selectbasics.MaxOwnerPriority(*args)

@deprecated
def selectbasics_MinOwnerPriority(*args):
	return selectbasics.MinOwnerPriority(*args)

@deprecated
def SelectBasics_PickResult_Min(*args):
	return SelectBasics_PickResult.Min(*args)



