/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ChainResolver
extends AbstractResolver {
    private boolean returnFirst = false;
    private List chain = new ArrayList();
    private boolean dual;

    public void add(DependencyResolver dependencyResolver) {
        this.chain.add(dependencyResolver);
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        ResolvedModuleRevision resolvedModuleRevision;
        resolveData = new ResolveData(resolveData, this.doValidate(resolveData));
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision = resolveData.getCurrentResolvedModuleRevision();
        if (resolvedModuleRevision == null) {
            Message.verbose(this.getName() + ": Checking cache for: " + dependencyDescriptor);
            resolvedModuleRevision2 = this.findModuleInCache(dependencyDescriptor, resolveData, true);
            if (resolvedModuleRevision2 != null) {
                Message.verbose(this.getName() + ": module revision found in cache: " + resolvedModuleRevision2.getId());
                resolvedModuleRevision2 = this.forcedRevision(resolvedModuleRevision2);
            }
        }
        for (Object object : this.chain) {
            LatestStrategy object2 = this.setLatestIfRequired((DependencyResolver)object, this.getLatestStrategy());
            try {
                ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision2;
                resolveData.setCurrentResolvedModuleRevision(resolvedModuleRevision3);
                resolvedModuleRevision2 = object.getDependency(dependencyDescriptor, resolveData);
                if (resolvedModuleRevision2 != resolvedModuleRevision3 && this.isReturnFirst()) {
                    resolvedModuleRevision2 = this.forcedRevision(resolvedModuleRevision2);
                }
            }
            catch (Exception exception) {
                Message.verbose("problem occurred while resolving " + dependencyDescriptor + " with " + object + ": " + StringUtils.getStackTrace(exception));
                arrayList.add(exception);
            }
            finally {
                if (object2 != null) {
                    ChainResolver.setLatest((DependencyResolver)object, object2);
                }
            }
            this.checkInterrupted();
        }
        if (resolvedModuleRevision2 == null && !arrayList.isEmpty()) {
            Object object;
            if (arrayList.size() == 1) {
                object = (Exception)arrayList.get(0);
                if (object instanceof RuntimeException) {
                    throw (RuntimeException)object;
                }
                if (object instanceof ParseException) {
                    throw (ParseException)object;
                }
                throw new RuntimeException(((Throwable)object).toString(), (Throwable)object);
            }
            object = new StringBuffer();
            for (Exception exception : arrayList) {
                ((StringBuffer)object).append("\t").append(StringUtils.getErrorMessage(exception)).append("\n");
            }
            Object object2 = object;
            ((StringBuffer)object2).setLength(((StringBuffer)object2).length() - 1);
            throw new RuntimeException("several problems occurred while resolving " + dependencyDescriptor + ":\n" + object);
        }
        if (resolvedModuleRevision == resolvedModuleRevision2) {
            return resolvedModuleRevision;
        }
        return this.resolvedRevision(resolvedModuleRevision2);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (this.isDual() && resolvedModuleRevision != null) {
            return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), this, resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), resolvedModuleRevision.isForce());
        }
        return resolvedModuleRevision;
    }

    private ResolvedModuleRevision forcedRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return null;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), resolvedModuleRevision.getArtifactResolver(), resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), true);
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver dependencyResolver, LatestStrategy latestStrategy) {
        Object object = ChainResolver.getLatestStrategyName(dependencyResolver);
        if (object != null && !"default".equals(object)) {
            object = ChainResolver.getLatest(dependencyResolver);
            ChainResolver.setLatest(dependencyResolver, latestStrategy);
            return object;
        }
        return null;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        for (Object object : this.chain) {
            if ((object = object.findIvyFileRef(dependencyDescriptor, resolveData)) == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public void reportFailure() {
        for (DependencyResolver dependencyResolver : this.chain) {
            dependencyResolver.reportFailure();
        }
    }

    @Override
    public void reportFailure(Artifact artifact) {
        for (DependencyResolver dependencyResolver : this.chain) {
            dependencyResolver.reportFailure(artifact);
        }
    }

    @Override
    public DownloadReport download(Artifact[] object, DownloadOptions downloadOptions) {
        ArtifactDownloadReport[] artifactDownloadReportArray;
        object = new ArrayList<Artifact>(Arrays.asList(object));
        DownloadReport downloadReport = new DownloadReport();
        Iterator iterator = this.chain.iterator();
        while (iterator.hasNext() && !object.isEmpty()) {
            artifactDownloadReportArray = (DependencyResolver)iterator.next();
            Object object2 = object;
            artifactDownloadReportArray = artifactDownloadReportArray.download(object2.toArray(new Artifact[object2.size()]), downloadOptions);
            artifactDownloadReportArray = artifactDownloadReportArray.getArtifactsReports();
            for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
                if (artifactDownloadReportArray[i].getDownloadStatus() == DownloadStatus.FAILED) continue;
                object.remove(artifactDownloadReportArray[i].getArtifact());
                downloadReport.addArtifactReport(artifactDownloadReportArray[i]);
            }
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            artifactDownloadReportArray = (Artifact)iterator.next();
            artifactDownloadReportArray = new ArtifactDownloadReport((Artifact)artifactDownloadReportArray);
            artifactDownloadReportArray.setDownloadStatus(DownloadStatus.FAILED);
            downloadReport.addArtifactReport((ArtifactDownloadReport)artifactDownloadReportArray);
        }
        return downloadReport;
    }

    public List getResolvers() {
        return this.chain;
    }

    public boolean isReturnFirst() {
        return this.returnFirst;
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [chain] " + this.chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        for (DependencyResolver dependencyResolver : this.chain) {
            Message.debug("\t\t-> " + dependencyResolver.getName());
        }
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        for (Object object : this.chain) {
            if (ArtifactOrigin.isUnknown((ArtifactOrigin)(object = object.locate(artifact)))) continue;
            return object;
        }
        return ArtifactOrigin.unkwnown(artifact);
    }

    private static void setLatest(DependencyResolver object, LatestStrategy latestStrategy) {
        if (object instanceof HasLatestStrategy) {
            object = (HasLatestStrategy)object;
            object.setLatestStrategy(latestStrategy);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver object) {
        if (object instanceof HasLatestStrategy) {
            object = (HasLatestStrategy)object;
            return object.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver object) {
        if (object instanceof HasLatestStrategy) {
            object = (HasLatestStrategy)object;
            return object.getLatest();
        }
        return null;
    }

    public boolean isDual() {
        return this.dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision resolvedModuleRevision) {
            this.rmr = resolvedModuleRevision;
        }

        @Override
        public String getRevision() {
            return this.rmr.getId().getRevision();
        }

        @Override
        public long getLastModified() {
            return this.rmr.getPublicationDate().getTime();
        }
    }
}

