/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public abstract class AbstractMessageLogger
implements MessageLogger {
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();
    private boolean showProgress = true;

    @Override
    public void debug(String string) {
        this.log(string, 4);
    }

    @Override
    public void verbose(String string) {
        this.log(string, 3);
    }

    @Override
    public void deprecated(String string) {
        this.log("DEPRECATED: " + string, 1);
    }

    @Override
    public void info(String string) {
        this.log(string, 2);
    }

    @Override
    public void rawinfo(String string) {
        this.rawlog(string, 2);
    }

    @Override
    public void warn(String string) {
        this.log("WARN: " + string, 3);
        this.problems.add("WARN:  " + string);
        this.getWarns().add(string);
    }

    @Override
    public void error(String string) {
        this.log("ERROR: " + string, 3);
        this.problems.add("\tERROR: " + string);
        this.getErrors().add(string);
    }

    @Override
    public List getProblems() {
        return this.problems;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    @Override
    public List getWarns() {
        return this.warns;
    }

    @Override
    public void progress() {
        if (this.showProgress) {
            this.doProgress();
        }
    }

    @Override
    public void endProgress(String string) {
        if (this.showProgress) {
            this.doEndProgress(string);
        }
    }

    protected abstract void doProgress();

    protected abstract void doEndProgress(String var1);
}

