"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeDefinitionProviderImpl = void 0;
const documents_1 = require("../../../lib/documents");
const utils_1 = require("../../../utils");
const utils_2 = require("../utils");
const utils_3 = require("./utils");
class TypeDefinitionProviderImpl {
    constructor(lsAndTsDocResolver) {
        this.lsAndTsDocResolver = lsAndTsDocResolver;
    }
    async getTypeDefinition(document, position) {
        const { tsDoc, lang } = await this.lsAndTsDocResolver.getLSAndTSDoc(document);
        const offset = tsDoc.offsetAt(tsDoc.getGeneratedPosition(position));
        const typeDefs = lang.getTypeDefinitionAtPosition(tsDoc.filePath, offset);
        const snapshots = new utils_3.SnapshotMap(this.lsAndTsDocResolver);
        snapshots.set(tsDoc.filePath, tsDoc);
        if (!typeDefs) {
            return null;
        }
        const result = await Promise.all(typeDefs.map(async (typeDef) => {
            const snapshot = await snapshots.retrieve(typeDef.fileName);
            if ((0, utils_3.isTextSpanInGeneratedCode)(snapshot.getFullText(), typeDef.textSpan)) {
                return;
            }
            const location = (0, documents_1.mapLocationToOriginal)(snapshot, (0, utils_2.convertRange)(snapshot, typeDef.textSpan));
            if (location.range.start.line >= 0 && location.range.end.line >= 0) {
                return location;
            }
        }));
        return result.filter(utils_1.isNotNullOrUndefined);
    }
}
exports.TypeDefinitionProviderImpl = TypeDefinitionProviderImpl;
//# sourceMappingURL=TypeDefinitionProvider.js.map