export interface SvelteNode {
    start: number;
    end: number;
    type: string;
    parent?: SvelteNode;
}
/**
 * Returns true if given node is a component or html element, or if the offset is at the end of the node
 * and its parent is a component or html element.
 */
export declare function isInTag(node: SvelteNode | null | undefined, offset: number): boolean;
/**
 * Returns when given node represents an HTML Attribute.
 * Example: The `class` in `<div class=".."`.
 * Note: This method returns `false` for shorthands like `<div {foo}`.
 */
export declare function isAttributeName(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `{foo}` in `<div {foo}`
 */
export declare function isAttributeShorthand(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `on:click={foo}` in `<div on:click={foo}`
 */
export declare function isEventHandler(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
