/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.ImportedTextureWizardController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceView;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public class TextureChoiceController
implements Controller {
    private static final int MAX_RECENT_TEXTURES = 15;
    private final String title;
    private final boolean rotationSupported;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private TextureChoiceView textureChoiceView;
    private HomeTexture texture;

    public TextureChoiceController(String string, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(string, true, userPreferences, viewFactory, contentManager);
    }

    public TextureChoiceController(String string, boolean bl, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this.title = string;
        this.rotationSupported = bl;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public TextureChoiceView getView() {
        if (this.textureChoiceView == null) {
            this.textureChoiceView = this.viewFactory.createTextureChoiceView(this.preferences, this);
        }
        return this.textureChoiceView;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setTexture(HomeTexture homeTexture) {
        if (!(this.texture == homeTexture || homeTexture != null && homeTexture.equals(this.texture))) {
            HomeTexture homeTexture2 = this.texture;
            this.texture = homeTexture;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public HomeTexture getTexture() {
        return this.texture;
    }

    public String getDialogTitle() {
        return this.title;
    }

    public boolean isRotationSupported() {
        return this.rotationSupported;
    }

    public void importTexture() {
        new ImportedTextureWizardController(this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
    }

    public void importTexture(String string) {
        new ImportedTextureWizardController(string, this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
    }

    public void modifyTexture(CatalogTexture catalogTexture) {
        new ImportedTextureWizardController(catalogTexture, this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
    }

    public void deleteTexture(CatalogTexture catalogTexture) {
        if (this.getView().confirmDeleteSelectedCatalogTexture()) {
            this.preferences.getTexturesCatalog().delete(catalogTexture);
        }
    }

    public void addRecentTexture(TextureImage textureImage) {
        ArrayList<TextureImage> arrayList = new ArrayList<TextureImage>(this.preferences.getRecentTextures());
        for (int i = 0; i < arrayList.size(); ++i) {
            TextureImage textureImage2 = (TextureImage)arrayList.get(i);
            if (!textureImage2.getImage().equals(textureImage.getImage())) continue;
            if (i == 0) {
                return;
            }
            arrayList.remove(i);
            break;
        }
        arrayList.add(0, textureImage);
        while (arrayList.size() > 15) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.preferences.setRecentTextures(arrayList);
    }

    public static enum Property {
        TEXTURE;

    }
}

