/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;

@Deprecated
public class HistoryReferenceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(HistoryReferenceTableModel.class);
    public static final int COLUMN_ = 0;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("view.href.table.header.hrefid"), Constant.messages.getString("view.href.table.header.hreftype"), Constant.messages.getString("view.href.table.header.method"), Constant.messages.getString("view.href.table.header.url"), Constant.messages.getString("view.href.table.header.code"), Constant.messages.getString("view.href.table.header.reason"), Constant.messages.getString("view.href.table.header.rtt"), Constant.messages.getString("view.href.table.header.size.message"), Constant.messages.getString("view.href.table.header.sessionid"), Constant.messages.getString("view.href.table.header.highestalert"), Constant.messages.getString("view.href.table.header.tags", "", "", "")};
    private List<HistoryReference> hrefList;
    private COLUMN[] columns = null;

    public HistoryReferenceTableModel(COLUMN[] columns) {
        this.columns = columns;
        this.hrefList = new ArrayList<HistoryReference>();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[this.columns[column].ordinal()];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public COLUMN getColumn(int column) {
        return this.columns[column];
    }

    @Override
    public int getRowCount() {
        return this.hrefList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        HistoryReference href = this.hrefList.get(row);
        try {
            switch (this.columns[col]) {
                case HREF_ID: {
                    return href.getHistoryId();
                }
                case TYPE_FLAG: {
                    return this.getHrefTypeIcon(href);
                }
                case METHOD: {
                    return href.getMethod();
                }
                case URL: {
                    return href.getURI().toString();
                }
                case CODE: {
                    return href.getStatusCode();
                }
                case REASON: {
                    return href.getReason();
                }
                case RTT: {
                    return href.getRtt();
                }
                case SIZE: {
                    return href.getResponseBodyLength();
                }
                case SESSION_ID: {
                    return href.getSessionId();
                }
                case ALERT_FLAG: {
                    return this.getHrefAlertIcon(href);
                }
                case TAGS: {
                    return this.listToCsv(href.getTags());
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public HistoryReference getHistoryReference(int row) {
        return this.hrefList.get(row);
    }

    private String listToCsv(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private ImageIcon getHrefAlertIcon(HistoryReference href) {
        switch (href.getHighestAlert()) {
            case 0: {
                return new ImageIcon(Constant.INFO_FLAG_IMAGE_URL);
            }
            case 1: {
                return new ImageIcon(Constant.LOW_FLAG_IMAGE_URL);
            }
            case 2: {
                return new ImageIcon(Constant.MED_FLAG_IMAGE_URL);
            }
            case 3: {
                return new ImageIcon(Constant.HIGH_FLAG_IMAGE_URL);
            }
        }
        return null;
    }

    private ImageIcon getHrefTypeIcon(HistoryReference href) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            this.hrefList.clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HistoryReference href) {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            this.hrefList.add(href);
            this.fireTableRowsInserted(this.hrefList.size() - 1, this.hrefList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HistoryReference href) {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            int index = this.hrefList.indexOf(href);
            if (index >= 0) {
                this.hrefList.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (this.columns[columnIndex]) {
            case HREF_ID: {
                return Integer.class;
            }
            case TYPE_FLAG: {
                return ImageIcon.class;
            }
            case METHOD: {
                return String.class;
            }
            case URL: {
                return String.class;
            }
            case CODE: {
                return Integer.class;
            }
            case REASON: {
                return String.class;
            }
            case RTT: {
                return Integer.class;
            }
            case SIZE: {
                return Integer.class;
            }
            case SESSION_ID: {
                return Long.class;
            }
            case ALERT_FLAG: {
                return ImageIcon.class;
            }
            case TAGS: {
                return String.class;
            }
        }
        return null;
    }

    public static enum COLUMN {
        HREF_ID,
        TYPE_FLAG,
        METHOD,
        URL,
        CODE,
        REASON,
        RTT,
        SIZE,
        SESSION_ID,
        ALERT_FLAG,
        TAGS,
        CUSTOM_1,
        CUSTOM_2,
        CUSTOM_3;

    }
}

