/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener;
import com.jidesoft.plaf.basic.BasicJideComboBoxUI;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;

public class BasicJideComboBoxButton
extends JButton {
    protected JComboBox _comboBox;
    protected JList _listBox;
    protected CellRendererPane _rendererPane;
    protected Icon _comboIcon;
    protected boolean _iconOnly = false;

    public final JComboBox getComboBox() {
        return this._comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this._comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this._comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this._comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this._iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this._iconOnly = isIconOnly;
    }

    public BasicJideComboBoxButton() {
        super("");
        this.addMouseListener(new BasicJideButtonListener(this));
        DefaultButtonModel model = new DefaultButtonModel(){
            private static final long serialVersionUID = -5866286842846125926L;

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        };
        this.setModel(model);
        this.customizeButton();
    }

    public BasicJideComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list) {
        this();
        this._comboBox = cb;
        this._comboIcon = i;
        this._rendererPane = pane;
        this._listBox = list;
        this.setEnabled(this._comboBox.isEnabled());
    }

    protected void customizeButton() {
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setRequestFocusEnabled(false);
    }

    public BasicJideComboBoxButton(JComboBox comboBox, Icon icon, boolean editable, CellRendererPane currentValuePane, JList listBox) {
        this(comboBox, icon, currentValuePane, listBox);
        this._iconOnly = editable;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Color old = g2.getColor();
        Object painterObject = UIDefaultsLookup.get("Theme.painter");
        if (!(painterObject instanceof ThemePainter)) {
            return;
        }
        ThemePainter painter = (ThemePainter)painterObject;
        if (this.getModel().isSelected() || this.getModel().isPressed() || this._comboBox.isPopupVisible()) {
            painter.paintButtonBackground(this, g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 1, false);
        } else if (this.getModel().isRollover() || ((BasicJideComboBoxUI)this._comboBox.getUI()).isRollOver()) {
            painter.paintButtonBackground(this, g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 2, false);
        } else {
            painter.paintButtonBackground(this, g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0, false);
        }
        if (((BasicJideComboBoxUI)this._comboBox.getUI()).isRollOver() || this._comboBox.isPopupVisible()) {
            g2.setColor(painter.getMenuItemBorderColor());
            g2.drawLine(0, 0, 0, this.getHeight());
        }
        this.paintIcon(g2);
        g2.setColor(old);
    }

    protected void paintIcon(Graphics g2) {
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int bottom = top + (height - 1);
        if (this._comboIcon != null) {
            int iconTop;
            int iconLeft;
            int iconWidth = this._comboIcon.getIconWidth();
            int iconHeight = this._comboIcon.getIconHeight();
            if (this._iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2 - 1;
            } else {
                iconLeft = left;
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
            }
            this._comboIcon.paintIcon(this, g2, iconLeft, iconTop);
        }
    }
}

