/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.resthandler;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.reportsscheduler.action.GetAllReportInstancesAction;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.GetAllReportInstancesRequest;
import org.opensearch.reportsscheduler.model.GetAllReportInstancesResponse;
import org.opensearch.reportsscheduler.resthandler.PluginBaseHandler;
import org.opensearch.reportsscheduler.resthandler.RestResponseToXContentListener;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/reportsscheduler/resthandler/ReportInstanceListRestHandler;", "Lorg/opensearch/reportsscheduler/resthandler/PluginBaseHandler;", "()V", "executeRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "getName", "", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "responseParams", "", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-reports-scheduler"})
public final class ReportInstanceListRestHandler
extends PluginBaseHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String REPORT_INSTANCE_LIST_ACTION = "report_instance_list_actions";
    @NotNull
    private static final String LIST_REPORT_INSTANCES_URL = "/_plugins/_reports/instances";
    @NotNull
    private static final String LEGACY_LIST_REPORT_INSTANCES_URL = "/_opendistro/_reports/instances";

    @NotNull
    public String getName() {
        return REPORT_INSTANCE_LIST_ACTION;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return CollectionsKt.listOf((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, LIST_REPORT_INSTANCES_URL, RestRequest.Method.GET, LEGACY_LIST_REPORT_INSTANCES_URL));
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"fromIndex", "maxItems"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected BaseRestHandler.RestChannelConsumer executeRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = request.param("fromIndex");
        int from = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object2 = request.param("maxItems");
        int maxItems = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? ((Integer)object2).intValue() : PluginSettings.INSTANCE.getDefaultItemsQueryCount();
        RestRequest.Method method = request.method();
        return (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) == 1 ? arg_0 -> ReportInstanceListRestHandler.executeRequest$lambda$0(client, from, maxItems, arg_0) : arg_0 -> ReportInstanceListRestHandler.executeRequest$lambda$1(request, arg_0);
    }

    private static final void executeRequest$lambda$0(NodeClient $client, int $from, int $maxItems, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Metrics.REPORT_INSTANCE_LIST_TOTAL.getCounter().increment();
        Metrics.REPORT_INSTANCE_LIST_INTERVAL_COUNT.getCounter().increment();
        ActionType<GetAllReportInstancesResponse> actionType = GetAllReportInstancesAction.Companion.getACTION_TYPE$opensearch_reports_scheduler();
        ActionRequest actionRequest = new GetAllReportInstancesRequest($from, $maxItems);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executeRequest$lambda$1(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/reportsscheduler/resthandler/ReportInstanceListRestHandler$Companion;", "", "()V", "LEGACY_LIST_REPORT_INSTANCES_URL", "", "LIST_REPORT_INSTANCES_URL", "REPORT_INSTANCE_LIST_ACTION", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            try {
                nArray[RestRequest.Method.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

