# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
IGESData module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_igesdata.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _IGESData
else:
    import _IGESData

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IGESData.delete_SwigPyIterator

    def value(self):
        return _IGESData.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _IGESData.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _IGESData.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _IGESData.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _IGESData.SwigPyIterator_equal(self, x)

    def copy(self):
        return _IGESData.SwigPyIterator_copy(self)

    def next(self):
        return _IGESData.SwigPyIterator_next(self)

    def __next__(self):
        return _IGESData.SwigPyIterator___next__(self)

    def previous(self):
        return _IGESData.SwigPyIterator_previous(self)

    def advance(self, n):
        return _IGESData.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _IGESData.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _IGESData.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _IGESData.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _IGESData.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _IGESData.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _IGESData.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _IGESData:
_IGESData.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _IGESData.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Interface
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.MoniTool
import OCC.Core.TopoDS
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.ShapeBuild
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Geom2d
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.TopTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.ShapeExtend
import OCC.Core.TColGeom

from enum import IntEnum
from OCC.Core.Exception import *

IGESData_DefNone = _IGESData.IGESData_DefNone
IGESData_DefOne = _IGESData.IGESData_DefOne
IGESData_DefSeveral = _IGESData.IGESData_DefSeveral
IGESData_ErrorOne = _IGESData.IGESData_ErrorOne
IGESData_ErrorSeveral = _IGESData.IGESData_ErrorSeveral
IGESData_DefVoid = _IGESData.IGESData_DefVoid
IGESData_DefValue = _IGESData.IGESData_DefValue
IGESData_DefReference = _IGESData.IGESData_DefReference
IGESData_DefAny = _IGESData.IGESData_DefAny
IGESData_ErrorVal = _IGESData.IGESData_ErrorVal
IGESData_ErrorRef = _IGESData.IGESData_ErrorRef
IGESData_ReadDir = _IGESData.IGESData_ReadDir
IGESData_ReadOwn = _IGESData.IGESData_ReadOwn
IGESData_ReadAssocs = _IGESData.IGESData_ReadAssocs
IGESData_ReadProps = _IGESData.IGESData_ReadProps
IGESData_ReadEnd = _IGESData.IGESData_ReadEnd
IGESData_EntityOK = _IGESData.IGESData_EntityOK
IGESData_EntityError = _IGESData.IGESData_EntityError
IGESData_ReferenceError = _IGESData.IGESData_ReferenceError
IGESData_TypeError = _IGESData.IGESData_TypeError


class IGESData_DefList(IntEnum):
	IGESData_DefNone = 0
	IGESData_DefOne = 1
	IGESData_DefSeveral = 2
	IGESData_ErrorOne = 3
	IGESData_ErrorSeveral = 4
IGESData_DefNone = IGESData_DefList.IGESData_DefNone
IGESData_DefOne = IGESData_DefList.IGESData_DefOne
IGESData_DefSeveral = IGESData_DefList.IGESData_DefSeveral
IGESData_ErrorOne = IGESData_DefList.IGESData_ErrorOne
IGESData_ErrorSeveral = IGESData_DefList.IGESData_ErrorSeveral

class IGESData_DefType(IntEnum):
	IGESData_DefVoid = 0
	IGESData_DefValue = 1
	IGESData_DefReference = 2
	IGESData_DefAny = 3
	IGESData_ErrorVal = 4
	IGESData_ErrorRef = 5
IGESData_DefVoid = IGESData_DefType.IGESData_DefVoid
IGESData_DefValue = IGESData_DefType.IGESData_DefValue
IGESData_DefReference = IGESData_DefType.IGESData_DefReference
IGESData_DefAny = IGESData_DefType.IGESData_DefAny
IGESData_ErrorVal = IGESData_DefType.IGESData_ErrorVal
IGESData_ErrorRef = IGESData_DefType.IGESData_ErrorRef

class IGESData_ReadStage(IntEnum):
	IGESData_ReadDir = 0
	IGESData_ReadOwn = 1
	IGESData_ReadAssocs = 2
	IGESData_ReadProps = 3
	IGESData_ReadEnd = 4
IGESData_ReadDir = IGESData_ReadStage.IGESData_ReadDir
IGESData_ReadOwn = IGESData_ReadStage.IGESData_ReadOwn
IGESData_ReadAssocs = IGESData_ReadStage.IGESData_ReadAssocs
IGESData_ReadProps = IGESData_ReadStage.IGESData_ReadProps
IGESData_ReadEnd = IGESData_ReadStage.IGESData_ReadEnd

class IGESData_Status(IntEnum):
	IGESData_EntityOK = 0
	IGESData_EntityError = 1
	IGESData_ReferenceError = 2
	IGESData_TypeError = 3
IGESData_EntityOK = IGESData_Status.IGESData_EntityOK
IGESData_EntityError = IGESData_Status.IGESData_EntityError
IGESData_ReferenceError = IGESData_Status.IGESData_ReferenceError
IGESData_TypeError = IGESData_Status.IGESData_TypeError


def Handle_IGESData_FileRecognizer_Create():
    return _IGESData.Handle_IGESData_FileRecognizer_Create()

def Handle_IGESData_FileRecognizer_DownCast(t):
    return _IGESData.Handle_IGESData_FileRecognizer_DownCast(t)

def Handle_IGESData_FileRecognizer_IsNull(t):
    return _IGESData.Handle_IGESData_FileRecognizer_IsNull(t)

def Handle_IGESData_GeneralModule_Create():
    return _IGESData.Handle_IGESData_GeneralModule_Create()

def Handle_IGESData_GeneralModule_DownCast(t):
    return _IGESData.Handle_IGESData_GeneralModule_DownCast(t)

def Handle_IGESData_GeneralModule_IsNull(t):
    return _IGESData.Handle_IGESData_GeneralModule_IsNull(t)

def Handle_IGESData_GlobalNodeOfSpecificLib_Create():
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_Create()

def Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t):
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t)

def Handle_IGESData_GlobalNodeOfSpecificLib_IsNull(t):
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_IsNull(t)

def Handle_IGESData_GlobalNodeOfWriterLib_Create():
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_Create()

def Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t):
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t)

def Handle_IGESData_GlobalNodeOfWriterLib_IsNull(t):
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_IsNull(t)

def Handle_IGESData_IGESEntity_Create():
    return _IGESData.Handle_IGESData_IGESEntity_Create()

def Handle_IGESData_IGESEntity_DownCast(t):
    return _IGESData.Handle_IGESData_IGESEntity_DownCast(t)

def Handle_IGESData_IGESEntity_IsNull(t):
    return _IGESData.Handle_IGESData_IGESEntity_IsNull(t)

def Handle_IGESData_IGESModel_Create():
    return _IGESData.Handle_IGESData_IGESModel_Create()

def Handle_IGESData_IGESModel_DownCast(t):
    return _IGESData.Handle_IGESData_IGESModel_DownCast(t)

def Handle_IGESData_IGESModel_IsNull(t):
    return _IGESData.Handle_IGESData_IGESModel_IsNull(t)

def Handle_IGESData_IGESReaderData_Create():
    return _IGESData.Handle_IGESData_IGESReaderData_Create()

def Handle_IGESData_IGESReaderData_DownCast(t):
    return _IGESData.Handle_IGESData_IGESReaderData_DownCast(t)

def Handle_IGESData_IGESReaderData_IsNull(t):
    return _IGESData.Handle_IGESData_IGESReaderData_IsNull(t)

def Handle_IGESData_NodeOfSpecificLib_Create():
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_Create()

def Handle_IGESData_NodeOfSpecificLib_DownCast(t):
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_DownCast(t)

def Handle_IGESData_NodeOfSpecificLib_IsNull(t):
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_IsNull(t)

def Handle_IGESData_NodeOfWriterLib_Create():
    return _IGESData.Handle_IGESData_NodeOfWriterLib_Create()

def Handle_IGESData_NodeOfWriterLib_DownCast(t):
    return _IGESData.Handle_IGESData_NodeOfWriterLib_DownCast(t)

def Handle_IGESData_NodeOfWriterLib_IsNull(t):
    return _IGESData.Handle_IGESData_NodeOfWriterLib_IsNull(t)

def Handle_IGESData_Protocol_Create():
    return _IGESData.Handle_IGESData_Protocol_Create()

def Handle_IGESData_Protocol_DownCast(t):
    return _IGESData.Handle_IGESData_Protocol_DownCast(t)

def Handle_IGESData_Protocol_IsNull(t):
    return _IGESData.Handle_IGESData_Protocol_IsNull(t)

def Handle_IGESData_ReadWriteModule_Create():
    return _IGESData.Handle_IGESData_ReadWriteModule_Create()

def Handle_IGESData_ReadWriteModule_DownCast(t):
    return _IGESData.Handle_IGESData_ReadWriteModule_DownCast(t)

def Handle_IGESData_ReadWriteModule_IsNull(t):
    return _IGESData.Handle_IGESData_ReadWriteModule_IsNull(t)

def Handle_IGESData_SpecificModule_Create():
    return _IGESData.Handle_IGESData_SpecificModule_Create()

def Handle_IGESData_SpecificModule_DownCast(t):
    return _IGESData.Handle_IGESData_SpecificModule_DownCast(t)

def Handle_IGESData_SpecificModule_IsNull(t):
    return _IGESData.Handle_IGESData_SpecificModule_IsNull(t)

def Handle_IGESData_ToolLocation_Create():
    return _IGESData.Handle_IGESData_ToolLocation_Create()

def Handle_IGESData_ToolLocation_DownCast(t):
    return _IGESData.Handle_IGESData_ToolLocation_DownCast(t)

def Handle_IGESData_ToolLocation_IsNull(t):
    return _IGESData.Handle_IGESData_ToolLocation_IsNull(t)

def Handle_IGESData_ColorEntity_Create():
    return _IGESData.Handle_IGESData_ColorEntity_Create()

def Handle_IGESData_ColorEntity_DownCast(t):
    return _IGESData.Handle_IGESData_ColorEntity_DownCast(t)

def Handle_IGESData_ColorEntity_IsNull(t):
    return _IGESData.Handle_IGESData_ColorEntity_IsNull(t)

def Handle_IGESData_DefaultGeneral_Create():
    return _IGESData.Handle_IGESData_DefaultGeneral_Create()

def Handle_IGESData_DefaultGeneral_DownCast(t):
    return _IGESData.Handle_IGESData_DefaultGeneral_DownCast(t)

def Handle_IGESData_DefaultGeneral_IsNull(t):
    return _IGESData.Handle_IGESData_DefaultGeneral_IsNull(t)

def Handle_IGESData_DefaultSpecific_Create():
    return _IGESData.Handle_IGESData_DefaultSpecific_Create()

def Handle_IGESData_DefaultSpecific_DownCast(t):
    return _IGESData.Handle_IGESData_DefaultSpecific_DownCast(t)

def Handle_IGESData_DefaultSpecific_IsNull(t):
    return _IGESData.Handle_IGESData_DefaultSpecific_IsNull(t)

def Handle_IGESData_FileProtocol_Create():
    return _IGESData.Handle_IGESData_FileProtocol_Create()

def Handle_IGESData_FileProtocol_DownCast(t):
    return _IGESData.Handle_IGESData_FileProtocol_DownCast(t)

def Handle_IGESData_FileProtocol_IsNull(t):
    return _IGESData.Handle_IGESData_FileProtocol_IsNull(t)

def Handle_IGESData_LabelDisplayEntity_Create():
    return _IGESData.Handle_IGESData_LabelDisplayEntity_Create()

def Handle_IGESData_LabelDisplayEntity_DownCast(t):
    return _IGESData.Handle_IGESData_LabelDisplayEntity_DownCast(t)

def Handle_IGESData_LabelDisplayEntity_IsNull(t):
    return _IGESData.Handle_IGESData_LabelDisplayEntity_IsNull(t)

def Handle_IGESData_LevelListEntity_Create():
    return _IGESData.Handle_IGESData_LevelListEntity_Create()

def Handle_IGESData_LevelListEntity_DownCast(t):
    return _IGESData.Handle_IGESData_LevelListEntity_DownCast(t)

def Handle_IGESData_LevelListEntity_IsNull(t):
    return _IGESData.Handle_IGESData_LevelListEntity_IsNull(t)

def Handle_IGESData_LineFontEntity_Create():
    return _IGESData.Handle_IGESData_LineFontEntity_Create()

def Handle_IGESData_LineFontEntity_DownCast(t):
    return _IGESData.Handle_IGESData_LineFontEntity_DownCast(t)

def Handle_IGESData_LineFontEntity_IsNull(t):
    return _IGESData.Handle_IGESData_LineFontEntity_IsNull(t)

def Handle_IGESData_NameEntity_Create():
    return _IGESData.Handle_IGESData_NameEntity_Create()

def Handle_IGESData_NameEntity_DownCast(t):
    return _IGESData.Handle_IGESData_NameEntity_DownCast(t)

def Handle_IGESData_NameEntity_IsNull(t):
    return _IGESData.Handle_IGESData_NameEntity_IsNull(t)

def Handle_IGESData_SingleParentEntity_Create():
    return _IGESData.Handle_IGESData_SingleParentEntity_Create()

def Handle_IGESData_SingleParentEntity_DownCast(t):
    return _IGESData.Handle_IGESData_SingleParentEntity_DownCast(t)

def Handle_IGESData_SingleParentEntity_IsNull(t):
    return _IGESData.Handle_IGESData_SingleParentEntity_IsNull(t)

def Handle_IGESData_TransfEntity_Create():
    return _IGESData.Handle_IGESData_TransfEntity_Create()

def Handle_IGESData_TransfEntity_DownCast(t):
    return _IGESData.Handle_IGESData_TransfEntity_DownCast(t)

def Handle_IGESData_TransfEntity_IsNull(t):
    return _IGESData.Handle_IGESData_TransfEntity_IsNull(t)

def Handle_IGESData_UndefinedEntity_Create():
    return _IGESData.Handle_IGESData_UndefinedEntity_Create()

def Handle_IGESData_UndefinedEntity_DownCast(t):
    return _IGESData.Handle_IGESData_UndefinedEntity_DownCast(t)

def Handle_IGESData_UndefinedEntity_IsNull(t):
    return _IGESData.Handle_IGESData_UndefinedEntity_IsNull(t)

def Handle_IGESData_ViewKindEntity_Create():
    return _IGESData.Handle_IGESData_ViewKindEntity_Create()

def Handle_IGESData_ViewKindEntity_DownCast(t):
    return _IGESData.Handle_IGESData_ViewKindEntity_DownCast(t)

def Handle_IGESData_ViewKindEntity_IsNull(t):
    return _IGESData.Handle_IGESData_ViewKindEntity_IsNull(t)

def Handle_IGESData_FreeFormatEntity_Create():
    return _IGESData.Handle_IGESData_FreeFormatEntity_Create()

def Handle_IGESData_FreeFormatEntity_DownCast(t):
    return _IGESData.Handle_IGESData_FreeFormatEntity_DownCast(t)

def Handle_IGESData_FreeFormatEntity_IsNull(t):
    return _IGESData.Handle_IGESData_FreeFormatEntity_IsNull(t)

def Handle_IGESData_HArray1OfIGESEntity_Create():
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_Create()

def Handle_IGESData_HArray1OfIGESEntity_DownCast(t):
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_DownCast(t)

def Handle_IGESData_HArray1OfIGESEntity_IsNull(t):
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_IsNull(t)
class IGESData_Array1OfDirPart(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _IGESData.IGESData_Array1OfDirPart_begin(self)

    def end(self):
        return _IGESData.IGESData_Array1OfDirPart_end(self)

    def cbegin(self):
        return _IGESData.IGESData_Array1OfDirPart_cbegin(self)

    def cend(self):
        return _IGESData.IGESData_Array1OfDirPart_cend(self)

    def __init__(self, *args):
        _IGESData.IGESData_Array1OfDirPart_swiginit(self, _IGESData.new_IGESData_Array1OfDirPart(*args))

    def Init(self, theValue):
        return _IGESData.IGESData_Array1OfDirPart_Init(self, theValue)

    def Size(self):
        return _IGESData.IGESData_Array1OfDirPart_Size(self)

    def Length(self):
        return _IGESData.IGESData_Array1OfDirPart_Length(self)

    def IsEmpty(self):
        return _IGESData.IGESData_Array1OfDirPart_IsEmpty(self)

    def Lower(self):
        return _IGESData.IGESData_Array1OfDirPart_Lower(self)

    def Upper(self):
        return _IGESData.IGESData_Array1OfDirPart_Upper(self)

    def IsDeletable(self):
        return _IGESData.IGESData_Array1OfDirPart_IsDeletable(self)

    def IsAllocated(self):
        return _IGESData.IGESData_Array1OfDirPart_IsAllocated(self)

    def Assign(self, theOther):
        return _IGESData.IGESData_Array1OfDirPart_Assign(self, theOther)

    def Move(self, theOther):
        return _IGESData.IGESData_Array1OfDirPart_Move(self, theOther)

    def Set(self, *args):
        return _IGESData.IGESData_Array1OfDirPart_Set(self, *args)

    def First(self):
        return _IGESData.IGESData_Array1OfDirPart_First(self)

    def ChangeFirst(self):
        return _IGESData.IGESData_Array1OfDirPart_ChangeFirst(self)

    def Last(self):
        return _IGESData.IGESData_Array1OfDirPart_Last(self)

    def ChangeLast(self):
        return _IGESData.IGESData_Array1OfDirPart_ChangeLast(self)

    def Value(self, theIndex):
        return _IGESData.IGESData_Array1OfDirPart_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _IGESData.IGESData_Array1OfDirPart_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _IGESData.IGESData_Array1OfDirPart___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _IGESData.IGESData_Array1OfDirPart_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _IGESData.IGESData_Array1OfDirPart_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _IGESData.delete_IGESData_Array1OfDirPart

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register IGESData_Array1OfDirPart in _IGESData:
_IGESData.IGESData_Array1OfDirPart_swigregister(IGESData_Array1OfDirPart)
class IGESData_Array1OfIGESEntity(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _IGESData.IGESData_Array1OfIGESEntity_begin(self)

    def end(self):
        return _IGESData.IGESData_Array1OfIGESEntity_end(self)

    def cbegin(self):
        return _IGESData.IGESData_Array1OfIGESEntity_cbegin(self)

    def cend(self):
        return _IGESData.IGESData_Array1OfIGESEntity_cend(self)

    def __init__(self, *args):
        _IGESData.IGESData_Array1OfIGESEntity_swiginit(self, _IGESData.new_IGESData_Array1OfIGESEntity(*args))

    def Init(self, theValue):
        return _IGESData.IGESData_Array1OfIGESEntity_Init(self, theValue)

    def Size(self):
        return _IGESData.IGESData_Array1OfIGESEntity_Size(self)

    def Length(self):
        return _IGESData.IGESData_Array1OfIGESEntity_Length(self)

    def IsEmpty(self):
        return _IGESData.IGESData_Array1OfIGESEntity_IsEmpty(self)

    def Lower(self):
        return _IGESData.IGESData_Array1OfIGESEntity_Lower(self)

    def Upper(self):
        return _IGESData.IGESData_Array1OfIGESEntity_Upper(self)

    def IsDeletable(self):
        return _IGESData.IGESData_Array1OfIGESEntity_IsDeletable(self)

    def IsAllocated(self):
        return _IGESData.IGESData_Array1OfIGESEntity_IsAllocated(self)

    def Assign(self, theOther):
        return _IGESData.IGESData_Array1OfIGESEntity_Assign(self, theOther)

    def Move(self, theOther):
        return _IGESData.IGESData_Array1OfIGESEntity_Move(self, theOther)

    def Set(self, *args):
        return _IGESData.IGESData_Array1OfIGESEntity_Set(self, *args)

    def First(self):
        return _IGESData.IGESData_Array1OfIGESEntity_First(self)

    def ChangeFirst(self):
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeFirst(self)

    def Last(self):
        return _IGESData.IGESData_Array1OfIGESEntity_Last(self)

    def ChangeLast(self):
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeLast(self)

    def Value(self, theIndex):
        return _IGESData.IGESData_Array1OfIGESEntity_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _IGESData.IGESData_Array1OfIGESEntity___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _IGESData.IGESData_Array1OfIGESEntity_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _IGESData.IGESData_Array1OfIGESEntity_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _IGESData.delete_IGESData_Array1OfIGESEntity

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register IGESData_Array1OfIGESEntity in _IGESData:
_IGESData.IGESData_Array1OfIGESEntity_swigregister(IGESData_Array1OfIGESEntity)
class igesdata(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Init(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Prepares general dynamic data used for igesdata specifically: protocol and modules, which treat undefinedentity.

        """
        return _IGESData.igesdata_Init(*args)

    @staticmethod
    def Protocol(*args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns a protocol from igesdata (avoids to create it).

        """
        return _IGESData.igesdata_Protocol(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.igesdata_swiginit(self, _IGESData.new_igesdata())
    __swig_destroy__ = _IGESData.delete_igesdata

# Register igesdata in _IGESData:
_IGESData.igesdata_swigregister(igesdata)
class IGESData_BasicEditor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty basic editor which should be initialized via init() method.

        Parameters
        ----------
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates a basic editor, with a new igesmodel, ready to run.

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates a basic editor for iges data, ready to run.

        """
        _IGESData.IGESData_BasicEditor_swiginit(self, _IGESData.new_IGESData_BasicEditor(*args))

    def ApplyUnit(self, *args):
        r"""

        Parameters
        ----------
        enforce: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Applies unit value to convert header data: resolution, maxcoord, maxlineweight applies unit only once after setunit... has been called, if <enforce> is given as true. it can be called just before writing the model to a file, i.e. when definitive values are finally known.

        """
        return _IGESData.IGESData_BasicEditor_ApplyUnit(self, *args)

    def AutoCorrect(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Performs auto-correction on an igesentity returns true if something has changed, false if nothing done. //! works with the specific iges services: dirchecker which allows to correct data in 'directory part' of entities (such as required values for status, or references to be null), and the specific iges service owncorrect, which is specialised for each type of entity.

        """
        return _IGESData.IGESData_BasicEditor_AutoCorrect(self, *args)

    def AutoCorrectModel(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Performs auto-correction on the whole model returns the count of modified entities.

        """
        return _IGESData.IGESData_BasicEditor_AutoCorrectModel(self, *args)

    def ComputeStatus(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Performs the re-computation of status on the whole model (subordinate status and use flag of each iges entity), which can have required values according the way they are referenced (see definitions of logical use, physical use, etc...).

        """
        return _IGESData.IGESData_BasicEditor_ComputeStatus(self, *args)

    @staticmethod
    def DraftingMax(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum allowed value for drafting flag.

        """
        return _IGESData.IGESData_BasicEditor_DraftingMax(*args)

    @staticmethod
    def DraftingName(*args):
        r"""

        Parameters
        ----------
        flag: int

        Return
        -------
        str

        Description
        -----------
        From the flag of drafting standard, returns name, '' if incorrect.

        """
        return _IGESData.IGESData_BasicEditor_DraftingName(*args)

    @staticmethod
    def IGESVersionMax(*args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum allowed value for igesversion flag.

        """
        return _IGESData.IGESData_BasicEditor_IGESVersionMax(*args)

    @staticmethod
    def IGESVersionName(*args):
        r"""

        Parameters
        ----------
        flag: int

        Return
        -------
        str

        Description
        -----------
        From the flag of iges version, returns name, '' if incorrect.

        """
        return _IGESData.IGESData_BasicEditor_IGESVersionName(*args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Initialize a basic editor, with a new igesmodel, ready to run.

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Initialize a basic editor for iges data, ready to run.

        """
        return _IGESData.IGESData_BasicEditor_Init(self, *args)

    def Model(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_IGESModel>

        Description
        -----------
        Returns the designated model.

        """
        return _IGESData.IGESData_BasicEditor_Model(self, *args)

    def SetUnitFlag(self, *args):
        r"""

        Parameters
        ----------
        flag: int

        Return
        -------
        bool

        Description
        -----------
        Sets a new unit from its flag (param 14 of global section) returns true if done, false if <flag> is incorrect.

        """
        return _IGESData.IGESData_BasicEditor_SetUnitFlag(self, *args)

    def SetUnitName(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        bool

        Description
        -----------
        Sets a new unit from its name (param 15 of global section) returns true if done, false if <name> is incorrect remark: if <flag> has been set to 3 (user defined), <name> is then free.

        """
        return _IGESData.IGESData_BasicEditor_SetUnitName(self, *args)

    def SetUnitValue(self, *args):
        r"""

        Parameters
        ----------
        val: float

        Return
        -------
        bool

        Description
        -----------
        Sets a new unit from its value in meters (rounded to the closest one, max gap 1%) returns true if done, false if <val> is too far from a suitable value.

        """
        return _IGESData.IGESData_BasicEditor_SetUnitValue(self, *args)

    @staticmethod
    def UnitFlagName(*args):
        r"""

        Parameters
        ----------
        flag: int

        Return
        -------
        str

        Description
        -----------
        From the flag of unit, determines its name, '' if incorrect.

        """
        return _IGESData.IGESData_BasicEditor_UnitFlagName(*args)

    @staticmethod
    def UnitFlagValue(*args):
        r"""

        Parameters
        ----------
        flag: int

        Return
        -------
        float

        Description
        -----------
        From the flag of unit, determines value in mm, 0 if incorrect.

        """
        return _IGESData.IGESData_BasicEditor_UnitFlagValue(*args)

    @staticmethod
    def UnitNameFlag(*args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        int

        Description
        -----------
        From the name of unit, computes flag number, 0 if incorrect (in this case, user defined entity remains possible).

        """
        return _IGESData.IGESData_BasicEditor_UnitNameFlag(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_BasicEditor

# Register IGESData_BasicEditor in _IGESData:
_IGESData.IGESData_BasicEditor_swigregister(IGESData_BasicEditor)
class IGESData_DefSwitch(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a defswitch as void.

        """
        _IGESData.IGESData_DefSwitch_swiginit(self, _IGESData.new_IGESData_DefSwitch(*args))

    def DefType(self, *args):
        r"""
        Return
        -------
        IGESData_DefType

        Description
        -----------
        Returns deftype status (void,reference,rank).

        """
        return _IGESData.IGESData_DefSwitch_DefType(self, *args)

    def SetRank(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets defswitch to 'rank' with a value (in file: integer > 0).

        """
        return _IGESData.IGESData_DefSwitch_SetRank(self, *args)

    def SetReference(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets defswitch to 'reference' status (in file: integer < 0).

        """
        return _IGESData.IGESData_DefSwitch_SetReference(self, *args)

    def SetVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets defswitch to 'void' status (in file: integer = 0).

        """
        return _IGESData.IGESData_DefSwitch_SetVoid(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns value as integer (sensefull for a rank).

        """
        return _IGESData.IGESData_DefSwitch_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefSwitch

# Register IGESData_DefSwitch in _IGESData:
_IGESData.IGESData_DefSwitch_swigregister(IGESData_DefSwitch)
class IGESData_DirChecker(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns a dirchecker, with no criterium at all to be checked.

        Parameters
        ----------
        atype: int

        Return
        -------
        None

        Description
        -----------
        Returns a dirchecker, with no criterium except required type.

        Parameters
        ----------
        atype: int
        aform: int

        Return
        -------
        None

        Description
        -----------
        Returns a dirchecker, with no criterium except required values for type and form numbers.

        Parameters
        ----------
        atype: int
        aform1: int
        aform2: int

        Return
        -------
        None

        Description
        -----------
        Returns a dirchecker, with no criterium except required values for type number (atype), and required range for form number (which must be between aform1 and aform2 included).

        """
        _IGESData.IGESData_DirChecker_swiginit(self, _IGESData.new_IGESData_DirChecker(*args))

    def BlankStatusIgnored(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets blank status to be ignored (should not be defined, or its value should be 0).

        """
        return _IGESData.IGESData_DirChecker_BlankStatusIgnored(self, *args)

    def BlankStatusRequired(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets blank status to be required at a given value.

        """
        return _IGESData.IGESData_DirChecker_BlankStatusRequired(self, *args)

    def Check(self, *args):
        r"""

        Parameters
        ----------
        ach: Interface_Check
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Performs the checks on an igesentity, according to the recorded criteria in addition, does minimal checks, such as admitted range for status, or presence of error status in some data (color, ...).

        """
        return _IGESData.IGESData_DirChecker_Check(self, *args)

    def CheckTypeAndForm(self, *args):
        r"""

        Parameters
        ----------
        ach: Interface_Check
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Performs a check only on values of type number and form number this allows to do a check on an entity not yet completely filled but of which type and form number have been already set.

        """
        return _IGESData.IGESData_DirChecker_CheckTypeAndForm(self, *args)

    def Color(self, *args):
        r"""

        Parameters
        ----------
        crit: IGESData_DefType

        Return
        -------
        None

        Description
        -----------
        Sets color criterium if crit is defvoid, ignored: should not be defined if crit is defany, required: must be defined (value or ref) other values are not taken in account.

        """
        return _IGESData.IGESData_DirChecker_Color(self, *args)

    def Correct(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Corrects the directory entry of an iges entity as far as it is possible according recorded criteria without any ambiguity: - if a numeric status is required a given value, this value is enforced - if an item is required to be void, or if it recorded as erroneous, it is cleared (set to void) - type number is enforced - finally form number is enforced only if one and only value is admitted (no range, see constructors of dirchecker).

        """
        return _IGESData.IGESData_DirChecker_Correct(self, *args)

    def GraphicsIgnored(self, *args):
        r"""

        Parameters
        ----------
        hierarchy: int (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Sets graphics data (linefont, lineweight, color, level, view) to be ignored according value of hierarchy status: if hierarchy is not given, they are ignored any way (that is, they should not be defined) if hierarchy is given, graphics are ignored if the hierarchy status has the value given in argument 'hierarchy'.

        """
        return _IGESData.IGESData_DirChecker_GraphicsIgnored(self, *args)

    def HierarchyStatusIgnored(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets hierarchy status to be ignored (should not be defined, or its value should be 0).

        """
        return _IGESData.IGESData_DirChecker_HierarchyStatusIgnored(self, *args)

    def HierarchyStatusRequired(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets hierarchy status to be required at a given value.

        """
        return _IGESData.IGESData_DirChecker_HierarchyStatusRequired(self, *args)

    def IsSet(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if at least one criterium has already been set allows user to store a dirchecker (static variable) then ask if it has been set before setting it.

        """
        return _IGESData.IGESData_DirChecker_IsSet(self, *args)

    def LineFont(self, *args):
        r"""

        Parameters
        ----------
        crit: IGESData_DefType

        Return
        -------
        None

        Description
        -----------
        Sets linefont criterium if crit is defvoid, ignored: should not be defined if crit is defany, required: must be defined (value or ref) if crit is defvalue, required as a value (error if reference) other values are not taken in account.

        """
        return _IGESData.IGESData_DirChecker_LineFont(self, *args)

    def LineWeight(self, *args):
        r"""

        Parameters
        ----------
        crit: IGESData_DefType

        Return
        -------
        None

        Description
        -----------
        Sets lineweight criterium if crit is defvoid, ignored: should not be defined if crit is defvalue, required other values are not taken in account.

        """
        return _IGESData.IGESData_DirChecker_LineWeight(self, *args)

    def SetDefault(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets a dirchecker with most current criteria, that is: structure ignored ( worths call structure(crit = defvoid) ).

        """
        return _IGESData.IGESData_DirChecker_SetDefault(self, *args)

    def Structure(self, *args):
        r"""

        Parameters
        ----------
        crit: IGESData_DefType

        Return
        -------
        None

        Description
        -----------
        Sets structure criterium. if crit is defvoid, ignored: should not be defined if crit is defreference, required: must be defined other values are not taken in account.

        """
        return _IGESData.IGESData_DirChecker_Structure(self, *args)

    def SubordinateStatusIgnored(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets subordinate status to be ignored (should not be defined, or its value should be 0).

        """
        return _IGESData.IGESData_DirChecker_SubordinateStatusIgnored(self, *args)

    def SubordinateStatusRequired(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets subordinate status to be required at a given value.

        """
        return _IGESData.IGESData_DirChecker_SubordinateStatusRequired(self, *args)

    def UseFlagIgnored(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets blank status to be ignored (should not be defined, or its value should be 0).

        """
        return _IGESData.IGESData_DirChecker_UseFlagIgnored(self, *args)

    def UseFlagRequired(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        Sets blank status to be required at a given value give -1 to demand useflag not zero (but no precise value req.).

        """
        return _IGESData.IGESData_DirChecker_UseFlagRequired(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DirChecker

# Register IGESData_DirChecker in _IGESData:
_IGESData.IGESData_DirChecker_swigregister(IGESData_DirChecker)
class IGESData_DirPart(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty dirpart, ready to be filled by init.

        """
        _IGESData.IGESData_DirPart_swiginit(self, _IGESData.new_IGESData_DirPart(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i19: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int
        res1: str
        res2: str
        label: str
        subscript: str

        Return
        -------
        None

        Description
        -----------
        Fills dirpart with consistent data read from file.

        """
        return _IGESData.IGESData_DirPart_Init(self, *args)

    def Type(self, *args):
        r"""
        Return
        -------
        IGESData_IGESType

        Description
        -----------
        Returns 'type' and 'form' info, used to recognize the entity.

        """
        return _IGESData.IGESData_DirPart_Type(self, *args)

    def Values(self, *args):
        r"""

        Parameters
        ----------
        res1: str
        res2: str
        label: str
        subscript: str

        Return
        -------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i19: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int

        Description
        -----------
        Returns values recorded in dirpart (content of cstrings are modified).

        """
        return _IGESData.IGESData_DirPart_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DirPart

# Register IGESData_DirPart in _IGESData:
_IGESData.IGESData_DirPart_swigregister(IGESData_DirPart)
class IGESData_FileRecognizer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Add(self, *args):
        r"""

        Parameters
        ----------
        reco: IGESData_FileRecognizer

        Return
        -------
        None

        Description
        -----------
        Adds a new recognizer to the compound, at the end several calls to add work by adding in the order of calls: hence, when eval has failed to recognize, evaluate will call evaluate from the first added recognizer if there is one, and to the second if there is still no result, and so on.

        """
        return _IGESData.IGESData_FileRecognizer_Add(self, *args)

    def Evaluate(self, *args):
        r"""

        Parameters
        ----------
        akey: IGESData_IGESType
        res: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Evaluates if recognition has a result, returns it if yes in case of success, returns true and puts result in 'res' in case of failure, simply returns false works by calling deferred method eval, and in case of failure, looks for added recognizers to work.

        """
        return _IGESData.IGESData_FileRecognizer_Evaluate(self, *args)

    def Result(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns result of last recognition (call of evaluate).

        """
        return _IGESData.IGESData_FileRecognizer_Result(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FileRecognizer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FileRecognizer

# Register IGESData_FileRecognizer in _IGESData:
_IGESData.IGESData_FileRecognizer_swigregister(IGESData_FileRecognizer)
class IGESData_GeneralModule(OCC.Core.Interface.Interface_GeneralModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DirChecker(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Return
        -------
        IGESData_DirChecker

        Description
        -----------
        Returns a dirchecker, specific for each type of entity (identified by its case number): this dirchecker defines constraints which must be respected by the directorypart.

        """
        return _IGESData.IGESData_GeneralModule_DirChecker(self, *args)

    def OwnCheckCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        shares: Interface_ShareTool
        ach: Interface_Check

        Return
        -------
        None

        Description
        -----------
        Performs specific semantic check for each type of entity.

        """
        return _IGESData.IGESData_GeneralModule_OwnCheckCase(self, *args)

    def OwnCopyCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        entfrom: IGESData_IGESEntity
        entto: IGESData_IGESEntity
        TC: Interface_CopyTool

        Return
        -------
        None

        Description
        -----------
        Copies parameters which are specific of each type of entity.

        """
        return _IGESData.IGESData_GeneralModule_OwnCopyCase(self, *args)

    def OwnDeleteCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Specific preparation for delete, acts on own parameters default does nothing, to be redefined as required.

        """
        return _IGESData.IGESData_GeneralModule_OwnDeleteCase(self, *args)

    def OwnImpliedCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        iter: Interface_EntityIterator

        Return
        -------
        None

        Description
        -----------
        Specific list of entities implied by a given igesentity <ent> (in addition to associativities). by default, there are none, but this method can be redefined as required.

        """
        return _IGESData.IGESData_GeneralModule_OwnImpliedCase(self, *args)

    def OwnRenewCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        entfrom: IGESData_IGESEntity
        entto: IGESData_IGESEntity
        TC: Interface_CopyTool

        Return
        -------
        None

        Description
        -----------
        Renews parameters which are specific of each type of entity: the provided default does nothing, but this method may be redefined as required.

        """
        return _IGESData.IGESData_GeneralModule_OwnRenewCase(self, *args)

    def OwnSharedCase(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        iter: Interface_EntityIterator

        Return
        -------
        None

        Description
        -----------
        Lists the entities shared by a given igesentity <ent>, from its specific parameters: specific for each type.

        """
        return _IGESData.IGESData_GeneralModule_OwnSharedCase(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GeneralModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GeneralModule

# Register IGESData_GeneralModule in _IGESData:
_IGESData.IGESData_GeneralModule_swigregister(IGESData_GeneralModule)
class IGESData_GlobalNodeOfSpecificLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty globalnode, with no next.

        """
        _IGESData.IGESData_GlobalNodeOfSpecificLib_swiginit(self, _IGESData.new_IGESData_GlobalNodeOfSpecificLib(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        amodule: IGESData_SpecificModule
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Adds a module bound with a protocol to the list: does nothing if already in the list, that is, same type (exact match) and same state (that is, isequal is not required) once added, stores its attached protocol in correspondence.

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Add(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_SpecificModule>

        Description
        -----------
        Returns the module stored in a given globalnode.

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Module(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_GlobalNodeOfSpecificLib>

        Description
        -----------
        Returns the next globalnode. if none is defined, returned value is a null handle.

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the attached protocol stored in a given globalnode.

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalNodeOfSpecificLib

# Register IGESData_GlobalNodeOfSpecificLib in _IGESData:
_IGESData.IGESData_GlobalNodeOfSpecificLib_swigregister(IGESData_GlobalNodeOfSpecificLib)
class IGESData_GlobalNodeOfWriterLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty globalnode, with no next.

        """
        _IGESData.IGESData_GlobalNodeOfWriterLib_swiginit(self, _IGESData.new_IGESData_GlobalNodeOfWriterLib(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        amodule: IGESData_ReadWriteModule
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Adds a module bound with a protocol to the list: does nothing if already in the list, that is, same type (exact match) and same state (that is, isequal is not required). once added, stores its attached protocol in correspondence.

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Add(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        Description
        -----------
        Returns the module stored in a given globalnode.

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Module(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_GlobalNodeOfWriterLib>

        Description
        -----------
        Returns the next globalnode. if none is defined, returned value is a null handle.

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the attached protocol stored in a given globalnode.

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalNodeOfWriterLib

# Register IGESData_GlobalNodeOfWriterLib in _IGESData:
_IGESData.IGESData_GlobalNodeOfWriterLib_swigregister(IGESData_GlobalNodeOfWriterLib)
class IGESData_GlobalSection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty globalsection, ready to be filled, warning: no default value is provided.

        """
        _IGESData.IGESData_GlobalSection_swiginit(self, _IGESData.new_IGESData_GlobalSection(*args))

    def ApplicationProtocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_ApplicationProtocol(self, *args)

    def AuthorName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the iges file author.

        """
        return _IGESData.IGESData_GlobalSection_AuthorName(self, *args)

    def CascadeUnit(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the system length unit.

        """
        return _IGESData.IGESData_GlobalSection_CascadeUnit(self, *args)

    def CompanyName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the company where the iges file was written.

        """
        return _IGESData.IGESData_GlobalSection_CompanyName(self, *args)

    def CopyRefs(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Copies data referenced by handle (that is, strings) useful to 'isolate' a globalsection after copy by '=' (from a model to another model for instance).

        """
        return _IGESData.IGESData_GlobalSection_CopyRefs(self, *args)

    def Date(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the iges file creation date.

        """
        return _IGESData.IGESData_GlobalSection_Date(self, *args)

    def DraftingStandard(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_DraftingStandard(self, *args)

    def EndMark(self, *args):
        r"""
        Return
        -------
        Standard_Character

        Description
        -----------
        Returns the record delimiter character.

        """
        return _IGESData.IGESData_GlobalSection_EndMark(self, *args)

    def FileName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the iges file.

        """
        return _IGESData.IGESData_GlobalSection_FileName(self, *args)

    def HasApplicationProtocol(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_HasApplicationProtocol(self, *args)

    def HasLastChangeDate(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the date and time when the model was created or last modified are specified, i.e. not defaulted to null.

        """
        return _IGESData.IGESData_GlobalSection_HasLastChangeDate(self, *args)

    def HasMaxCoord(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the approximate maximum coordinate value found in the model is greater than 0.

        """
        return _IGESData.IGESData_GlobalSection_HasMaxCoord(self, *args)

    def IGESVersion(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the iges version that the iges file was written in.

        """
        return _IGESData.IGESData_GlobalSection_IGESVersion(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        params: Interface_ParamSet
        ach: Interface_Check

        Return
        -------
        None

        Description
        -----------
        Fills globalsection from a paramset (i.e. taken from file) undefined parameters do not change default values when defined fills check about corrections or fails.

        """
        return _IGESData.IGESData_GlobalSection_Init(self, *args)

    def IntegerBits(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of binary bits for integer representations.

        """
        return _IGESData.IGESData_GlobalSection_IntegerBits(self, *args)

    def InterfaceVersion(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the pre-processor used to write the iges file.

        """
        return _IGESData.IGESData_GlobalSection_InterfaceVersion(self, *args)

    def LastChangeDate(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the date and time when the model was created or last modified (for iges 5.1 and later).

        """
        return _IGESData.IGESData_GlobalSection_LastChangeDate(self, *args)

    def LineWeightGrad(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum number of line weight gradations.

        """
        return _IGESData.IGESData_GlobalSection_LineWeightGrad(self, *args)

    def MaxCoord(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the approximate maximum coordinate value found in the model.

        """
        return _IGESData.IGESData_GlobalSection_MaxCoord(self, *args)

    def MaxDigitsDouble(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_MaxDigitsDouble(self, *args)

    def MaxDigitsSingle(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_MaxDigitsSingle(self, *args)

    def MaxLineWeight(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the of maximum line weight width in iges file units.

        """
        return _IGESData.IGESData_GlobalSection_MaxLineWeight(self, *args)

    def MaxMaxCoord(self, *args):
        r"""

        Parameters
        ----------
        val: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_MaxMaxCoord(self, *args)

    def MaxMaxCoords(self, *args):
        r"""

        Parameters
        ----------
        xyz: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_MaxMaxCoords(self, *args)

    def MaxPower10Double(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum power of a decimal representation of a double-precision floating point number in the sending system.

        """
        return _IGESData.IGESData_GlobalSection_MaxPower10Double(self, *args)

    def MaxPower10Single(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum power of a decimal representation of a single-precision floating point number in the sending system.

        """
        return _IGESData.IGESData_GlobalSection_MaxPower10Single(self, *args)

    @staticmethod
    def NewDateString(*args):
        r"""

        Parameters
        ----------
        year: int
        month: int
        day: int
        hour: int
        minut: int
        second: int
        mode: int (optional, default to -1)

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns a string built from year, month, day, hour, minute and second values. the form of the resulting string is defined as follows: - -1: yymmdd.hhnnss, - 0: yyyymmdd.hhnnss, - 1: yyyy-mm-dd:hh-nn-ss, where: - yyyy or yy is 4 or 2 digit year, - hh is hour (00-23), - mm is month (01-12), - nn is minute (00-59) - dd is day (01-31), - ss is second (00-59).

        Parameters
        ----------
        date: TCollection_HAsciiString
        mode: int (optional, default to 1)

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Converts the string given in the form yymmdd.hhnnss or yyyymmdd.hhnnss to either yymmdd.hhnnss, yyyymmdd.hhnnss or yyyy-mm-dd:hh-nn-ss.

        """
        return _IGESData.IGESData_GlobalSection_NewDateString(*args)

    def Params(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_ParamSet>

        Description
        -----------
        Returns all contained data in the form of a paramset remark: strings are given under hollerith form.

        """
        return _IGESData.IGESData_GlobalSection_Params(self, *args)

    def ReceiveName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the receiving system.

        """
        return _IGESData.IGESData_GlobalSection_ReceiveName(self, *args)

    def Resolution(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the resolution used in the iges file.

        """
        return _IGESData.IGESData_GlobalSection_Resolution(self, *args)

    def Scale(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the scale used in the iges file.

        """
        return _IGESData.IGESData_GlobalSection_Scale(self, *args)

    def SendName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the sending system.

        """
        return _IGESData.IGESData_GlobalSection_SendName(self, *args)

    def Separator(self, *args):
        r"""
        Return
        -------
        Standard_Character

        Description
        -----------
        Returns the parameter delimiter character.

        """
        return _IGESData.IGESData_GlobalSection_Separator(self, *args)

    def SetApplicationProtocol(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetApplicationProtocol(self, *args)

    def SetAuthorName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetAuthorName(self, *args)

    def SetCascadeUnit(self, *args):
        r"""

        Parameters
        ----------
        theUnit: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetCascadeUnit(self, *args)

    def SetCompanyName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetCompanyName(self, *args)

    def SetDate(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetDate(self, *args)

    def SetDraftingStandard(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetDraftingStandard(self, *args)

    def SetEndMark(self, *args):
        r"""

        Parameters
        ----------
        val: Standard_Character

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetEndMark(self, *args)

    def SetFileName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetFileName(self, *args)

    def SetIGESVersion(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetIGESVersion(self, *args)

    def SetIntegerBits(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetIntegerBits(self, *args)

    def SetInterfaceVersion(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetInterfaceVersion(self, *args)

    def SetLastChangeDate(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetLastChangeDate(self, *args)

    def SetLineWeightGrad(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetLineWeightGrad(self, *args)

    def SetMaxCoord(self, *args):
        r"""

        Parameters
        ----------
        val: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxCoord(self, *args)

    def SetMaxDigitsDouble(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxDigitsDouble(self, *args)

    def SetMaxDigitsSingle(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxDigitsSingle(self, *args)

    def SetMaxLineWeight(self, *args):
        r"""

        Parameters
        ----------
        val: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxLineWeight(self, *args)

    def SetMaxPower10Double(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxPower10Double(self, *args)

    def SetMaxPower10Single(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetMaxPower10Single(self, *args)

    def SetReceiveName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetReceiveName(self, *args)

    def SetResolution(self, *args):
        r"""

        Parameters
        ----------
        val: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetResolution(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        val: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetScale(self, *args)

    def SetSendName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetSendName(self, *args)

    def SetSeparator(self, *args):
        r"""

        Parameters
        ----------
        val: Standard_Character

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetSeparator(self, *args)

    def SetSystemId(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetSystemId(self, *args)

    def SetUnitFlag(self, *args):
        r"""

        Parameters
        ----------
        val: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetUnitFlag(self, *args)

    def SetUnitName(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_GlobalSection_SetUnitName(self, *args)

    def SystemId(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the native system id of the system that created the iges file.

        """
        return _IGESData.IGESData_GlobalSection_SystemId(self, *args)

    def TranslatedFromHollerith(self, *args):
        r"""

        Parameters
        ----------
        astr: TCollection_HAsciiString

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns a string withpout its hollerith marks (nnnh ahead). remark: all strings stored in globalsection are expurged from hollerith information (without nnnh) if <astr> is not hollerith form, it is simply copied.

        """
        return _IGESData.IGESData_GlobalSection_TranslatedFromHollerith(self, *args)

    def UnitFlag(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the unit flag that was used to write the iges file.

        """
        return _IGESData.IGESData_GlobalSection_UnitFlag(self, *args)

    def UnitName(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the name of the unit the iges file was written in.

        """
        return _IGESData.IGESData_GlobalSection_UnitName(self, *args)

    def UnitValue(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the unit value (in meters) that the iges file was written in.

        """
        return _IGESData.IGESData_GlobalSection_UnitValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalSection

# Register IGESData_GlobalSection in _IGESData:
_IGESData.IGESData_GlobalSection_swigregister(IGESData_GlobalSection)
class IGESData_IGESDumper(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Returns an igesdumper ready to work. the igesmodel provides the numbering of entities: as for any interfacemodel, it gives each entity a number; but for igesentities, the 'number of directory entry' according to the definition of iges files, is also useful.

        """
        _IGESData.IGESData_IGESDumper_swiginit(self, _IGESData.new_IGESData_IGESDumper(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESDumper

# Register IGESData_IGESDumper in _IGESData:
_IGESData.IGESData_IGESDumper_swigregister(IGESData_IGESDumper)
class IGESData_IGESEntity(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddProperty(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Adds a property in the list.

        """
        return _IGESData.IGESData_IGESEntity_AddProperty(self, *args)

    def ArePresentAssociativities(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the entity is defined with an associativity list, even empty (that is, file contains its length 0) else, the file contained no idencation at all about this list.

        """
        return _IGESData.IGESData_IGESEntity_ArePresentAssociativities(self, *args)

    def ArePresentProperties(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the entity is defined with a property list, even empty (that is, file contains its length 0) else, the file contained no idencation at all about this list.

        """
        return _IGESData.IGESData_IGESEntity_ArePresentProperties(self, *args)

    def Associate(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sets 'me' in the associativity list of another entity.

        """
        return _IGESData.IGESData_IGESEntity_Associate(self, *args)

    def Associativities(self, *args):
        r"""
        Return
        -------
        Interface_EntityIterator

        Description
        -----------
        Returns the associativity list under the form of an entityiterator.

        """
        return _IGESData.IGESData_IGESEntity_Associativities(self, *args)

    def BlankStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives blank status (0 visible, 1 blanked).

        """
        return _IGESData.IGESData_IGESEntity_BlankStatus(self, *args)

    def CResValues(self, *args):
        r"""

        Parameters
        ----------
        res1: str
        res2: str

        Return
        -------
        bool

        Description
        -----------
        Returns 'reserved' alphanumeric values res1 and res2 res1 and res2 have to be reserved as character[9 at least] (remark: their content is changed) returned values are ended by null character in 9th returned boolean is false if res1 and res2 are blank, true else.

        """
        return _IGESData.IGESData_IGESEntity_CResValues(self, *args)

    def Color(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ColorEntity>

        Description
        -----------
        Returns the iges entity which describes the color of the entity. returns a null handle if this entity was defined as an integer.

        """
        return _IGESData.IGESData_IGESEntity_Color(self, *args)

    def CompoundLocation(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns location by taking in account a parent which has its own location: that one will be combined to that of <self> the parent is considered only if hasoneparent is true, else it is ignored and compoundlocation = location.

        """
        return _IGESData.IGESData_IGESEntity_CompoundLocation(self, *args)

    def DefColor(self, *args):
        r"""
        Return
        -------
        IGESData_DefType

        Description
        -----------
        Returns the definition status of color.

        """
        return _IGESData.IGESData_IGESEntity_DefColor(self, *args)

    def DefLevel(self, *args):
        r"""
        Return
        -------
        IGESData_DefList

        Description
        -----------
        Returns the definition status of level.

        """
        return _IGESData.IGESData_IGESEntity_DefLevel(self, *args)

    def DefLineFont(self, *args):
        r"""
        Return
        -------
        IGESData_DefType

        Description
        -----------
        Returns the definition status of linefont.

        """
        return _IGESData.IGESData_IGESEntity_DefLineFont(self, *args)

    def DefView(self, *args):
        r"""
        Return
        -------
        IGESData_DefList

        Description
        -----------
        Returns the definition status of the view. this can be: none, one or several.

        """
        return _IGESData.IGESData_IGESEntity_DefView(self, *args)

    def DirFieldEntity(self, *args):
        r"""

        Parameters
        ----------
        fieldnum: int

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the entity which has been recorded for a given field number, i.e. without any cast. maps with: 3: structure 4: linefont 5: levellist 6: view 7: transf(ormation matrix) 8: labeldisplay 13: color. other values give a null handle it can then be of any kind, while specific items have a type.

        """
        return _IGESData.IGESData_IGESEntity_DirFieldEntity(self, *args)

    def Dissociate(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Resets 'me' from the associativity list of another entity.

        """
        return _IGESData.IGESData_IGESEntity_Dissociate(self, *args)

    def FormNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the form number for that type of an iges entity. the default form number is 0.

        """
        return _IGESData.IGESData_IGESEntity_FormNumber(self, *args)

    def HasLabelDisplay(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if a labeldisplay mode is defined for this entity.

        """
        return _IGESData.IGESData_IGESEntity_HasLabelDisplay(self, *args)

    def HasName(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Says if a name is defined, as short label or as name property (property is looked first, else shortlabel is considered).

        """
        return _IGESData.IGESData_IGESEntity_HasName(self, *args)

    def HasOneParent(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if an entity has one and only one parent, defined by a singleparententity type associativity (explicit sharing). thus, implicit sharing remains defined at model level (see class toollocation).

        """
        return _IGESData.IGESData_IGESEntity_HasOneParent(self, *args)

    def HasShortLabel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if a short label is defined. a short label is a non-blank 8-character string.

        """
        return _IGESData.IGESData_IGESEntity_HasShortLabel(self, *args)

    def HasStructure(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if an igesentity is defined with a structure (it is normally reserved for certain classes, such as macros).

        """
        return _IGESData.IGESData_IGESEntity_HasStructure(self, *args)

    def HasSubScriptNumber(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if a subscript number is defined. a subscript number is an integer used to identify a label.

        """
        return _IGESData.IGESData_IGESEntity_HasSubScriptNumber(self, *args)

    def HasTransf(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if a transformation matrix is defined.

        """
        return _IGESData.IGESData_IGESEntity_HasTransf(self, *args)

    def HierarchyStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives hierarchy status (0-1-2).

        """
        return _IGESData.IGESData_IGESEntity_HierarchyStatus(self, *args)

    def IGESType(self, *args):
        r"""
        Return
        -------
        IGESData_IGESType

        Description
        -----------
        Gives iges typing info (includes 'type' and 'form' data).

        """
        return _IGESData.IGESData_IGESEntity_IGESType(self, *args)

    def InitColor(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_ColorEntity
        rank: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Initializes color data: if <ent> is not null, it gives color, else <rank> gives or erases (if zero) rankcolor.

        """
        return _IGESData.IGESData_IGESEntity_InitColor(self, *args)

    def InitDirFieldEntity(self, *args):
        r"""

        Parameters
        ----------
        fieldnum: int
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Initializes a directory field as an entiy of any kind see dirfieldentity for more details.

        """
        return _IGESData.IGESData_IGESEntity_InitDirFieldEntity(self, *args)

    def InitLevel(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_LevelListEntity
        val: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Initializes level: if <ent> is not null, it gives levellist, else <val> gives or erases (if zero) unique level.

        """
        return _IGESData.IGESData_IGESEntity_InitLevel(self, *args)

    def InitLineFont(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_LineFontEntity
        rank: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Initializes linefont: if <ent> is not null, it gives linefont, else <rank> gives or erases (if zero) ranklinefont.

        """
        return _IGESData.IGESData_IGESEntity_InitLineFont(self, *args)

    def InitMisc(self, *args):
        r"""

        Parameters
        ----------
        str: IGESData_IGESEntity
        lab: IGESData_LabelDisplayEntity
        weightnum: int

        Return
        -------
        None

        Description
        -----------
        Initializes various data (those not yet seen above), or erases them if they are given as null (zero for <weightnum>): <str> for structure, <lab> for labeldisplay, and <weightnum> for weightnumber.

        """
        return _IGESData.IGESData_IGESEntity_InitMisc(self, *args)

    def InitStatus(self, *args):
        r"""

        Parameters
        ----------
        blank: int
        subordinate: int
        useflag: int
        hierarchy: int

        Return
        -------
        None

        Description
        -----------
        Initializes the status of directory part.

        """
        return _IGESData.IGESData_IGESEntity_InitStatus(self, *args)

    def InitTransf(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_TransfEntity

        Return
        -------
        None

        Description
        -----------
        Initializes transf, or erases it if <ent> is given null.

        """
        return _IGESData.IGESData_IGESEntity_InitTransf(self, *args)

    def InitView(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_ViewKindEntity

        Return
        -------
        None

        Description
        -----------
        Initializes view, or erases it if <ent> is given null.

        """
        return _IGESData.IGESData_IGESEntity_InitView(self, *args)

    def LabelDisplay(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_LabelDisplayEntity>

        Description
        -----------
        Returns the label display associativity entity if there is one. returns a null handle if there is none.

        """
        return _IGESData.IGESData_IGESEntity_LabelDisplay(self, *args)

    def Level(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the level the entity belongs to. returns -1 if the entity belongs to more than one level.

        """
        return _IGESData.IGESData_IGESEntity_Level(self, *args)

    def LevelList(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_LevelListEntity>

        Description
        -----------
        Returns levellist if level is defined as a list. returns a null handle if deflevel is not defseveral.

        """
        return _IGESData.IGESData_IGESEntity_LevelList(self, *args)

    def LineFont(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_LineFontEntity>

        Description
        -----------
        Returns linefont as an entity (if defined as reference) returns a null handle if deflinefont is not 'defreference'.

        """
        return _IGESData.IGESData_IGESEntity_LineFont(self, *args)

    def LineWeight(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the true line weight, computed from lineweightnumber and global parameter in the model by call to setlineweight.

        """
        return _IGESData.IGESData_IGESEntity_LineWeight(self, *args)

    def LineWeightNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the lineweight number (0 not defined), see also lineweight.

        """
        return _IGESData.IGESData_IGESEntity_LineWeightNumber(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns location given by transf in directory part (see above) it must be considered for local definition: if the entity is set in a 'parent', that one can add its one location, but this is not taken in account here: see compoundlocation for that. if no transf is defined, returns identity if transf is itself compound, gives the final result.

        """
        return _IGESData.IGESData_IGESEntity_Location(self, *args)

    def NameValue(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns name value as a string (property name or shortlabel) if subnumber is defined, it is concatenated after shortlabel as follows label(number). ignored with a property name.

        """
        return _IGESData.IGESData_IGESEntity_NameValue(self, *args)

    def NbAssociativities(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives number of recorded associativities (0 no list defined).

        """
        return _IGESData.IGESData_IGESEntity_NbAssociativities(self, *args)

    def NbProperties(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives number of recorded properties (0 no list defined).

        """
        return _IGESData.IGESData_IGESEntity_NbProperties(self, *args)

    def NbTypedAssociativities(self, *args):
        r"""

        Parameters
        ----------
        atype: Standard_Type

        Return
        -------
        int

        Description
        -----------
        Gives how many associativities have a given type.

        """
        return _IGESData.IGESData_IGESEntity_NbTypedAssociativities(self, *args)

    def NbTypedProperties(self, *args):
        r"""

        Parameters
        ----------
        atype: Standard_Type

        Return
        -------
        int

        Description
        -----------
        Gives how many properties have a given type.

        """
        return _IGESData.IGESData_IGESEntity_NbTypedProperties(self, *args)

    def Properties(self, *args):
        r"""
        Return
        -------
        Interface_EntityIterator

        Description
        -----------
        Returns property list under the form of an entityiterator.

        """
        return _IGESData.IGESData_IGESEntity_Properties(self, *args)

    def RankColor(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the color definition as an integer value if the color was defined as a rank. warning a negative value is returned if the color was defined as an entity.

        """
        return _IGESData.IGESData_IGESEntity_RankColor(self, *args)

    def RankLineFont(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns linefont definition as an integer (if defined as rank) if linefont is defined as an entity, returns a negative value.

        """
        return _IGESData.IGESData_IGESEntity_RankLineFont(self, *args)

    def RemoveProperty(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Removes a property from the list.

        """
        return _IGESData.IGESData_IGESEntity_RemoveProperty(self, *args)

    def SetLabel(self, *args):
        r"""

        Parameters
        ----------
        label: TCollection_HAsciiString
        sub: int (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Sets a new label to an iges entity if <sub> is given, it sets value of subscriptnumber else, subscriptnumber is erased.

        """
        return _IGESData.IGESData_IGESEntity_SetLabel(self, *args)

    def SetLineWeight(self, *args):
        r"""

        Parameters
        ----------
        defw: float
        maxw: float
        gradw: int

        Return
        -------
        None

        Description
        -----------
        Computes and sets 'true' line weight according iges rules from global data maxlineweight (maxv) and lineweightgrad (gradw), or sets it to defw (default) if lineweightnumber is null.

        """
        return _IGESData.IGESData_IGESEntity_SetLineWeight(self, *args)

    def ShortLabel(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns the label value for this iges entity as a string. warning if the label is blank, this string is null.

        """
        return _IGESData.IGESData_IGESEntity_ShortLabel(self, *args)

    def SingleView(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        Description
        -----------
        Returns the view as a single view if it was defined as such and not as a list of views. warning a null handle is returned if defview does not have the value defone.

        """
        return _IGESData.IGESData_IGESEntity_SingleView(self, *args)

    def Structure(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns structure (used by some types of iges entities only) returns a null handle if structure is not defined.

        """
        return _IGESData.IGESData_IGESEntity_Structure(self, *args)

    def SubScriptNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the integer subscript number used to identify this iges entity. warning 0 is returned if no subscript number is defined for this iges entity.

        """
        return _IGESData.IGESData_IGESEntity_SubScriptNumber(self, *args)

    def SubordinateStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives subordinate switch (0-1-2-3).

        """
        return _IGESData.IGESData_IGESEntity_SubordinateStatus(self, *args)

    def Transf(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_TransfEntity>

        Description
        -----------
        Returns the transformation matrix (under iges definition) returns a null handle if there is none for a more complete use, see location & compoundlocation.

        """
        return _IGESData.IGESData_IGESEntity_Transf(self, *args)

    def TypeNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives iges type number (often coupled with form number).

        """
        return _IGESData.IGESData_IGESEntity_TypeNumber(self, *args)

    def TypedAssociativity(self, *args):
        r"""

        Parameters
        ----------
        atype: Standard_Type

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the associativity of a given type (if only one exists) error if none or more than one.

        """
        return _IGESData.IGESData_IGESEntity_TypedAssociativity(self, *args)

    def TypedProperty(self, *args):
        r"""

        Parameters
        ----------
        atype: Standard_Type
        anum: int (optional, default to 0)

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the property of a given type error if none or more than one.

        """
        return _IGESData.IGESData_IGESEntity_TypedProperty(self, *args)

    def UniqueParent(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the unique parent (in the sense given by hasoneparent) error if there is none or several.

        """
        return _IGESData.IGESData_IGESEntity_UniqueParent(self, *args)

    def UseFlag(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives entity's use flag (0 to 5).

        """
        return _IGESData.IGESData_IGESEntity_UseFlag(self, *args)

    def VectorLocation(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns location considered for vectors, i.e. without its translation part. as location, it gives local definition.

        """
        return _IGESData.IGESData_IGESEntity_VectorLocation(self, *args)

    def View(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        Description
        -----------
        Returns the view of this iges entity. this view can be a single view or a list of views. warning a null handle is returned if the view is not defined.

        """
        return _IGESData.IGESData_IGESEntity_View(self, *args)

    def ViewList(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        Description
        -----------
        Returns the view of this iges entity as a list. warning a null handle is returned if the definition status does not have the value defseveral.

        """
        return _IGESData.IGESData_IGESEntity_ViewList(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESEntity

# Register IGESData_IGESEntity in _IGESData:
_IGESData.IGESData_IGESEntity_swigregister(IGESData_IGESEntity)
class IGESData_IGESModel(OCC.Core.Interface.Interface_InterfaceModel):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _IGESData.IGESData_IGESModel_swiginit(self, _IGESData.new_IGESData_IGESModel(*args))

    def AddStartLine(self, *args):
        r"""

        Parameters
        ----------
        line: str
        atnum: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Adds a new string to the existing start section at the end if atnum is 0 or not given, or before atnumth line.

        """
        return _IGESData.IGESData_IGESModel_AddStartLine(self, *args)

    def ApplyStatic(self, *args):
        r"""

        Parameters
        ----------
        param: str (optional, default to )

        Return
        -------
        bool

        Description
        -----------
        Sets some of the global section parameters with the values defined by the translation parameters. param may be: - receiver (value read in xstep.iges.header.receiver), - author (value read in xstep.iges.header.author), - company (value read in xstep.iges.header.company). the default value for param is an empty string. returns true when done and if param is given, false if param is unknown or empty. note: set the unit in the iges file global section via igesdata_basiceditor class.

        """
        return _IGESData.IGESData_IGESModel_ApplyStatic(self, *args)

    def ChangeGlobalSection(self, *args):
        r"""
        Return
        -------
        IGESData_GlobalSection

        Description
        -----------
        Returns the global section of the iges file.

        """
        return _IGESData.IGESData_IGESModel_ChangeGlobalSection(self, *args)

    def ClearStartSection(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the iges file start section.

        """
        return _IGESData.IGESData_IGESModel_ClearStartSection(self, *args)

    def DNum(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        int

        Description
        -----------
        Returns the equivalent de number for an entity, i.e. 2*number(ent)-1 , or 0 if <ent> is unknown from <self> this de number is used for file writing for instance.

        """
        return _IGESData.IGESData_IGESModel_DNum(self, *args)

    def Entity(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns an iges entity given by its rank number.

        """
        return _IGESData.IGESData_IGESModel_Entity(self, *args)

    def GlobalSection(self, *args):
        r"""
        Return
        -------
        IGESData_GlobalSection

        Description
        -----------
        Returns the global section of the iges file.

        """
        return _IGESData.IGESData_IGESModel_GlobalSection(self, *args)

    def NbStartLines(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the count of recorded start lines.

        """
        return _IGESData.IGESData_IGESModel_NbStartLines(self, *args)

    def ReShape(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeBuild_ReShape>

        Description
        -----------
        Gets reshape used to store a model's shapes changes.

        """
        return _IGESData.IGESData_IGESModel_ReShape(self, *args)

    def SetGlobalSection(self, *args):
        r"""

        Parameters
        ----------
        header: IGESData_GlobalSection

        Return
        -------
        None

        Description
        -----------
        Sets the global section of the iges file.

        """
        return _IGESData.IGESData_IGESModel_SetGlobalSection(self, *args)

    def SetLineWeights(self, *args):
        r"""

        Parameters
        ----------
        defw: float

        Return
        -------
        None

        Description
        -----------
        Sets lineweights of contained entities according header data (maxlineweight and lineweightgrad) or to a default value for undefined weights.

        """
        return _IGESData.IGESData_IGESModel_SetLineWeights(self, *args)

    def SetReShape(self, *args):
        r"""

        Parameters
        ----------
        theReShape: ShapeBuild_ReShape

        Return
        -------
        None

        Description
        -----------
        Sets reshape used to store a history of changes of the model's shapes.

        """
        return _IGESData.IGESData_IGESModel_SetReShape(self, *args)

    def SetStartSection(self, *args):
        r"""

        Parameters
        ----------
        list: TColStd_HSequenceOfHAsciiString
        copy: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets a new start section from a list of strings. if copy is false, the start section will be shared. any modifications made to the strings later on, will have an effect on the start section. if copy is true (default value), an independent copy of the strings is created and used as the start section. any modifications made to the strings later on, will have no effect on the start section.

        """
        return _IGESData.IGESData_IGESModel_SetStartSection(self, *args)

    def StartLine(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        str

        Description
        -----------
        Returns a line from the iges file start section by specifying its number. an empty string is returned if the number given is out of range, the range being from 1 to nbstartlines.

        """
        return _IGESData.IGESData_IGESModel_StartLine(self, *args)

    def StartSection(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        Description
        -----------
        Returns model's start section (list of comment lines).

        """
        return _IGESData.IGESData_IGESModel_StartSection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESModel_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESModel

# Register IGESData_IGESModel in _IGESData:
_IGESData.IGESData_IGESModel_swigregister(IGESData_IGESModel)
class IGESData_IGESReaderData(OCC.Core.Interface.Interface_FileReaderData):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        nbe: int
        nbp: int

        Return
        -------
        None

        Description
        -----------
        Creates igesreaderdata correctly dimensionned (for arrays) <nbe> count of entities, that is, half nb of directory lines <nbp>: count of parameters.

        """
        _IGESData.IGESData_IGESReaderData_swiginit(self, _IGESData.new_IGESData_IGESReaderData(*args))

    def AddGlobal(self, *args):
        r"""

        Parameters
        ----------
        atype: Interface_ParamType
        aval: str

        Return
        -------
        None

        Description
        -----------
        Adds a parameter to global section's parameter list.

        """
        return _IGESData.IGESData_IGESReaderData_AddGlobal(self, *args)

    def AddStartLine(self, *args):
        r"""

        Parameters
        ----------
        aval: str

        Return
        -------
        None

        Description
        -----------
        Adds a start line to start section.

        """
        return _IGESData.IGESData_IGESReaderData_AddStartLine(self, *args)

    def DefaultLineWeight(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the recorded default line weight, if there is (else, returns 0).

        """
        return _IGESData.IGESData_IGESReaderData_DefaultLineWeight(self, *args)

    def DirPart(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        IGESData_DirPart

        Description
        -----------
        Returns dirpart identified by record no (half dsect number).

        """
        return _IGESData.IGESData_IGESReaderData_DirPart(self, *args)

    def DirType(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        IGESData_IGESType

        Description
        -----------
        Returns 'type' and 'form' info from a directory part.

        """
        return _IGESData.IGESData_IGESReaderData_DirType(self, *args)

    def DirValues(self, *args):
        r"""

        Parameters
        ----------
        num: int
        res1: str
        res2: str
        label: str
        subs: str

        Return
        -------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i10: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int

        Description
        -----------
        Returns values recorded in directory part n0 <num>.

        """
        return _IGESData.IGESData_IGESReaderData_DirValues(self, *args)

    def GlobalCheck(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_Check>

        Description
        -----------
        Returns the recorded global check.

        """
        return _IGESData.IGESData_IGESReaderData_GlobalCheck(self, *args)

    def GlobalSection(self, *args):
        r"""
        Return
        -------
        IGESData_GlobalSection

        Description
        -----------
        Returns header as globalsection.

        """
        return _IGESData.IGESData_IGESReaderData_GlobalSection(self, *args)

    def SetDefaultLineWeight(self, *args):
        r"""

        Parameters
        ----------
        defw: float

        Return
        -------
        None

        Description
        -----------
        Allows to set a default line weight, will be later applied at load time, on entities which have no specified line weight.

        """
        return _IGESData.IGESData_IGESReaderData_SetDefaultLineWeight(self, *args)

    def SetDirPart(self, *args):
        r"""

        Parameters
        ----------
        num: int
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i10: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int
        res1: str
        res2: str
        label: str
        subs: str

        Return
        -------
        None

        Description
        -----------
        Fills a dirpart, designated by its rank (that is, (n+1)/2 if n is its first number in section d).

        """
        return _IGESData.IGESData_IGESReaderData_SetDirPart(self, *args)

    def SetEntityNumbers(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Determines reference numbers in entitynumber fields (called by setentities from igesreadertool) works on 'integer' type parameters, because iges does not distinguish integer and entity refs: every integer which is odd and less than twice nbrecords can be an entity ref ... (ref number is then (n+1)/2 if n is the integer value).

        """
        return _IGESData.IGESData_IGESReaderData_SetEntityNumbers(self, *args)

    def SetGlobalSection(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reads header (as globalsection) content from the paramset after it has been filled by successive calls to addglobal.

        """
        return _IGESData.IGESData_IGESReaderData_SetGlobalSection(self, *args)

    def StartSection(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        Description
        -----------
        Returns the start section in once.

        """
        return _IGESData.IGESData_IGESReaderData_StartSection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESReaderData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESReaderData

# Register IGESData_IGESReaderData in _IGESData:
_IGESData.IGESData_IGESReaderData_swigregister(IGESData_IGESReaderData)
class IGESData_IGESReaderTool(OCC.Core.Interface.Interface_FileReaderTool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        reader: IGESData_IGESReaderData
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates igesreadertool to work with an igesreaderdata and an iges protocol. actually, no lib is used.

        """
        _IGESData.IGESData_IGESReaderTool_swiginit(self, _IGESData.new_IGESData_IGESReaderTool(*args))

    def Prepare(self, *args):
        r"""

        Parameters
        ----------
        reco: IGESData_FileRecognizer

        Return
        -------
        None

        Description
        -----------
        Binds empty entities to records, works with the protocol (from igesdata) stored and later used rq: actually, sets dnum into iges entities also loads the list of parameters for paramreader.

        """
        return _IGESData.IGESData_IGESReaderTool_Prepare(self, *args)

    def ReadAssocs(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Return
        -------
        None

        Description
        -----------
        Reads associativity list, if there is (if not, does nothing) criterium is: current parameter of pr remains inside params list, and stage is 'own' same conditions as above; in addition, no parameter must be let after the list once read note that 'associated' entities are not declared 'shared'.

        """
        return _IGESData.IGESData_IGESReaderTool_ReadAssocs(self, *args)

    def ReadDir(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        DP: IGESData_DirPart
        ach: Interface_Check

        Return
        -------
        None

        Description
        -----------
        Reads directory part components from file; dp is the literal directory part, ir detains entities referenced by dp.

        """
        return _IGESData.IGESData_IGESReaderTool_ReadDir(self, *args)

    def ReadOwnParams(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Return
        -------
        None

        Description
        -----------
        Performs reading of own parameters for each igesentity works with the readerlib loaded with readwritemodules for iges in case of failure, tries undefinedentity from iges.

        """
        return _IGESData.IGESData_IGESReaderTool_ReadOwnParams(self, *args)

    def ReadProps(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Return
        -------
        None

        Description
        -----------
        Reads property list, if there is (if not, does nothing) criterium is: current parameter of pr remains inside params list, and stage is 'own' current parameter must be a positive integer, which value gives the length of the list; else, a fail is produced (into check of pr) and reading process is stopped.

        """
        return _IGESData.IGESData_IGESReaderTool_ReadProps(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESReaderTool

# Register IGESData_IGESReaderTool in _IGESData:
_IGESData.IGESData_IGESReaderTool_swigregister(IGESData_IGESReaderTool)
class IGESData_IGESType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        atype: int
        aform: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _IGESData.IGESData_IGESType_swiginit(self, _IGESData.new_IGESData_IGESType(*args))

    def Form(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns 'form' data.

        """
        return _IGESData.IGESData_IGESType_Form(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        another: IGESData_IGESType

        Return
        -------
        bool

        Description
        -----------
        Compares two igestypes, avoiding comparing their fields.

        """
        return _IGESData.IGESData_IGESType_IsEqual(self, *args)

    def Nullify(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Resets fields (useful when an igestype is stored as mask).

        """
        return _IGESData.IGESData_IGESType_Nullify(self, *args)

    def Type(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns 'type' data.

        """
        return _IGESData.IGESData_IGESType_Type(self, *args)

    def __eq_wrapper__(self, other):
        return _IGESData.IGESData_IGESType___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESType

# Register IGESData_IGESType in _IGESData:
_IGESData.IGESData_IGESType_swigregister(IGESData_IGESType)
class IGESData_IGESWriter(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        amodel: IGESData_IGESModel

        Return
        -------
        None

        Description
        -----------
        Creates an igeswriter, empty ready to work (see the methods sendmodel and print).
        Return
        -------
        None

        Description
        -----------
        Default constructor (not used) to satisfy the compiler.

        Parameters
        ----------
        other: IGESData_IGESWriter

        Return
        -------
        None

        Description
        -----------
        Constructor by copy (not used) to satisfy the compiler.

        """
        _IGESData.IGESData_IGESWriter_swiginit(self, _IGESData.new_IGESData_IGESWriter(*args))

    def Associativities(self, *args):
        r"""

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sends associativity list, as complement of parameters list error if not in sections dp or stage not 'associativity'.

        """
        return _IGESData.IGESData_IGESWriter_Associativities(self, *args)

    def DirPart(self, *args):
        r"""

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Translates directory part of an entity into a literal dirpart some infos are computed after sending parameters error if not in sections dp or stage not 'dir'.

        """
        return _IGESData.IGESData_IGESWriter_DirPart(self, *args)

    def EndEntity(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Declares end of sending an entity (ends param list by ';').

        """
        return _IGESData.IGESData_IGESWriter_EndEntity(self, *args)

    def FloatWriter(self, *args):
        r"""
        Return
        -------
        Interface_FloatWriter

        Description
        -----------
        Returns the embedded floatwriter, which controls sending reals use this method to access floatwriter in order to consult or change its options (mainformat, formatforrange,zerosuppress), because it is returned as the address of its field.

        """
        return _IGESData.IGESData_IGESWriter_FloatWriter(self, *args)

    def OwnParams(self, *args):
        r"""

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sends own parameters of the entity, by sending firstly its type, then calling specific method writeownparams error if not in sections dp or stage not 'own'.

        """
        return _IGESData.IGESData_IGESWriter_OwnParams(self, *args)

    def PrintToString(self):
        r"""PrintToString(IGESData_IGESWriter self) -> std::string"""
        return _IGESData.IGESData_IGESWriter_PrintToString(self)

    def Properties(self, *args):
        r"""

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sends property list, as complement of parameters list error if not in sections dp or stage not 'property'.

        """
        return _IGESData.IGESData_IGESWriter_Properties(self, *args)

    def SectionG(self, *args):
        r"""

        Parameters
        ----------
        header: IGESData_GlobalSection

        Return
        -------
        None

        Description
        -----------
        Prepares sending of header, from a globalsection (stores it) error if sections was not called just before takes in account special characters (separator, endmark).

        """
        return _IGESData.IGESData_IGESWriter_SectionG(self, *args)

    def SectionS(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Declares sending of s section (only a declaration) error if state is not initial.

        """
        return _IGESData.IGESData_IGESWriter_SectionS(self, *args)

    def SectionStrings(self, *args):
        r"""

        Parameters
        ----------
        numsec: int

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        Description
        -----------
        Returns the list of strings for a section given its rank 1: start (if not empty) 2: global 3 or 4: parameters rq: no string list for directory section an empty section gives a null handle.

        """
        return _IGESData.IGESData_IGESWriter_SectionStrings(self, *args)

    def SectionT(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Declares sending of t section (only a declaration) error if does not follow entities sending.

        """
        return _IGESData.IGESData_IGESWriter_SectionT(self, *args)

    def SectionsDP(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Prepares sending of list of entities, as sections d (directory list) and p (parameters lists, one per entity) entities will be then processed, one after the other error if sectiong has not be called just before.

        """
        return _IGESData.IGESData_IGESWriter_SectionsDP(self, *args)

    def SendBoolean(self, *args):
        r"""

        Parameters
        ----------
        val: bool

        Return
        -------
        None

        Description
        -----------
        Sends a boolean parameter as an integer value 0(false)/1(true).

        """
        return _IGESData.IGESData_IGESWriter_SendBoolean(self, *args)

    def SendModel(self, *args):
        r"""

        Parameters
        ----------
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Sends the complete igesmodel (global section, entities as directory entries & parameter lists, etc...) i.e. fills a list of texts. once filled, it can be sent by method print.

        """
        return _IGESData.IGESData_IGESWriter_SendModel(self, *args)

    def SendStartLine(self, *args):
        r"""

        Parameters
        ----------
        startline: str

        Return
        -------
        None

        Description
        -----------
        Sends an additional starting line: this is the way used to send comments in an iges file (at beginning of the file). if the line is more than 72 char.s long, it is splited into as many lines as required to send it completely.

        """
        return _IGESData.IGESData_IGESWriter_SendStartLine(self, *args)

    def SendString(self, *args):
        r"""

        Parameters
        ----------
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        Sends a parameter under its exact form given as a string.

        """
        return _IGESData.IGESData_IGESWriter_SendString(self, *args)

    def SendVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sends a void parameter, that is null text.

        """
        return _IGESData.IGESData_IGESWriter_SendVoid(self, *args)

    def GetWriteMode(self):
        r"""GetWriteMode(IGESData_IGESWriter self) -> Standard_Integer"""
        return _IGESData.IGESData_IGESWriter_GetWriteMode(self)

    def SetWriteMode(self, value):
        r"""SetWriteMode(IGESData_IGESWriter self, Standard_Integer value)"""
        return _IGESData.IGESData_IGESWriter_SetWriteMode(self, value)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Send(self):
    	pass

    __swig_destroy__ = _IGESData.delete_IGESData_IGESWriter

# Register IGESData_IGESWriter in _IGESData:
_IGESData.IGESData_IGESWriter_swigregister(IGESData_IGESWriter)
class IGESData_NodeOfSpecificLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty node, with no next.

        """
        _IGESData.IGESData_NodeOfSpecificLib_swiginit(self, _IGESData.new_IGESData_NodeOfSpecificLib(*args))

    def AddNode(self, *args):
        r"""

        Parameters
        ----------
        anode: IGESData_GlobalNodeOfSpecificLib

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module,protocol), that is, stores it into itself if not yet done, else creates a next node to do it.

        """
        return _IGESData.IGESData_NodeOfSpecificLib_AddNode(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_SpecificModule>

        Description
        -----------
        Returns the module designated by a precise node.

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Module(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_NodeOfSpecificLib>

        Description
        -----------
        Returns the next node. if none was defined, returned value is a null handle.

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the protocol designated by a precise node.

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NodeOfSpecificLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NodeOfSpecificLib

# Register IGESData_NodeOfSpecificLib in _IGESData:
_IGESData.IGESData_NodeOfSpecificLib_swigregister(IGESData_NodeOfSpecificLib)
class IGESData_NodeOfWriterLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty node, with no next.

        """
        _IGESData.IGESData_NodeOfWriterLib_swiginit(self, _IGESData.new_IGESData_NodeOfWriterLib(*args))

    def AddNode(self, *args):
        r"""

        Parameters
        ----------
        anode: IGESData_GlobalNodeOfWriterLib

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module,protocol), that is, stores it into itself if not yet done, else creates a next node to do it.

        """
        return _IGESData.IGESData_NodeOfWriterLib_AddNode(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        Description
        -----------
        Returns the module designated by a precise node.

        """
        return _IGESData.IGESData_NodeOfWriterLib_Module(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_NodeOfWriterLib>

        Description
        -----------
        Returns the next node. if none was defined, returned value is a null handle.

        """
        return _IGESData.IGESData_NodeOfWriterLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the protocol designated by a precise node.

        """
        return _IGESData.IGESData_NodeOfWriterLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NodeOfWriterLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NodeOfWriterLib

# Register IGESData_NodeOfWriterLib in _IGESData:
_IGESData.IGESData_NodeOfWriterLib_swigregister(IGESData_NodeOfWriterLib)
class IGESData_ParamCursor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Creates a cursor to read a precise parameter of paramreader, identified by its number, then set current number to 'num + 1' (this constructor allows to simply give a number to a method read... from paramreader, which will be translated into a paramcursor by compiler).

        Parameters
        ----------
        num: int
        nb: int
        size: int (optional, default to 1)

        Return
        -------
        None

        Description
        -----------
        Creates a cursor to read a list of parameters (count 'nb') starting from a precise one (number 'num') included, then set current number of paramnumber to the first following one ('num + nb') if size is given, it means that each parameter is made of more than one term. one term is the normal (default) case: for instance, a parameter comprises one integer, or one entity ... size gives the complete size of each item if it is complex. to be used only if it is constant.

        """
        _IGESData.IGESData_ParamCursor_swiginit(self, _IGESData.new_IGESData_ParamCursor(*args))

    def Advance(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if advance command has been set.

        """
        return _IGESData.IGESData_ParamCursor_Advance(self, *args)

    def Count(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns required count of items to be read.

        """
        return _IGESData.IGESData_ParamCursor_Count(self, *args)

    def ItemSize(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns length of item (count of parameters per item).

        """
        return _IGESData.IGESData_ParamCursor_ItemSize(self, *args)

    def Limit(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns (excluded) upper limit number for reading parameters.

        """
        return _IGESData.IGESData_ParamCursor_Limit(self, *args)

    def Offset(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns offset from which current term must be read in item.

        """
        return _IGESData.IGESData_ParamCursor_Offset(self, *args)

    def SetAdvance(self, *args):
        r"""

        Parameters
        ----------
        advance: bool

        Return
        -------
        None

        Description
        -----------
        Changes command to advance current cursor after reading parameters. if 'advance' true, sets advance, if 'false', resets it. paramcursor is created by default with true.

        """
        return _IGESData.IGESData_ParamCursor_SetAdvance(self, *args)

    def SetOne(self, *args):
        r"""

        Parameters
        ----------
        autoadv: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Defines a term of one parameter (very current case).

        """
        return _IGESData.IGESData_ParamCursor_SetOne(self, *args)

    def SetTerm(self, *args):
        r"""

        Parameters
        ----------
        size: int
        autoadv: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Defines the size of a term to read in the item: this commands paramreader to read 'size' parameters for each item, then skip the remainder of the item to the same term of next item (that is, skip 'item size' - 'term size') //! in addition, offset from beginning of item is managed: after being created, and for the first call to setterm, the part of item to be read begins exactly as the item begins but after a setterm, the next read will add an offset which is the size of former term. //! autoadv commands advance management. if it is true (default), the last setterm (item size has been covered) calls setadvance if it is false, setadvance must be called directly if necessary //! error if a setterm overpasses the size of the item.

        """
        return _IGESData.IGESData_ParamCursor_SetTerm(self, *args)

    def SetXY(self, *args):
        r"""

        Parameters
        ----------
        autoadv: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Defines a term of two parameters for a xy (current case).

        """
        return _IGESData.IGESData_ParamCursor_SetXY(self, *args)

    def SetXYZ(self, *args):
        r"""

        Parameters
        ----------
        autoadv: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Defines a term of three parameters for xyz (current case).

        """
        return _IGESData.IGESData_ParamCursor_SetXYZ(self, *args)

    def Start(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns (included) starting number for reading parameters.

        """
        return _IGESData.IGESData_ParamCursor_Start(self, *args)

    def TermSize(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns length of current term (count of parameters) in item.

        """
        return _IGESData.IGESData_ParamCursor_TermSize(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ParamCursor

# Register IGESData_ParamCursor in _IGESData:
_IGESData.IGESData_ParamCursor_swigregister(IGESData_ParamCursor)
class IGESData_ParamReader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        list: Interface_ParamList
        ach: Interface_Check
        base: int (optional, default to 1)
        nbpar: int (optional, default to 0)
        num: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Prepares a paramreader, stage 'own', current param = 1 it considers a part of the list, from <base> (excluded) for <nbpar> parameters; <nbpar> = 0 commands to take list length. default is (1 to skip type).

        """
        _IGESData.IGESData_ParamReader_swiginit(self, _IGESData.new_IGESData_ParamReader(*args))

    def AddFail(self, *args):
        r"""

        Parameters
        ----------
        afail: str
        bfail: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        af: TCollection_HAsciiString
        bf: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        Feeds the check with a new fail (as a string or as a cstring).

        """
        return _IGESData.IGESData_ParamReader_AddFail(self, *args)

    def AddWarning(self, *args):
        r"""

        Parameters
        ----------
        awarn: str
        bwarn: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aw: TCollection_HAsciiString
        bw: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        Feeds the check with a new warning message.

        """
        return _IGESData.IGESData_ParamReader_AddWarning(self, *args)

    def CCheck(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_Check>

        Description
        -----------
        Returns the check in a way which allows to work on it directly (i.e. messages added to the check are added to paramreader too).

        """
        return _IGESData.IGESData_ParamReader_CCheck(self, *args)

    def Check(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_Check>

        Description
        -----------
        Returns the check note that any error signaled above is also recorded into it.

        """
        return _IGESData.IGESData_ParamReader_Check(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Resets state (stage, current param number, check with no fail).

        """
        return _IGESData.IGESData_ParamReader_Clear(self, *args)

    def Current(self, *args):
        r"""
        Return
        -------
        IGESData_ParamCursor

        Description
        -----------
        Creates a paramcursor from the current number, to read one parameter, and to advance current number after reading.

        """
        return _IGESData.IGESData_ParamReader_Current(self, *args)

    def CurrentList(self, *args):
        r"""

        Parameters
        ----------
        nb: int
        size: int (optional, default to 1)

        Return
        -------
        IGESData_ParamCursor

        Description
        -----------
        Creates a paramcursor from the current number, to read a list of 'nb' items, and to advance current number after reading by default, each item is made of one parameter if size is given, it precises the number of params per item.

        """
        return _IGESData.IGESData_ParamReader_CurrentList(self, *args)

    def CurrentNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the current parameter number this notion is involved by the organisation of an iges list of parameter: it can be ended by two lists (associativities and properties), which can be empty, or even absent. hence, it is necessary to know, at the end of specific reading, how many parameters have been read: the optional lists follow.

        """
        return _IGESData.IGESData_ParamReader_CurrentNumber(self, *args)

    def DefinedElseSkip(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Allows to simply process a parameter which can be defaulted. waits on the current number a defined parameter or skips it: if the parameter <num> is defined, changes nothing and returns true hence, the next reading with current cursor will concern <num> if it is void, advances current position by one, and returns false the next reading will concern <num+1> (except if <num> = nbparams) //! this allows to process default values as follows (c++): if (pr.definedelseskip()) { .. pr.read... (current parameter); } else { <current parameter> = default value .. nothing else to do with paramreader } for message.

        """
        return _IGESData.IGESData_ParamReader_DefinedElseSkip(self, *args)

    def EndAll(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Passes directly to the end of reading process.

        """
        return _IGESData.IGESData_ParamReader_EndAll(self, *args)

    def EntityNumber(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the entity number in the file.

        """
        return _IGESData.IGESData_ParamReader_EntityNumber(self, *args)

    def HasFailed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Says if fails have been recorded into the check.

        """
        return _IGESData.IGESData_ParamReader_HasFailed(self, *args)

    def IsCheckEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the check is empty else, it has to be recorded with the read entity.

        """
        return _IGESData.IGESData_ParamReader_IsCheckEmpty(self, *args)

    def IsParamDefined(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Says if a parameter is defined (not void) see also definedelseskip.

        """
        return _IGESData.IGESData_ParamReader_IsParamDefined(self, *args)

    def IsParamEntity(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Says if a parameter can be regarded as an entity reference (see prepare from igesreaderdata for more explanation) note that such a parameter can seen as be a plain integer too.

        """
        return _IGESData.IGESData_ParamReader_IsParamEntity(self, *args)

    def Mend(self, *args):
        r"""

        Parameters
        ----------
        pref: str (optional, default to )

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_ParamReader_Mend(self, *args)

    def NbParams(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of parameters (minus the first one) following method skip the first parameter (1 gives the 2nd).

        """
        return _IGESData.IGESData_ParamReader_NbParams(self, *args)

    def NextStage(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Passes to next stage (must be linked with setting current).

        """
        return _IGESData.IGESData_ParamReader_NextStage(self, *args)

    def ParamEntity(self, *args):
        r"""

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        num: int

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Directly returns entity referenced by a parameter.

        """
        return _IGESData.IGESData_ParamReader_ParamEntity(self, *args)

    def ParamNumber(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        int

        Description
        -----------
        Returns entity number corresponding to a parameter if there is otherwise zero (according criterium isparamentity).

        """
        return _IGESData.IGESData_ParamReader_ParamNumber(self, *args)

    def ParamType(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        Interface_ParamType

        Description
        -----------
        Returns type of parameter; note that 'ident' or 'sub' cannot be encountered, they correspond to 'integer', see also below.

        """
        return _IGESData.IGESData_ParamReader_ParamType(self, *args)

    def ParamValue(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        str

        Description
        -----------
        Returns literal value of a parameter, as it was in file.

        """
        return _IGESData.IGESData_ParamReader_ParamValue(self, *args)

    def ReadBoolean(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        exact: bool (optional, default to Standard_True)

        Return
        -------
        val: bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        exact: bool (optional, default to Standard_True)

        Return
        -------
        val: bool

        Description
        -----------
        Reads a boolean value from parameter 'num' a boolean is given as an integer value 0 (false) or 1 (true) anyway, an integer is demanded (else, check is filled) if exact is given true, those precise values are demanded else, correction is done, as false for 0 or <0, true for >0 (with a warning error message, and return is true) in case of error (not an integer, or not 0/1 and exact true), check is filled with a fail (using mess) and return is false.

        """
        return _IGESData.IGESData_ParamReader_ReadBoolean(self, *args)

    def ReadEntList(self, *args):
        r"""

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: Interface_EntityList
        ord: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        mess: str
        val: Interface_EntityList
        ord: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        Reads a list of entities defined by pc same conditions as for readents, for pc the list is given as an entitylist (index has no meaning; the entitylist starts from clear) if 'ord' is given true (default), entities will be added to the list in their original order remark: negative or null pointers are ignored else ('ord' false), order is not guaranteed (faster mode) if all params cannot be read as entities, same as above warning give 'ord' to false only if order is not significant.

        """
        return _IGESData.IGESData_ParamReader_ReadEntList(self, *args)

    def ReadEnts(self, *args):
        r"""

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: IGESData_HArray1OfIGESEntity
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        mess: str
        val: IGESData_HArray1OfIGESEntity
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        Reads a list of entities defined by pc same conditions as for readints, for pc and index the list is given as a harray1, numered from 'index' if all params cannot be read as entities, check is filled (using mess) and return value is false remark: null references are accepted, they are ignored (negative pointers too: they provoke a warning message) if the caller wants to check them, a loop on readentity should be used.

        """
        return _IGESData.IGESData_ParamReader_ReadEnts(self, *args)

    def ReadInteger(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor

        Return
        -------
        val: int

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str

        Return
        -------
        val: int

        Description
        -----------
        Reads an integer value designated by pc the method current designates the current parameter and advances the current number by one after reading note that if a count (not 1) is given, it is ignored if it is not an integer, fills check with a fail (using mess) and returns false.

        """
        return _IGESData.IGESData_ParamReader_ReadInteger(self, *args)

    def ReadInts(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: TColStd_HArray1OfInteger
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        val: TColStd_HArray1OfInteger
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        Reads a list of integer values, defined by pc (with a count of parameters). pc can start from current number and command it to advance after reading (use method currentlist to do this) the list is given as a harray1, numered from 'index' if all params are not integer, check is filled (using mess) and return value is false.

        """
        return _IGESData.IGESData_ParamReader_ReadInts(self, *args)

    def ReadReal(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor

        Return
        -------
        val: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str

        Return
        -------
        val: float

        Description
        -----------
        Reads a real value from parameter 'num' an integer is accepted (check is filled with a warning message) and causes return to be true (as normal case) in other cases, check is filled with a fail and return is false.

        """
        return _IGESData.IGESData_ParamReader_ReadReal(self, *args)

    def ReadReals(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: TColStd_HArray1OfReal
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        val: TColStd_HArray1OfReal
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        Reads a list of real values defined by pc same conditions as for readints, for pc and index an integer parameter is accepted, if at least one parameter is integer, check is filled with a 'warning' message if all params are neither real nor integer, check is filled (using mess) and return value is false.

        """
        return _IGESData.IGESData_ParamReader_ReadReals(self, *args)

    def ReadText(self, *args):
        r"""

        Parameters
        ----------
        thePC: IGESData_ParamCursor
        theMsg: Message_Msg

        Return
        -------
        theVal: TCollection_HAsciiString

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str

        Return
        -------
        val: TCollection_HAsciiString

        Description
        -----------
        Reads a text value from parameter 'num', as a string from collection, that is, hollerith text without leading 'nnnh' if it is not a string, fills check with a fail (using mess) and returns false.

        """
        return _IGESData.IGESData_ParamReader_ReadText(self, *args)

    def ReadTexts(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: Interface_HArray1OfHAsciiString
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        val: Interface_HArray1OfHAsciiString
        index: int (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        Reads a list of hollerith texts, defined by pc texts are read as hollerith texts without leading 'nnnh' same conditions as for readints, for pc and index if all params are not text, check is filled (using mess) and return value is false.

        """
        return _IGESData.IGESData_ParamReader_ReadTexts(self, *args)

    def ReadXY(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: gp_XY

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        val: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Reads a couple of real values (x,y) from parameter 'num' integers are accepted (check is filled with a warning message) and cause return to be true (as normal case) in other cases, check is filled with a fail and return is false.

        """
        return _IGESData.IGESData_ParamReader_ReadXY(self, *args)

    def ReadXYZ(self, *args):
        r"""

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: gp_XYZ

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: str
        val: gp_XYZ

        Return
        -------
        bool

        Description
        -----------
        Reads a triplet of real values (x,y,z) from parameter 'num' integers are accepted (check is filled with a warning message) and cause return to be true (as normal case) in other cases, check is filled with a fail and return is false for message.

        """
        return _IGESData.IGESData_ParamReader_ReadXYZ(self, *args)

    def ReadingEntityNumber(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        val: int

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        num: int
        mess: str

        Return
        -------
        val: int

        Description
        -----------
        Routine which reads an entity number (which allows to read the entity in the igesreaderdata by boundentity), given its number in the list of parameters same conditions as readentity for mess, val, and return value in particular, returns true and val to zero means null entity, and val not zero means entity read by boundentity.

        """
        return _IGESData.IGESData_ParamReader_ReadingEntityNumber(self, *args)

    def ReadingReal(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        val: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        num: int
        mess: str

        Return
        -------
        val: float

        Description
        -----------
        Routine which reads a real parameter, given its number same conditions as readreal for mess, val, and return value.

        """
        return _IGESData.IGESData_ParamReader_ReadingReal(self, *args)

    def SendFail(self, *args):
        r"""

        Parameters
        ----------
        amsg: Message_Msg

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_ParamReader_SendFail(self, *args)

    def SendWarning(self, *args):
        r"""

        Parameters
        ----------
        amsg: Message_Msg

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _IGESData.IGESData_ParamReader_SendWarning(self, *args)

    def SetCurrentNumber(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Sets current parameter number to a new value must be done at end of each step: set on first parameter following last read one; is done by some read... methods (must be done directly if these method are not used) num greater than nbparams means that following lists are empty if current num is not managed, it remains at 1, which probably will cause error when successive steps of reading are made.

        """
        return _IGESData.IGESData_ParamReader_SetCurrentNumber(self, *args)

    def Stage(self, *args):
        r"""
        Return
        -------
        IGESData_ReadStage

        Description
        -----------
        Gives current stage (own-props-assocs-end, begins at own).

        """
        return _IGESData.IGESData_ParamReader_Stage(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ReadEntity(self):
    	pass

    __swig_destroy__ = _IGESData.delete_IGESData_ParamReader

# Register IGESData_ParamReader in _IGESData:
_IGESData.IGESData_ParamReader_swigregister(IGESData_ParamReader)
class IGESData_Protocol(OCC.Core.Interface.Interface_Protocol):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _IGESData.IGESData_Protocol_swiginit(self, _IGESData.new_IGESData_Protocol(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_Protocol_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_Protocol

# Register IGESData_Protocol in _IGESData:
_IGESData.IGESData_Protocol_swigregister(IGESData_Protocol)
class IGESData_ReadWriteModule(OCC.Core.Interface.Interface_ReaderModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def CaseIGES(self, *args):
        r"""

        Parameters
        ----------
        typenum: int
        formnum: int

        Return
        -------
        int

        Description
        -----------
        Defines case numbers corresponding to the entity types taken into account by a sub-class of readwritemodule (hence, each sub-class of readwritemodule has to redefine this method) called by casenum. its result will then be used to call read, etc ...

        """
        return _IGESData.IGESData_ReadWriteModule_CaseIGES(self, *args)

    def ReadOwnParams(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Return
        -------
        None

        Description
        -----------
        Reads own parameters from file for an entity; <pr> gives access to them, <ir> detains parameter types and values for each class, there must be a specific action provided note that properties and associativities lists are read by specific methods (see below), they are called under control of reading process (only one call) according stage recorded in paramreader.

        """
        return _IGESData.IGESData_ReadWriteModule_ReadOwnParams(self, *args)

    def WriteOwnParams(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        IW: IGESData_IGESWriter

        Return
        -------
        None

        Description
        -----------
        Writes own parameters to igeswriter; defined for each class (to be redefined for other iges readwritemodules) warning: properties and associativities are directly managed by writeiges, must not be sent by this method.

        """
        return _IGESData.IGESData_ReadWriteModule_WriteOwnParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ReadWriteModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ReadWriteModule

# Register IGESData_ReadWriteModule in _IGESData:
_IGESData.IGESData_ReadWriteModule_swigregister(IGESData_ReadWriteModule)
class IGESData_SpecificLib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates a library which complies with a protocol, that is: same class (criterium isinstance) this creation gets the modules from the global set, those which are bound to the given protocol and its resources.
        Return
        -------
        None

        Description
        -----------
        Creates an empty library: it will later by filled by method addprotocol.

        """
        _IGESData.IGESData_SpecificLib_swiginit(self, _IGESData.new_IGESData_SpecificLib(*args))

    def AddProtocol(self, *args):
        r"""

        Parameters
        ----------
        aprotocol: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module-protocol) to the library, given the class of a protocol. takes resources into account. (if <aprotocol> is not of type theprotocol, it is not added).

        """
        return _IGESData.IGESData_SpecificLib_AddProtocol(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the list of modules of a library (can be used to redefine the order of modules before action: clear then refill the library by calls to addprotocol).

        """
        return _IGESData.IGESData_SpecificLib_Clear(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_SpecificModule>

        Description
        -----------
        Returns the current module in the iteration.

        """
        return _IGESData.IGESData_SpecificLib_Module(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there are more modules to iterate on.

        """
        return _IGESData.IGESData_SpecificLib_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Iterates by getting the next module in the list if there is none, the exception will be raised by value.

        """
        return _IGESData.IGESData_SpecificLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the current protocol in the iteration.

        """
        return _IGESData.IGESData_SpecificLib_Protocol(self, *args)

    def Select(self, *args):
        r"""

        Parameters
        ----------
        obj: IGESData_IGESEntity
        module: IGESData_SpecificModule

        Return
        -------
        CN: int

        Description
        -----------
        Selects a module from the library, given an object. returns true if select has succeeded, false else. also returns (as arguments) the selected module and the case number determined by the associated protocol. if select has failed, <module> is null handle and cn is zero. (select can work on any criterium, such as object dynamictype).

        """
        return _IGESData.IGESData_SpecificLib_Select(self, *args)

    def SetComplete(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets a library to be defined with the complete global list (all the couples protocol/modules recorded in it).

        """
        return _IGESData.IGESData_SpecificLib_SetComplete(self, *args)

    @staticmethod
    def SetGlobal(*args):
        r"""

        Parameters
        ----------
        amodule: IGESData_SpecificModule
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module-protocol) into the global definition set for this class of library.

        """
        return _IGESData.IGESData_SpecificLib_SetGlobal(*args)

    def Start(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Starts iteration on the modules (sets it on the first one).

        """
        return _IGESData.IGESData_SpecificLib_Start(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SpecificLib

# Register IGESData_SpecificLib in _IGESData:
_IGESData.IGESData_SpecificLib_swigregister(IGESData_SpecificLib)
class IGESData_SpecificModule(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def OwnCorrect(self, *args):
        r"""

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Specific automatic correction on own parameters of an entity. it works by setting in accordance redundant data, if there are when there is no ambiguity (else, it does nothing). remark that classic corrections on directory entry (to set void data) are taken into account alsewhere. //! for instance, many 'associativity entities' have a number of properties which must have a fixed value. or, a conicalarc has its form number which records the kind of conic, also determined from its coefficients but, a circulararc of which distances (center-start) and (center-end) are not equal cannot be corrected ... //! returns true if something has been corrected in <ent> by default, does nothing. if at least one of the types processed by a sub-class of specificmodule has a correct procedure attached, this method can be redefined.

        """
        return _IGESData.IGESData_SpecificModule_OwnCorrect(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_SpecificModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SpecificModule

# Register IGESData_SpecificModule in _IGESData:
_IGESData.IGESData_SpecificModule_swigregister(IGESData_SpecificModule)
class IGESData_ToolLocation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        amodel: IGESData_IGESModel
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates a toollocation on a given model, filled with the help of a protocol (which allows to known entities referenced by other ones).

        """
        _IGESData.IGESData_ToolLocation_swiginit(self, _IGESData.new_IGESData_ToolLocation(*args))

    def AnalyseLocation(self, *args):
        r"""

        Parameters
        ----------
        loc: gp_GTrsf
        result: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Analysis a location given as a gtrsf, by trying to convert it to a trsf (i.e. to a true location of which effect is described by an isometry or a similarity) works with the precision given by default or by setprecision calls convertlocation (see below).

        """
        return _IGESData.IGESData_ToolLocation_AnalyseLocation(self, *args)

    @staticmethod
    def ConvertLocation(*args):
        r"""

        Parameters
        ----------
        prec: float
        loc: gp_GTrsf
        result: gp_Trsf
        uni: float (optional, default to 1)

        Return
        -------
        bool

        Description
        -----------
        Conversion of a location, from gtrsf form to trsf form works with a precision given as argument. returns true if the conversion is possible, (hence, <result> contains the converted location), false else <unit>, if given, indicates the unit in which <loc> is defined in meters. it concerns the translation part (to be converted. //! as a class method, it can be called separately.

        """
        return _IGESData.IGESData_ToolLocation_ConvertLocation(*args)

    def EffectiveLocation(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns the effective location of an entity, i.e. the composition of its proper transformation matrix (returned by transf) and its parent's location (returned by parentlocation).

        """
        return _IGESData.IGESData_ToolLocation_EffectiveLocation(self, *args)

    def ExplicitLocation(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns the explicit location defined by the transformation matrix of <ent>. identity if there is none.

        """
        return _IGESData.IGESData_ToolLocation_ExplicitLocation(self, *args)

    def HasParent(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if <ent> is dependent from one and only one other entity, either by reference or by associativity.

        """
        return _IGESData.IGESData_ToolLocation_HasParent(self, *args)

    def HasParentByAssociativity(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if the parent, if there is one, is defined by a singleparententity associativity else, if hasparent is true, it is by reference.

        """
        return _IGESData.IGESData_ToolLocation_HasParentByAssociativity(self, *args)

    def HasTransf(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if <ent> has a transformation matrix in proper (referenced from its directory part).

        """
        return _IGESData.IGESData_ToolLocation_HasTransf(self, *args)

    def IsAmbiguous(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if more than one parent has been determined for <ent>, by adding direct references and associativities.

        """
        return _IGESData.IGESData_ToolLocation_IsAmbiguous(self, *args)

    def IsAssociativity(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if <ent> is an associativity (iges type 402). then, location does not apply.

        """
        return _IGESData.IGESData_ToolLocation_IsAssociativity(self, *args)

    def IsTransf(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        bool

        Description
        -----------
        Returns true if <ent> is kind of transfentity. then, it has no location, while it can be used to define a location).

        """
        return _IGESData.IGESData_ToolLocation_IsTransf(self, *args)

    def Load(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Does the effective work of determining locations of entities.

        """
        return _IGESData.IGESData_ToolLocation_Load(self, *args)

    def Parent(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the unique parent recorded for <ent>. returns a null handle if there is none.

        """
        return _IGESData.IGESData_ToolLocation_Parent(self, *args)

    def ParentLocation(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        gp_GTrsf

        Description
        -----------
        Returns the effective location of the parent of <ent>, if there is one: this location is itself given as compound according dependences on the parent, if there are some. returns an identity transformation if no parent is recorded.

        """
        return _IGESData.IGESData_ToolLocation_ParentLocation(self, *args)

    def ResetDependences(self, *args):
        r"""

        Parameters
        ----------
        child: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Resets all information about dependences for <child>.

        """
        return _IGESData.IGESData_ToolLocation_ResetDependences(self, *args)

    def SetOwnAsDependent(self, *args):
        r"""

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Unitary action which defines entities referenced by <ent> (except those in directory part and associativities list) as dependent (their locations are related to that of <ent>).

        """
        return _IGESData.IGESData_ToolLocation_SetOwnAsDependent(self, *args)

    def SetParentAssoc(self, *args):
        r"""

        Parameters
        ----------
        parent: IGESData_IGESEntity
        child: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sets the 'associativity' information for <child> as being <parent> (it must be the parent itself, not the associativity).

        """
        return _IGESData.IGESData_ToolLocation_SetParentAssoc(self, *args)

    def SetPrecision(self, *args):
        r"""

        Parameters
        ----------
        prec: float

        Return
        -------
        None

        Description
        -----------
        Sets a precision for the analysis of locations (default by constructor is 1.e-05).

        """
        return _IGESData.IGESData_ToolLocation_SetPrecision(self, *args)

    def SetReference(self, *args):
        r"""

        Parameters
        ----------
        parent: IGESData_IGESEntity
        child: IGESData_IGESEntity

        Return
        -------
        None

        Description
        -----------
        Sets the 'reference' information for <child> as being <parent> sets an error status if already set (see method isambiguous).

        """
        return _IGESData.IGESData_ToolLocation_SetReference(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ToolLocation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ToolLocation

# Register IGESData_ToolLocation in _IGESData:
_IGESData.IGESData_ToolLocation_swigregister(IGESData_ToolLocation)
class IGESData_WriterLib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Creates a library which complies with a protocol, that is: same class (criterium isinstance) this creation gets the modules from the global set, those which are bound to the given protocol and its resources.
        Return
        -------
        None

        Description
        -----------
        Creates an empty library: it will later by filled by method addprotocol.

        """
        _IGESData.IGESData_WriterLib_swiginit(self, _IGESData.new_IGESData_WriterLib(*args))

    def AddProtocol(self, *args):
        r"""

        Parameters
        ----------
        aprotocol: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module-protocol) to the library, given the class of a protocol. takes resources into account. (if <aprotocol> is not of type theprotocol, it is not added).

        """
        return _IGESData.IGESData_WriterLib_AddProtocol(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the list of modules of a library (can be used to redefine the order of modules before action: clear then refill the library by calls to addprotocol).

        """
        return _IGESData.IGESData_WriterLib_Clear(self, *args)

    def Module(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        Description
        -----------
        Returns the current module in the iteration.

        """
        return _IGESData.IGESData_WriterLib_Module(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there are more modules to iterate on.

        """
        return _IGESData.IGESData_WriterLib_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Iterates by getting the next module in the list if there is none, the exception will be raised by value.

        """
        return _IGESData.IGESData_WriterLib_Next(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_Protocol>

        Description
        -----------
        Returns the current protocol in the iteration.

        """
        return _IGESData.IGESData_WriterLib_Protocol(self, *args)

    def Select(self, *args):
        r"""

        Parameters
        ----------
        obj: IGESData_IGESEntity
        module: IGESData_ReadWriteModule

        Return
        -------
        CN: int

        Description
        -----------
        Selects a module from the library, given an object. returns true if select has succeeded, false else. also returns (as arguments) the selected module and the case number determined by the associated protocol. if select has failed, <module> is null handle and cn is zero. (select can work on any criterium, such as object dynamictype).

        """
        return _IGESData.IGESData_WriterLib_Select(self, *args)

    def SetComplete(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets a library to be defined with the complete global list (all the couples protocol/modules recorded in it).

        """
        return _IGESData.IGESData_WriterLib_SetComplete(self, *args)

    @staticmethod
    def SetGlobal(*args):
        r"""

        Parameters
        ----------
        amodule: IGESData_ReadWriteModule
        aprotocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Adds a couple (module-protocol) into the global definition set for this class of library.

        """
        return _IGESData.IGESData_WriterLib_SetGlobal(*args)

    def Start(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Starts iteration on the modules (sets it on the first one).

        """
        return _IGESData.IGESData_WriterLib_Start(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_WriterLib

# Register IGESData_WriterLib in _IGESData:
_IGESData.IGESData_WriterLib_swigregister(IGESData_WriterLib)
class IGESData_ColorEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ColorEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_ColorEntity_swiginit(self, _IGESData.new_IGESData_ColorEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_ColorEntity

# Register IGESData_ColorEntity in _IGESData:
_IGESData.IGESData_ColorEntity_swigregister(IGESData_ColorEntity)
class IGESData_DefaultGeneral(IGESData_GeneralModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a defaultgeneral and puts it into generallib, bound with a protocol from igesdata.

        """
        _IGESData.IGESData_DefaultGeneral_swiginit(self, _IGESData.new_IGESData_DefaultGeneral(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_DefaultGeneral_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefaultGeneral

# Register IGESData_DefaultGeneral in _IGESData:
_IGESData.IGESData_DefaultGeneral_swigregister(IGESData_DefaultGeneral)
class IGESData_DefaultSpecific(IGESData_SpecificModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a defaultspecific and puts it into specificlib.

        """
        _IGESData.IGESData_DefaultSpecific_swiginit(self, _IGESData.new_IGESData_DefaultSpecific(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_DefaultSpecific_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefaultSpecific

# Register IGESData_DefaultSpecific in _IGESData:
_IGESData.IGESData_DefaultSpecific_swigregister(IGESData_DefaultSpecific)
class IGESData_FileProtocol(IGESData_Protocol):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns an empty fileprotocol.

        """
        _IGESData.IGESData_FileProtocol_swiginit(self, _IGESData.new_IGESData_FileProtocol(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        protocol: IGESData_Protocol

        Return
        -------
        None

        Description
        -----------
        Adds a resource.

        """
        return _IGESData.IGESData_FileProtocol_Add(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FileProtocol_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FileProtocol

# Register IGESData_FileProtocol in _IGESData:
_IGESData.IGESData_FileProtocol_swigregister(IGESData_FileProtocol)
class IGESData_LabelDisplayEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LabelDisplayEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_LabelDisplayEntity_swiginit(self, _IGESData.new_IGESData_LabelDisplayEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_LabelDisplayEntity

# Register IGESData_LabelDisplayEntity in _IGESData:
_IGESData.IGESData_LabelDisplayEntity_swigregister(IGESData_LabelDisplayEntity)
class IGESData_LevelListEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def HasLevelNumber(self, *args):
        r"""

        Parameters
        ----------
        level: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if <level> is in the list.

        """
        return _IGESData.IGESData_LevelListEntity_HasLevelNumber(self, *args)

    def LevelNumber(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        int

        Description
        -----------
        Returns the level number of <self>, indicated by <num> raises an exception if num is out of range.

        """
        return _IGESData.IGESData_LevelListEntity_LevelNumber(self, *args)

    def NbLevelNumbers(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Must return the count of levels.

        """
        return _IGESData.IGESData_LevelListEntity_NbLevelNumbers(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LevelListEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_LevelListEntity

# Register IGESData_LevelListEntity in _IGESData:
_IGESData.IGESData_LevelListEntity_swigregister(IGESData_LevelListEntity)
class IGESData_LineFontEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LineFontEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_LineFontEntity_swiginit(self, _IGESData.new_IGESData_LineFontEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_LineFontEntity

# Register IGESData_LineFontEntity in _IGESData:
_IGESData.IGESData_LineFontEntity_swigregister(IGESData_LineFontEntity)
class IGESData_NameEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Value(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Retyrns the alphanumeric value of the name, to be defined.

        """
        return _IGESData.IGESData_NameEntity_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NameEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NameEntity

# Register IGESData_NameEntity in _IGESData:
_IGESData.IGESData_NameEntity_swigregister(IGESData_NameEntity)
class IGESData_SingleParentEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Child(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns a child given its rank.

        """
        return _IGESData.IGESData_SingleParentEntity_Child(self, *args)

    def NbChildren(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the count of entities designated as children.

        """
        return _IGESData.IGESData_SingleParentEntity_NbChildren(self, *args)

    def SingleParent(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns the parent designated by the entity, if only one !.

        """
        return _IGESData.IGESData_SingleParentEntity_SingleParent(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_SingleParentEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SingleParentEntity

# Register IGESData_SingleParentEntity in _IGESData:
_IGESData.IGESData_SingleParentEntity_swigregister(IGESData_SingleParentEntity)
class IGESData_TransfEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Value(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Gives value of the transformation, as a gtrsf to be defined by an effective class of transformation entity warning: must take in account composition: if a transfentity has in its directory part, a transf, this means that it is compound, value must return the global result.

        """
        return _IGESData.IGESData_TransfEntity_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_TransfEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_TransfEntity

# Register IGESData_TransfEntity in _IGESData:
_IGESData.IGESData_TransfEntity_swigregister(IGESData_TransfEntity)
class IGESData_UndefinedEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an unknown entity.

        """
        _IGESData.IGESData_UndefinedEntity_swiginit(self, _IGESData.new_IGESData_UndefinedEntity(*args))

    def ChangeableContent(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_UndefinedContent>

        Description
        -----------
        Returns own data as an undefinedcontent, in order to touch it.

        """
        return _IGESData.IGESData_UndefinedEntity_ChangeableContent(self, *args)

    def DirStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns directory error status (used for copy).

        """
        return _IGESData.IGESData_UndefinedEntity_DirStatus(self, *args)

    def IsOKDirPart(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Says if dirpart is ok or not (if not, it is erroneous) note that if it is not, def* methods can return error status.

        """
        return _IGESData.IGESData_UndefinedEntity_IsOKDirPart(self, *args)

    def ReadDir(self, *args):
        r"""

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        DP: IGESData_DirPart
        ach: Interface_Check

        Return
        -------
        bool

        Description
        -----------
        Computes the directory error status, to be called before standard readdir from igesreadertool returns true if ok (hence, directory can be loaded), else returns false and the dirpart <dp> is modified (hence, directory error status is non null; and standard read will work with an acceptable directorypart).

        """
        return _IGESData.IGESData_UndefinedEntity_ReadDir(self, *args)

    def ReadOwnParams(self, *args):
        r"""

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Return
        -------
        None

        Description
        -----------
        Reads own parameters from file; pr gives access to them, ir detains parameter types and values here, reads all parameters, integers are considered as entity reference unless they cannot be; no list interpretation no property or associativity list is managed.

        """
        return _IGESData.IGESData_UndefinedEntity_ReadOwnParams(self, *args)

    def SetNewContent(self, *args):
        r"""

        Parameters
        ----------
        cont: Interface_UndefinedContent

        Return
        -------
        None

        Description
        -----------
        Redefines a completely new undefinedcontent used by a copy which begins by shallowcopy, for instance.

        """
        return _IGESData.IGESData_UndefinedEntity_SetNewContent(self, *args)

    def SetOKDirPart(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Erases the directory error status warning: be sure that data are consistent to call this method ...

        """
        return _IGESData.IGESData_UndefinedEntity_SetOKDirPart(self, *args)

    def UndefinedContent(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_UndefinedContent>

        Description
        -----------
        Returns own data as an undefinedcontent.

        """
        return _IGESData.IGESData_UndefinedEntity_UndefinedContent(self, *args)

    def WriteOwnParams(self, *args):
        r"""

        Parameters
        ----------
        IW: IGESData_IGESWriter

        Return
        -------
        None

        Description
        -----------
        Writes parameters to igeswriter, taken from undefinedcontent.

        """
        return _IGESData.IGESData_UndefinedEntity_WriteOwnParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_UndefinedEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_UndefinedEntity

# Register IGESData_UndefinedEntity in _IGESData:
_IGESData.IGESData_UndefinedEntity_swigregister(IGESData_UndefinedEntity)
class IGESData_ViewKindEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsSingle(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Says if 'me' is a single view (true) or a list of views (false).

        """
        return _IGESData.IGESData_ViewKindEntity_IsSingle(self, *args)

    def NbViews(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the count of views for a list of views. for a single view, may return simply 1.

        """
        return _IGESData.IGESData_ViewKindEntity_NbViews(self, *args)

    def ViewItem(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        Description
        -----------
        Returns the view n0. <num> for a list of views. for a single views, may return <self> itself.

        """
        return _IGESData.IGESData_ViewKindEntity_ViewItem(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ViewKindEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ViewKindEntity

# Register IGESData_ViewKindEntity in _IGESData:
_IGESData.IGESData_ViewKindEntity_swigregister(IGESData_ViewKindEntity)
class IGESData_FreeFormatEntity(IGESData_UndefinedEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a completely empty freeformatentity.

        """
        _IGESData.IGESData_FreeFormatEntity_swiginit(self, _IGESData.new_IGESData_FreeFormatEntity(*args))

    def AddEntities(self, *args):
        r"""

        Parameters
        ----------
        ents: IGESData_HArray1OfIGESEntity

        Return
        -------
        None

        Description
        -----------
        Adds a set of entities, given as a harray1ofigesentity causes creation of: an integer parameter which gives count of entities, then the list of entities of the array error if an entity is not an igesentity all these entities will be interpreted as 'positive pointers' by igeswriter.

        """
        return _IGESData.IGESData_FreeFormatEntity_AddEntities(self, *args)

    def AddEntity(self, *args):
        r"""

        Parameters
        ----------
        ptype: Interface_ParamType
        ent: IGESData_IGESEntity
        negative: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Adds a parameter which references an entity. if the entity is null, the added parameter will define a 'null pointer' (0) if <negative> is given true, this will command sending to file (see igeswriter) to produce a 'negative pointer' (default is false).

        """
        return _IGESData.IGESData_FreeFormatEntity_AddEntity(self, *args)

    def AddLiteral(self, *args):
        r"""

        Parameters
        ----------
        ptype: Interface_ParamType
        val: TCollection_HAsciiString

        Return
        -------
        None

        Description
        -----------
        Adds a literal parameter to the list (as such).

        Parameters
        ----------
        ptype: Interface_ParamType
        val: str

        Return
        -------
        None

        Description
        -----------
        Adds a literal parameter to the list (builds an hasciistring).

        """
        return _IGESData.IGESData_FreeFormatEntity_AddLiteral(self, *args)

    def AddNegativePointers(self, *args):
        r"""

        Parameters
        ----------
        list: TColStd_HSequenceOfInteger

        Return
        -------
        None

        Description
        -----------
        Adds a list of ranks of parameters to be noted as negative pointers (this will be taken into account for parameters which are entities).

        """
        return _IGESData.IGESData_FreeFormatEntity_AddNegativePointers(self, *args)

    def ClearNegativePointers(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all information about negative pointers, hence every entity kind parameter will be sent normally, as positive.

        """
        return _IGESData.IGESData_FreeFormatEntity_ClearNegativePointers(self, *args)

    def IsNegativePointer(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if <num> is noted as for a 'negative pointer' (see addentity for details). senseful only if isparamentity answers true for <num>, else returns false.

        """
        return _IGESData.IGESData_FreeFormatEntity_IsNegativePointer(self, *args)

    def IsParamEntity(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if a parameter is recorded as an entity error if num is not between 1 and nbparams.

        """
        return _IGESData.IGESData_FreeFormatEntity_IsParamEntity(self, *args)

    def NbParams(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Gives count of recorded parameters.

        """
        return _IGESData.IGESData_FreeFormatEntity_NbParams(self, *args)

    def NegativePointers(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfInteger>

        Description
        -----------
        Returns the complete list of ramks of parameters which have been noted as negative pointers warning: it is returned as a null handle if none was noted.

        """
        return _IGESData.IGESData_FreeFormatEntity_NegativePointers(self, *args)

    def ParamData(self, *args):
        r"""

        Parameters
        ----------
        num: int
        ptype: Interface_ParamType
        ent: IGESData_IGESEntity

        Return
        -------
        val: TCollection_HAsciiString

        Description
        -----------
        Returns data of a parameter: its type, and the entity if it designates en entity ('ent') or its literal value else ('str') returned value (boolean): true if it is an entity, false else.

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamData(self, *args)

    def ParamEntity(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        opencascade::handle<IGESData_IGESEntity>

        Description
        -----------
        Returns entity corresponding to a param, given its rank error if out of range or if param num does not designate an entity.

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamEntity(self, *args)

    def ParamType(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        Interface_ParamType

        Description
        -----------
        Returns the paramtype of a param, given its rank error if num is not between 1 and nbparams.

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamType(self, *args)

    def ParamValue(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        Returns literal value of a parameter, given its rank error if num is out of range, or if parameter is not literal.

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamValue(self, *args)

    def SetFormNumber(self, *args):
        r"""

        Parameters
        ----------
        formnum: int

        Return
        -------
        None

        Description
        -----------
        Sets form number to a new value (to called after settypenumber).

        """
        return _IGESData.IGESData_FreeFormatEntity_SetFormNumber(self, *args)

    def SetTypeNumber(self, *args):
        r"""

        Parameters
        ----------
        typenum: int

        Return
        -------
        None

        Description
        -----------
        Sets type number to a new value, and form number to zero.

        """
        return _IGESData.IGESData_FreeFormatEntity_SetTypeNumber(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FreeFormatEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FreeFormatEntity

# Register IGESData_FreeFormatEntity in _IGESData:
_IGESData.IGESData_FreeFormatEntity_swigregister(IGESData_FreeFormatEntity)
class IGESData_HArray1OfIGESEntity(IGESData_Array1OfIGESEntity, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _IGESData.IGESData_HArray1OfIGESEntity_swiginit(self, _IGESData.new_IGESData_HArray1OfIGESEntity(*args))

    def Array1(self):
        return _IGESData.IGESData_HArray1OfIGESEntity_Array1(self)

    def ChangeArray1(self):
        return _IGESData.IGESData_HArray1OfIGESEntity_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_HArray1OfIGESEntity_DownCast(t)

    __swig_destroy__ = _IGESData.delete_IGESData_HArray1OfIGESEntity

# Register IGESData_HArray1OfIGESEntity in _IGESData:
_IGESData.IGESData_HArray1OfIGESEntity_swigregister(IGESData_HArray1OfIGESEntity)



@deprecated
def igesdata_Init(*args):
	return igesdata.Init(*args)

@deprecated
def igesdata_Protocol(*args):
	return igesdata.Protocol(*args)

@deprecated
def IGESData_BasicEditor_DraftingMax(*args):
	return IGESData_BasicEditor.DraftingMax(*args)

@deprecated
def IGESData_BasicEditor_DraftingName(*args):
	return IGESData_BasicEditor.DraftingName(*args)

@deprecated
def IGESData_BasicEditor_IGESVersionMax(*args):
	return IGESData_BasicEditor.IGESVersionMax(*args)

@deprecated
def IGESData_BasicEditor_IGESVersionName(*args):
	return IGESData_BasicEditor.IGESVersionName(*args)

@deprecated
def IGESData_BasicEditor_UnitFlagName(*args):
	return IGESData_BasicEditor.UnitFlagName(*args)

@deprecated
def IGESData_BasicEditor_UnitFlagValue(*args):
	return IGESData_BasicEditor.UnitFlagValue(*args)

@deprecated
def IGESData_BasicEditor_UnitNameFlag(*args):
	return IGESData_BasicEditor.UnitNameFlag(*args)

@deprecated
def IGESData_GlobalSection_NewDateString(*args):
	return IGESData_GlobalSection.NewDateString(*args)

@deprecated
def IGESData_GlobalSection_NewDateString(*args):
	return IGESData_GlobalSection.NewDateString(*args)

@deprecated
def IGESData_SpecificLib_SetGlobal(*args):
	return IGESData_SpecificLib.SetGlobal(*args)

@deprecated
def IGESData_ToolLocation_ConvertLocation(*args):
	return IGESData_ToolLocation.ConvertLocation(*args)

@deprecated
def IGESData_WriterLib_SetGlobal(*args):
	return IGESData_WriterLib.SetGlobal(*args)



